# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/appengine/v1/appengine.proto for package 'Google.Cloud.AppEngine.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/appengine/v1/appengine_pb'

module Google
  module Cloud
    module AppEngine
      module V1
        module Applications
          # Manages App Engine applications.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.Applications'

            # Gets information about an application.
            rpc :GetApplication, ::Google::Cloud::AppEngine::V1::GetApplicationRequest, ::Google::Cloud::AppEngine::V1::Application
            # Creates an App Engine application for a Google Cloud Platform project.
            # Required fields:
            #
            # * `id` - The ID of the target Cloud Platform project.
            # * *location* - The [region](https://cloud.google.com/appengine/docs/locations) where you want the App Engine application located.
            #
            # For more information about App Engine applications, see [Managing Projects, Applications, and Billing](https://cloud.google.com/appengine/docs/standard/python/console/).
            rpc :CreateApplication, ::Google::Cloud::AppEngine::V1::CreateApplicationRequest, ::Google::Longrunning::Operation
            # Updates the specified Application resource.
            # You can update the following fields:
            #
            # * `auth_domain` - Google authentication domain for controlling user access to the application.
            # * `default_cookie_expiration` - Cookie expiration policy for the application.
            # * `iap` - Identity-Aware Proxy properties for the application.
            rpc :UpdateApplication, ::Google::Cloud::AppEngine::V1::UpdateApplicationRequest, ::Google::Longrunning::Operation
            # Recreates the required App Engine features for the specified App Engine
            # application, for example a Cloud Storage bucket or App Engine service
            # account.
            # Use this method if you receive an error message about a missing feature,
            # for example, *Error retrieving the App Engine service account*.
            # If you have deleted your App Engine service account, this will
            # not be able to recreate it. Instead, you should attempt to use the
            # IAM undelete API if possible at https://cloud.google.com/iam/reference/rest/v1/projects.serviceAccounts/undelete?apix_params=%7B"name"%3A"projects%2F-%2FserviceAccounts%2Funique_id"%2C"resource"%3A%7B%7D%7D .
            # If the deletion was recent, the numeric ID can be found in the Cloud
            # Console Activity Log.
            rpc :RepairApplication, ::Google::Cloud::AppEngine::V1::RepairApplicationRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
        module Services
          # Manages services of an application.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.Services'

            # Lists all the services in the application.
            rpc :ListServices, ::Google::Cloud::AppEngine::V1::ListServicesRequest, ::Google::Cloud::AppEngine::V1::ListServicesResponse
            # Gets the current configuration of the specified service.
            rpc :GetService, ::Google::Cloud::AppEngine::V1::GetServiceRequest, ::Google::Cloud::AppEngine::V1::Service
            # Updates the configuration of the specified service.
            rpc :UpdateService, ::Google::Cloud::AppEngine::V1::UpdateServiceRequest, ::Google::Longrunning::Operation
            # Deletes the specified service and all enclosed versions.
            rpc :DeleteService, ::Google::Cloud::AppEngine::V1::DeleteServiceRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
        module Versions
          # Manages versions of a service.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.Versions'

            # Lists the versions of a service.
            rpc :ListVersions, ::Google::Cloud::AppEngine::V1::ListVersionsRequest, ::Google::Cloud::AppEngine::V1::ListVersionsResponse
            # Gets the specified Version resource.
            # By default, only a `BASIC_VIEW` will be returned.
            # Specify the `FULL_VIEW` parameter to get the full resource.
            rpc :GetVersion, ::Google::Cloud::AppEngine::V1::GetVersionRequest, ::Google::Cloud::AppEngine::V1::Version
            # Deploys code and resource files to a new version.
            rpc :CreateVersion, ::Google::Cloud::AppEngine::V1::CreateVersionRequest, ::Google::Longrunning::Operation
            # Updates the specified Version resource.
            # You can specify the following fields depending on the App Engine
            # environment and type of scaling that the version resource uses:
            #
            # **Standard environment**
            #
            # * [`instance_class`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.instance_class)
            #
            # *automatic scaling* in the standard environment:
            #
            # * [`automatic_scaling.min_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
            # * [`automatic_scaling.max_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
            # * [`automaticScaling.standard_scheduler_settings.max_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
            # * [`automaticScaling.standard_scheduler_settings.min_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
            # * [`automaticScaling.standard_scheduler_settings.target_cpu_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
            # * [`automaticScaling.standard_scheduler_settings.target_throughput_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
            #
            # *basic scaling* or *manual scaling* in the standard environment:
            #
            # * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status)
            # * [`manual_scaling.instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#manualscaling)
            #
            # **Flexible environment**
            #
            # * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status)
            #
            # *automatic scaling* in the flexible environment:
            #
            # * [`automatic_scaling.min_total_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
            # * [`automatic_scaling.max_total_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
            # * [`automatic_scaling.cool_down_period_sec`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
            # * [`automatic_scaling.cpu_utilization.target_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
            #
            # *manual scaling* in the flexible environment:
            #
            # * [`manual_scaling.instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#manualscaling)
            rpc :UpdateVersion, ::Google::Cloud::AppEngine::V1::UpdateVersionRequest, ::Google::Longrunning::Operation
            # Deletes an existing Version resource.
            rpc :DeleteVersion, ::Google::Cloud::AppEngine::V1::DeleteVersionRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
        module Instances
          # Manages instances of a version.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.Instances'

            # Lists the instances of a version.
            #
            # Tip: To aggregate details about instances over time, see the
            # [Stackdriver Monitoring API](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
            rpc :ListInstances, ::Google::Cloud::AppEngine::V1::ListInstancesRequest, ::Google::Cloud::AppEngine::V1::ListInstancesResponse
            # Gets instance information.
            rpc :GetInstance, ::Google::Cloud::AppEngine::V1::GetInstanceRequest, ::Google::Cloud::AppEngine::V1::Instance
            # Stops a running instance.
            #
            # The instance might be automatically recreated based on the scaling settings
            # of the version. For more information, see "How Instances are Managed"
            # ([standard environment](https://cloud.google.com/appengine/docs/standard/python/how-instances-are-managed) |
            # [flexible environment](https://cloud.google.com/appengine/docs/flexible/python/how-instances-are-managed)).
            #
            # To ensure that instances are not re-created and avoid getting billed, you
            # can stop all instances within the target version by changing the serving
            # status of the version to `STOPPED` with the
            # [`apps.services.versions.patch`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions/patch)
            # method.
            rpc :DeleteInstance, ::Google::Cloud::AppEngine::V1::DeleteInstanceRequest, ::Google::Longrunning::Operation
            # Enables debugging on a VM instance. This allows you to use the SSH
            # command to connect to the virtual machine where the instance lives.
            # While in "debug mode", the instance continues to serve live traffic.
            # You should delete the instance when you are done debugging and then
            # allow the system to take over and determine if another instance
            # should be started.
            #
            # Only applicable for instances in App Engine flexible environment.
            rpc :DebugInstance, ::Google::Cloud::AppEngine::V1::DebugInstanceRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
        module Firewall
          # Firewall resources are used to define a collection of access control rules
          # for an Application. Each rule is defined with a position which specifies
          # the rule's order in the sequence of rules, an IP range to be matched against
          # requests, and an action to take upon matching requests.
          #
          # Every request is evaluated against the Firewall rules in priority order.
          # Processesing stops at the first rule which matches the request's IP address.
          # A final rule always specifies an action that applies to all remaining
          # IP addresses. The default final rule for a newly-created application will be
          # set to "allow" if not otherwise specified by the user.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.Firewall'

            # Lists the firewall rules of an application.
            rpc :ListIngressRules, ::Google::Cloud::AppEngine::V1::ListIngressRulesRequest, ::Google::Cloud::AppEngine::V1::ListIngressRulesResponse
            # Replaces the entire firewall ruleset in one bulk operation. This overrides
            # and replaces the rules of an existing firewall with the new rules.
            #
            # If the final rule does not match traffic with the '*' wildcard IP range,
            # then an "allow all" rule is explicitly added to the end of the list.
            rpc :BatchUpdateIngressRules, ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest, ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesResponse
            # Creates a firewall rule for the application.
            rpc :CreateIngressRule, ::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest, ::Google::Cloud::AppEngine::V1::FirewallRule
            # Gets the specified firewall rule.
            rpc :GetIngressRule, ::Google::Cloud::AppEngine::V1::GetIngressRuleRequest, ::Google::Cloud::AppEngine::V1::FirewallRule
            # Updates the specified firewall rule.
            rpc :UpdateIngressRule, ::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest, ::Google::Cloud::AppEngine::V1::FirewallRule
            # Deletes the specified firewall rule.
            rpc :DeleteIngressRule, ::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
        module AuthorizedDomains
          # Manages domains a user is authorized to administer. To authorize use of a
          # domain, verify ownership via
          # [Webmaster Central](https://www.google.com/webmasters/verification/home).
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.AuthorizedDomains'

            # Lists all domains the user is authorized to administer.
            rpc :ListAuthorizedDomains, ::Google::Cloud::AppEngine::V1::ListAuthorizedDomainsRequest, ::Google::Cloud::AppEngine::V1::ListAuthorizedDomainsResponse
          end

          Stub = Service.rpc_stub_class
        end
        module AuthorizedCertificates
          # Manages SSL certificates a user is authorized to administer. A user can
          # administer any SSL certificates applicable to their authorized domains.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.AuthorizedCertificates'

            # Lists all SSL certificates the user is authorized to administer.
            rpc :ListAuthorizedCertificates, ::Google::Cloud::AppEngine::V1::ListAuthorizedCertificatesRequest, ::Google::Cloud::AppEngine::V1::ListAuthorizedCertificatesResponse
            # Gets the specified SSL certificate.
            rpc :GetAuthorizedCertificate, ::Google::Cloud::AppEngine::V1::GetAuthorizedCertificateRequest, ::Google::Cloud::AppEngine::V1::AuthorizedCertificate
            # Uploads the specified SSL certificate.
            rpc :CreateAuthorizedCertificate, ::Google::Cloud::AppEngine::V1::CreateAuthorizedCertificateRequest, ::Google::Cloud::AppEngine::V1::AuthorizedCertificate
            # Updates the specified SSL certificate. To renew a certificate and maintain
            # its existing domain mappings, update `certificate_data` with a new
            # certificate. The new certificate must be applicable to the same domains as
            # the original certificate. The certificate `display_name` may also be
            # updated.
            rpc :UpdateAuthorizedCertificate, ::Google::Cloud::AppEngine::V1::UpdateAuthorizedCertificateRequest, ::Google::Cloud::AppEngine::V1::AuthorizedCertificate
            # Deletes the specified SSL certificate.
            rpc :DeleteAuthorizedCertificate, ::Google::Cloud::AppEngine::V1::DeleteAuthorizedCertificateRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
        module DomainMappings
          # Manages domains serving an application.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.appengine.v1.DomainMappings'

            # Lists the domain mappings on an application.
            rpc :ListDomainMappings, ::Google::Cloud::AppEngine::V1::ListDomainMappingsRequest, ::Google::Cloud::AppEngine::V1::ListDomainMappingsResponse
            # Gets the specified domain mapping.
            rpc :GetDomainMapping, ::Google::Cloud::AppEngine::V1::GetDomainMappingRequest, ::Google::Cloud::AppEngine::V1::DomainMapping
            # Maps a domain to an application. A user must be authorized to administer a
            # domain in order to map it to an application. For a list of available
            # authorized domains, see [`AuthorizedDomains.ListAuthorizedDomains`]().
            rpc :CreateDomainMapping, ::Google::Cloud::AppEngine::V1::CreateDomainMappingRequest, ::Google::Longrunning::Operation
            # Updates the specified domain mapping. To map an SSL certificate to a
            # domain mapping, update `certificate_id` to point to an `AuthorizedCertificate`
            # resource. A user must be authorized to administer the associated domain
            # in order to update a `DomainMapping` resource.
            rpc :UpdateDomainMapping, ::Google::Cloud::AppEngine::V1::UpdateDomainMappingRequest, ::Google::Longrunning::Operation
            # Deletes the specified domain mapping. A user must be authorized to
            # administer the associated domain in order to delete a `DomainMapping`
            # resource.
            rpc :DeleteDomainMapping, ::Google::Cloud::AppEngine::V1::DeleteDomainMappingRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
