# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/apigeeregistry/v1/registry_service_pb"
require "google/cloud/apigee_registry/v1/registry"

class ::Google::Cloud::ApigeeRegistry::V1::Registry::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_apis
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ListApisResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_apis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_apis, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ListApisRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_apis_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_apis({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_apis parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_apis ::Google::Cloud::ApigeeRegistry::V1::ListApisRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_apis({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_apis(::Google::Cloud::ApigeeRegistry::V1::ListApisRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_apis_client_stub.call_rpc_count
    end
  end

  def test_get_api
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::Api.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_api, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::GetApiRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_api_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_api({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_api name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_api ::Google::Cloud::ApigeeRegistry::V1::GetApiRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_api({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_api(::Google::Cloud::ApigeeRegistry::V1::GetApiRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_api_client_stub.call_rpc_count
    end
  end

  def test_create_api
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::Api.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api = {}
    api_id = "hello world"

    create_api_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_api, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::Api), request["api"]
      assert_equal "hello world", request["api_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_api_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_api({ parent: parent, api: api, api_id: api_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_api parent: parent, api: api, api_id: api_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_api ::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest.new(parent: parent, api: api, api_id: api_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_api({ parent: parent, api: api, api_id: api_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_api(::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest.new(parent: parent, api: api, api_id: api_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_api_client_stub.call_rpc_count
    end
  end

  def test_update_api
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::Api.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    api = {}
    update_mask = {}
    allow_missing = true

    update_api_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_api, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::Api), request["api"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_api_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_api({ api: api, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_api api: api, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_api ::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest.new(api: api, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_api({ api: api, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_api(::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest.new(api: api, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_api_client_stub.call_rpc_count
    end
  end

  def test_delete_api
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_api, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_api_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_api({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_api name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_api ::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_api({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_api(::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_api_client_stub.call_rpc_count
    end
  end

  def test_list_api_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_api_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_api_versions, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_api_versions_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_api_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_api_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_api_versions ::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_api_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_api_versions(::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_api_versions_client_stub.call_rpc_count
    end
  end

  def test_get_api_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_api_version, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_api_version_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_api_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_api_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_api_version ::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_api_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_api_version(::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_api_version_client_stub.call_rpc_count
    end
  end

  def test_create_api_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_version = {}
    api_version_id = "hello world"

    create_api_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_api_version, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::ApiVersion), request["api_version"]
      assert_equal "hello world", request["api_version_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_api_version_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_api_version({ parent: parent, api_version: api_version, api_version_id: api_version_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_api_version parent: parent, api_version: api_version, api_version_id: api_version_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_api_version ::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest.new(parent: parent, api_version: api_version, api_version_id: api_version_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_api_version({ parent: parent, api_version: api_version, api_version_id: api_version_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_api_version(::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest.new(parent: parent, api_version: api_version, api_version_id: api_version_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_api_version_client_stub.call_rpc_count
    end
  end

  def test_update_api_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    api_version = {}
    update_mask = {}
    allow_missing = true

    update_api_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_api_version, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::ApiVersion), request["api_version"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_api_version_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_api_version({ api_version: api_version, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_api_version api_version: api_version, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_api_version ::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest.new(api_version: api_version, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_api_version({ api_version: api_version, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_api_version(::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest.new(api_version: api_version, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_api_version_client_stub.call_rpc_count
    end
  end

  def test_delete_api_version
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_api_version, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_api_version_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_api_version({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_api_version name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_api_version ::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_api_version({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_api_version(::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_api_version_client_stub.call_rpc_count
    end
  end

  def test_list_api_specs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_api_specs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_api_specs, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_api_specs_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_api_specs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_api_specs parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_api_specs ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_api_specs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_api_specs(::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_api_specs_client_stub.call_rpc_count
    end
  end

  def test_get_api_spec
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_spec_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_api_spec, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_api_spec_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_api_spec({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_api_spec name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_api_spec ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_api_spec({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_api_spec(::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_api_spec_client_stub.call_rpc_count
    end
  end

  def test_get_api_spec_contents
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_spec_contents_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_api_spec_contents, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_api_spec_contents_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_api_spec_contents({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_api_spec_contents name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_api_spec_contents ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_api_spec_contents({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_api_spec_contents(::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_api_spec_contents_client_stub.call_rpc_count
    end
  end

  def test_create_api_spec
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_spec = {}
    api_spec_id = "hello world"

    create_api_spec_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_api_spec, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::ApiSpec), request["api_spec"]
      assert_equal "hello world", request["api_spec_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_api_spec_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_api_spec({ parent: parent, api_spec: api_spec, api_spec_id: api_spec_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_api_spec parent: parent, api_spec: api_spec, api_spec_id: api_spec_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_api_spec ::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest.new(parent: parent, api_spec: api_spec, api_spec_id: api_spec_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_api_spec({ parent: parent, api_spec: api_spec, api_spec_id: api_spec_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_api_spec(::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest.new(parent: parent, api_spec: api_spec, api_spec_id: api_spec_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_api_spec_client_stub.call_rpc_count
    end
  end

  def test_update_api_spec
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    api_spec = {}
    update_mask = {}
    allow_missing = true

    update_api_spec_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_api_spec, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::ApiSpec), request["api_spec"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_api_spec_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_api_spec({ api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_api_spec api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_api_spec ::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest.new(api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_api_spec({ api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_api_spec(::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest.new(api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_api_spec_client_stub.call_rpc_count
    end
  end

  def test_delete_api_spec
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_spec_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_api_spec, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_api_spec_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_api_spec({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_api_spec name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_api_spec ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_api_spec({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_api_spec(::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_api_spec_client_stub.call_rpc_count
    end
  end

  def test_tag_api_spec_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    tag = "hello world"

    tag_api_spec_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :tag_api_spec_revision, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["tag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, tag_api_spec_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.tag_api_spec_revision({ name: name, tag: tag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.tag_api_spec_revision name: name, tag: tag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.tag_api_spec_revision ::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest.new(name: name, tag: tag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.tag_api_spec_revision({ name: name, tag: tag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.tag_api_spec_revision(::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest.new(name: name, tag: tag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, tag_api_spec_revision_client_stub.call_rpc_count
    end
  end

  def test_list_api_spec_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_api_spec_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_api_spec_revisions, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_api_spec_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_api_spec_revisions({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_api_spec_revisions name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_api_spec_revisions ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_api_spec_revisions({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_api_spec_revisions(::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_api_spec_revisions_client_stub.call_rpc_count
    end
  end

  def test_rollback_api_spec
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision_id = "hello world"

    rollback_api_spec_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback_api_spec, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["revision_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_api_spec_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback_api_spec({ name: name, revision_id: revision_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback_api_spec name: name, revision_id: revision_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback_api_spec ::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest.new(name: name, revision_id: revision_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback_api_spec({ name: name, revision_id: revision_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback_api_spec(::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest.new(name: name, revision_id: revision_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_api_spec_client_stub.call_rpc_count
    end
  end

  def test_delete_api_spec_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_api_spec_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_api_spec_revision, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_api_spec_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_api_spec_revision({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_api_spec_revision name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_api_spec_revision ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_api_spec_revision({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_api_spec_revision(::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_api_spec_revision_client_stub.call_rpc_count
    end
  end

  def test_list_api_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_api_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_api_deployments, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_api_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_api_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_api_deployments parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_api_deployments ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_api_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_api_deployments(::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_api_deployments_client_stub.call_rpc_count
    end
  end

  def test_get_api_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_api_deployment, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_api_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_api_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_api_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_api_deployment ::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_api_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_api_deployment(::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_api_deployment_client_stub.call_rpc_count
    end
  end

  def test_create_api_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_deployment = {}
    api_deployment_id = "hello world"

    create_api_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_api_deployment, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment), request["api_deployment"]
      assert_equal "hello world", request["api_deployment_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_api_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_api_deployment({ parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_api_deployment parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_api_deployment ::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest.new(parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_api_deployment({ parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_api_deployment(::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest.new(parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_api_deployment_client_stub.call_rpc_count
    end
  end

  def test_update_api_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    api_deployment = {}
    update_mask = {}
    allow_missing = true

    update_api_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_api_deployment, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment), request["api_deployment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_api_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_api_deployment({ api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_api_deployment api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_api_deployment ::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest.new(api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_api_deployment({ api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_api_deployment(::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest.new(api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_api_deployment_client_stub.call_rpc_count
    end
  end

  def test_delete_api_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_api_deployment, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_api_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_api_deployment({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_api_deployment name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_api_deployment ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_api_deployment({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_api_deployment(::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_api_deployment_client_stub.call_rpc_count
    end
  end

  def test_tag_api_deployment_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    tag = "hello world"

    tag_api_deployment_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :tag_api_deployment_revision, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["tag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, tag_api_deployment_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.tag_api_deployment_revision({ name: name, tag: tag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.tag_api_deployment_revision name: name, tag: tag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.tag_api_deployment_revision ::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest.new(name: name, tag: tag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.tag_api_deployment_revision({ name: name, tag: tag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.tag_api_deployment_revision(::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest.new(name: name, tag: tag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, tag_api_deployment_revision_client_stub.call_rpc_count
    end
  end

  def test_list_api_deployment_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_api_deployment_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_api_deployment_revisions, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_api_deployment_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_api_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_api_deployment_revisions name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_api_deployment_revisions ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_api_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_api_deployment_revisions(::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_api_deployment_revisions_client_stub.call_rpc_count
    end
  end

  def test_rollback_api_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision_id = "hello world"

    rollback_api_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback_api_deployment, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["revision_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_api_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback_api_deployment({ name: name, revision_id: revision_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback_api_deployment name: name, revision_id: revision_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback_api_deployment ::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest.new(name: name, revision_id: revision_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback_api_deployment({ name: name, revision_id: revision_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback_api_deployment(::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest.new(name: name, revision_id: revision_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_api_deployment_client_stub.call_rpc_count
    end
  end

  def test_delete_api_deployment_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_api_deployment_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_api_deployment_revision, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_api_deployment_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_api_deployment_revision({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_api_deployment_revision name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_api_deployment_revision ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_api_deployment_revision({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_api_deployment_revision(::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_api_deployment_revision_client_stub.call_rpc_count
    end
  end

  def test_list_artifacts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::ListArtifactsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_artifacts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_artifacts, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_artifacts_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_artifacts parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_artifacts ::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_artifacts(::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_artifacts_client_stub.call_rpc_count
    end
  end

  def test_get_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::Artifact.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_artifact, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_artifact({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_artifact name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_artifact ::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_artifact({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_artifact(::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_artifact_client_stub.call_rpc_count
    end
  end

  def test_get_artifact_contents
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_artifact_contents_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_artifact_contents, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_artifact_contents_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_artifact_contents({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_artifact_contents name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_artifact_contents ::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_artifact_contents({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_artifact_contents(::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_artifact_contents_client_stub.call_rpc_count
    end
  end

  def test_create_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::Artifact.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    artifact = {}
    artifact_id = "hello world"

    create_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_artifact, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::Artifact), request["artifact"]
      assert_equal "hello world", request["artifact_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_artifact parent: parent, artifact: artifact, artifact_id: artifact_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_artifact ::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_artifact(::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_artifact_client_stub.call_rpc_count
    end
  end

  def test_replace_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeRegistry::V1::Artifact.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    artifact = {}

    replace_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :replace_artifact, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeRegistry::V1::Artifact), request["artifact"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, replace_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.replace_artifact({ artifact: artifact }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.replace_artifact artifact: artifact do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.replace_artifact ::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest.new(artifact: artifact) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.replace_artifact({ artifact: artifact }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.replace_artifact(::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest.new(artifact: artifact), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, replace_artifact_client_stub.call_rpc_count
    end
  end

  def test_delete_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_artifact, name
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_artifact({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_artifact name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_artifact ::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_artifact({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_artifact(::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_artifact_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::Registry::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::Registry::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
