# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/apigeeregistry/v1/registry_service_pb"
require "google/cloud/apigee_registry/v1/registry/rest"


class ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_apis
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ListApisResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_apis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_list_apis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_apis_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_apis({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_apis parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_apis ::Google::Cloud::ApigeeRegistry::V1::ListApisRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_apis({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_apis(::Google::Cloud::ApigeeRegistry::V1::ListApisRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_apis_client_stub.call_count
      end
    end
  end

  def test_get_api
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::Api.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_get_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api ::Google::Cloud::ApigeeRegistry::V1::GetApiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api(::Google::Cloud::ApigeeRegistry::V1::GetApiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_client_stub.call_count
      end
    end
  end

  def test_create_api
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::Api.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api = {}
    api_id = "hello world"

    create_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_create_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api({ parent: parent, api: api, api_id: api_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api parent: parent, api: api, api_id: api_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api ::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest.new(parent: parent, api: api, api_id: api_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api({ parent: parent, api: api, api_id: api_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api(::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest.new(parent: parent, api: api, api_id: api_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_client_stub.call_count
      end
    end
  end

  def test_update_api
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::Api.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    api = {}
    update_mask = {}
    allow_missing = true

    update_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_update_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api({ api: api, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api api: api, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api ::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest.new(api: api, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api({ api: api, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api(::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest.new(api: api, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_client_stub.call_count
      end
    end
  end

  def test_delete_api
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_delete_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api ::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api(::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_client_stub.call_count
      end
    end
  end

  def test_list_api_versions
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_api_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_list_api_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_api_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_api_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_api_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_api_versions ::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_api_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_api_versions(::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_api_versions_client_stub.call_count
      end
    end
  end

  def test_get_api_version
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_get_api_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api_version ::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api_version(::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_version_client_stub.call_count
      end
    end
  end

  def test_create_api_version
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_version = {}
    api_version_id = "hello world"

    create_api_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_create_api_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api_version({ parent: parent, api_version: api_version, api_version_id: api_version_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api_version parent: parent, api_version: api_version, api_version_id: api_version_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api_version ::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest.new(parent: parent, api_version: api_version, api_version_id: api_version_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api_version({ parent: parent, api_version: api_version, api_version_id: api_version_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api_version(::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest.new(parent: parent, api_version: api_version, api_version_id: api_version_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_version_client_stub.call_count
      end
    end
  end

  def test_update_api_version
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    api_version = {}
    update_mask = {}
    allow_missing = true

    update_api_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_update_api_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api_version({ api_version: api_version, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api_version api_version: api_version, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api_version ::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest.new(api_version: api_version, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api_version({ api_version: api_version, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api_version(::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest.new(api_version: api_version, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_version_client_stub.call_count
      end
    end
  end

  def test_delete_api_version
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_delete_api_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api_version({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api_version name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api_version ::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api_version({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api_version(::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_version_client_stub.call_count
      end
    end
  end

  def test_list_api_specs
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_api_specs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_list_api_specs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_api_specs_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_api_specs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_api_specs parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_api_specs ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_api_specs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_api_specs(::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_api_specs_client_stub.call_count
      end
    end
  end

  def test_get_api_spec
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_get_api_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api_spec({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api_spec name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api_spec ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api_spec({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api_spec(::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_spec_client_stub.call_count
      end
    end
  end

  def test_get_api_spec_contents
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_spec_contents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_get_api_spec_contents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_spec_contents_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api_spec_contents({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api_spec_contents name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api_spec_contents ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api_spec_contents({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api_spec_contents(::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_spec_contents_client_stub.call_count
      end
    end
  end

  def test_create_api_spec
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_spec = {}
    api_spec_id = "hello world"

    create_api_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_create_api_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api_spec({ parent: parent, api_spec: api_spec, api_spec_id: api_spec_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api_spec parent: parent, api_spec: api_spec, api_spec_id: api_spec_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api_spec ::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest.new(parent: parent, api_spec: api_spec, api_spec_id: api_spec_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api_spec({ parent: parent, api_spec: api_spec, api_spec_id: api_spec_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api_spec(::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest.new(parent: parent, api_spec: api_spec, api_spec_id: api_spec_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_spec_client_stub.call_count
      end
    end
  end

  def test_update_api_spec
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    api_spec = {}
    update_mask = {}
    allow_missing = true

    update_api_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_update_api_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api_spec({ api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api_spec api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api_spec ::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest.new(api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api_spec({ api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api_spec(::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest.new(api_spec: api_spec, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_spec_client_stub.call_count
      end
    end
  end

  def test_delete_api_spec
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_delete_api_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api_spec({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api_spec name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api_spec ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api_spec({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api_spec(::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_spec_client_stub.call_count
      end
    end
  end

  def test_tag_api_spec_revision
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    tag = "hello world"

    tag_api_spec_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_tag_api_spec_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, tag_api_spec_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.tag_api_spec_revision({ name: name, tag: tag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.tag_api_spec_revision name: name, tag: tag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.tag_api_spec_revision ::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest.new(name: name, tag: tag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.tag_api_spec_revision({ name: name, tag: tag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.tag_api_spec_revision(::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest.new(name: name, tag: tag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, tag_api_spec_revision_client_stub.call_count
      end
    end
  end

  def test_list_api_spec_revisions
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_api_spec_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_list_api_spec_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_api_spec_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_api_spec_revisions({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_api_spec_revisions name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_api_spec_revisions ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_api_spec_revisions({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_api_spec_revisions(::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_api_spec_revisions_client_stub.call_count
      end
    end
  end

  def test_rollback_api_spec
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision_id = "hello world"

    rollback_api_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_rollback_api_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_api_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback_api_spec({ name: name, revision_id: revision_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback_api_spec name: name, revision_id: revision_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback_api_spec ::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest.new(name: name, revision_id: revision_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback_api_spec({ name: name, revision_id: revision_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback_api_spec(::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest.new(name: name, revision_id: revision_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_api_spec_client_stub.call_count
      end
    end
  end

  def test_delete_api_spec_revision
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_api_spec_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_delete_api_spec_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_spec_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api_spec_revision({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api_spec_revision name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api_spec_revision ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api_spec_revision({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api_spec_revision(::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_spec_revision_client_stub.call_count
      end
    end
  end

  def test_list_api_deployments
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_api_deployments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_list_api_deployments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_api_deployments_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_api_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_api_deployments parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_api_deployments ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_api_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_api_deployments(::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_api_deployments_client_stub.call_count
      end
    end
  end

  def test_get_api_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_get_api_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api_deployment ::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api_deployment(::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_deployment_client_stub.call_count
      end
    end
  end

  def test_create_api_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_deployment = {}
    api_deployment_id = "hello world"

    create_api_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_create_api_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api_deployment({ parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api_deployment parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api_deployment ::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest.new(parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api_deployment({ parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api_deployment(::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest.new(parent: parent, api_deployment: api_deployment, api_deployment_id: api_deployment_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_deployment_client_stub.call_count
      end
    end
  end

  def test_update_api_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    api_deployment = {}
    update_mask = {}
    allow_missing = true

    update_api_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_update_api_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api_deployment({ api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api_deployment api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api_deployment ::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest.new(api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api_deployment({ api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api_deployment(::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest.new(api_deployment: api_deployment, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_deployment_client_stub.call_count
      end
    end
  end

  def test_delete_api_deployment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_delete_api_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api_deployment({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api_deployment name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api_deployment ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api_deployment({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api_deployment(::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_deployment_client_stub.call_count
      end
    end
  end

  def test_tag_api_deployment_revision
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    tag = "hello world"

    tag_api_deployment_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_tag_api_deployment_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, tag_api_deployment_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.tag_api_deployment_revision({ name: name, tag: tag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.tag_api_deployment_revision name: name, tag: tag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.tag_api_deployment_revision ::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest.new(name: name, tag: tag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.tag_api_deployment_revision({ name: name, tag: tag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.tag_api_deployment_revision(::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest.new(name: name, tag: tag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, tag_api_deployment_revision_client_stub.call_count
      end
    end
  end

  def test_list_api_deployment_revisions
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_api_deployment_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_list_api_deployment_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_api_deployment_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_api_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_api_deployment_revisions name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_api_deployment_revisions ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_api_deployment_revisions({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_api_deployment_revisions(::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_api_deployment_revisions_client_stub.call_count
      end
    end
  end

  def test_rollback_api_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    revision_id = "hello world"

    rollback_api_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_rollback_api_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_api_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback_api_deployment({ name: name, revision_id: revision_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback_api_deployment name: name, revision_id: revision_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback_api_deployment ::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest.new(name: name, revision_id: revision_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback_api_deployment({ name: name, revision_id: revision_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback_api_deployment(::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest.new(name: name, revision_id: revision_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_api_deployment_client_stub.call_count
      end
    end
  end

  def test_delete_api_deployment_revision
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_api_deployment_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_delete_api_deployment_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_deployment_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api_deployment_revision({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api_deployment_revision name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api_deployment_revision ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api_deployment_revision({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api_deployment_revision(::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_deployment_revision_client_stub.call_count
      end
    end
  end

  def test_list_artifacts
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::ListArtifactsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_list_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_artifacts parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_artifacts ::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_artifacts(::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_artifacts_client_stub.call_count
      end
    end
  end

  def test_get_artifact
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::Artifact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_get_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_artifact({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_artifact name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_artifact ::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_artifact({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_artifact(::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_artifact_client_stub.call_count
      end
    end
  end

  def test_get_artifact_contents
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_artifact_contents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_get_artifact_contents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_artifact_contents_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_artifact_contents({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_artifact_contents name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_artifact_contents ::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_artifact_contents({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_artifact_contents(::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_artifact_contents_client_stub.call_count
      end
    end
  end

  def test_create_artifact
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::Artifact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    artifact = {}
    artifact_id = "hello world"

    create_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_create_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_artifact parent: parent, artifact: artifact, artifact_id: artifact_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_artifact ::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_artifact(::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_artifact_client_stub.call_count
      end
    end
  end

  def test_replace_artifact
    # Create test objects.
    client_result = ::Google::Cloud::ApigeeRegistry::V1::Artifact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    artifact = {}

    replace_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_replace_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, replace_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.replace_artifact({ artifact: artifact }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.replace_artifact artifact: artifact do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.replace_artifact ::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest.new(artifact: artifact) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.replace_artifact({ artifact: artifact }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.replace_artifact(::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest.new(artifact: artifact), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, replace_artifact_client_stub.call_count
      end
    end
  end

  def test_delete_artifact
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.stub :transcode_delete_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_artifact({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_artifact name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_artifact ::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_artifact({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_artifact(::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_artifact_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client::Configuration, config
  end
end
