# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/apigee_registry/v1/registry"

class ::Google::Cloud::ApigeeRegistry::V1::Registry::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_api_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.api_path project: "value0", location: "value1", api: "value2"
      assert_equal "projects/value0/locations/value1/apis/value2", path
    end
  end

  def test_api_deployment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.api_deployment_path project: "value0", location: "value1", api: "value2", deployment: "value3"
      assert_equal "projects/value0/locations/value1/apis/value2/deployments/value3", path
    end
  end

  def test_api_spec_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.api_spec_path project: "value0", location: "value1", api: "value2", version: "value3", spec: "value4"
      assert_equal "projects/value0/locations/value1/apis/value2/versions/value3/specs/value4", path
    end
  end

  def test_api_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.api_version_path project: "value0", location: "value1", api: "value2", version: "value3"
      assert_equal "projects/value0/locations/value1/apis/value2/versions/value3", path
    end
  end

  def test_artifact_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.artifact_path project: "value0", location: "value1", artifact: "value2"
      assert_equal "projects/value0/locations/value1/artifacts/value2", path

      path = client.artifact_path project: "value0", location: "value1", api: "value2", artifact: "value3"
      assert_equal "projects/value0/locations/value1/apis/value2/artifacts/value3", path

      path = client.artifact_path project: "value0", location: "value1", api: "value2", version: "value3", artifact: "value4"
      assert_equal "projects/value0/locations/value1/apis/value2/versions/value3/artifacts/value4", path

      path = client.artifact_path project: "value0", location: "value1", api: "value2", version: "value3", spec: "value4", artifact: "value5"
      assert_equal "projects/value0/locations/value1/apis/value2/versions/value3/specs/value4/artifacts/value5", path

      path = client.artifact_path project: "value0", location: "value1", api: "value2", deployment: "value3", artifact: "value4"
      assert_equal "projects/value0/locations/value1/apis/value2/deployments/value3/artifacts/value4", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end
end
