# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApigeeRegistry
      module V1
        # Request message for ListApis.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of APIs.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of APIs to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 50 values will be returned.
        #     The maximum is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListApis` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListApis` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that can be used to filter the list. Filters use the Common
        #     Expression Language and can refer to all message fields.
        class ListApisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListApis.
        # @!attribute [rw] apis
        #   @return [::Array<::Google::Cloud::ApigeeRegistry::V1::Api>]
        #     The APIs from the specified publisher.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApisResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetApi.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the API to retrieve.
        #     Format: `projects/*/locations/*/apis/*`
        class GetApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateApi.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of APIs.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] api
        #   @return [::Google::Cloud::ApigeeRegistry::V1::Api]
        #     Required. The API to create.
        # @!attribute [rw] api_id
        #   @return [::String]
        #     Required. The ID to use for the API, which will become the final component of
        #     the API's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        #
        #     Following AIP-162, IDs must not have the form of a UUID.
        class CreateApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateApi.
        # @!attribute [rw] api
        #   @return [::Google::Cloud::ApigeeRegistry::V1::Api]
        #     Required. The API to update.
        #
        #     The `name` field is used to identify the API to update.
        #     Format: `projects/*/locations/*/apis/*`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. If omitted, all fields are updated that
        #     are set in the request message (fields set to default values are ignored).
        #     If an asterisk "*" is specified, all fields are updated, including fields
        #     that are unspecified/default in the request.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the API is not found, a new API will be created.
        #     In this situation, `update_mask` is ignored.
        class UpdateApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteApi.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the API to delete.
        #     Format: `projects/*/locations/*/apis/*`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any child resources will also be deleted.
        #     (Otherwise, the request will only work if there are no child resources.)
        class DeleteApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListApiVersions.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of versions.
        #     Format: `projects/*/locations/*/apis/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of versions to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 50 values will be returned.
        #     The maximum is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListApiVersions` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListApiVersions` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that can be used to filter the list. Filters use the Common
        #     Expression Language and can refer to all message fields.
        class ListApiVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListApiVersions.
        # @!attribute [rw] api_versions
        #   @return [::Array<::Google::Cloud::ApigeeRegistry::V1::ApiVersion>]
        #     The versions from the specified publisher.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApiVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetApiVersion.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the version to retrieve.
        #     Format: `projects/*/locations/*/apis/*/versions/*`
        class GetApiVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateApiVersion.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of versions.
        #     Format: `projects/*/locations/*/apis/*`
        # @!attribute [rw] api_version
        #   @return [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
        #     Required. The version to create.
        # @!attribute [rw] api_version_id
        #   @return [::String]
        #     Required. The ID to use for the version, which will become the final component of
        #     the version's resource name.
        #
        #     This value should be 1-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        #
        #     Following AIP-162, IDs must not have the form of a UUID.
        class CreateApiVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateApiVersion.
        # @!attribute [rw] api_version
        #   @return [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
        #     Required. The version to update.
        #
        #     The `name` field is used to identify the version to update.
        #     Format: `projects/*/locations/*/apis/*/versions/*`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. If omitted, all fields are updated that
        #     are set in the request message (fields set to default values are ignored).
        #     If an asterisk "*" is specified, all fields are updated, including fields
        #     that are unspecified/default in the request.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the version is not found, a new version will be
        #     created. In this situation, `update_mask` is ignored.
        class UpdateApiVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteApiVersion.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the version to delete.
        #     Format: `projects/*/locations/*/apis/*/versions/*`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any child resources will also be deleted.
        #     (Otherwise, the request will only work if there are no child resources.)
        class DeleteApiVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListApiSpecs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of specs.
        #     Format: `projects/*/locations/*/apis/*/versions/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of specs to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 50 values will be returned.
        #     The maximum is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListApiSpecs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListApiSpecs` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that can be used to filter the list. Filters use the Common
        #     Expression Language and can refer to all message fields except contents.
        class ListApiSpecsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListApiSpecs.
        # @!attribute [rw] api_specs
        #   @return [::Array<::Google::Cloud::ApigeeRegistry::V1::ApiSpec>]
        #     The specs from the specified publisher.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApiSpecsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetApiSpec.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec to retrieve.
        #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
        class GetApiSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetApiSpecContents.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec whose contents should be retrieved.
        #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
        class GetApiSpecContentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateApiSpec.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of specs.
        #     Format: `projects/*/locations/*/apis/*/versions/*`
        # @!attribute [rw] api_spec
        #   @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
        #     Required. The spec to create.
        # @!attribute [rw] api_spec_id
        #   @return [::String]
        #     Required. The ID to use for the spec, which will become the final component of
        #     the spec's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        #
        #     Following AIP-162, IDs must not have the form of a UUID.
        class CreateApiSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateApiSpec.
        # @!attribute [rw] api_spec
        #   @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
        #     Required. The spec to update.
        #
        #     The `name` field is used to identify the spec to update.
        #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. If omitted, all fields are updated that
        #     are set in the request message (fields set to default values are ignored).
        #     If an asterisk "*" is specified, all fields are updated, including fields
        #     that are unspecified/default in the request.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the spec is not found, a new spec will be created.
        #     In this situation, `update_mask` is ignored.
        class UpdateApiSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteApiSpec.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec to delete.
        #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any child resources will also be deleted.
        #     (Otherwise, the request will only work if there are no child resources.)
        class DeleteApiSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for TagApiSpecRevision.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec to be tagged, including the revision ID.
        # @!attribute [rw] tag
        #   @return [::String]
        #     Required. The tag to apply.
        #     The tag should be at most 40 characters, and match `[a-z][a-z0-9-]{3,39}`.
        class TagApiSpecRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListApiSpecRevisions.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec to list revisions for.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of revisions to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token, received from a previous ListApiSpecRevisions call.
        #     Provide this to retrieve the subsequent page.
        class ListApiSpecRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListApiSpecRevisionsResponse.
        # @!attribute [rw] api_specs
        #   @return [::Array<::Google::Cloud::ApigeeRegistry::V1::ApiSpec>]
        #     The revisions of the spec.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApiSpecRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for RollbackApiSpec.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The spec being rolled back.
        # @!attribute [rw] revision_id
        #   @return [::String]
        #     Required. The revision ID to roll back to.
        #     It must be a revision of the same spec.
        #
        #       Example: `c7cfa2a8`
        class RollbackApiSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteApiSpecRevision.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec revision to be deleted,
        #     with a revision ID explicitly included.
        #
        #     Example:
        #     `projects/sample/locations/global/apis/petstore/versions/1.0.0/specs/openapi.yaml@c7cfa2a8`
        class DeleteApiSpecRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListApiDeployments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of deployments.
        #     Format: `projects/*/locations/*/apis/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of deployments to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 50 values will be returned.
        #     The maximum is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListApiDeployments` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListApiDeployments` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that can be used to filter the list. Filters use the Common
        #     Expression Language and can refer to all message fields.
        class ListApiDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListApiDeployments.
        # @!attribute [rw] api_deployments
        #   @return [::Array<::Google::Cloud::ApigeeRegistry::V1::ApiDeployment>]
        #     The deployments from the specified publisher.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApiDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetApiDeployment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment to retrieve.
        #     Format: `projects/*/locations/*/apis/*/deployments/*`
        class GetApiDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateApiDeployment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of deployments.
        #     Format: `projects/*/locations/*/apis/*`
        # @!attribute [rw] api_deployment
        #   @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
        #     Required. The deployment to create.
        # @!attribute [rw] api_deployment_id
        #   @return [::String]
        #     Required. The ID to use for the deployment, which will become the final component of
        #     the deployment's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        #
        #     Following AIP-162, IDs must not have the form of a UUID.
        class CreateApiDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateApiDeployment.
        # @!attribute [rw] api_deployment
        #   @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
        #     Required. The deployment to update.
        #
        #     The `name` field is used to identify the deployment to update.
        #     Format: `projects/*/locations/*/apis/*/deployments/*`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. If omitted, all fields are updated that
        #     are set in the request message (fields set to default values are ignored).
        #     If an asterisk "*" is specified, all fields are updated, including fields
        #     that are unspecified/default in the request.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the deployment is not found, a new deployment will be
        #     created. In this situation, `update_mask` is ignored.
        class UpdateApiDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteApiDeployment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment to delete.
        #     Format: `projects/*/locations/*/apis/*/deployments/*`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, any child resources will also be deleted.
        #     (Otherwise, the request will only work if there are no child resources.)
        class DeleteApiDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for TagApiDeploymentRevision.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment to be tagged, including the revision ID.
        # @!attribute [rw] tag
        #   @return [::String]
        #     Required. The tag to apply.
        #     The tag should be at most 40 characters, and match `[a-z][a-z0-9-]{3,39}`.
        class TagApiDeploymentRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListApiDeploymentRevisions.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment to list revisions for.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of revisions to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token, received from a previous ListApiDeploymentRevisions call.
        #     Provide this to retrieve the subsequent page.
        class ListApiDeploymentRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListApiDeploymentRevisionsResponse.
        # @!attribute [rw] api_deployments
        #   @return [::Array<::Google::Cloud::ApigeeRegistry::V1::ApiDeployment>]
        #     The revisions of the deployment.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApiDeploymentRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for RollbackApiDeployment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The deployment being rolled back.
        # @!attribute [rw] revision_id
        #   @return [::String]
        #     Required. The revision ID to roll back to.
        #     It must be a revision of the same deployment.
        #
        #       Example: `c7cfa2a8`
        class RollbackApiDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteApiDeploymentRevision.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment revision to be deleted,
        #     with a revision ID explicitly included.
        #
        #     Example:
        #     `projects/sample/locations/global/apis/petstore/deployments/prod@c7cfa2a8`
        class DeleteApiDeploymentRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListArtifacts.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of artifacts.
        #     Format: `{parent}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of artifacts to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 50 values will be returned.
        #     The maximum is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListArtifacts` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListArtifacts` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that can be used to filter the list. Filters use the Common
        #     Expression Language and can refer to all message fields except contents.
        class ListArtifactsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListArtifacts.
        # @!attribute [rw] artifacts
        #   @return [::Array<::Google::Cloud::ApigeeRegistry::V1::Artifact>]
        #     The artifacts from the specified publisher.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListArtifactsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetArtifact.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the artifact to retrieve.
        #     Format: `{parent}/artifacts/*`
        class GetArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetArtifactContents.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the artifact whose contents should be retrieved.
        #     Format: `{parent}/artifacts/*`
        class GetArtifactContentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateArtifact.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of artifacts.
        #     Format: `{parent}`
        # @!attribute [rw] artifact
        #   @return [::Google::Cloud::ApigeeRegistry::V1::Artifact]
        #     Required. The artifact to create.
        # @!attribute [rw] artifact_id
        #   @return [::String]
        #     Required. The ID to use for the artifact, which will become the final component of
        #     the artifact's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        #
        #     Following AIP-162, IDs must not have the form of a UUID.
        class CreateArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ReplaceArtifact.
        # @!attribute [rw] artifact
        #   @return [::Google::Cloud::ApigeeRegistry::V1::Artifact]
        #     Required. The artifact to replace.
        #
        #     The `name` field is used to identify the artifact to replace.
        #     Format: `{parent}/artifacts/*`
        class ReplaceArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteArtifact.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the artifact to delete.
        #     Format: `{parent}/artifacts/*`
        class DeleteArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
