# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/apigeeregistry/v1/registry_service_pb"
require "google/cloud/apigee_registry/v1/registry/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module ApigeeRegistry
      module V1
        module Registry
          module Rest
            ##
            # REST client for the Registry service.
            #
            # The Registry service allows teams to manage descriptions of APIs.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "apigeeregistry.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :registry_stub

              ##
              # Configure the Registry Client class.
              #
              # See {::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Registry clients
              #   ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ApigeeRegistry", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_apis.timeout = 60.0
                  default_config.rpcs.list_apis.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.get_api.timeout = 60.0
                  default_config.rpcs.get_api.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.create_api.timeout = 60.0
                  default_config.rpcs.create_api.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.update_api.timeout = 60.0
                  default_config.rpcs.update_api.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.delete_api.timeout = 60.0
                  default_config.rpcs.delete_api.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.list_api_versions.timeout = 60.0
                  default_config.rpcs.list_api_versions.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.get_api_version.timeout = 60.0
                  default_config.rpcs.get_api_version.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.create_api_version.timeout = 60.0
                  default_config.rpcs.create_api_version.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.update_api_version.timeout = 60.0
                  default_config.rpcs.update_api_version.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.delete_api_version.timeout = 60.0
                  default_config.rpcs.delete_api_version.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.list_api_specs.timeout = 60.0
                  default_config.rpcs.list_api_specs.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.get_api_spec.timeout = 60.0
                  default_config.rpcs.get_api_spec.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.get_api_spec_contents.timeout = 60.0
                  default_config.rpcs.get_api_spec_contents.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.create_api_spec.timeout = 60.0
                  default_config.rpcs.create_api_spec.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.update_api_spec.timeout = 60.0
                  default_config.rpcs.update_api_spec.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.delete_api_spec.timeout = 60.0
                  default_config.rpcs.delete_api_spec.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.tag_api_spec_revision.timeout = 60.0
                  default_config.rpcs.tag_api_spec_revision.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.list_api_spec_revisions.timeout = 60.0
                  default_config.rpcs.list_api_spec_revisions.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.rollback_api_spec.timeout = 60.0

                  default_config.rpcs.delete_api_spec_revision.timeout = 60.0
                  default_config.rpcs.delete_api_spec_revision.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.list_api_deployments.timeout = 60.0
                  default_config.rpcs.list_api_deployments.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.get_api_deployment.timeout = 60.0
                  default_config.rpcs.get_api_deployment.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.create_api_deployment.timeout = 60.0
                  default_config.rpcs.create_api_deployment.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.update_api_deployment.timeout = 60.0
                  default_config.rpcs.update_api_deployment.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.delete_api_deployment.timeout = 60.0
                  default_config.rpcs.delete_api_deployment.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.tag_api_deployment_revision.timeout = 60.0
                  default_config.rpcs.tag_api_deployment_revision.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.list_api_deployment_revisions.timeout = 60.0
                  default_config.rpcs.list_api_deployment_revisions.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.rollback_api_deployment.timeout = 60.0

                  default_config.rpcs.delete_api_deployment_revision.timeout = 60.0
                  default_config.rpcs.delete_api_deployment_revision.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.list_artifacts.timeout = 60.0
                  default_config.rpcs.list_artifacts.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.get_artifact.timeout = 60.0
                  default_config.rpcs.get_artifact.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.get_artifact_contents.timeout = 60.0
                  default_config.rpcs.get_artifact_contents.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.create_artifact.timeout = 60.0
                  default_config.rpcs.create_artifact.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.replace_artifact.timeout = 60.0
                  default_config.rpcs.replace_artifact.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config.rpcs.delete_artifact.timeout = 60.0
                  default_config.rpcs.delete_artifact.retry_policy = {
                    initial_delay: 0.2, max_delay: 60.0, multiplier: 1.3, retry_codes: [10, 1, 4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Registry Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @registry_stub.universe_domain
              end

              ##
              # Create a new Registry REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Registry client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @registry_stub = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @registry_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @registry_stub.endpoint
                  config.universe_domain = @registry_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @registry_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @registry_stub.endpoint
                  config.universe_domain = @registry_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @registry_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @registry_stub.logger
              end

              # Service calls

              ##
              # Returns matching APIs.
              #
              # @overload list_apis(request, options = nil)
              #   Pass arguments to `list_apis` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ListApisRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ListApisRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_apis(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_apis` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of APIs.
              #     Format: `projects/*/locations/*`
              #   @param page_size [::Integer]
              #     The maximum number of APIs to return.
              #     The service may return fewer than this value.
              #     If unspecified, at most 50 values will be returned.
              #     The maximum is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListApis` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListApis` must match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     An expression that can be used to filter the list. Filters use the Common
              #     Expression Language and can refer to all message fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::Api>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::Api>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ListApisRequest.new
              #
              #   # Call the list_apis method.
              #   result = client.list_apis request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApigeeRegistry::V1::Api.
              #     p item
              #   end
              #
              def list_apis request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ListApisRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_apis.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_apis.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_apis.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.list_apis request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registry_stub, :list_apis, "apis", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a specified API.
              #
              # @overload get_api(request, options = nil)
              #   Pass arguments to `get_api` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::GetApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::GetApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_api(name: nil)
              #   Pass arguments to `get_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the API to retrieve.
              #     Format: `projects/*/locations/*/apis/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::Api]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::Api]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::GetApiRequest.new
              #
              #   # Call the get_api method.
              #   result = client.get_api request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::Api.
              #   p result
              #
              def get_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::GetApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.get_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a specified API.
              #
              # @overload create_api(request, options = nil)
              #   Pass arguments to `create_api` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_api(parent: nil, api: nil, api_id: nil)
              #   Pass arguments to `create_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of APIs.
              #     Format: `projects/*/locations/*`
              #   @param api [::Google::Cloud::ApigeeRegistry::V1::Api, ::Hash]
              #     Required. The API to create.
              #   @param api_id [::String]
              #     Required. The ID to use for the API, which will become the final component of
              #     the API's resource name.
              #
              #     This value should be 4-63 characters, and valid characters
              #     are /[a-z][0-9]-/.
              #
              #     Following AIP-162, IDs must not have the form of a UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::Api]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::Api]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::CreateApiRequest.new
              #
              #   # Call the create_api method.
              #   result = client.create_api request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::Api.
              #   p result
              #
              def create_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::CreateApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.create_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Used to modify a specified API.
              #
              # @overload update_api(request, options = nil)
              #   Pass arguments to `update_api` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_api(api: nil, update_mask: nil, allow_missing: nil)
              #   Pass arguments to `update_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param api [::Google::Cloud::ApigeeRegistry::V1::Api, ::Hash]
              #     Required. The API to update.
              #
              #     The `name` field is used to identify the API to update.
              #     Format: `projects/*/locations/*/apis/*`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated. If omitted, all fields are updated that
              #     are set in the request message (fields set to default values are ignored).
              #     If an asterisk "*" is specified, all fields are updated, including fields
              #     that are unspecified/default in the request.
              #   @param allow_missing [::Boolean]
              #     If set to true, and the API is not found, a new API will be created.
              #     In this situation, `update_mask` is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::Api]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::Api]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest.new
              #
              #   # Call the update_api method.
              #   result = client.update_api request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::Api.
              #   p result
              #
              def update_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::UpdateApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.update_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a specified API and all of the resources that it
              # owns.
              #
              # @overload delete_api(request, options = nil)
              #   Pass arguments to `delete_api` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api(name: nil, force: nil)
              #   Pass arguments to `delete_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the API to delete.
              #     Format: `projects/*/locations/*/apis/*`
              #   @param force [::Boolean]
              #     If set to true, any child resources will also be deleted.
              #     (Otherwise, the request will only work if there are no child resources.)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest.new
              #
              #   # Call the delete_api method.
              #   result = client.delete_api request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::DeleteApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.delete_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns matching versions.
              #
              # @overload list_api_versions(request, options = nil)
              #   Pass arguments to `list_api_versions` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_api_versions(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_api_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of versions.
              #     Format: `projects/*/locations/*/apis/*`
              #   @param page_size [::Integer]
              #     The maximum number of versions to return.
              #     The service may return fewer than this value.
              #     If unspecified, at most 50 values will be returned.
              #     The maximum is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListApiVersions` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListApiVersions` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     An expression that can be used to filter the list. Filters use the Common
              #     Expression Language and can refer to all message fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest.new
              #
              #   # Call the list_api_versions method.
              #   result = client.list_api_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApigeeRegistry::V1::ApiVersion.
              #     p item
              #   end
              #
              def list_api_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ListApiVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_api_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_api_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_api_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.list_api_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registry_stub, :list_api_versions, "api_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a specified version.
              #
              # @overload get_api_version(request, options = nil)
              #   Pass arguments to `get_api_version` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_api_version(name: nil)
              #   Pass arguments to `get_api_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the version to retrieve.
              #     Format: `projects/*/locations/*/apis/*/versions/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest.new
              #
              #   # Call the get_api_version method.
              #   result = client.get_api_version request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiVersion.
              #   p result
              #
              def get_api_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::GetApiVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_api_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_api_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_api_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.get_api_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a specified version.
              #
              # @overload create_api_version(request, options = nil)
              #   Pass arguments to `create_api_version` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_api_version(parent: nil, api_version: nil, api_version_id: nil)
              #   Pass arguments to `create_api_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of versions.
              #     Format: `projects/*/locations/*/apis/*`
              #   @param api_version [::Google::Cloud::ApigeeRegistry::V1::ApiVersion, ::Hash]
              #     Required. The version to create.
              #   @param api_version_id [::String]
              #     Required. The ID to use for the version, which will become the final component of
              #     the version's resource name.
              #
              #     This value should be 1-63 characters, and valid characters
              #     are /[a-z][0-9]-/.
              #
              #     Following AIP-162, IDs must not have the form of a UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest.new
              #
              #   # Call the create_api_version method.
              #   result = client.create_api_version request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiVersion.
              #   p result
              #
              def create_api_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::CreateApiVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_api_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_api_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_api_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.create_api_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Used to modify a specified version.
              #
              # @overload update_api_version(request, options = nil)
              #   Pass arguments to `update_api_version` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_api_version(api_version: nil, update_mask: nil, allow_missing: nil)
              #   Pass arguments to `update_api_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param api_version [::Google::Cloud::ApigeeRegistry::V1::ApiVersion, ::Hash]
              #     Required. The version to update.
              #
              #     The `name` field is used to identify the version to update.
              #     Format: `projects/*/locations/*/apis/*/versions/*`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated. If omitted, all fields are updated that
              #     are set in the request message (fields set to default values are ignored).
              #     If an asterisk "*" is specified, all fields are updated, including fields
              #     that are unspecified/default in the request.
              #   @param allow_missing [::Boolean]
              #     If set to true, and the version is not found, a new version will be
              #     created. In this situation, `update_mask` is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest.new
              #
              #   # Call the update_api_version method.
              #   result = client.update_api_version request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiVersion.
              #   p result
              #
              def update_api_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::UpdateApiVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_api_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_api_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_api_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.update_api_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a specified version and all of the resources that
              # it owns.
              #
              # @overload delete_api_version(request, options = nil)
              #   Pass arguments to `delete_api_version` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api_version(name: nil, force: nil)
              #   Pass arguments to `delete_api_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the version to delete.
              #     Format: `projects/*/locations/*/apis/*/versions/*`
              #   @param force [::Boolean]
              #     If set to true, any child resources will also be deleted.
              #     (Otherwise, the request will only work if there are no child resources.)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest.new
              #
              #   # Call the delete_api_version method.
              #   result = client.delete_api_version request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_api_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::DeleteApiVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.delete_api_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns matching specs.
              #
              # @overload list_api_specs(request, options = nil)
              #   Pass arguments to `list_api_specs` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_api_specs(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_api_specs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of specs.
              #     Format: `projects/*/locations/*/apis/*/versions/*`
              #   @param page_size [::Integer]
              #     The maximum number of specs to return.
              #     The service may return fewer than this value.
              #     If unspecified, at most 50 values will be returned.
              #     The maximum is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListApiSpecs` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListApiSpecs` must match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     An expression that can be used to filter the list. Filters use the Common
              #     Expression Language and can refer to all message fields except contents.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiSpec>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiSpec>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest.new
              #
              #   # Call the list_api_specs method.
              #   result = client.list_api_specs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #     p item
              #   end
              #
              def list_api_specs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_api_specs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_api_specs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_api_specs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.list_api_specs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registry_stub, :list_api_specs, "api_specs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a specified spec.
              #
              # @overload get_api_spec(request, options = nil)
              #   Pass arguments to `get_api_spec` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_api_spec(name: nil)
              #   Pass arguments to `get_api_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec to retrieve.
              #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest.new
              #
              #   # Call the get_api_spec method.
              #   result = client.get_api_spec request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #   p result
              #
              def get_api_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_api_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_api_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_api_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.get_api_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the contents of a specified spec.
              # If specs are stored with GZip compression, the default behavior
              # is to return the spec uncompressed (the mime_type response field
              # indicates the exact format returned).
              #
              # @overload get_api_spec_contents(request, options = nil)
              #   Pass arguments to `get_api_spec_contents` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_api_spec_contents(name: nil)
              #   Pass arguments to `get_api_spec_contents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec whose contents should be retrieved.
              #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Api::HttpBody]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest.new
              #
              #   # Call the get_api_spec_contents method.
              #   result = client.get_api_spec_contents request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def get_api_spec_contents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::GetApiSpecContentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_api_spec_contents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_api_spec_contents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_api_spec_contents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.get_api_spec_contents request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a specified spec.
              #
              # @overload create_api_spec(request, options = nil)
              #   Pass arguments to `create_api_spec` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_api_spec(parent: nil, api_spec: nil, api_spec_id: nil)
              #   Pass arguments to `create_api_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of specs.
              #     Format: `projects/*/locations/*/apis/*/versions/*`
              #   @param api_spec [::Google::Cloud::ApigeeRegistry::V1::ApiSpec, ::Hash]
              #     Required. The spec to create.
              #   @param api_spec_id [::String]
              #     Required. The ID to use for the spec, which will become the final component of
              #     the spec's resource name.
              #
              #     This value should be 4-63 characters, and valid characters
              #     are /[a-z][0-9]-/.
              #
              #     Following AIP-162, IDs must not have the form of a UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest.new
              #
              #   # Call the create_api_spec method.
              #   result = client.create_api_spec request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #   p result
              #
              def create_api_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::CreateApiSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_api_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_api_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_api_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.create_api_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Used to modify a specified spec.
              #
              # @overload update_api_spec(request, options = nil)
              #   Pass arguments to `update_api_spec` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_api_spec(api_spec: nil, update_mask: nil, allow_missing: nil)
              #   Pass arguments to `update_api_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param api_spec [::Google::Cloud::ApigeeRegistry::V1::ApiSpec, ::Hash]
              #     Required. The spec to update.
              #
              #     The `name` field is used to identify the spec to update.
              #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated. If omitted, all fields are updated that
              #     are set in the request message (fields set to default values are ignored).
              #     If an asterisk "*" is specified, all fields are updated, including fields
              #     that are unspecified/default in the request.
              #   @param allow_missing [::Boolean]
              #     If set to true, and the spec is not found, a new spec will be created.
              #     In this situation, `update_mask` is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest.new
              #
              #   # Call the update_api_spec method.
              #   result = client.update_api_spec request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #   p result
              #
              def update_api_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::UpdateApiSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_api_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_api_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_api_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.update_api_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a specified spec, all revisions, and all child
              # resources (e.g., artifacts).
              #
              # @overload delete_api_spec(request, options = nil)
              #   Pass arguments to `delete_api_spec` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api_spec(name: nil, force: nil)
              #   Pass arguments to `delete_api_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec to delete.
              #     Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
              #   @param force [::Boolean]
              #     If set to true, any child resources will also be deleted.
              #     (Otherwise, the request will only work if there are no child resources.)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest.new
              #
              #   # Call the delete_api_spec method.
              #   result = client.delete_api_spec request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_api_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.delete_api_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds a tag to a specified revision of a spec.
              #
              # @overload tag_api_spec_revision(request, options = nil)
              #   Pass arguments to `tag_api_spec_revision` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload tag_api_spec_revision(name: nil, tag: nil)
              #   Pass arguments to `tag_api_spec_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec to be tagged, including the revision ID.
              #   @param tag [::String]
              #     Required. The tag to apply.
              #     The tag should be at most 40 characters, and match `[a-z][a-z0-9-]{3,39}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest.new
              #
              #   # Call the tag_api_spec_revision method.
              #   result = client.tag_api_spec_revision request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #   p result
              #
              def tag_api_spec_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::TagApiSpecRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.tag_api_spec_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.tag_api_spec_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.tag_api_spec_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.tag_api_spec_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all revisions of a spec.
              # Revisions are returned in descending order of revision creation time.
              #
              # @overload list_api_spec_revisions(request, options = nil)
              #   Pass arguments to `list_api_spec_revisions` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_api_spec_revisions(name: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_api_spec_revisions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec to list revisions for.
              #   @param page_size [::Integer]
              #     The maximum number of revisions to return per page.
              #   @param page_token [::String]
              #     The page token, received from a previous ListApiSpecRevisions call.
              #     Provide this to retrieve the subsequent page.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiSpec>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiSpec>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest.new
              #
              #   # Call the list_api_spec_revisions method.
              #   result = client.list_api_spec_revisions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #     p item
              #   end
              #
              def list_api_spec_revisions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ListApiSpecRevisionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_api_spec_revisions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_api_spec_revisions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_api_spec_revisions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.list_api_spec_revisions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registry_stub, :list_api_spec_revisions, "api_specs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the current revision to a specified prior revision.
              # Note that this creates a new revision with a new revision ID.
              #
              # @overload rollback_api_spec(request, options = nil)
              #   Pass arguments to `rollback_api_spec` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rollback_api_spec(name: nil, revision_id: nil)
              #   Pass arguments to `rollback_api_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The spec being rolled back.
              #   @param revision_id [::String]
              #     Required. The revision ID to roll back to.
              #     It must be a revision of the same spec.
              #
              #       Example: `c7cfa2a8`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest.new
              #
              #   # Call the rollback_api_spec method.
              #   result = client.rollback_api_spec request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #   p result
              #
              def rollback_api_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::RollbackApiSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rollback_api_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rollback_api_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rollback_api_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.rollback_api_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a revision of a spec.
              #
              # @overload delete_api_spec_revision(request, options = nil)
              #   Pass arguments to `delete_api_spec_revision` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api_spec_revision(name: nil)
              #   Pass arguments to `delete_api_spec_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec revision to be deleted,
              #     with a revision ID explicitly included.
              #
              #     Example:
              #     `projects/sample/locations/global/apis/petstore/versions/1.0.0/specs/openapi.yaml@c7cfa2a8`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest.new
              #
              #   # Call the delete_api_spec_revision method.
              #   result = client.delete_api_spec_revision request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiSpec.
              #   p result
              #
              def delete_api_spec_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::DeleteApiSpecRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api_spec_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api_spec_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api_spec_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.delete_api_spec_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns matching deployments.
              #
              # @overload list_api_deployments(request, options = nil)
              #   Pass arguments to `list_api_deployments` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_api_deployments(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_api_deployments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of deployments.
              #     Format: `projects/*/locations/*/apis/*`
              #   @param page_size [::Integer]
              #     The maximum number of deployments to return.
              #     The service may return fewer than this value.
              #     If unspecified, at most 50 values will be returned.
              #     The maximum is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListApiDeployments` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListApiDeployments` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     An expression that can be used to filter the list. Filters use the Common
              #     Expression Language and can refer to all message fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiDeployment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiDeployment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest.new
              #
              #   # Call the list_api_deployments method.
              #   result = client.list_api_deployments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #     p item
              #   end
              #
              def list_api_deployments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_api_deployments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_api_deployments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_api_deployments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.list_api_deployments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registry_stub, :list_api_deployments, "api_deployments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a specified deployment.
              #
              # @overload get_api_deployment(request, options = nil)
              #   Pass arguments to `get_api_deployment` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_api_deployment(name: nil)
              #   Pass arguments to `get_api_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment to retrieve.
              #     Format: `projects/*/locations/*/apis/*/deployments/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest.new
              #
              #   # Call the get_api_deployment method.
              #   result = client.get_api_deployment request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #   p result
              #
              def get_api_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::GetApiDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_api_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_api_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_api_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.get_api_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a specified deployment.
              #
              # @overload create_api_deployment(request, options = nil)
              #   Pass arguments to `create_api_deployment` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_api_deployment(parent: nil, api_deployment: nil, api_deployment_id: nil)
              #   Pass arguments to `create_api_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of deployments.
              #     Format: `projects/*/locations/*/apis/*`
              #   @param api_deployment [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment, ::Hash]
              #     Required. The deployment to create.
              #   @param api_deployment_id [::String]
              #     Required. The ID to use for the deployment, which will become the final component of
              #     the deployment's resource name.
              #
              #     This value should be 4-63 characters, and valid characters
              #     are /[a-z][0-9]-/.
              #
              #     Following AIP-162, IDs must not have the form of a UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest.new
              #
              #   # Call the create_api_deployment method.
              #   result = client.create_api_deployment request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #   p result
              #
              def create_api_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::CreateApiDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_api_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_api_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_api_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.create_api_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Used to modify a specified deployment.
              #
              # @overload update_api_deployment(request, options = nil)
              #   Pass arguments to `update_api_deployment` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_api_deployment(api_deployment: nil, update_mask: nil, allow_missing: nil)
              #   Pass arguments to `update_api_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param api_deployment [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment, ::Hash]
              #     Required. The deployment to update.
              #
              #     The `name` field is used to identify the deployment to update.
              #     Format: `projects/*/locations/*/apis/*/deployments/*`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated. If omitted, all fields are updated that
              #     are set in the request message (fields set to default values are ignored).
              #     If an asterisk "*" is specified, all fields are updated, including fields
              #     that are unspecified/default in the request.
              #   @param allow_missing [::Boolean]
              #     If set to true, and the deployment is not found, a new deployment will be
              #     created. In this situation, `update_mask` is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest.new
              #
              #   # Call the update_api_deployment method.
              #   result = client.update_api_deployment request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #   p result
              #
              def update_api_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::UpdateApiDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_api_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_api_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_api_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.update_api_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a specified deployment, all revisions, and all
              # child resources (e.g., artifacts).
              #
              # @overload delete_api_deployment(request, options = nil)
              #   Pass arguments to `delete_api_deployment` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api_deployment(name: nil, force: nil)
              #   Pass arguments to `delete_api_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment to delete.
              #     Format: `projects/*/locations/*/apis/*/deployments/*`
              #   @param force [::Boolean]
              #     If set to true, any child resources will also be deleted.
              #     (Otherwise, the request will only work if there are no child resources.)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest.new
              #
              #   # Call the delete_api_deployment method.
              #   result = client.delete_api_deployment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_api_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.delete_api_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds a tag to a specified revision of a
              # deployment.
              #
              # @overload tag_api_deployment_revision(request, options = nil)
              #   Pass arguments to `tag_api_deployment_revision` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload tag_api_deployment_revision(name: nil, tag: nil)
              #   Pass arguments to `tag_api_deployment_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment to be tagged, including the revision ID.
              #   @param tag [::String]
              #     Required. The tag to apply.
              #     The tag should be at most 40 characters, and match `[a-z][a-z0-9-]{3,39}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest.new
              #
              #   # Call the tag_api_deployment_revision method.
              #   result = client.tag_api_deployment_revision request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #   p result
              #
              def tag_api_deployment_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::TagApiDeploymentRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.tag_api_deployment_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.tag_api_deployment_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.tag_api_deployment_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.tag_api_deployment_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all revisions of a deployment.
              # Revisions are returned in descending order of revision creation time.
              #
              # @overload list_api_deployment_revisions(request, options = nil)
              #   Pass arguments to `list_api_deployment_revisions` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_api_deployment_revisions(name: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_api_deployment_revisions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment to list revisions for.
              #   @param page_size [::Integer]
              #     The maximum number of revisions to return per page.
              #   @param page_token [::String]
              #     The page token, received from a previous ListApiDeploymentRevisions call.
              #     Provide this to retrieve the subsequent page.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiDeployment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::ApiDeployment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest.new
              #
              #   # Call the list_api_deployment_revisions method.
              #   result = client.list_api_deployment_revisions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #     p item
              #   end
              #
              def list_api_deployment_revisions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ListApiDeploymentRevisionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_api_deployment_revisions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_api_deployment_revisions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_api_deployment_revisions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.list_api_deployment_revisions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registry_stub, :list_api_deployment_revisions, "api_deployments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the current revision to a specified prior
              # revision. Note that this creates a new revision with a new revision ID.
              #
              # @overload rollback_api_deployment(request, options = nil)
              #   Pass arguments to `rollback_api_deployment` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rollback_api_deployment(name: nil, revision_id: nil)
              #   Pass arguments to `rollback_api_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The deployment being rolled back.
              #   @param revision_id [::String]
              #     Required. The revision ID to roll back to.
              #     It must be a revision of the same deployment.
              #
              #       Example: `c7cfa2a8`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest.new
              #
              #   # Call the rollback_api_deployment method.
              #   result = client.rollback_api_deployment request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #   p result
              #
              def rollback_api_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::RollbackApiDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rollback_api_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rollback_api_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rollback_api_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.rollback_api_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a revision of a deployment.
              #
              # @overload delete_api_deployment_revision(request, options = nil)
              #   Pass arguments to `delete_api_deployment_revision` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api_deployment_revision(name: nil)
              #   Pass arguments to `delete_api_deployment_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment revision to be deleted,
              #     with a revision ID explicitly included.
              #
              #     Example:
              #     `projects/sample/locations/global/apis/petstore/deployments/prod@c7cfa2a8`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::ApiDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest.new
              #
              #   # Call the delete_api_deployment_revision method.
              #   result = client.delete_api_deployment_revision request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::ApiDeployment.
              #   p result
              #
              def delete_api_deployment_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::DeleteApiDeploymentRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api_deployment_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api_deployment_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api_deployment_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.delete_api_deployment_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns matching artifacts.
              #
              # @overload list_artifacts(request, options = nil)
              #   Pass arguments to `list_artifacts` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_artifacts(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_artifacts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of artifacts.
              #     Format: `{parent}`
              #   @param page_size [::Integer]
              #     The maximum number of artifacts to return.
              #     The service may return fewer than this value.
              #     If unspecified, at most 50 values will be returned.
              #     The maximum is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListArtifacts` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListArtifacts` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     An expression that can be used to filter the list. Filters use the Common
              #     Expression Language and can refer to all message fields except contents.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::Artifact>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApigeeRegistry::V1::Artifact>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest.new
              #
              #   # Call the list_artifacts method.
              #   result = client.list_artifacts request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApigeeRegistry::V1::Artifact.
              #     p item
              #   end
              #
              def list_artifacts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ListArtifactsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_artifacts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_artifacts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_artifacts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.list_artifacts request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @registry_stub, :list_artifacts, "artifacts", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a specified artifact.
              #
              # @overload get_artifact(request, options = nil)
              #   Pass arguments to `get_artifact` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_artifact(name: nil)
              #   Pass arguments to `get_artifact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the artifact to retrieve.
              #     Format: `{parent}/artifacts/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::Artifact]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::Artifact]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest.new
              #
              #   # Call the get_artifact method.
              #   result = client.get_artifact request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::Artifact.
              #   p result
              #
              def get_artifact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::GetArtifactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_artifact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_artifact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_artifact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.get_artifact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the contents of a specified artifact.
              # If artifacts are stored with GZip compression, the default behavior
              # is to return the artifact uncompressed (the mime_type response field
              # indicates the exact format returned).
              #
              # @overload get_artifact_contents(request, options = nil)
              #   Pass arguments to `get_artifact_contents` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_artifact_contents(name: nil)
              #   Pass arguments to `get_artifact_contents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the artifact whose contents should be retrieved.
              #     Format: `{parent}/artifacts/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Api::HttpBody]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest.new
              #
              #   # Call the get_artifact_contents method.
              #   result = client.get_artifact_contents request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def get_artifact_contents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::GetArtifactContentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_artifact_contents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_artifact_contents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_artifact_contents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.get_artifact_contents request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a specified artifact.
              #
              # @overload create_artifact(request, options = nil)
              #   Pass arguments to `create_artifact` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_artifact(parent: nil, artifact: nil, artifact_id: nil)
              #   Pass arguments to `create_artifact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of artifacts.
              #     Format: `{parent}`
              #   @param artifact [::Google::Cloud::ApigeeRegistry::V1::Artifact, ::Hash]
              #     Required. The artifact to create.
              #   @param artifact_id [::String]
              #     Required. The ID to use for the artifact, which will become the final component of
              #     the artifact's resource name.
              #
              #     This value should be 4-63 characters, and valid characters
              #     are /[a-z][0-9]-/.
              #
              #     Following AIP-162, IDs must not have the form of a UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::Artifact]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::Artifact]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest.new
              #
              #   # Call the create_artifact method.
              #   result = client.create_artifact request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::Artifact.
              #   p result
              #
              def create_artifact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::CreateArtifactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_artifact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_artifact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_artifact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.create_artifact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Used to replace a specified artifact.
              #
              # @overload replace_artifact(request, options = nil)
              #   Pass arguments to `replace_artifact` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload replace_artifact(artifact: nil)
              #   Pass arguments to `replace_artifact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param artifact [::Google::Cloud::ApigeeRegistry::V1::Artifact, ::Hash]
              #     Required. The artifact to replace.
              #
              #     The `name` field is used to identify the artifact to replace.
              #     Format: `{parent}/artifacts/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApigeeRegistry::V1::Artifact]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApigeeRegistry::V1::Artifact]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest.new
              #
              #   # Call the replace_artifact method.
              #   result = client.replace_artifact request
              #
              #   # The returned object is of type Google::Cloud::ApigeeRegistry::V1::Artifact.
              #   p result
              #
              def replace_artifact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::ReplaceArtifactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.replace_artifact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.replace_artifact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.replace_artifact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.replace_artifact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a specified artifact.
              #
              # @overload delete_artifact(request, options = nil)
              #   Pass arguments to `delete_artifact` via a request object, either of type
              #   {::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_artifact(name: nil)
              #   Pass arguments to `delete_artifact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the artifact to delete.
              #     Format: `{parent}/artifacts/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/apigee_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest.new
              #
              #   # Call the delete_artifact method.
              #   result = client.delete_artifact request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_artifact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApigeeRegistry::V1::DeleteArtifactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_artifact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApigeeRegistry::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_artifact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_artifact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @registry_stub.delete_artifact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Registry REST API.
              #
              # This class represents the configuration for Registry REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_apis to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_apis.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ApigeeRegistry::V1::Registry::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_apis.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "apigeeregistry.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Registry API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_apis`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_apis
                  ##
                  # RPC-specific configuration for `get_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_api
                  ##
                  # RPC-specific configuration for `create_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_api
                  ##
                  # RPC-specific configuration for `update_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_api
                  ##
                  # RPC-specific configuration for `delete_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api
                  ##
                  # RPC-specific configuration for `list_api_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_api_versions
                  ##
                  # RPC-specific configuration for `get_api_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_api_version
                  ##
                  # RPC-specific configuration for `create_api_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_api_version
                  ##
                  # RPC-specific configuration for `update_api_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_api_version
                  ##
                  # RPC-specific configuration for `delete_api_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api_version
                  ##
                  # RPC-specific configuration for `list_api_specs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_api_specs
                  ##
                  # RPC-specific configuration for `get_api_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_api_spec
                  ##
                  # RPC-specific configuration for `get_api_spec_contents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_api_spec_contents
                  ##
                  # RPC-specific configuration for `create_api_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_api_spec
                  ##
                  # RPC-specific configuration for `update_api_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_api_spec
                  ##
                  # RPC-specific configuration for `delete_api_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api_spec
                  ##
                  # RPC-specific configuration for `tag_api_spec_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :tag_api_spec_revision
                  ##
                  # RPC-specific configuration for `list_api_spec_revisions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_api_spec_revisions
                  ##
                  # RPC-specific configuration for `rollback_api_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rollback_api_spec
                  ##
                  # RPC-specific configuration for `delete_api_spec_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api_spec_revision
                  ##
                  # RPC-specific configuration for `list_api_deployments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_api_deployments
                  ##
                  # RPC-specific configuration for `get_api_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_api_deployment
                  ##
                  # RPC-specific configuration for `create_api_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_api_deployment
                  ##
                  # RPC-specific configuration for `update_api_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_api_deployment
                  ##
                  # RPC-specific configuration for `delete_api_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api_deployment
                  ##
                  # RPC-specific configuration for `tag_api_deployment_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :tag_api_deployment_revision
                  ##
                  # RPC-specific configuration for `list_api_deployment_revisions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_api_deployment_revisions
                  ##
                  # RPC-specific configuration for `rollback_api_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rollback_api_deployment
                  ##
                  # RPC-specific configuration for `delete_api_deployment_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api_deployment_revision
                  ##
                  # RPC-specific configuration for `list_artifacts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_artifacts
                  ##
                  # RPC-specific configuration for `get_artifact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_artifact
                  ##
                  # RPC-specific configuration for `get_artifact_contents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_artifact_contents
                  ##
                  # RPC-specific configuration for `create_artifact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_artifact
                  ##
                  # RPC-specific configuration for `replace_artifact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :replace_artifact
                  ##
                  # RPC-specific configuration for `delete_artifact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_artifact

                  # @private
                  def initialize parent_rpcs = nil
                    list_apis_config = parent_rpcs.list_apis if parent_rpcs.respond_to? :list_apis
                    @list_apis = ::Gapic::Config::Method.new list_apis_config
                    get_api_config = parent_rpcs.get_api if parent_rpcs.respond_to? :get_api
                    @get_api = ::Gapic::Config::Method.new get_api_config
                    create_api_config = parent_rpcs.create_api if parent_rpcs.respond_to? :create_api
                    @create_api = ::Gapic::Config::Method.new create_api_config
                    update_api_config = parent_rpcs.update_api if parent_rpcs.respond_to? :update_api
                    @update_api = ::Gapic::Config::Method.new update_api_config
                    delete_api_config = parent_rpcs.delete_api if parent_rpcs.respond_to? :delete_api
                    @delete_api = ::Gapic::Config::Method.new delete_api_config
                    list_api_versions_config = parent_rpcs.list_api_versions if parent_rpcs.respond_to? :list_api_versions
                    @list_api_versions = ::Gapic::Config::Method.new list_api_versions_config
                    get_api_version_config = parent_rpcs.get_api_version if parent_rpcs.respond_to? :get_api_version
                    @get_api_version = ::Gapic::Config::Method.new get_api_version_config
                    create_api_version_config = parent_rpcs.create_api_version if parent_rpcs.respond_to? :create_api_version
                    @create_api_version = ::Gapic::Config::Method.new create_api_version_config
                    update_api_version_config = parent_rpcs.update_api_version if parent_rpcs.respond_to? :update_api_version
                    @update_api_version = ::Gapic::Config::Method.new update_api_version_config
                    delete_api_version_config = parent_rpcs.delete_api_version if parent_rpcs.respond_to? :delete_api_version
                    @delete_api_version = ::Gapic::Config::Method.new delete_api_version_config
                    list_api_specs_config = parent_rpcs.list_api_specs if parent_rpcs.respond_to? :list_api_specs
                    @list_api_specs = ::Gapic::Config::Method.new list_api_specs_config
                    get_api_spec_config = parent_rpcs.get_api_spec if parent_rpcs.respond_to? :get_api_spec
                    @get_api_spec = ::Gapic::Config::Method.new get_api_spec_config
                    get_api_spec_contents_config = parent_rpcs.get_api_spec_contents if parent_rpcs.respond_to? :get_api_spec_contents
                    @get_api_spec_contents = ::Gapic::Config::Method.new get_api_spec_contents_config
                    create_api_spec_config = parent_rpcs.create_api_spec if parent_rpcs.respond_to? :create_api_spec
                    @create_api_spec = ::Gapic::Config::Method.new create_api_spec_config
                    update_api_spec_config = parent_rpcs.update_api_spec if parent_rpcs.respond_to? :update_api_spec
                    @update_api_spec = ::Gapic::Config::Method.new update_api_spec_config
                    delete_api_spec_config = parent_rpcs.delete_api_spec if parent_rpcs.respond_to? :delete_api_spec
                    @delete_api_spec = ::Gapic::Config::Method.new delete_api_spec_config
                    tag_api_spec_revision_config = parent_rpcs.tag_api_spec_revision if parent_rpcs.respond_to? :tag_api_spec_revision
                    @tag_api_spec_revision = ::Gapic::Config::Method.new tag_api_spec_revision_config
                    list_api_spec_revisions_config = parent_rpcs.list_api_spec_revisions if parent_rpcs.respond_to? :list_api_spec_revisions
                    @list_api_spec_revisions = ::Gapic::Config::Method.new list_api_spec_revisions_config
                    rollback_api_spec_config = parent_rpcs.rollback_api_spec if parent_rpcs.respond_to? :rollback_api_spec
                    @rollback_api_spec = ::Gapic::Config::Method.new rollback_api_spec_config
                    delete_api_spec_revision_config = parent_rpcs.delete_api_spec_revision if parent_rpcs.respond_to? :delete_api_spec_revision
                    @delete_api_spec_revision = ::Gapic::Config::Method.new delete_api_spec_revision_config
                    list_api_deployments_config = parent_rpcs.list_api_deployments if parent_rpcs.respond_to? :list_api_deployments
                    @list_api_deployments = ::Gapic::Config::Method.new list_api_deployments_config
                    get_api_deployment_config = parent_rpcs.get_api_deployment if parent_rpcs.respond_to? :get_api_deployment
                    @get_api_deployment = ::Gapic::Config::Method.new get_api_deployment_config
                    create_api_deployment_config = parent_rpcs.create_api_deployment if parent_rpcs.respond_to? :create_api_deployment
                    @create_api_deployment = ::Gapic::Config::Method.new create_api_deployment_config
                    update_api_deployment_config = parent_rpcs.update_api_deployment if parent_rpcs.respond_to? :update_api_deployment
                    @update_api_deployment = ::Gapic::Config::Method.new update_api_deployment_config
                    delete_api_deployment_config = parent_rpcs.delete_api_deployment if parent_rpcs.respond_to? :delete_api_deployment
                    @delete_api_deployment = ::Gapic::Config::Method.new delete_api_deployment_config
                    tag_api_deployment_revision_config = parent_rpcs.tag_api_deployment_revision if parent_rpcs.respond_to? :tag_api_deployment_revision
                    @tag_api_deployment_revision = ::Gapic::Config::Method.new tag_api_deployment_revision_config
                    list_api_deployment_revisions_config = parent_rpcs.list_api_deployment_revisions if parent_rpcs.respond_to? :list_api_deployment_revisions
                    @list_api_deployment_revisions = ::Gapic::Config::Method.new list_api_deployment_revisions_config
                    rollback_api_deployment_config = parent_rpcs.rollback_api_deployment if parent_rpcs.respond_to? :rollback_api_deployment
                    @rollback_api_deployment = ::Gapic::Config::Method.new rollback_api_deployment_config
                    delete_api_deployment_revision_config = parent_rpcs.delete_api_deployment_revision if parent_rpcs.respond_to? :delete_api_deployment_revision
                    @delete_api_deployment_revision = ::Gapic::Config::Method.new delete_api_deployment_revision_config
                    list_artifacts_config = parent_rpcs.list_artifacts if parent_rpcs.respond_to? :list_artifacts
                    @list_artifacts = ::Gapic::Config::Method.new list_artifacts_config
                    get_artifact_config = parent_rpcs.get_artifact if parent_rpcs.respond_to? :get_artifact
                    @get_artifact = ::Gapic::Config::Method.new get_artifact_config
                    get_artifact_contents_config = parent_rpcs.get_artifact_contents if parent_rpcs.respond_to? :get_artifact_contents
                    @get_artifact_contents = ::Gapic::Config::Method.new get_artifact_contents_config
                    create_artifact_config = parent_rpcs.create_artifact if parent_rpcs.respond_to? :create_artifact
                    @create_artifact = ::Gapic::Config::Method.new create_artifact_config
                    replace_artifact_config = parent_rpcs.replace_artifact if parent_rpcs.respond_to? :replace_artifact
                    @replace_artifact = ::Gapic::Config::Method.new replace_artifact_config
                    delete_artifact_config = parent_rpcs.delete_artifact if parent_rpcs.respond_to? :delete_artifact
                    @delete_artifact = ::Gapic::Config::Method.new delete_artifact_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
