# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApigeeRegistry
      module V1
        module Registry
          # Path helper methods for the Registry API.
          module Paths
            ##
            # Create a fully-qualified Api resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apis/{api}`
            #
            # @param project [String]
            # @param location [String]
            # @param api [String]
            #
            # @return [::String]
            def api_path project:, location:, api:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apis/#{api}"
            end

            ##
            # Create a fully-qualified ApiDeployment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}`
            #
            # @param project [String]
            # @param location [String]
            # @param api [String]
            # @param deployment [String]
            #
            # @return [::String]
            def api_deployment_path project:, location:, api:, deployment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apis/#{api}/deployments/#{deployment}"
            end

            ##
            # Create a fully-qualified ApiSpec resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
            #
            # @param project [String]
            # @param location [String]
            # @param api [String]
            # @param version [String]
            # @param spec [String]
            #
            # @return [::String]
            def api_spec_path project:, location:, api:, version:, spec:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"
              raise ::ArgumentError, "version cannot contain /" if version.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apis/#{api}/versions/#{version}/specs/#{spec}"
            end

            ##
            # Create a fully-qualified ApiVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
            #
            # @param project [String]
            # @param location [String]
            # @param api [String]
            # @param version [String]
            #
            # @return [::String]
            def api_version_path project:, location:, api:, version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apis/#{api}/versions/#{version}"
            end

            ##
            # Create a fully-qualified Artifact resource string.
            #
            # @overload artifact_path(project:, location:, artifact:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/artifacts/{artifact}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param artifact [String]
            #
            # @overload artifact_path(project:, location:, api:, artifact:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/apis/{api}/artifacts/{artifact}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param api [String]
            #   @param artifact [String]
            #
            # @overload artifact_path(project:, location:, api:, version:, artifact:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/apis/{api}/versions/{version}/artifacts/{artifact}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param api [String]
            #   @param version [String]
            #   @param artifact [String]
            #
            # @overload artifact_path(project:, location:, api:, version:, spec:, artifact:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}/artifacts/{artifact}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param api [String]
            #   @param version [String]
            #   @param spec [String]
            #   @param artifact [String]
            #
            # @overload artifact_path(project:, location:, api:, deployment:, artifact:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}/artifacts/{artifact}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param api [String]
            #   @param deployment [String]
            #   @param artifact [String]
            #
            # @return [::String]
            def artifact_path **args
              resources = {
                "artifact:location:project" => (proc do |project:, location:, artifact:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/artifacts/#{artifact}"
                end),
                "api:artifact:location:project" => (proc do |project:, location:, api:, artifact:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/apis/#{api}/artifacts/#{artifact}"
                end),
                "api:artifact:location:project:version" => (proc do |project:, location:, api:, version:, artifact:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"
                  raise ::ArgumentError, "version cannot contain /" if version.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/apis/#{api}/versions/#{version}/artifacts/#{artifact}"
                end),
                "api:artifact:location:project:spec:version" => (proc do |project:, location:, api:, version:, spec:, artifact:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"
                  raise ::ArgumentError, "version cannot contain /" if version.to_s.include? "/"
                  raise ::ArgumentError, "spec cannot contain /" if spec.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/apis/#{api}/versions/#{version}/specs/#{spec}/artifacts/#{artifact}"
                end),
                "api:artifact:deployment:location:project" => (proc do |project:, location:, api:, deployment:, artifact:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"
                  raise ::ArgumentError, "deployment cannot contain /" if deployment.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/apis/#{api}/deployments/#{deployment}/artifacts/#{artifact}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
