# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/apigeeconnect/v1/tether_pb"
require "google/cloud/apigee_connect/v1/tether"

class ::Google::Cloud::ApigeeConnect::V1::Tether::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_egress
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ApigeeConnect::V1::EgressRequest.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    id = "hello world"
    http_response = {}
    status = {}
    project = "hello world"
    trace_id = "hello world"
    endpoint = :TETHER_ENDPOINT_UNSPECIFIED
    name = "hello world"

    egress_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :egress, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, egress_client_stub do
      # Create client
      client = ::Google::Cloud::ApigeeConnect::V1::Tether::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name }
      request_proto = ::Google::Cloud::ApigeeConnect::V1::EgressResponse.new id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name
      enum_input = [request_hash, request_proto].to_enum
      client.egress enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::ApigeeConnect::V1::EgressRequest, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name }
      request_proto = ::Google::Cloud::ApigeeConnect::V1::EgressResponse.new id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name
      stream_input = Gapic::StreamInput.new
      client.egress stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::ApigeeConnect::V1::EgressRequest, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name }
      request_proto = ::Google::Cloud::ApigeeConnect::V1::EgressResponse.new id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name
      enum_input = [request_hash, request_proto].to_enum
      client.egress enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::ApigeeConnect::V1::EgressRequest, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name }
      request_proto = ::Google::Cloud::ApigeeConnect::V1::EgressResponse.new id: id, http_response: http_response, status: status, project: project, trace_id: trace_id, endpoint: endpoint, name: name
      stream_input = Gapic::StreamInput.new
      client.egress stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::ApigeeConnect::V1::EgressRequest, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, egress_client_stub.call_rpc_count
      egress_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::ApigeeConnect::V1::EgressResponse, r
          assert_equal "hello world", r["id"]
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ApigeeConnect::V1::HttpResponse), r["http_response"]
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Rpc::Status), r["status"]
          assert_equal "hello world", r["project"]
          assert_equal "hello world", r["trace_id"]
          assert_equal :TETHER_ENDPOINT_UNSPECIFIED, r["endpoint"]
          assert_equal "hello world", r["name"]
        end
      end
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApigeeConnect::V1::Tether::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ApigeeConnect::V1::Tether::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApigeeConnect::V1::Tether::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ApigeeConnect::V1::Tether::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
