# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApigeeConnect
      module V1
        # gRPC request payload for tether.
        # @!attribute [rw] id
        #   @return [::String]
        #     Unique identifier for the request.
        # @!attribute [rw] payload
        #   @return [::Google::Cloud::ApigeeConnect::V1::Payload]
        #     Actual payload to send to agent.
        # @!attribute [rw] endpoint
        #   @return [::Google::Cloud::ApigeeConnect::V1::TetherEndpoint]
        #     Tether Endpoint.
        # @!attribute [rw] project
        #   @return [::String]
        #     GCP Project.
        #     Format: `projects/{project_number}`.
        # @!attribute [rw] trace_id
        #   @return [::String]
        #     Unique identifier for clients to trace their request/response.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Timeout for the HTTP request.
        class EgressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Payload for EgressRequest.
        # @!attribute [rw] http_request
        #   @return [::Google::Cloud::ApigeeConnect::V1::HttpRequest]
        #     The HttpRequest proto.
        #
        #     Note: The following fields are mutually exclusive: `http_request`, `stream_info`, `action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] stream_info
        #   @return [::Google::Cloud::ApigeeConnect::V1::StreamInfo]
        #     The information of stream.
        #
        #     Note: The following fields are mutually exclusive: `stream_info`, `http_request`, `action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::ApigeeConnect::V1::Action]
        #     The action taken by agent.
        #
        #     Note: The following fields are mutually exclusive: `action`, `http_request`, `stream_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Payload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Information of bi-directional stream.
        # @!attribute [rw] id
        #   @return [::String]
        #     Unique identifier for the stream.
        class StreamInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # gRPC response payload for tether.
        # @!attribute [rw] id
        #   @return [::String]
        #     Unique identifier for the response. Matches the EgressRequest's id.
        # @!attribute [rw] http_response
        #   @return [::Google::Cloud::ApigeeConnect::V1::HttpResponse]
        #     HttpResponse.
        # @!attribute [rw] status
        #   @return [::Google::Rpc::Status]
        #     Errors from application when handling the http request.
        # @!attribute [rw] project
        #   @return [::String]
        #     GCP Project.
        #     Format: `projects/{project_number}`.
        # @!attribute [rw] trace_id
        #   @return [::String]
        #     Unique identifier for clients to trace their request/response. Matches the
        #     EgressRequest's trace id
        # @!attribute [rw] endpoint
        #   @return [::Google::Cloud::ApigeeConnect::V1::TetherEndpoint]
        #     Tether Endpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name is the full resource path of endpoint.
        #     Format: `projects/{project_number or project_id}/endpoints/{endpoint}`
        class EgressResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The proto definition of http request.
        # @!attribute [rw] id
        #   @return [::String]
        #     A unique identifier for the request.
        # @!attribute [rw] method
        #   @return [::String]
        #     The HTTP request method.
        #     Valid methods: "GET", "HEAD", "POST", "PUT", "PATCH","DELETE".
        # @!attribute [rw] url
        #   @return [::Google::Cloud::ApigeeConnect::V1::Url]
        #     The HTTP request URL.
        # @!attribute [rw] headers
        #   @return [::Array<::Google::Cloud::ApigeeConnect::V1::Header>]
        #     The HTTP request headers.
        # @!attribute [rw] body
        #   @return [::String]
        #     HTTP request body.
        class HttpRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The proto definition of url.
        # A url represents a URL and the general form represented is:
        #
        #  `[scheme://][google.cloud.apigeeconnect.v1.Url.host][path]`
        # @!attribute [rw] scheme
        #   @return [::Google::Cloud::ApigeeConnect::V1::Scheme]
        #     Scheme.
        # @!attribute [rw] host
        #   @return [::String]
        #     Host or Host:Port.
        # @!attribute [rw] path
        #   @return [::String]
        #     Path starts with `/`.
        class Url
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The http headers.
        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        class Header
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The proto definition of http response.
        # @!attribute [rw] id
        #   @return [::String]
        #     A unique identifier that matches the request ID.
        # @!attribute [rw] status
        #   @return [::String]
        #     Status of http response, e.g. "200 OK".
        # @!attribute [rw] status_code
        #   @return [::Integer]
        #     Status code of http response, e.g. 200.
        # @!attribute [rw] body
        #   @return [::String]
        #     The HTTP 1.1 response body.
        # @!attribute [rw] headers
        #   @return [::Array<::Google::Cloud::ApigeeConnect::V1::Header>]
        #     The HTTP response headers.
        # @!attribute [rw] content_length
        #   @return [::Integer]
        #     Content length records the length of the associated content. The
        #     value -1 indicates that the length is unknown. Unless http method
        #     is "HEAD", values >= 0 indicate that the given number of bytes may
        #     be read from Body.
        class HttpResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The action taken by agent.
        module Action
          # Unspecified Action.
          ACTION_UNSPECIFIED = 0

          # Indicates that agent should open a new stream.
          OPEN_NEW_STREAM = 1
        end

        # Endpoint indicates where the messages will be delivered.
        module TetherEndpoint
          # Unspecified tether endpoint.
          TETHER_ENDPOINT_UNSPECIFIED = 0

          # Apigee MART endpoint.
          APIGEE_MART = 1

          # Apigee Runtime endpoint.
          APIGEE_RUNTIME = 2

          # Apigee Mint Rating endpoint.
          APIGEE_MINT_RATING = 3
        end

        # HTTP Scheme.
        module Scheme
          # Unspecified scheme.
          SCHEME_UNSPECIFIED = 0

          # HTTPS protocol.
          HTTPS = 1
        end
      end
    end
  end
end
