# -*- ruby -*-
# encoding: utf-8

require File.expand_path("lib/google/cloud/apigee_connect/v1/version", __dir__)

Gem::Specification.new do |gem|
  gem.name          = "google-cloud-apigee_connect-v1"
  gem.version       = Google::Cloud::ApigeeConnect::V1::VERSION

  gem.authors       = ["Google LLC"]
  gem.email         = "googleapis-packages@google.com"
  gem.description   = "Apigee Connect allows the Apigee hybrid management plane to connect securely to the MART service in the runtime plane without requiring you to expose the MART endpoint on the internet. If you use Apigee Connect, you do not need to configure the MART ingress gateway with a host alias and an authorized DNS certificate. Note that google-cloud-apigee_connect-v1 is a version-specific client library. For most uses, we recommend installing the main client library google-cloud-apigee_connect instead. See the readme for more details."
  gem.summary       = "API Client library for the Apigee Connect V1 API"
  gem.homepage      = "https://github.com/googleapis/google-cloud-ruby"
  gem.license       = "Apache-2.0"

  gem.platform      = Gem::Platform::RUBY

  gem.files         = `git ls-files -- lib/*`.split("\n") +
                      `git ls-files -- proto_docs/*`.split("\n") +
                      ["README.md", "LICENSE.md", "AUTHENTICATION.md", ".yardopts"]
  gem.require_paths = ["lib"]

  gem.required_ruby_version = ">= 3.1"

  gem.add_dependency "gapic-common", "~> 1.2"
  gem.add_dependency "google-cloud-errors", "~> 1.0"
end
