# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/api/apikeys/v2/apikeys_pb"
require "google/cloud/api_keys/v2/api_keys/rest"


class ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_key
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    key = {}
    key_id = "hello world"

    create_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_create_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_key_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_key({ parent: parent, key: key, key_id: key_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_key parent: parent, key: key, key_id: key_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_key ::Google::Cloud::ApiKeys::V2::CreateKeyRequest.new(parent: parent, key: key, key_id: key_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_key({ parent: parent, key: key, key_id: key_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_key(::Google::Cloud::ApiKeys::V2::CreateKeyRequest.new(parent: parent, key: key, key_id: key_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_key_client_stub.call_count
      end
    end
  end

  def test_list_keys
    # Create test objects.
    client_result = ::Google::Cloud::ApiKeys::V2::ListKeysResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_keys_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_list_keys_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_keys_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_keys({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_keys parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_keys ::Google::Cloud::ApiKeys::V2::ListKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_keys({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_keys(::Google::Cloud::ApiKeys::V2::ListKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_keys_client_stub.call_count
      end
    end
  end

  def test_get_key
    # Create test objects.
    client_result = ::Google::Cloud::ApiKeys::V2::Key.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_get_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_key_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_key({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_key name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_key ::Google::Cloud::ApiKeys::V2::GetKeyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_key({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_key(::Google::Cloud::ApiKeys::V2::GetKeyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_key_client_stub.call_count
      end
    end
  end

  def test_get_key_string
    # Create test objects.
    client_result = ::Google::Cloud::ApiKeys::V2::GetKeyStringResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_key_string_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_get_key_string_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_key_string_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_key_string({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_key_string name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_key_string ::Google::Cloud::ApiKeys::V2::GetKeyStringRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_key_string({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_key_string(::Google::Cloud::ApiKeys::V2::GetKeyStringRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_key_string_client_stub.call_count
      end
    end
  end

  def test_update_key
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    key = {}
    update_mask = {}

    update_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_update_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_key_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_key({ key: key, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_key key: key, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_key ::Google::Cloud::ApiKeys::V2::UpdateKeyRequest.new(key: key, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_key({ key: key, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_key(::Google::Cloud::ApiKeys::V2::UpdateKeyRequest.new(key: key, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_key_client_stub.call_count
      end
    end
  end

  def test_delete_key
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_delete_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_key_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_key({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_key name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_key ::Google::Cloud::ApiKeys::V2::DeleteKeyRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_key({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_key(::Google::Cloud::ApiKeys::V2::DeleteKeyRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_key_client_stub.call_count
      end
    end
  end

  def test_undelete_key
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undelete_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_undelete_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undelete_key_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undelete_key({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undelete_key name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undelete_key ::Google::Cloud::ApiKeys::V2::UndeleteKeyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undelete_key({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undelete_key(::Google::Cloud::ApiKeys::V2::UndeleteKeyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undelete_key_client_stub.call_count
      end
    end
  end

  def test_lookup_key
    # Create test objects.
    client_result = ::Google::Cloud::ApiKeys::V2::LookupKeyResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    key_string = "hello world"

    lookup_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.stub :transcode_lookup_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_key_client_stub do
        # Create client
        client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_key({ key_string: key_string }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_key key_string: key_string do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_key ::Google::Cloud::ApiKeys::V2::LookupKeyRequest.new(key_string: key_string) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_key({ key_string: key_string }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_key(::Google::Cloud::ApiKeys::V2::LookupKeyRequest.new(key_string: key_string), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_key_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client::Configuration, config
  end
end
