# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiKeys
      module V2
        # Request message for `CreateKey` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project in which the API key is created.
        # @!attribute [rw] key
        #   @return [::Google::Cloud::ApiKeys::V2::Key]
        #     Required. The API key fields to set at creation time.
        #     You can configure only the `display_name`, `restrictions`, and
        #     `annotations` fields.
        # @!attribute [rw] key_id
        #   @return [::String]
        #     User specified key id (optional). If specified, it will become the final
        #     component of the key resource name.
        #
        #     The id must be unique within the project, must conform with RFC-1034,
        #     is restricted to lower-cased letters, and has a maximum length of 63
        #     characters. In another word, the id must match the regular
        #     expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        #
        #     The id must NOT be a UUID-like string.
        class CreateKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `ListKeys` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Lists all API keys associated with this project.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Specifies the maximum number of results to be returned at a time.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Requests a specific page of results.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Optional. Indicate that keys deleted in the past 30 days should also be
        #     returned.
        class ListKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `ListKeys` method.
        # @!attribute [rw] keys
        #   @return [::Array<::Google::Cloud::ApiKeys::V2::Key>]
        #     A list of API keys.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The pagination token for the next page of results.
        class ListKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GetKey` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the API key to get.
        class GetKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GetKeyString` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the API key to be retrieved.
        class GetKeyStringRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `GetKeyString` method.
        # @!attribute [rw] key_string
        #   @return [::String]
        #     An encrypted and signed value of the key.
        class GetKeyStringResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `UpdateKey` method.
        # @!attribute [rw] key
        #   @return [::Google::Cloud::ApiKeys::V2::Key]
        #     Required. Set the `name` field to the resource name of the API key to be
        #     updated. You can update only the `display_name`, `restrictions`, and
        #     `annotations` fields.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The field mask specifies which fields to be updated as part of this
        #     request. All other fields are ignored.
        #     Mutable fields are: `display_name`, `restrictions`, and `annotations`.
        #     If an update mask is not provided, the service treats it as an implied mask
        #     equivalent to all allowed fields that are set on the wire. If the field
        #     mask has a special value "*", the service treats it equivalent to replace
        #     all allowed mutable fields.
        class UpdateKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `DeleteKey` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the API key to be deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag known to the client for the expected state of the key.
        #     This is to be used for optimistic concurrency.
        class DeleteKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `UndeleteKey` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the API key to be undeleted.
        class UndeleteKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `LookupKey` method.
        # @!attribute [rw] key_string
        #   @return [::String]
        #     Required. Finds the project that owns the key string value.
        class LookupKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `LookupKey` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The project that owns the key with the value specified in the request.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the API key. If the API key has been purged,
        #     resource name is empty.
        class LookupKeyResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
