# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/api/apikeys/v2/apikeys_pb"
require "google/cloud/api_keys/v2/api_keys/rest/service_stub"

module Google
  module Cloud
    module ApiKeys
      module V2
        module ApiKeys
          module Rest
            ##
            # REST client for the ApiKeys service.
            #
            # Manages the API keys associated with projects.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "apikeys.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :api_keys_stub

              ##
              # Configure the ApiKeys Client class.
              #
              # See {::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ApiKeys clients
              #   ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ApiKeys", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 10.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ApiKeys Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @api_keys_stub.universe_domain
              end

              ##
              # Create a new ApiKeys REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ApiKeys client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @api_keys_stub = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @api_keys_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @api_keys_stub.logger
              end

              # Service calls

              ##
              # Creates a new API key.
              #
              # NOTE: Key is a global resource; hence the only supported value for
              # location is `global`.
              #
              # @overload create_key(request, options = nil)
              #   Pass arguments to `create_key` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::CreateKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::CreateKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_key(parent: nil, key: nil, key_id: nil)
              #   Pass arguments to `create_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the API key is created.
              #   @param key [::Google::Cloud::ApiKeys::V2::Key, ::Hash]
              #     Required. The API key fields to set at creation time.
              #     You can configure only the `display_name`, `restrictions`, and
              #     `annotations` fields.
              #   @param key_id [::String]
              #     User specified key id (optional). If specified, it will become the final
              #     component of the key resource name.
              #
              #     The id must be unique within the project, must conform with RFC-1034,
              #     is restricted to lower-cased letters, and has a maximum length of 63
              #     characters. In another word, the id must match the regular
              #     expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
              #
              #     The id must NOT be a UUID-like string.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::CreateKeyRequest.new
              #
              #   # Call the create_key method.
              #   result = client.create_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::CreateKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.create_key request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the API keys owned by a project. The key string of the API key
              # isn't included in the response.
              #
              # NOTE: Key is a global resource; hence the only supported value for
              # location is `global`.
              #
              # @overload list_keys(request, options = nil)
              #   Pass arguments to `list_keys` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::ListKeysRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::ListKeysRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_keys(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
              #   Pass arguments to `list_keys` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Lists all API keys associated with this project.
              #   @param page_size [::Integer]
              #     Optional. Specifies the maximum number of results to be returned at a time.
              #   @param page_token [::String]
              #     Optional. Requests a specific page of results.
              #   @param show_deleted [::Boolean]
              #     Optional. Indicate that keys deleted in the past 30 days should also be
              #     returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiKeys::V2::Key>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiKeys::V2::Key>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::ListKeysRequest.new
              #
              #   # Call the list_keys method.
              #   result = client.list_keys request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiKeys::V2::Key.
              #     p item
              #   end
              #
              def list_keys request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::ListKeysRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_keys.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_keys.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_keys.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.list_keys request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_keys_stub, :list_keys, "keys", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the metadata for an API key. The key string of the API key
              # isn't included in the response.
              #
              # NOTE: Key is a global resource; hence the only supported value for
              # location is `global`.
              #
              # @overload get_key(request, options = nil)
              #   Pass arguments to `get_key` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::GetKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::GetKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_key(name: nil)
              #   Pass arguments to `get_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the API key to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiKeys::V2::Key]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiKeys::V2::Key]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::GetKeyRequest.new
              #
              #   # Call the get_key method.
              #   result = client.get_key request
              #
              #   # The returned object is of type Google::Cloud::ApiKeys::V2::Key.
              #   p result
              #
              def get_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::GetKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.get_key request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the key string for an API key.
              #
              # NOTE: Key is a global resource; hence the only supported value for
              # location is `global`.
              #
              # @overload get_key_string(request, options = nil)
              #   Pass arguments to `get_key_string` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::GetKeyStringRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::GetKeyStringRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_key_string(name: nil)
              #   Pass arguments to `get_key_string` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the API key to be retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiKeys::V2::GetKeyStringResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiKeys::V2::GetKeyStringResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::GetKeyStringRequest.new
              #
              #   # Call the get_key_string method.
              #   result = client.get_key_string request
              #
              #   # The returned object is of type Google::Cloud::ApiKeys::V2::GetKeyStringResponse.
              #   p result
              #
              def get_key_string request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::GetKeyStringRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_key_string.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_key_string.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_key_string.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.get_key_string request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Patches the modifiable fields of an API key.
              # The key string of the API key isn't included in the response.
              #
              # NOTE: Key is a global resource; hence the only supported value for
              # location is `global`.
              #
              # @overload update_key(request, options = nil)
              #   Pass arguments to `update_key` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::UpdateKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::UpdateKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_key(key: nil, update_mask: nil)
              #   Pass arguments to `update_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param key [::Google::Cloud::ApiKeys::V2::Key, ::Hash]
              #     Required. Set the `name` field to the resource name of the API key to be
              #     updated. You can update only the `display_name`, `restrictions`, and
              #     `annotations` fields.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The field mask specifies which fields to be updated as part of this
              #     request. All other fields are ignored.
              #     Mutable fields are: `display_name`, `restrictions`, and `annotations`.
              #     If an update mask is not provided, the service treats it as an implied mask
              #     equivalent to all allowed fields that are set on the wire. If the field
              #     mask has a special value "*", the service treats it equivalent to replace
              #     all allowed mutable fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::UpdateKeyRequest.new
              #
              #   # Call the update_key method.
              #   result = client.update_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::UpdateKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.update_key request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an API key. Deleted key can be retrieved within 30 days of
              # deletion. Afterward, key will be purged from the project.
              #
              # NOTE: Key is a global resource; hence the only supported value for
              # location is `global`.
              #
              # @overload delete_key(request, options = nil)
              #   Pass arguments to `delete_key` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::DeleteKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::DeleteKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_key(name: nil, etag: nil)
              #   Pass arguments to `delete_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the API key to be deleted.
              #   @param etag [::String]
              #     Optional. The etag known to the client for the expected state of the key.
              #     This is to be used for optimistic concurrency.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::DeleteKeyRequest.new
              #
              #   # Call the delete_key method.
              #   result = client.delete_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::DeleteKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.delete_key request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Undeletes an API key which was deleted within 30 days.
              #
              # NOTE: Key is a global resource; hence the only supported value for
              # location is `global`.
              #
              # @overload undelete_key(request, options = nil)
              #   Pass arguments to `undelete_key` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::UndeleteKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::UndeleteKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload undelete_key(name: nil)
              #   Pass arguments to `undelete_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the API key to be undeleted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::UndeleteKeyRequest.new
              #
              #   # Call the undelete_key method.
              #   result = client.undelete_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def undelete_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::UndeleteKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.undelete_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.undelete_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.undelete_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.undelete_key request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Find the parent project and resource name of the API
              # key that matches the key string in the request. If the API key has been
              # purged, resource name will not be set.
              # The service account must have the `apikeys.keys.lookup` permission
              # on the parent project.
              #
              # @overload lookup_key(request, options = nil)
              #   Pass arguments to `lookup_key` via a request object, either of type
              #   {::Google::Cloud::ApiKeys::V2::LookupKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiKeys::V2::LookupKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload lookup_key(key_string: nil)
              #   Pass arguments to `lookup_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param key_string [::String]
              #     Required. Finds the project that owns the key string value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiKeys::V2::LookupKeyResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiKeys::V2::LookupKeyResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_keys/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiKeys::V2::LookupKeyRequest.new
              #
              #   # Call the lookup_key method.
              #   result = client.lookup_key request
              #
              #   # The returned object is of type Google::Cloud::ApiKeys::V2::LookupKeyResponse.
              #   p result
              #
              def lookup_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiKeys::V2::LookupKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.lookup_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiKeys::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.lookup_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.lookup_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_keys_stub.lookup_key request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ApiKeys REST API.
              #
              # This class represents the configuration for ApiKeys REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_key to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_key.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_key.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "apikeys.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ApiKeys API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_key
                  ##
                  # RPC-specific configuration for `list_keys`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_keys
                  ##
                  # RPC-specific configuration for `get_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_key
                  ##
                  # RPC-specific configuration for `get_key_string`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_key_string
                  ##
                  # RPC-specific configuration for `update_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_key
                  ##
                  # RPC-specific configuration for `delete_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_key
                  ##
                  # RPC-specific configuration for `undelete_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :undelete_key
                  ##
                  # RPC-specific configuration for `lookup_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :lookup_key

                  # @private
                  def initialize parent_rpcs = nil
                    create_key_config = parent_rpcs.create_key if parent_rpcs.respond_to? :create_key
                    @create_key = ::Gapic::Config::Method.new create_key_config
                    list_keys_config = parent_rpcs.list_keys if parent_rpcs.respond_to? :list_keys
                    @list_keys = ::Gapic::Config::Method.new list_keys_config
                    get_key_config = parent_rpcs.get_key if parent_rpcs.respond_to? :get_key
                    @get_key = ::Gapic::Config::Method.new get_key_config
                    get_key_string_config = parent_rpcs.get_key_string if parent_rpcs.respond_to? :get_key_string
                    @get_key_string = ::Gapic::Config::Method.new get_key_string_config
                    update_key_config = parent_rpcs.update_key if parent_rpcs.respond_to? :update_key
                    @update_key = ::Gapic::Config::Method.new update_key_config
                    delete_key_config = parent_rpcs.delete_key if parent_rpcs.respond_to? :delete_key
                    @delete_key = ::Gapic::Config::Method.new delete_key_config
                    undelete_key_config = parent_rpcs.undelete_key if parent_rpcs.respond_to? :undelete_key
                    @undelete_key = ::Gapic::Config::Method.new undelete_key_config
                    lookup_key_config = parent_rpcs.lookup_key if parent_rpcs.respond_to? :lookup_key
                    @lookup_key = ::Gapic::Config::Method.new lookup_key_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
