# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/api_keys/v2/version"

require "google/cloud/api_keys/v2/api_keys/credentials"
require "google/cloud/api_keys/v2/api_keys/paths"
require "google/cloud/api_keys/v2/api_keys/operations"
require "google/cloud/api_keys/v2/api_keys/client"
require "google/cloud/api_keys/v2/api_keys/rest"

module Google
  module Cloud
    module ApiKeys
      module V2
        ##
        # Manages the API keys associated with projects.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/api_keys/v2/api_keys"
        #     client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/api_keys/v2/api_keys/rest"
        #     client = ::Google::Cloud::ApiKeys::V2::ApiKeys::Rest::Client.new
        #
        module ApiKeys
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "api_keys", "helpers.rb"
require "google/cloud/api_keys/v2/api_keys/helpers" if ::File.file? helper_path
