# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/api_hub"
require "gapic/common"
require "gapic/rest"

class Google::Cloud::ApiHub::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_api_hub_rest
    skip unless Google::Cloud::ApiHub.api_hub_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.api_hub do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::ApiHub::Rest::Client, client
    end
  end

  def test_api_hub_dependencies_rest
    skip unless Google::Cloud::ApiHub.api_hub_dependencies_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.api_hub_dependencies do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client, client
    end
  end

  def test_api_hub_collect_rest
    skip unless Google::Cloud::ApiHub.api_hub_collect_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.api_hub_collect do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::ApiHubCollect::Rest::Client, client
    end
  end

  def test_api_hub_curate_rest
    skip unless Google::Cloud::ApiHub.api_hub_curate_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.api_hub_curate do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::ApiHubCurate::Rest::Client, client
    end
  end

  def test_api_hub_discovery_rest
    skip unless Google::Cloud::ApiHub.api_hub_discovery_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.api_hub_discovery do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::ApiHubDiscovery::Rest::Client, client
    end
  end

  def test_host_project_registration_service_rest
    skip unless Google::Cloud::ApiHub.host_project_registration_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.host_project_registration_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::HostProjectRegistrationService::Rest::Client, client
    end
  end

  def test_linting_service_rest
    skip unless Google::Cloud::ApiHub.linting_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.linting_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::LintingService::Rest::Client, client
    end
  end

  def test_api_hub_plugin_rest
    skip unless Google::Cloud::ApiHub.api_hub_plugin_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.api_hub_plugin do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client, client
    end
  end

  def test_provisioning_rest
    skip unless Google::Cloud::ApiHub.provisioning_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.provisioning do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::Provisioning::Rest::Client, client
    end
  end

  def test_runtime_project_attachment_service_rest
    skip unless Google::Cloud::ApiHub.runtime_project_attachment_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ApiHub.runtime_project_attachment_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client, client
    end
  end
end
