# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/api_hub/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :api_hub do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module ApiHub
      ##
      # Create a new client object for ApiHub.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::ApiHub::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-ApiHub-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ApiHub service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ApiHub service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.api_hub_available?}.
      #
      # ## About ApiHub
      #
      # This service provides all methods related to the API hub.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.api_hub version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:ApiHub)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ApiHub service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.api_hub}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ApiHub service,
      # or if the versioned client gem needs an update to support the ApiHub service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.api_hub_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :ApiHub
        service_module = service_module.const_get :ApiHub
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ApiHubDependencies.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-ApiHubDependencies-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ApiHubDependencies service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ApiHubDependencies service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.api_hub_dependencies_available?}.
      #
      # ## About ApiHubDependencies
      #
      # This service provides methods for various operations related to a
      # Dependency in the API hub.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.api_hub_dependencies version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:ApiHubDependencies)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ApiHubDependencies service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.api_hub_dependencies}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ApiHubDependencies service,
      # or if the versioned client gem needs an update to support the ApiHubDependencies service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.api_hub_dependencies_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :ApiHubDependencies
        service_module = service_module.const_get :ApiHubDependencies
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ApiHubCollect.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::ApiHubCollect::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-ApiHubCollect-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ApiHubCollect service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ApiHubCollect service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.api_hub_collect_available?}.
      #
      # ## About ApiHubCollect
      #
      # This service exposes methods used for collecting various types of data from
      # different first party and third party sources and push it to Hub's collect
      # layer.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.api_hub_collect version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:ApiHubCollect)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ApiHubCollect service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.api_hub_collect}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ApiHubCollect service,
      # or if the versioned client gem needs an update to support the ApiHubCollect service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.api_hub_collect_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :ApiHubCollect
        service_module = service_module.const_get :ApiHubCollect
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ApiHubCurate.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::ApiHubCurate::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-ApiHubCurate-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ApiHubCurate service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ApiHubCurate service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.api_hub_curate_available?}.
      #
      # ## About ApiHubCurate
      #
      # This service is used for managing curations for processing API data consumed
      # from collect layer.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.api_hub_curate version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:ApiHubCurate)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ApiHubCurate service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.api_hub_curate}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ApiHubCurate service,
      # or if the versioned client gem needs an update to support the ApiHubCurate service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.api_hub_curate_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :ApiHubCurate
        service_module = service_module.const_get :ApiHubCurate
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ApiHubDiscovery.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::ApiHubDiscovery::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-ApiHubDiscovery-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ApiHubDiscovery service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ApiHubDiscovery service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.api_hub_discovery_available?}.
      #
      # ## About ApiHubDiscovery
      #
      # This service exposes methods used to manage DiscoveredApiObservations
      # and DiscoveredApiOperations.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.api_hub_discovery version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:ApiHubDiscovery)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ApiHubDiscovery service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.api_hub_discovery}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ApiHubDiscovery service,
      # or if the versioned client gem needs an update to support the ApiHubDiscovery service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.api_hub_discovery_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :ApiHubDiscovery
        service_module = service_module.const_get :ApiHubDiscovery
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for HostProjectRegistrationService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::HostProjectRegistrationService::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-HostProjectRegistrationService-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the HostProjectRegistrationService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the HostProjectRegistrationService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.host_project_registration_service_available?}.
      #
      # ## About HostProjectRegistrationService
      #
      # This service is used for managing the host project registrations.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.host_project_registration_service version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:HostProjectRegistrationService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the HostProjectRegistrationService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.host_project_registration_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the HostProjectRegistrationService service,
      # or if the versioned client gem needs an update to support the HostProjectRegistrationService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.host_project_registration_service_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :HostProjectRegistrationService
        service_module = service_module.const_get :HostProjectRegistrationService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for LintingService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::LintingService::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-LintingService-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the LintingService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the LintingService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.linting_service_available?}.
      #
      # ## About LintingService
      #
      # This service provides all methods related to the 1p Linter.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.linting_service version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:LintingService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the LintingService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.linting_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the LintingService service,
      # or if the versioned client gem needs an update to support the LintingService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.linting_service_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :LintingService
        service_module = service_module.const_get :LintingService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ApiHubPlugin.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-ApiHubPlugin-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ApiHubPlugin service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ApiHubPlugin service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.api_hub_plugin_available?}.
      #
      # ## About ApiHubPlugin
      #
      # This service is used for managing plugins inside the API Hub.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.api_hub_plugin version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:ApiHubPlugin)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ApiHubPlugin service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.api_hub_plugin}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ApiHubPlugin service,
      # or if the versioned client gem needs an update to support the ApiHubPlugin service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.api_hub_plugin_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :ApiHubPlugin
        service_module = service_module.const_get :ApiHubPlugin
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Provisioning.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::Provisioning::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-Provisioning-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Provisioning service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the Provisioning service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.provisioning_available?}.
      #
      # ## About Provisioning
      #
      # This service is used for managing the data plane provisioning of the API hub.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.provisioning version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:Provisioning)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Provisioning service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.provisioning}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Provisioning service,
      # or if the versioned client gem needs an update to support the Provisioning service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.provisioning_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :Provisioning
        service_module = service_module.const_get :Provisioning
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for RuntimeProjectAttachmentService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-api_hub-v1/latest/Google-Cloud-ApiHub-V1-RuntimeProjectAttachmentService-Rest-Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the RuntimeProjectAttachmentService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the RuntimeProjectAttachmentService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ApiHub.runtime_project_attachment_service_available?}.
      #
      # ## About RuntimeProjectAttachmentService
      #
      # This service is used for managing the runtime project attachments.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.runtime_project_attachment_service version: :v1, &block
        require "google/cloud/api_hub/#{version.to_s.downcase}"

        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ApiHub.const_get(package_name).const_get(:RuntimeProjectAttachmentService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the RuntimeProjectAttachmentService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ApiHub.runtime_project_attachment_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the RuntimeProjectAttachmentService service,
      # or if the versioned client gem needs an update to support the RuntimeProjectAttachmentService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.runtime_project_attachment_service_available? version: :v1
        require "google/cloud/api_hub/#{version.to_s.downcase}"
        package_name = Google::Cloud::ApiHub
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ApiHub.const_get package_name
        return false unless service_module.const_defined? :RuntimeProjectAttachmentService
        service_module = service_module.const_get :RuntimeProjectAttachmentService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-api_hub library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.api_hub if block_given?

        ::Google::Cloud.configure.api_hub
      end
    end
  end
end

helper_path = ::File.join __dir__, "api_hub", "helpers.rb"
require "google/cloud/api_hub/helpers" if ::File.file? helper_path
