# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/apihub/v1/apihub_service_pb"
require "google/cloud/api_hub/v1/api_hub/rest"


class ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_api
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Api.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_id = "hello world"
    api = {}

    create_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_create_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api({ parent: parent, api_id: api_id, api: api }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api parent: parent, api_id: api_id, api: api do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api ::Google::Cloud::ApiHub::V1::CreateApiRequest.new(parent: parent, api_id: api_id, api: api) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api({ parent: parent, api_id: api_id, api: api }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api(::Google::Cloud::ApiHub::V1::CreateApiRequest.new(parent: parent, api_id: api_id, api: api), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_client_stub.call_count
      end
    end
  end

  def test_get_api
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Api.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api ::Google::Cloud::ApiHub::V1::GetApiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api(::Google::Cloud::ApiHub::V1::GetApiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_client_stub.call_count
      end
    end
  end

  def test_list_apis
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListApisResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_apis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_list_apis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_apis_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_apis({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_apis parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_apis ::Google::Cloud::ApiHub::V1::ListApisRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_apis({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_apis(::Google::Cloud::ApiHub::V1::ListApisRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_apis_client_stub.call_count
      end
    end
  end

  def test_update_api
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Api.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    api = {}
    update_mask = {}

    update_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_update_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api({ api: api, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api api: api, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api ::Google::Cloud::ApiHub::V1::UpdateApiRequest.new(api: api, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api({ api: api, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api(::Google::Cloud::ApiHub::V1::UpdateApiRequest.new(api: api, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_client_stub.call_count
      end
    end
  end

  def test_delete_api
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_delete_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api ::Google::Cloud::ApiHub::V1::DeleteApiRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api(::Google::Cloud::ApiHub::V1::DeleteApiRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_client_stub.call_count
      end
    end
  end

  def test_create_version
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Version.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    version_id = "hello world"
    version = {}

    create_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_create_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_version({ parent: parent, version_id: version_id, version: version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_version parent: parent, version_id: version_id, version: version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_version ::Google::Cloud::ApiHub::V1::CreateVersionRequest.new(parent: parent, version_id: version_id, version: version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_version({ parent: parent, version_id: version_id, version: version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_version(::Google::Cloud::ApiHub::V1::CreateVersionRequest.new(parent: parent, version_id: version_id, version: version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_version_client_stub.call_count
      end
    end
  end

  def test_get_version
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Version.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_version ::Google::Cloud::ApiHub::V1::GetVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_version(::Google::Cloud::ApiHub::V1::GetVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_version_client_stub.call_count
      end
    end
  end

  def test_list_versions
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_list_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_versions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_versions parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_versions ::Google::Cloud::ApiHub::V1::ListVersionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_versions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_versions(::Google::Cloud::ApiHub::V1::ListVersionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_versions_client_stub.call_count
      end
    end
  end

  def test_update_version
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Version.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    version = {}
    update_mask = {}

    update_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_update_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_version({ version: version, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_version version: version, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_version ::Google::Cloud::ApiHub::V1::UpdateVersionRequest.new(version: version, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_version({ version: version, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_version(::Google::Cloud::ApiHub::V1::UpdateVersionRequest.new(version: version, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_version_client_stub.call_count
      end
    end
  end

  def test_delete_version
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_delete_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_version_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_version({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_version name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_version ::Google::Cloud::ApiHub::V1::DeleteVersionRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_version({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_version(::Google::Cloud::ApiHub::V1::DeleteVersionRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_version_client_stub.call_count
      end
    end
  end

  def test_create_spec
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Spec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    spec_id = "hello world"
    spec = {}

    create_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_create_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_spec({ parent: parent, spec_id: spec_id, spec: spec }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_spec parent: parent, spec_id: spec_id, spec: spec do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_spec ::Google::Cloud::ApiHub::V1::CreateSpecRequest.new(parent: parent, spec_id: spec_id, spec: spec) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_spec({ parent: parent, spec_id: spec_id, spec: spec }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_spec(::Google::Cloud::ApiHub::V1::CreateSpecRequest.new(parent: parent, spec_id: spec_id, spec: spec), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_spec_client_stub.call_count
      end
    end
  end

  def test_get_spec
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Spec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_spec({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_spec name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_spec ::Google::Cloud::ApiHub::V1::GetSpecRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_spec({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_spec(::Google::Cloud::ApiHub::V1::GetSpecRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_spec_client_stub.call_count
      end
    end
  end

  def test_get_spec_contents
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::SpecContents.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_spec_contents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_spec_contents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_spec_contents_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_spec_contents({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_spec_contents name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_spec_contents ::Google::Cloud::ApiHub::V1::GetSpecContentsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_spec_contents({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_spec_contents(::Google::Cloud::ApiHub::V1::GetSpecContentsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_spec_contents_client_stub.call_count
      end
    end
  end

  def test_list_specs
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListSpecsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_specs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_list_specs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_specs_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_specs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_specs parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_specs ::Google::Cloud::ApiHub::V1::ListSpecsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_specs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_specs(::Google::Cloud::ApiHub::V1::ListSpecsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_specs_client_stub.call_count
      end
    end
  end

  def test_update_spec
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Spec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    spec = {}
    update_mask = {}

    update_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_update_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_spec({ spec: spec, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_spec spec: spec, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_spec ::Google::Cloud::ApiHub::V1::UpdateSpecRequest.new(spec: spec, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_spec({ spec: spec, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_spec(::Google::Cloud::ApiHub::V1::UpdateSpecRequest.new(spec: spec, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_spec_client_stub.call_count
      end
    end
  end

  def test_delete_spec
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_delete_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_spec({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_spec name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_spec ::Google::Cloud::ApiHub::V1::DeleteSpecRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_spec({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_spec(::Google::Cloud::ApiHub::V1::DeleteSpecRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_spec_client_stub.call_count
      end
    end
  end

  def test_create_api_operation
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ApiOperation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_operation_id = "hello world"
    api_operation = {}

    create_api_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_create_api_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_operation_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api_operation({ parent: parent, api_operation_id: api_operation_id, api_operation: api_operation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api_operation parent: parent, api_operation_id: api_operation_id, api_operation: api_operation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api_operation ::Google::Cloud::ApiHub::V1::CreateApiOperationRequest.new(parent: parent, api_operation_id: api_operation_id, api_operation: api_operation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api_operation({ parent: parent, api_operation_id: api_operation_id, api_operation: api_operation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api_operation(::Google::Cloud::ApiHub::V1::CreateApiOperationRequest.new(parent: parent, api_operation_id: api_operation_id, api_operation: api_operation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_operation_client_stub.call_count
      end
    end
  end

  def test_get_api_operation
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ApiOperation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_api_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_operation_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api_operation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api_operation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api_operation ::Google::Cloud::ApiHub::V1::GetApiOperationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api_operation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api_operation(::Google::Cloud::ApiHub::V1::GetApiOperationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_operation_client_stub.call_count
      end
    end
  end

  def test_list_api_operations
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListApiOperationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_api_operations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_list_api_operations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_api_operations_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_api_operations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_api_operations parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_api_operations ::Google::Cloud::ApiHub::V1::ListApiOperationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_api_operations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_api_operations(::Google::Cloud::ApiHub::V1::ListApiOperationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_api_operations_client_stub.call_count
      end
    end
  end

  def test_update_api_operation
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ApiOperation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    api_operation = {}
    update_mask = {}

    update_api_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_update_api_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_operation_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api_operation({ api_operation: api_operation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api_operation api_operation: api_operation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api_operation ::Google::Cloud::ApiHub::V1::UpdateApiOperationRequest.new(api_operation: api_operation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api_operation({ api_operation: api_operation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api_operation(::Google::Cloud::ApiHub::V1::UpdateApiOperationRequest.new(api_operation: api_operation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_operation_client_stub.call_count
      end
    end
  end

  def test_delete_api_operation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_api_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_delete_api_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_operation_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api_operation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api_operation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api_operation ::Google::Cloud::ApiHub::V1::DeleteApiOperationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api_operation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api_operation(::Google::Cloud::ApiHub::V1::DeleteApiOperationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_operation_client_stub.call_count
      end
    end
  end

  def test_get_definition
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Definition.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_definition_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_definition_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_definition_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_definition({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_definition name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_definition ::Google::Cloud::ApiHub::V1::GetDefinitionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_definition({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_definition(::Google::Cloud::ApiHub::V1::GetDefinitionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_definition_client_stub.call_count
      end
    end
  end

  def test_create_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}

    create_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_create_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_deployment ::Google::Cloud::ApiHub::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_deployment(::Google::Cloud::ApiHub::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_deployment_client_stub.call_count
      end
    end
  end

  def test_get_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_deployment ::Google::Cloud::ApiHub::V1::GetDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_deployment(::Google::Cloud::ApiHub::V1::GetDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_deployment_client_stub.call_count
      end
    end
  end

  def test_list_deployments
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListDeploymentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_deployments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_list_deployments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_deployments_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_deployments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_deployments parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_deployments ::Google::Cloud::ApiHub::V1::ListDeploymentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_deployments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_deployments(::Google::Cloud::ApiHub::V1::ListDeploymentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_deployments_client_stub.call_count
      end
    end
  end

  def test_update_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    deployment = {}
    update_mask = {}

    update_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_update_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_deployment({ deployment: deployment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_deployment deployment: deployment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_deployment ::Google::Cloud::ApiHub::V1::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_deployment({ deployment: deployment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_deployment(::Google::Cloud::ApiHub::V1::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_deployment_client_stub.call_count
      end
    end
  end

  def test_delete_deployment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_delete_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_deployment ::Google::Cloud::ApiHub::V1::DeleteDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_deployment(::Google::Cloud::ApiHub::V1::DeleteDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_deployment_client_stub.call_count
      end
    end
  end

  def test_create_attribute
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Attribute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    attribute_id = "hello world"
    attribute = {}

    create_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_create_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_attribute({ parent: parent, attribute_id: attribute_id, attribute: attribute }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_attribute parent: parent, attribute_id: attribute_id, attribute: attribute do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_attribute ::Google::Cloud::ApiHub::V1::CreateAttributeRequest.new(parent: parent, attribute_id: attribute_id, attribute: attribute) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_attribute({ parent: parent, attribute_id: attribute_id, attribute: attribute }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_attribute(::Google::Cloud::ApiHub::V1::CreateAttributeRequest.new(parent: parent, attribute_id: attribute_id, attribute: attribute), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_attribute_client_stub.call_count
      end
    end
  end

  def test_get_attribute
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Attribute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_attribute({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_attribute name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_attribute ::Google::Cloud::ApiHub::V1::GetAttributeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_attribute({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_attribute(::Google::Cloud::ApiHub::V1::GetAttributeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_attribute_client_stub.call_count
      end
    end
  end

  def test_update_attribute
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Attribute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    attribute = {}
    update_mask = {}

    update_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_update_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_attribute({ attribute: attribute, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_attribute attribute: attribute, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_attribute ::Google::Cloud::ApiHub::V1::UpdateAttributeRequest.new(attribute: attribute, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_attribute({ attribute: attribute, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_attribute(::Google::Cloud::ApiHub::V1::UpdateAttributeRequest.new(attribute: attribute, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_attribute_client_stub.call_count
      end
    end
  end

  def test_delete_attribute
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_delete_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_attribute({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_attribute name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_attribute ::Google::Cloud::ApiHub::V1::DeleteAttributeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_attribute({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_attribute(::Google::Cloud::ApiHub::V1::DeleteAttributeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_attribute_client_stub.call_count
      end
    end
  end

  def test_list_attributes
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListAttributesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_attributes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_list_attributes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_attributes_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_attributes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_attributes parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_attributes ::Google::Cloud::ApiHub::V1::ListAttributesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_attributes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_attributes(::Google::Cloud::ApiHub::V1::ListAttributesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_attributes_client_stub.call_count
      end
    end
  end

  def test_search_resources
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::SearchResourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    query = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    search_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_search_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_resources_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_resources({ location: location, query: query, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_resources location: location, query: query, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_resources ::Google::Cloud::ApiHub::V1::SearchResourcesRequest.new(location: location, query: query, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_resources({ location: location, query: query, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_resources(::Google::Cloud::ApiHub::V1::SearchResourcesRequest.new(location: location, query: query, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_resources_client_stub.call_count
      end
    end
  end

  def test_create_external_api
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ExternalApi.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    external_api_id = "hello world"
    external_api = {}

    create_external_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_create_external_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_external_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_external_api({ parent: parent, external_api_id: external_api_id, external_api: external_api }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_external_api parent: parent, external_api_id: external_api_id, external_api: external_api do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_external_api ::Google::Cloud::ApiHub::V1::CreateExternalApiRequest.new(parent: parent, external_api_id: external_api_id, external_api: external_api) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_external_api({ parent: parent, external_api_id: external_api_id, external_api: external_api }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_external_api(::Google::Cloud::ApiHub::V1::CreateExternalApiRequest.new(parent: parent, external_api_id: external_api_id, external_api: external_api), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_external_api_client_stub.call_count
      end
    end
  end

  def test_get_external_api
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ExternalApi.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_external_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_get_external_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_external_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_external_api({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_external_api name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_external_api ::Google::Cloud::ApiHub::V1::GetExternalApiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_external_api({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_external_api(::Google::Cloud::ApiHub::V1::GetExternalApiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_external_api_client_stub.call_count
      end
    end
  end

  def test_update_external_api
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ExternalApi.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    external_api = {}
    update_mask = {}

    update_external_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_update_external_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_external_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_external_api({ external_api: external_api, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_external_api external_api: external_api, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_external_api ::Google::Cloud::ApiHub::V1::UpdateExternalApiRequest.new(external_api: external_api, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_external_api({ external_api: external_api, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_external_api(::Google::Cloud::ApiHub::V1::UpdateExternalApiRequest.new(external_api: external_api, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_external_api_client_stub.call_count
      end
    end
  end

  def test_delete_external_api
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_external_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_delete_external_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_external_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_external_api({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_external_api name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_external_api ::Google::Cloud::ApiHub::V1::DeleteExternalApiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_external_api({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_external_api(::Google::Cloud::ApiHub::V1::DeleteExternalApiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_external_api_client_stub.call_count
      end
    end
  end

  def test_list_external_apis
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListExternalApisResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_external_apis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.stub :transcode_list_external_apis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_external_apis_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_external_apis({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_external_apis parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_external_apis ::Google::Cloud::ApiHub::V1::ListExternalApisRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_external_apis({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_external_apis(::Google::Cloud::ApiHub::V1::ListExternalApisRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_external_apis_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client::Configuration, config
  end
end
