# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/apihub/v1/plugin_service_pb"
require "google/cloud/api_hub/v1/api_hub_plugin/rest"


class ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_plugin
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Plugin.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_get_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_plugin({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_plugin name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_plugin ::Google::Cloud::ApiHub::V1::GetPluginRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_plugin({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_plugin(::Google::Cloud::ApiHub::V1::GetPluginRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_plugin_client_stub.call_count
      end
    end
  end

  def test_enable_plugin
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Plugin.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    enable_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_enable_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_plugin({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_plugin name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_plugin ::Google::Cloud::ApiHub::V1::EnablePluginRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_plugin({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_plugin(::Google::Cloud::ApiHub::V1::EnablePluginRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_plugin_client_stub.call_count
      end
    end
  end

  def test_disable_plugin
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Plugin.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    disable_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_disable_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_plugin({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_plugin name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_plugin ::Google::Cloud::ApiHub::V1::DisablePluginRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_plugin({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_plugin(::Google::Cloud::ApiHub::V1::DisablePluginRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_plugin_client_stub.call_count
      end
    end
  end

  def test_create_plugin
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::Plugin.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    plugin_id = "hello world"
    plugin = {}

    create_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_create_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_plugin({ parent: parent, plugin_id: plugin_id, plugin: plugin }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_plugin parent: parent, plugin_id: plugin_id, plugin: plugin do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_plugin ::Google::Cloud::ApiHub::V1::CreatePluginRequest.new(parent: parent, plugin_id: plugin_id, plugin: plugin) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_plugin({ parent: parent, plugin_id: plugin_id, plugin: plugin }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_plugin(::Google::Cloud::ApiHub::V1::CreatePluginRequest.new(parent: parent, plugin_id: plugin_id, plugin: plugin), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_plugin_client_stub.call_count
      end
    end
  end

  def test_list_plugins
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListPluginsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_plugins_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_list_plugins_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_plugins_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_plugins({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_plugins parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_plugins ::Google::Cloud::ApiHub::V1::ListPluginsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_plugins({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_plugins(::Google::Cloud::ApiHub::V1::ListPluginsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_plugins_client_stub.call_count
      end
    end
  end

  def test_delete_plugin
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_delete_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_plugin({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_plugin name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_plugin ::Google::Cloud::ApiHub::V1::DeletePluginRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_plugin({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_plugin(::Google::Cloud::ApiHub::V1::DeletePluginRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_plugin_client_stub.call_count
      end
    end
  end

  def test_create_plugin_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    plugin_instance_id = "hello world"
    plugin_instance = {}

    create_plugin_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_create_plugin_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_plugin_instance_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_plugin_instance({ parent: parent, plugin_instance_id: plugin_instance_id, plugin_instance: plugin_instance }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_plugin_instance parent: parent, plugin_instance_id: plugin_instance_id, plugin_instance: plugin_instance do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_plugin_instance ::Google::Cloud::ApiHub::V1::CreatePluginInstanceRequest.new(parent: parent, plugin_instance_id: plugin_instance_id, plugin_instance: plugin_instance) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_plugin_instance({ parent: parent, plugin_instance_id: plugin_instance_id, plugin_instance: plugin_instance }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_plugin_instance(::Google::Cloud::ApiHub::V1::CreatePluginInstanceRequest.new(parent: parent, plugin_instance_id: plugin_instance_id, plugin_instance: plugin_instance), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_plugin_instance_client_stub.call_count
      end
    end
  end

  def test_execute_plugin_instance_action
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    action_execution_detail = {}

    execute_plugin_instance_action_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_execute_plugin_instance_action_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, execute_plugin_instance_action_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.execute_plugin_instance_action({ name: name, action_execution_detail: action_execution_detail }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.execute_plugin_instance_action name: name, action_execution_detail: action_execution_detail do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.execute_plugin_instance_action ::Google::Cloud::ApiHub::V1::ExecutePluginInstanceActionRequest.new(name: name, action_execution_detail: action_execution_detail) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.execute_plugin_instance_action({ name: name, action_execution_detail: action_execution_detail }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.execute_plugin_instance_action(::Google::Cloud::ApiHub::V1::ExecutePluginInstanceActionRequest.new(name: name, action_execution_detail: action_execution_detail), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, execute_plugin_instance_action_client_stub.call_count
      end
    end
  end

  def test_get_plugin_instance
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::PluginInstance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_plugin_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_get_plugin_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_plugin_instance_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_plugin_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_plugin_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_plugin_instance ::Google::Cloud::ApiHub::V1::GetPluginInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_plugin_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_plugin_instance(::Google::Cloud::ApiHub::V1::GetPluginInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_plugin_instance_client_stub.call_count
      end
    end
  end

  def test_list_plugin_instances
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::ListPluginInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_plugin_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_list_plugin_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_plugin_instances_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_plugin_instances({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_plugin_instances parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_plugin_instances ::Google::Cloud::ApiHub::V1::ListPluginInstancesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_plugin_instances({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_plugin_instances(::Google::Cloud::ApiHub::V1::ListPluginInstancesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_plugin_instances_client_stub.call_count
      end
    end
  end

  def test_enable_plugin_instance_action
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    action_id = "hello world"

    enable_plugin_instance_action_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_enable_plugin_instance_action_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_plugin_instance_action_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_plugin_instance_action({ name: name, action_id: action_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_plugin_instance_action name: name, action_id: action_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_plugin_instance_action ::Google::Cloud::ApiHub::V1::EnablePluginInstanceActionRequest.new(name: name, action_id: action_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_plugin_instance_action({ name: name, action_id: action_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_plugin_instance_action(::Google::Cloud::ApiHub::V1::EnablePluginInstanceActionRequest.new(name: name, action_id: action_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_plugin_instance_action_client_stub.call_count
      end
    end
  end

  def test_disable_plugin_instance_action
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    action_id = "hello world"

    disable_plugin_instance_action_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_disable_plugin_instance_action_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_plugin_instance_action_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_plugin_instance_action({ name: name, action_id: action_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_plugin_instance_action name: name, action_id: action_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_plugin_instance_action ::Google::Cloud::ApiHub::V1::DisablePluginInstanceActionRequest.new(name: name, action_id: action_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_plugin_instance_action({ name: name, action_id: action_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_plugin_instance_action(::Google::Cloud::ApiHub::V1::DisablePluginInstanceActionRequest.new(name: name, action_id: action_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_plugin_instance_action_client_stub.call_count
      end
    end
  end

  def test_update_plugin_instance
    # Create test objects.
    client_result = ::Google::Cloud::ApiHub::V1::PluginInstance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    plugin_instance = {}
    update_mask = {}

    update_plugin_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_update_plugin_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_plugin_instance_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_plugin_instance({ plugin_instance: plugin_instance, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_plugin_instance plugin_instance: plugin_instance, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_plugin_instance ::Google::Cloud::ApiHub::V1::UpdatePluginInstanceRequest.new(plugin_instance: plugin_instance, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_plugin_instance({ plugin_instance: plugin_instance, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_plugin_instance(::Google::Cloud::ApiHub::V1::UpdatePluginInstanceRequest.new(plugin_instance: plugin_instance, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_plugin_instance_client_stub.call_count
      end
    end
  end

  def test_delete_plugin_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_plugin_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::ServiceStub.stub :transcode_delete_plugin_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_plugin_instance_client_stub do
        # Create client
        client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_plugin_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_plugin_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_plugin_instance ::Google::Cloud::ApiHub::V1::DeletePluginInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_plugin_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_plugin_instance(::Google::Cloud::ApiHub::V1::DeletePluginInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_plugin_instance_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client::Configuration, config
  end
end
