# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # The
        # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client#create_runtime_project_attachment CreateRuntimeProjectAttachment}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the Runtime Project Attachment.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] runtime_project_attachment_id
        #   @return [::String]
        #     Required. The ID to use for the Runtime Project Attachment, which will
        #     become the final component of the Runtime Project Attachment's name. The ID
        #     must be the same as the project ID of the Google cloud project specified in
        #     the runtime_project_attachment.runtime_project field.
        # @!attribute [rw] runtime_project_attachment
        #   @return [::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment]
        #     Required. The Runtime Project Attachment to create.
        class CreateRuntimeProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client#get_runtime_project_attachment GetRuntimeProjectAttachment}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the API resource to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}`
        class GetRuntimeProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client#list_runtime_project_attachments ListRuntimeProjectAttachments}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of runtime project
        #     attachments. Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of runtime project attachments to return. The
        #     service may return fewer than this value. If unspecified, at most 50
        #     runtime project attachments will be returned. The maximum value is 1000;
        #     values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListRuntimeProjectAttachments` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListRuntimeProjectAttachments` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of RuntimeProjectAttachments.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. All
        #     standard operators as documented at https://google.aip.dev/160 are
        #     supported.
        #
        #     The following fields in the `RuntimeProjectAttachment` are eligible for
        #     filtering:
        #
        #       * `name` - The name of the RuntimeProjectAttachment.
        #       * `create_time` - The time at which the RuntimeProjectAttachment was
        #       created. The value should be in the
        #       (RFC3339)[https://tools.ietf.org/html/rfc3339] format.
        #       * `runtime_project` - The Google cloud project associated with the
        #       RuntimeProjectAttachment.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListRuntimeProjectAttachmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client#list_runtime_project_attachments ListRuntimeProjectAttachments}
        # method's response.
        # @!attribute [rw] runtime_project_attachments
        #   @return [::Array<::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment>]
        #     List of runtime project attachments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRuntimeProjectAttachmentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client#delete_runtime_project_attachment DeleteRuntimeProjectAttachment}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Runtime Project Attachment to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}`
        class DeleteRuntimeProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client#lookup_runtime_project_attachment LookupRuntimeProjectAttachment}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Runtime project ID to look up runtime project attachment for.
        #     Lookup happens across all regions. Expected format:
        #     `projects/{project}/locations/{location}`.
        class LookupRuntimeProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client#list_runtime_project_attachments ListRuntimeProjectAttachments}
        # method's response.
        # @!attribute [rw] runtime_project_attachment
        #   @return [::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment]
        #     Runtime project attachment for a project if exists, empty otherwise.
        class LookupRuntimeProjectAttachmentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime project attachment represents an attachment from the runtime project
        # to the host project. Api Hub looks for deployments in the attached runtime
        # projects and creates corresponding resources in Api Hub for the discovered
        # deployments.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of a runtime project attachment. Format:
        #     "projects/\\{project}/locations/\\{location}/runtimeProjectAttachments/\\{runtime_project_attachment}".
        # @!attribute [rw] runtime_project
        #   @return [::String]
        #     Required. Immutable. Google cloud project name in the format:
        #     "projects/abc" or "projects/123". As input, project name with either
        #     project id or number are accepted. As output, this field will contain
        #     project number.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time.
        class RuntimeProjectAttachment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
