# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # The
        # {::Google::Cloud::ApiHub::V1::Provisioning::Rest::Client#create_api_hub_instance CreateApiHubInstance}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the Api Hub instance resource.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] api_hub_instance_id
        #   @return [::String]
        #     Optional. Identifier to assign to the Api Hub instance. Must be unique
        #     within scope of the parent resource. If the field is not provided, system
        #     generated id will be used.
        #
        #     This value should be 4-40 characters, and valid characters
        #     are `/[a-z][A-Z][0-9]-_/`.
        # @!attribute [rw] api_hub_instance
        #   @return [::Google::Cloud::ApiHub::V1::ApiHubInstance]
        #     Required. The ApiHub instance.
        class CreateApiHubInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::Provisioning::Rest::Client#delete_api_hub_instance DeleteApiHubInstance}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Api Hub instance to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
        class DeleteApiHubInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::Provisioning::Rest::Client#get_api_hub_instance GetApiHubInstance}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Api Hub instance to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
        class GetApiHubInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::Provisioning::Rest::Client#lookup_api_hub_instance LookupApiHubInstance}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. There will always be only one Api Hub instance for a GCP project
        #     across all locations.
        #     The parent resource for the Api Hub instance resource.
        #     Format: `projects/{project}/locations/{location}`
        class LookupApiHubInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::Provisioning::Rest::Client#lookup_api_hub_instance LookupApiHubInstance}
        # method's response.`
        # @!attribute [rw] api_hub_instance
        #   @return [::Google::Cloud::ApiHub::V1::ApiHubInstance]
        #     API Hub instance for a project if it exists, empty otherwise.
        class LookupApiHubInstanceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
