# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # A plugin resource in the API Hub.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the plugin.
        #     Format: `projects/{project}/locations/{location}/plugins/{plugin}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the plugin. Max length is 50 characters
        #     (Unicode code points).
        # @!attribute [rw] type
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The type of the API.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-plugin-type`
        #     attribute.
        #     The number of allowed values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        #     Note this field is not required for plugins developed via plugin framework.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The plugin description. Max length is 2000 characters (Unicode
        #     code points).
        # @!attribute [r] state
        #   @return [::Google::Cloud::ApiHub::V1::Plugin::State]
        #     Output only. Represents the state of the plugin.
        #     Note this field will not be set for plugins developed via plugin
        #     framework as the state will be managed at plugin instance level.
        # @!attribute [r] ownership_type
        #   @return [::Google::Cloud::ApiHub::V1::Plugin::OwnershipType]
        #     Output only. The type of the plugin, indicating whether it is
        #     'SYSTEM_OWNED' or 'USER_OWNED'.
        # @!attribute [rw] hosting_service
        #   @return [::Google::Cloud::ApiHub::V1::Plugin::HostingService]
        #     Optional. This field is optional. It is used to notify the plugin hosting
        #     service for any lifecycle changes of the plugin instance and trigger
        #     execution of plugin instance actions in case of API hub managed actions.
        #
        #     This field should be provided if the plugin instance lifecycle of the
        #     developed plugin needs to be managed from API hub. Also, in this case the
        #     plugin hosting service interface needs to be implemented.
        #
        #     This field should not be provided if the plugin wants to manage plugin
        #     instance lifecycle events outside of hub interface and use plugin framework
        #     for only registering of plugin and plugin instances to capture the source
        #     of data into hub. Note, in this case the plugin hosting service interface
        #     is not required to be implemented. Also, the plugin instance lifecycle
        #     actions will be disabled from API hub's UI.
        # @!attribute [rw] actions_config
        #   @return [::Array<::Google::Cloud::ApiHub::V1::PluginActionConfig>]
        #     Optional. The configuration of actions supported by the plugin.
        #     **REQUIRED**: This field must be provided when creating or updating a
        #     Plugin. The server will reject requests if this field is missing.
        # @!attribute [rw] documentation
        #   @return [::Google::Cloud::ApiHub::V1::Documentation]
        #     Optional. The documentation of the plugin, that explains how to set up and
        #     use the plugin.
        # @!attribute [rw] plugin_category
        #   @return [::Google::Cloud::ApiHub::V1::PluginCategory]
        #     Optional. The category of the plugin, identifying its primary category or
        #     purpose. This field is required for all plugins.
        # @!attribute [rw] config_template
        #   @return [::Google::Cloud::ApiHub::V1::Plugin::ConfigTemplate]
        #     Optional. The configuration template for the plugin.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp indicating when the plugin was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp indicating when the plugin was last updated.
        # @!attribute [rw] gateway_type
        #   @return [::Google::Cloud::ApiHub::V1::GatewayType]
        #     Optional. The type of the gateway.
        class Plugin
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The information related to the service implemented by the plugin
          # developer, used to invoke the plugin's functionality.
          # @!attribute [rw] service_uri
          #   @return [::String]
          #     Optional. The URI of the service implemented by the plugin developer,
          #     used to invoke the plugin's functionality. This information is only
          #     required for user defined plugins.
          class HostingService
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # ConfigTemplate represents the configuration template for a plugin.
          # @!attribute [rw] auth_config_template
          #   @return [::Google::Cloud::ApiHub::V1::Plugin::ConfigTemplate::AuthConfigTemplate]
          #     Optional. The authentication template for the plugin.
          # @!attribute [rw] additional_config_template
          #   @return [::Array<::Google::Cloud::ApiHub::V1::ConfigVariableTemplate>]
          #     Optional. The list of additional configuration variables for the plugin's
          #     configuration.
          class ConfigTemplate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # AuthConfigTemplate represents the authentication template for a plugin.
            # @!attribute [rw] supported_auth_types
            #   @return [::Array<::Google::Cloud::ApiHub::V1::AuthType>]
            #     Required. The list of authentication types supported by the plugin.
            # @!attribute [rw] service_account
            #   @return [::Google::Cloud::ApiHub::V1::GoogleServiceAccountConfig]
            #     Optional. The service account of the plugin hosting service.
            #     This service account should be granted the required permissions on the
            #     Auth Config parameters provided while creating the plugin instances
            #     corresponding to this plugin.
            #
            #     For example, if the plugin instance auth config requires a secret
            #     manager secret, the service account should be granted the
            #     secretmanager.versions.access permission on the corresponding secret,
            #     if the plugin instance auth config contains a service account, the
            #     service account should be granted the
            #     iam.serviceAccounts.getAccessToken permission on the corresponding
            #     service account.
            class AuthConfigTemplate
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Possible states a plugin can have. Note that this enum may receive new
          # values in the future. Consumers are advised to always code against the
          # enum values expecting new states can be added later on.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The plugin is enabled.
            ENABLED = 1

            # The plugin is disabled.
            DISABLED = 2
          end

          # Ownership type of the plugin.
          module OwnershipType
            # Default unspecified type.
            OWNERSHIP_TYPE_UNSPECIFIED = 0

            # System owned plugins are defined by API hub and are available out of the
            # box in API hub.
            SYSTEM_OWNED = 1

            # User owned plugins are defined by the user and need to be explicitly
            # added to API hub via
            # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#create_plugin CreatePlugin} method.
            USER_OWNED = 2
          end
        end

        # PluginActionConfig represents the configuration of an action supported by a
        # plugin.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. The id of the action.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the action.
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. The description of the operation performed by the action.
        # @!attribute [rw] trigger_mode
        #   @return [::Google::Cloud::ApiHub::V1::PluginActionConfig::TriggerMode]
        #     Required. The trigger mode supported by the action.
        class PluginActionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Execution mode of the action.
          module TriggerMode
            # Default unspecified mode.
            TRIGGER_MODE_UNSPECIFIED = 0

            # This action can be executed by invoking
            # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#execute_plugin_instance_action ExecutePluginInstanceAction}
            # API with the given action id. To support this, the plugin hosting service
            # should handle this action id as part of execute call.
            API_HUB_ON_DEMAND_TRIGGER = 1

            # This action will be executed on schedule by invoking
            # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#execute_plugin_instance_action ExecutePluginInstanceAction}
            # API with the given action id. To set the schedule, the user can provide
            # the cron expression in the
            # [PluginAction][PluginAction.schedule_cron_expression] field for a given
            # plugin instance. To support this, the plugin hosting service should
            # handle this action id as part of execute call.
            # Note, on demand execution will be supported by default in this trigger
            # mode.
            API_HUB_SCHEDULE_TRIGGER = 2

            # The execution of this plugin is not handled by API hub. In this case,
            # the plugin hosting service need not handle this action id as part of
            # the execute call.
            NON_API_HUB_MANAGED = 3
          end
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#get_plugin GetPlugin} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin to retrieve.
        #     Format: `projects/{project}/locations/{location}/plugins/{plugin}`.
        class GetPluginRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#enable_plugin EnablePlugin} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin to enable.
        #     Format: `projects/{project}/locations/{location}/plugins/{plugin}`.
        class EnablePluginRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#disable_plugin DisablePlugin}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin to disable.
        #     Format: `projects/{project}/locations/{location}/plugins/{plugin}`.
        class DisablePluginRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PluginInstanceAction represents an action which can be executed in the plugin
        # instance.
        # @!attribute [rw] hub_instance_action
        #   @return [::Google::Cloud::ApiHub::V1::ExecutionStatus]
        #     Optional. The execution information for the plugin instance action done
        #     corresponding to an API hub instance.
        # @!attribute [rw] action_id
        #   @return [::String]
        #     Required. This should map to one of the [action
        #     id][google.cloud.apihub.v1.PluginActionConfig.id] specified in
        #     {::Google::Cloud::ApiHub::V1::Plugin#actions_config actions_config} in the
        #     plugin.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ApiHub::V1::PluginInstanceAction::State]
        #     Output only. The current state of the plugin action in the plugin instance.
        # @!attribute [rw] schedule_cron_expression
        #   @return [::String]
        #     Optional. The schedule for this plugin instance action. This can only be
        #     set if the plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
        # @!attribute [rw] curation_config
        #   @return [::Google::Cloud::ApiHub::V1::CurationConfig]
        #     Optional. This configuration should be provided if the plugin action is
        #     publishing data to API hub curate layer.
        # @!attribute [rw] schedule_time_zone
        #   @return [::String]
        #     Optional. The time zone for the schedule cron expression. If not provided,
        #     UTC will be used.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The service account used to publish data. Note, the service
        #     account will only be accepted for non GCP plugins like OPDK.
        # @!attribute [r] resource_config
        #   @return [::Google::Cloud::ApiHub::V1::PluginInstanceAction::ResourceConfig]
        #     Output only. The configuration of resources created for a given plugin
        #     instance action. Note these will be returned only in case of Non-GCP
        #     plugins like OPDK.
        class PluginInstanceAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The configuration of resources created for a given plugin instance action.
          # @!attribute [r] action_type
          #   @return [::Google::Cloud::ApiHub::V1::ActionType]
          #     Output only. The type of the action.
          # @!attribute [r] pubsub_topic
          #   @return [::String]
          #     Output only. The pubsub topic to publish the data to. Format is
          #     projects/\\{project}/topics/\\{topic}
          class ResourceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State represents the state of the plugin instance action.
          module State
            # Default unspecified state.
            STATE_UNSPECIFIED = 0

            # The action is enabled in the plugin instance i.e., executions can
            # be triggered for this action.
            ENABLED = 1

            # The action is disabled in the plugin instance i.e., no executions
            # can be triggered for this action. This state indicates that the user
            # explicitly disabled the instance, and no further action is needed unless
            # the user wants to re-enable it.
            DISABLED = 2

            # The action in the plugin instance is being enabled.
            ENABLING = 3

            # The action in the plugin instance is being disabled.
            DISABLING = 4

            # The ERROR state can come while enabling/disabling plugin instance action.
            # Users can retrigger enable, disable via
            # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#enable_plugin_instance_action EnablePluginInstanceAction}
            # and
            # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#disable_plugin_instance_action DisablePluginInstanceAction}
            # to restore the action back to enabled/disabled state. Note enable/disable
            # on actions can only be triggered if plugin instance is in Active state.
            ERROR = 5
          end
        end

        # Represents a plugin instance resource in the API Hub.
        # A PluginInstance is a specific instance of a hub plugin with its own
        # configuration, state, and execution details.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique name of the plugin instance resource.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name for this plugin instance. Max length is 255
        #     characters.
        # @!attribute [rw] auth_config
        #   @return [::Google::Cloud::ApiHub::V1::AuthConfig]
        #     Optional. The authentication information for this plugin instance.
        # @!attribute [rw] additional_config
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::ConfigVariable}]
        #     Optional. The additional information for this plugin instance corresponding
        #     to the additional config template of the plugin. This information will be
        #     sent to plugin hosting service on each call to plugin hosted service. The
        #     key will be the config_variable_template.display_name to uniquely identify
        #     the config variable.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ApiHub::V1::PluginInstance::State]
        #     Output only. The current state of the plugin instance (e.g., enabled,
        #     disabled, provisioning).
        # @!attribute [r] error_message
        #   @return [::String]
        #     Output only. Error message describing the failure, if any, during Create,
        #     Delete or ApplyConfig operation corresponding to the plugin instance.This
        #     field will only be populated if the plugin instance is in the ERROR or
        #     FAILED state.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::ApiHub::V1::PluginInstanceAction>]
        #     Required. The action status for the plugin instance.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp indicating when the plugin instance was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp indicating when the plugin instance was last
        #     updated.
        # @!attribute [rw] source_project_id
        #   @return [::String]
        #     Optional. The source project id of the plugin instance. This will be the id
        #     of runtime project in case of gcp based plugins and org id in case of non
        #     gcp based plugins. This field will be a required field for Google provided
        #     on-ramp plugins.
        class PluginInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::ConfigVariable]
          class AdditionalConfigEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State represents the state of the plugin instance.
          module State
            # Default unspecified state.
            STATE_UNSPECIFIED = 0

            # The plugin instance is being created.
            CREATING = 1

            # The plugin instance is active and ready for executions. This is the only
            # state where executions can run on the plugin instance.
            ACTIVE = 2

            # The updated config that contains
            # {::Google::Cloud::ApiHub::V1::PluginInstance#additional_config additional_config}
            # and {::Google::Cloud::ApiHub::V1::PluginInstance#auth_config auth_config} is
            # being applied.
            APPLYING_CONFIG = 3

            # The ERROR state can come while applying config. Users
            # can retrigger
            # [ApplyPluginInstanceConfig][google.cloud.apihub.v1.ApiHubPlugin.ApplyPluginInstanceConfig]
            # to restore the plugin instance back to active state. Note, In case the
            # ERROR state happens while applying config (auth_config,
            # additional_config), the plugin instance will reflect the config which was
            # trying to be applied while error happened. In order to overwrite, trigger
            # ApplyConfig with a new config.
            ERROR = 4

            # The plugin instance is in a failed state. This indicates that an
            # unrecoverable error occurred during a previous operation (Create,
            # Delete).
            FAILED = 5

            # The plugin instance is being deleted. Delete is only possible if there is
            # no other operation running on the plugin instance and plugin instance
            # action.
            DELETING = 6
          end
        end

        # The curation information for this plugin instance.
        # @!attribute [rw] custom_curation
        #   @return [::Google::Cloud::ApiHub::V1::CurationConfig::CustomCuration]
        #     Optional. Custom curation information for this plugin instance.
        # @!attribute [rw] curation_type
        #   @return [::Google::Cloud::ApiHub::V1::CurationType]
        #     Required. The curation type for this plugin instance.
        class CurationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Custom curation information for this plugin instance.
          # @!attribute [rw] curation
          #   @return [::String]
          #     Required. The unique name of the curation resource. This will be the name
          #     of the curation resource in the format:
          #     `projects/{project}/locations/{location}/curations/{curation}`
          class CustomCuration
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The execution status for the plugin instance.
        # @!attribute [r] current_execution_state
        #   @return [::Google::Cloud::ApiHub::V1::ExecutionStatus::CurrentExecutionState]
        #     Output only. The current state of the execution.
        # @!attribute [r] last_execution
        #   @return [::Google::Cloud::ApiHub::V1::ExecutionStatus::LastExecution]
        #     Output only. The last execution of the plugin instance.
        class ExecutionStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The result of the last execution of the plugin instance.
          # @!attribute [r] result
          #   @return [::Google::Cloud::ApiHub::V1::ExecutionStatus::LastExecution::Result]
          #     Output only. The result of the last execution of the plugin instance.
          # @!attribute [r] error_message
          #   @return [::String]
          #     Output only. Error message describing the failure, if any, during the
          #     last execution.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The last execution start time of the plugin instance.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The last execution end time of the plugin instance.
          class LastExecution
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum for the result of the last execution of the plugin instance.
            module Result
              # Default unspecified execution result.
              RESULT_UNSPECIFIED = 0

              # The plugin instance executed successfully.
              SUCCEEDED = 1

              # The plugin instance execution failed.
              FAILED = 2
            end
          end

          # Enum for the current state of the execution.
          module CurrentExecutionState
            # Default unspecified execution state.
            CURRENT_EXECUTION_STATE_UNSPECIFIED = 0

            # The plugin instance is executing.
            RUNNING = 1

            # The plugin instance is not running an execution.
            NOT_RUNNING = 2
          end
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#create_plugin CreatePlugin} method's
        # request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this plugin will be created.
        #     Format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] plugin_id
        #   @return [::String]
        #     Optional. The ID to use for the Plugin resource, which will become the
        #     final component of the Plugin's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another Plugin resource in the API hub
        #     instance.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-63 characters, overall resource name which will be
        #     of format
        #     `projects/{project}/locations/{location}/plugins/{plugin}`,
        #     its length is limited to 1000 characters and valid characters are
        #     /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] plugin
        #   @return [::Google::Cloud::ApiHub::V1::Plugin]
        #     Required. The plugin to create.
        class CreatePluginRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [DeletePlugin][ApiHub.DeletePlugin] method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Plugin resource to delete.
        #     Format: `projects/{project}/locations/{location}/plugins/{plugin}`
        class DeletePluginRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#list_plugins ListPlugins} method's
        # request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this plugin will be created.
        #     Format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of plugins.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. The
        #     comparison operator must be one of: `<`, `>` or
        #     `=`. Filters are not case sensitive.
        #
        #     The following fields in the `Plugins` are eligible for filtering:
        #
        #       * `plugin_category` - The category of the Plugin. Allowed
        #       comparison operators: `=`.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are
        #     supported. At most three filter fields are allowed in the filter
        #     string and if provided more than that then `INVALID_ARGUMENT` error is
        #     returned by the API.
        #     Here are a few examples:
        #
        #       * `plugin_category = ON_RAMP` - The plugin is of category
        #       on ramp.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of hub plugins to return. The service may
        #     return fewer than this value. If unspecified, at most 50 hub plugins will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListPlugins` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListPlugins` must match the call that provided the page token.
        class ListPluginsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#list_plugins ListPlugins} method's
        # response.
        # @!attribute [rw] plugins
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Plugin>]
        #     The plugins from the specified parent resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListPluginsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#create_plugin_instance CreatePluginInstance}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the plugin instance resource.
        #     Format: `projects/{project}/locations/{location}/plugins/{plugin}`
        # @!attribute [rw] plugin_instance_id
        #   @return [::String]
        #     Optional. The ID to use for the plugin instance, which will become the
        #     final component of the plugin instance's resource name. This field is
        #     optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another plugin instance in the plugin
        #     resource.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] plugin_instance
        #   @return [::Google::Cloud::ApiHub::V1::PluginInstance]
        #     Required. The plugin instance to create.
        class CreatePluginInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#execute_plugin_instance_action ExecutePluginInstanceAction}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin instance to execute.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        # @!attribute [rw] action_execution_detail
        #   @return [::Google::Cloud::ApiHub::V1::ActionExecutionDetail]
        #     Required. The execution details for the action to execute.
        class ExecutePluginInstanceActionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for the action to execute.
        # @!attribute [rw] action_id
        #   @return [::String]
        #     Required. The action id of the plugin to execute.
        class ActionExecutionDetail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#execute_plugin_instance_action ExecutePluginInstanceAction}
        # method's response.
        class ExecutePluginInstanceActionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#get_plugin_instance GetPluginInstance}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin instance to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        class GetPluginInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#list_plugin_instances ListPluginInstances}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this plugin will be created.
        #     Format: `projects/{project}/locations/{location}/plugins/{plugin}`.
        #     To list plugin instances for multiple plugins,
        #     use the - character instead of the plugin ID.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of plugin instances.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. The
        #     comparison operator must be one of: `<`, `>` or
        #     `=`. Filters are not case sensitive.
        #
        #     The following fields in the `PluginInstances` are eligible for filtering:
        #
        #       * `state` - The state of the Plugin Instance. Allowed
        #       comparison operators: `=`.
        #
        #     A filter function is also supported in the filter string. The filter
        #     function is `id(name)`. The `id(name)` function returns the id of the
        #     resource name. For example, `id(name) = \"plugin-instance-1\"` is
        #     equivalent to `name =
        #     \"projects/test-project-id/locations/test-location-id/plugins/plugin-1/instances/plugin-instance-1\"`
        #     provided the parent is
        #     `projects/test-project-id/locations/test-location-id/plugins/plugin-1`.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are
        #     supported. At most three filter fields are allowed in the filter
        #     string and if provided more than that then `INVALID_ARGUMENT` error is
        #     returned by the API.
        #     Here are a few examples:
        #
        #       * `state = ENABLED` - The plugin instance is in enabled state.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of hub plugins to return. The service may
        #     return fewer than this value. If unspecified, at most 50 hub plugins will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListPluginInstances`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListPluginInstances`
        #     must match the call that provided the page token.
        class ListPluginInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#list_plugin_instances ListPluginInstances}
        # method's response.
        # @!attribute [rw] plugin_instances
        #   @return [::Array<::Google::Cloud::ApiHub::V1::PluginInstance>]
        #     The plugin instances from the specified parent resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListPluginInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#enable_plugin_instance_action EnablePluginInstanceAction}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin instance to enable.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        # @!attribute [rw] action_id
        #   @return [::String]
        #     Required. The action id to enable.
        class EnablePluginInstanceActionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#enable_plugin_instance_action EnablePluginInstanceAction}
        # method's response.
        class EnablePluginInstanceActionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#disable_plugin_instance_action DisablePluginInstanceAction}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin instance to disable.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
        # @!attribute [rw] action_id
        #   @return [::String]
        #     Required. The action id to disable.
        class DisablePluginInstanceActionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#disable_plugin_instance_action DisablePluginInstanceAction}
        # method's response.
        class DisablePluginInstanceActionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#update_plugin_instance UpdatePluginInstance}
        # method's request.
        # @!attribute [rw] plugin_instance
        #   @return [::Google::Cloud::ApiHub::V1::PluginInstance]
        #     Required. The plugin instance to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdatePluginInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubPlugin::Rest::Client#delete_plugin_instance DeletePluginInstance}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the plugin instance to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`.
        class DeletePluginInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Enum for the action type.
        module ActionType
          # Default unspecified action type.
          ACTION_TYPE_UNSPECIFIED = 0

          # Action type for sync metadata.
          SYNC_METADATA = 1

          # Action type for sync runtime data.
          SYNC_RUNTIME_DATA = 2
        end

        # Enum for the gateway type.
        module GatewayType
          # The gateway type is not specified.
          GATEWAY_TYPE_UNSPECIFIED = 0

          # The gateway type is Apigee X and Hybrid.
          APIGEE_X_AND_HYBRID = 1

          # The gateway type is Apigee Edge Public Cloud.
          APIGEE_EDGE_PUBLIC_CLOUD = 2

          # The gateway type is Apigee Edge Private Cloud.
          APIGEE_EDGE_PRIVATE_CLOUD = 3

          # The gateway type is Cloud API Gateway.
          CLOUD_API_GATEWAY = 4

          # The gateway type is Cloud Endpoints.
          CLOUD_ENDPOINTS = 5

          # The gateway type is API Discovery.
          API_DISCOVERY = 6

          # The gateway type for any other types of gateways.
          OTHERS = 7
        end

        # Enum for the curation type.
        module CurationType
          # Default unspecified curation type.
          CURATION_TYPE_UNSPECIFIED = 0

          # Default curation for API metadata will be used.
          DEFAULT_CURATION_FOR_API_METADATA = 1

          # Custom curation for API metadata will be used.
          CUSTOM_CURATION_FOR_API_METADATA = 2
        end
      end
    end
  end
end
