# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # The {::Google::Cloud::ApiHub::V1::LintingService::Rest::Client#get_style_guide GetStyleGuide}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
        class GetStyleGuideRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::LintingService::Rest::Client#update_style_guide UpdateStyleGuide}
        # method's request.
        # @!attribute [rw] style_guide
        #   @return [::Google::Cloud::ApiHub::V1::StyleGuide]
        #     Required. The Style guide resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdateStyleGuideRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::LintingService::Rest::Client#get_style_guide_contents GetStyleGuideContents}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the StyleGuide whose contents need to be retrieved.
        #     There is exactly one style guide resource per project per location.
        #     The expected format is
        #     `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
        class GetStyleGuideContentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::LintingService::Rest::Client#lint_spec LintSpec} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec to be linted.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        class LintSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The style guide contents.
        # @!attribute [rw] contents
        #   @return [::String]
        #     Required. The contents of the style guide.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The mime type of the content.
        class StyleGuideContents
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a singleton style guide resource to be used for linting Open API
        # specs.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the style guide.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`
        # @!attribute [rw] linter
        #   @return [::Google::Cloud::ApiHub::V1::Linter]
        #     Required. Target linter for the style guide.
        # @!attribute [rw] contents
        #   @return [::Google::Cloud::ApiHub::V1::StyleGuideContents]
        #     Required. Input only. The contents of the uploaded style guide.
        class StyleGuide
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
