# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # The
        # {::Google::Cloud::ApiHub::V1::HostProjectRegistrationService::Rest::Client#create_host_project_registration CreateHostProjectRegistration}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the host project.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] host_project_registration_id
        #   @return [::String]
        #     Required. The ID to use for the Host Project Registration, which will
        #     become the final component of the host project registration's resource
        #     name. The ID must be the same as the Google cloud project specified in the
        #     host_project_registration.gcp_project field.
        # @!attribute [rw] host_project_registration
        #   @return [::Google::Cloud::ApiHub::V1::HostProjectRegistration]
        #     Required. The host project registration to register.
        class CreateHostProjectRegistrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::HostProjectRegistrationService::Rest::Client#get_host_project_registration GetHostProjectRegistration}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Host project registration resource name.
        #     projects/\\{project}/locations/\\{location}/hostProjectRegistrations/\\{host_project_registration_id}
        class GetHostProjectRegistrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::HostProjectRegistrationService::Rest::Client#list_host_project_registrations ListHostProjectRegistrations}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of host projects.
        #     Format: `projects/*/locations/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of host project registrations to return. The
        #     service may return fewer than this value. If unspecified, at most 50 host
        #     project registrations will be returned. The maximum value is 1000; values
        #     above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListHostProjectRegistrations` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListHostProjectRegistrations` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of HostProjectRegistrations.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. All
        #     standard operators as documented at https://google.aip.dev/160 are
        #     supported.
        #
        #     The following fields in the `HostProjectRegistration` are eligible for
        #     filtering:
        #
        #       * `name` - The name of the HostProjectRegistration.
        #       * `create_time` - The time at which the HostProjectRegistration was
        #       created. The value should be in the
        #       (RFC3339)[https://tools.ietf.org/html/rfc3339] format.
        #       * `gcp_project` - The Google cloud project associated with the
        #       HostProjectRegistration.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListHostProjectRegistrationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::HostProjectRegistrationService::Rest::Client#list_host_project_registrations ListHostProjectRegistrations}
        # method's response.
        # @!attribute [rw] host_project_registrations
        #   @return [::Array<::Google::Cloud::ApiHub::V1::HostProjectRegistration>]
        #     The list of host project registrations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListHostProjectRegistrationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Host project registration refers to the registration of a Google cloud
        # project with Api Hub as a host project. This is the project where Api Hub is
        # provisioned. It acts as the consumer project for the Api Hub instance
        # provisioned. Multiple runtime projects can be attached to the host project
        # and these attachments define the scope of Api Hub.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the host project registration.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/hostProjectRegistrations/\\{host_project_registration}".
        # @!attribute [rw] gcp_project
        #   @return [::String]
        #     Required. Immutable. Google cloud project name in the format:
        #     "projects/abc" or "projects/123". As input, project name with either
        #     project id or number are accepted. As output, this field will contain
        #     project number.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the host project registration was created.
        class HostProjectRegistration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
