# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # Message for requesting list of DiscoveredApiObservations
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of ApiObservations.
        #     Format:
        #     projects/\\{project}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of ApiObservations to return. The service may
        #     return fewer than this value. If unspecified, at most 10
        #     ApiObservations will be returned. The maximum value is 1000; values
        #     above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListApiObservations`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListApiObservations` must match the call that provided the page
        #     token.
        class ListDiscoveredApiObservationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing DiscoveredApiObservations
        # @!attribute [rw] discovered_api_observations
        #   @return [::Array<::Google::Cloud::ApiHub::V1::DiscoveredApiObservation>]
        #     The DiscoveredApiObservation from the specified project and location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDiscoveredApiObservationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of DiscoveredApiOperations
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of
        #     DiscoveredApiOperations. Format:
        #     projects/\\{project}/locations/\\{location}/discoveredApiObservations/\\{discovered_api_observation}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. DiscoveredApiOperations will be returned. The maximum value is
        #     1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListDiscoveredApiApiOperations` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDiscoveredApiApiOperations` must match the call that provided the page
        #     token.
        class ListDiscoveredApiOperationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing DiscoveredApiOperations
        # @!attribute [rw] discovered_api_operations
        #   @return [::Array<::Google::Cloud::ApiHub::V1::DiscoveredApiOperation>]
        #     The DiscoveredApiOperations from the specified project, location
        #     and DiscoveredApiObservation.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDiscoveredApiOperationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting a DiscoveredApiObservation
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DiscoveredApiObservation to retrieve.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/discoveredApiObservations/\\{discovered_api_observation}
        class GetDiscoveredApiObservationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting a DiscoveredApiOperation
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DiscoveredApiOperation to retrieve.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/discoveredApiObservations/\\{discovered_api_observation}/discoveredApiOperations/\\{discovered_api_operation}
        class GetDiscoveredApiOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
