# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # The [CreateCuration][ApiHub.CreateCuration] method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the curation resource.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] curation_id
        #   @return [::String]
        #     Optional. The ID to use for the curation resource, which will become the
        #     final component of the curations's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified ID is already used by another curation resource in the API
        #     hub.
        #     * If not provided, a system generated ID will be used.
        #
        #     This value should be 4-500 characters, and valid characters
        #     are /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] curation
        #   @return [::Google::Cloud::ApiHub::V1::Curation]
        #     Required. The curation resource to create.
        class CreateCurationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [GetCuration][ApiHub.GetCuration] method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the curation resource to retrieve.
        #     Format: `projects/{project}/locations/{location}/curations/{curation}`
        class GetCurationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [UpdateCuration][ApiHub.UpdateCuration] method's request.
        # @!attribute [rw] curation
        #   @return [::Google::Cloud::ApiHub::V1::Curation]
        #     Required. The curation resource to update.
        #
        #     The curation resource's `name` field is used to identify the curation
        #     resource to update.
        #     Format: `projects/{project}/locations/{location}/curations/{curation}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdateCurationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [DeleteCuration][ApiHub.DeleteCuration] method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the curation resource to delete.
        #     Format: `projects/{project}/locations/{location}/curations/{curation}`
        class DeleteCurationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [ListCurations][ApiHub.ListCurations] method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of curation resources.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of curation resources.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. The
        #     comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are case
        #     insensitive.
        #
        #     The following fields in the `curation resource` are eligible for filtering:
        #
        #       * `create_time` - The time at which the curation was created.
        #       The value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
        #       format. Allowed comparison operators: `>` and `<`.
        #       * `display_name` - The display name of the curation. Allowed
        #       comparison operators: `=`.
        #       * `state` - The state of the curation. Allowed comparison operators: `=`.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are supported. At most
        #     three filter fields are allowed in the filter string and if provided
        #     more than that then `INVALID_ARGUMENT` error is returned by the API.
        #
        #     Here are a few examples:
        #
        #       * `create_time < \"2021-08-15T14:50:00Z\" AND create_time >
        #       \"2021-08-10T12:00:00Z\"` -
        #       The curation resource was created before _2021-08-15 14:50:00 UTC_ and
        #       after _2021-08-10 12:00:00 UTC_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of curation resources to return. The service
        #     may return fewer than this value. If unspecified, at most 50 curations will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListCurations` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListCurations` must match the call that provided the page token.
        class ListCurationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [ListCurations][ApiHub.ListCurations] method's response.
        # @!attribute [rw] curations
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Curation>]
        #     The curation resources present in the API hub.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListCurationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A curation resource in the API Hub.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the curation.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/curations/{curation}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the curation.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the curation.
        # @!attribute [rw] endpoint
        #   @return [::Google::Cloud::ApiHub::V1::Endpoint]
        #     Required. The endpoint to be triggered for curation.
        # @!attribute [r] plugin_instance_actions
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Curation::PluginInstanceActionID>]
        #     Output only. The plugin instances and associated actions that are using the
        #     curation. Note: A particular curation could be used by multiple plugin
        #     instances or multiple actions in a plugin instance.
        # @!attribute [r] last_execution_state
        #   @return [::Google::Cloud::ApiHub::V1::Curation::LastExecutionState]
        #     Output only. The last execution state of the curation.
        # @!attribute [r] last_execution_error_code
        #   @return [::Google::Cloud::ApiHub::V1::Curation::ErrorCode]
        #     Output only. The error code of the last execution of the curation. The
        #     error code is populated only when the last execution state is failed.
        # @!attribute [r] last_execution_error_message
        #   @return [::String]
        #     Output only. Error message describing the failure, if any, during the last
        #     execution of the curation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the curation was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the curation was last updated.
        class Curation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The plugin instance and associated action that is using the curation.
          # @!attribute [r] plugin_instance
          #   @return [::String]
          #     Output only. Plugin instance that is using the curation.
          #     Format is
          #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
          # @!attribute [r] action_id
          #   @return [::String]
          #     Output only. The action ID that is using the curation.
          #     This should map to one of the action IDs specified
          #     in action configs in the plugin.
          class PluginInstanceActionID
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the last execution of the curation.
          module LastExecutionState
            # Default unspecified state.
            LAST_EXECUTION_STATE_UNSPECIFIED = 0

            # The last curation execution was successful.
            SUCCEEDED = 1

            # The last curation execution failed.
            FAILED = 2
          end

          # The error codes for failed executions.
          module ErrorCode
            # Default unspecified error code.
            ERROR_CODE_UNSPECIFIED = 0

            # The execution failed due to an internal error.
            INTERNAL_ERROR = 1

            # The curation is not authorized to trigger the endpoint uri.
            UNAUTHORIZED = 2
          end
        end

        # The endpoint to be triggered for curation.
        # The endpoint will be invoked with a request payload containing
        # [ApiMetadata][google.cloud.apihub.v1.ApiHub.ApiMetadata].
        # Response should contain curated data in the form of
        # [ApiMetadata][google.cloud.apihub.v1.ApiHub.ApiMetadata].
        # @!attribute [rw] application_integration_endpoint_details
        #   @return [::Google::Cloud::ApiHub::V1::ApplicationIntegrationEndpointDetails]
        #     Required. The details of the Application Integration endpoint to be
        #     triggered for curation.
        class Endpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details of the Application Integration endpoint to be triggered for
        # curation.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. The endpoint URI should be a valid REST URI for triggering an
        #     Application Integration. Format:
        #     `https://integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        #     or
        #     `https://{location}-integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        # @!attribute [rw] trigger_id
        #   @return [::String]
        #     Required. The API trigger ID of the Application Integration workflow.
        class ApplicationIntegrationEndpointDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
