# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # An API resource in the API Hub.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the API resource in the API Hub.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the API resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the API resource.
        # @!attribute [rw] documentation
        #   @return [::Google::Cloud::ApiHub::V1::Documentation]
        #     Optional. The documentation for the API resource.
        # @!attribute [rw] owner
        #   @return [::Google::Cloud::ApiHub::V1::Owner]
        #     Optional. Owner details for the API resource.
        # @!attribute [r] versions
        #   @return [::Array<::String>]
        #     Output only. The list of versions present in an API resource.
        #     Note: An API resource can be associated with more than 1 version.
        #     Format is
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the API resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the API resource was last updated.
        # @!attribute [rw] target_user
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The target users for the API.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-target-user`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] team
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The team owning the API.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-team`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] business_unit
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The business unit owning the API.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-business-unit`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] maturity_level
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The maturity level of the API.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-maturity-level`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the API
        #     resource. The key is the attribute name. It will be of the format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        # @!attribute [rw] api_style
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The style of the API.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-api-style`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] selected_version
        #   @return [::String]
        #     Optional. The selected version for an API resource.
        #     This can be used when special handling is needed on client side for
        #     particular version of the API. Format is
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] api_requirements
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The api requirement doc associated with the API resource.
        #     Carinality is 1 for this attribute. This maps to the following system
        #     defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-api-requirements`
        #     attribute. The value of the attribute should be a proper URI, and in case
        #     of Cloud Storage URI, it should point to a Cloud Storage object,
        #     not a directory.
        # @!attribute [rw] fingerprint
        #   @return [::String]
        #     Optional. Fingerprint of the API resource.
        # @!attribute [r] source_metadata
        #   @return [::Array<::Google::Cloud::ApiHub::V1::SourceMetadata>]
        #     Output only. The list of sources and metadata from the sources of the API
        #     resource.
        # @!attribute [rw] api_functional_requirements
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The api functional requirements associated with the API resource.
        #     Carinality is 1 for this attribute.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-api-functional-requirements`
        #     attribute. The value of the attribute should be a proper URI, and in case
        #     of Cloud Storage URI, it should point to a Cloud Storage object,
        #     not a directory.
        # @!attribute [rw] api_technical_requirements
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The api technical requirements associated with the API resource.
        #     Carinality is 1 for this attribute. This maps to the following system
        #     defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-api-technical-requirements`
        #     attribute. The value of the attribute should be a proper URI, and in case
        #     of Cloud Storage URI, it should point to a Cloud Storage object,
        #     not a directory.
        class Api
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a version of the API resource in API hub. This is also referred
        # to as the API version.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the version.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the version.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the version.
        # @!attribute [rw] documentation
        #   @return [::Google::Cloud::ApiHub::V1::Documentation]
        #     Optional. The documentation of the version.
        # @!attribute [r] specs
        #   @return [::Array<::String>]
        #     Output only. The specs associated with this version.
        #     Note that an API version can be associated with multiple specs.
        #     Format is
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        # @!attribute [r] api_operations
        #   @return [::Array<::String>]
        #     Output only. The operations contained in the API version.
        #     These operations will be added to the version when a new spec is
        #     added or when an existing spec is updated. Format is
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
        # @!attribute [r] definitions
        #   @return [::Array<::String>]
        #     Output only. The definitions contained in the API version.
        #     These definitions will be added to the version when a new spec is
        #     added or when an existing spec is updated. Format is
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
        # @!attribute [rw] deployments
        #   @return [::Array<::String>]
        #     Optional. The deployments linked to this API version.
        #     Note: A particular API version could be deployed to multiple deployments
        #     (for dev deployment, UAT deployment, etc)
        #     Format is
        #     `projects/{project}/locations/{location}/deployments/{deployment}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the version was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the version was last updated.
        # @!attribute [rw] lifecycle
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The lifecycle of the API version.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-lifecycle`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] compliance
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The compliance associated with the API version.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-compliance`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] accreditation
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The accreditations associated with the API version.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-accreditation`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the Version
        #     resource. The key is the attribute name. It will be of the format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        # @!attribute [rw] selected_deployment
        #   @return [::String]
        #     Optional. The selected deployment for a Version resource.
        #     This can be used when special handling is needed on client side for a
        #     particular deployment linked to the version.
        #     Format is
        #     `projects/{project}/locations/{location}/deployments/{deployment}`
        # @!attribute [r] source_metadata
        #   @return [::Array<::Google::Cloud::ApiHub::V1::SourceMetadata>]
        #     Output only. The list of sources and metadata from the sources of the
        #     version.
        class Version
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a spec associated with an API version in the API
        # Hub. Note that specs of various types can be uploaded, however
        # parsing of details is supported for OpenAPI spec currently.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the spec.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the spec.
        #     This can contain the file name of the spec.
        # @!attribute [rw] spec_type
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Required. The type of spec.
        #     The value should be one of the allowed values defined for
        #     `projects/{project}/locations/{location}/attributes/system-spec-type`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API.
        #
        #     Note, this field is mandatory if content is provided.
        # @!attribute [rw] contents
        #   @return [::Google::Cloud::ApiHub::V1::SpecContents]
        #     Optional. Input only. The contents of the uploaded spec.
        # @!attribute [r] details
        #   @return [::Google::Cloud::ApiHub::V1::SpecDetails]
        #     Output only. Details parsed from the spec.
        # @!attribute [rw] source_uri
        #   @return [::String]
        #     Optional. The URI of the spec source in case file is uploaded
        #     from an external version control system.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the spec was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the spec was last updated.
        # @!attribute [rw] lint_response
        #   @return [::Google::Cloud::ApiHub::V1::LintResponse]
        #     Optional. The lint response for the spec.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the spec.
        #     The key is the attribute name. It will be of the format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        # @!attribute [rw] documentation
        #   @return [::Google::Cloud::ApiHub::V1::Documentation]
        #     Optional. The documentation of the spec.
        #     For OpenAPI spec, this will be populated from `externalDocs` in OpenAPI
        #     spec.
        # @!attribute [rw] parsing_mode
        #   @return [::Google::Cloud::ApiHub::V1::Spec::ParsingMode]
        #     Optional. Input only. Enum specifying the parsing mode for OpenAPI
        #     Specification (OAS) parsing.
        # @!attribute [r] source_metadata
        #   @return [::Array<::Google::Cloud::ApiHub::V1::SourceMetadata>]
        #     Output only. The list of sources and metadata from the sources of the spec.
        class Spec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the parsing mode for API specifications during creation and
          # update.
          # - `RELAXED`: Parsing errors in the specification content do not fail the
          # API call.
          # - `STRICT`: Parsing errors in the specification content result in failure
          # of the API call.
          # If not specified, defaults to `RELAXED`.
          module ParsingMode
            # Defaults to `RELAXED`.
            PARSING_MODE_UNSPECIFIED = 0

            # Parsing of the Spec on create and update is relaxed, meaning that
            # parsing errors the spec contents will not fail the API call.
            RELAXED = 1

            # Parsing of the Spec on create and update is strict, meaning that
            # parsing errors in the spec contents will fail the API call.
            STRICT = 2
          end
        end

        # Details of the deployment where APIs are hosted.
        # A deployment could represent an Apigee proxy, API gateway, other Google Cloud
        # services or non-Google Cloud services as well. A deployment entity is a root
        # level entity in the API hub and exists independent of any API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the deployment.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/deployments/{deployment}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the deployment.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the deployment.
        # @!attribute [rw] documentation
        #   @return [::Google::Cloud::ApiHub::V1::Documentation]
        #     Optional. The documentation of the deployment.
        # @!attribute [rw] deployment_type
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Required. The type of deployment.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-deployment-type`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] resource_uri
        #   @return [::String]
        #     Required. The resource URI identifies the deployment within its gateway.
        #     For Apigee gateways, its recommended to use the format:
        #     organizations/\\{org}/environments/\\{env}/apis/\\{api}.
        #     For ex: if a proxy with name `orders` is deployed in `staging`
        #     environment of `cymbal` organization, the resource URI would be:
        #     `organizations/cymbal/environments/staging/apis/orders`.
        # @!attribute [rw] endpoints
        #   @return [::Array<::String>]
        #     Required. The endpoints at which this deployment resource is listening for
        #     API requests. This could be a list of complete URIs, hostnames or an IP
        #     addresses.
        # @!attribute [r] api_versions
        #   @return [::Array<::String>]
        #     Output only. The API versions linked to this deployment.
        #     Note: A particular deployment could be linked to multiple different API
        #     versions (of same or different APIs).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the deployment was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the deployment was last updated.
        # @!attribute [rw] slo
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The SLO for this deployment.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-slo`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] environment
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The environment mapping to this deployment.
        #     This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-environment`
        #     attribute.
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. All values should be from the list of allowed values defined for the
        #     attribute.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the
        #     deployment resource. The key is the attribute name. It will be of the
        #     format: `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        # @!attribute [r] source_metadata
        #   @return [::Array<::Google::Cloud::ApiHub::V1::SourceMetadata>]
        #     Output only. The list of sources and metadata from the sources of the
        #     deployment.
        # @!attribute [rw] management_url
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The uri where users can navigate to for the management of the
        #     deployment. This maps to the following system defined attribute:
        #     `projects/{project}/locations/{location}/attributes/system-management-url`
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. The value of the attribute should be a valid URL.
        # @!attribute [rw] source_uri
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
        #     Optional. The uri where additional source specific information for this
        #     deployment can be found. This maps to the following system defined
        #     attribute:
        #     `projects/{project}/locations/{location}/attributes/system-source-uri`
        #     The number of values for this attribute will be based on the
        #     cardinality of the attribute. The same can be retrieved via GetAttribute
        #     API. The value of the attribute should be a valid URI, and in case
        #     of Cloud Storage URI, it should point to a Cloud Storage object,
        #     not a directory.
        # @!attribute [rw] source_project
        #   @return [::String]
        #     Optional. The project to which the deployment belongs.
        #     For GCP gateways, this will refer to the project identifier.
        #     For others like Edge/OPDK, this will refer to the org identifier.
        # @!attribute [rw] source_environment
        #   @return [::String]
        #     Optional. The environment at source for the deployment.
        #     For example: prod, dev, staging, etc.
        class Deployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents an operation contained in an API version in the API Hub.
        # An operation is added/updated/deleted in an API version when a new spec is
        # added or an existing spec is updated/deleted in a version.
        # Currently, an operation will be created only corresponding to OpenAPI spec as
        # parsing is supported for OpenAPI spec.
        # Alternatively operations can be managed via create,update and delete APIs,
        # creation of apiOperation can be possible only for version with no parsed
        # operations and update/delete can be possible only for operations created via
        # create API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the operation.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
        # @!attribute [r] spec
        #   @return [::String]
        #     Output only. The name of the spec will be of the format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        #     Note:The name of the spec will be empty if the operation is created via
        #     {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api_operation CreateApiOperation} API.
        # @!attribute [rw] details
        #   @return [::Google::Cloud::ApiHub::V1::OperationDetails]
        #     Optional. Operation details.
        #     Note: Even though this field is optional, it is required for
        #     {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api_operation CreateApiOperation}
        #     API and we will fail the request if not provided.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the operation was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the operation was last updated.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the API
        #     operation resource. The key is the attribute name. It will be of the
        #     format: `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        # @!attribute [r] source_metadata
        #   @return [::Array<::Google::Cloud::ApiHub::V1::SourceMetadata>]
        #     Output only. The list of sources and metadata from the sources of the API
        #     operation.
        class ApiOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a definition for example schema, request, response definitions
        # contained in an API version.
        # A definition is added/updated/deleted in an API version when a new spec is
        # added or an existing spec is updated/deleted in a version. Currently,
        # definition will be created only corresponding to OpenAPI spec as parsing is
        # supported for OpenAPI spec. Also, within OpenAPI spec, only `schema` object
        # is supported.
        # @!attribute [r] schema
        #   @return [::Google::Cloud::ApiHub::V1::Schema]
        #     Output only. The value of a schema definition.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the definition.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
        # @!attribute [r] spec
        #   @return [::String]
        #     Output only. The name of the spec from where the definition was parsed.
        #     Format is
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        # @!attribute [r] type
        #   @return [::Google::Cloud::ApiHub::V1::Definition::Type]
        #     Output only. The type of the definition.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the definition was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the definition was last updated.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the
        #     definition resource. The key is the attribute name. It will be of the
        #     format: `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        class Definition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enumeration of definition types.
          module Type
            # Definition type unspecified.
            TYPE_UNSPECIFIED = 0

            # Definition type schema.
            SCHEMA = 1
          end
        end

        # An attribute in the API Hub.
        # An attribute is a name value pair which can be attached to different
        # resources in the API hub based on the scope of the attribute. Attributes can
        # either be pre-defined by the API Hub or created by users.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the attribute in the API Hub.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the attribute.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the attribute.
        # @!attribute [r] definition_type
        #   @return [::Google::Cloud::ApiHub::V1::Attribute::DefinitionType]
        #     Output only. The definition type of the attribute.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::ApiHub::V1::Attribute::Scope]
        #     Required. The scope of the attribute. It represents the resource in the API
        #     Hub to which the attribute can be linked.
        # @!attribute [rw] data_type
        #   @return [::Google::Cloud::ApiHub::V1::Attribute::DataType]
        #     Required. The type of the data of the attribute.
        # @!attribute [rw] allowed_values
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Attribute::AllowedValue>]
        #     Optional. The list of allowed values when the attribute value is of type
        #     enum. This is required when the data_type of the attribute is ENUM. The
        #     maximum number of allowed values of an attribute will be 1000.
        # @!attribute [rw] cardinality
        #   @return [::Integer]
        #     Optional. The maximum number of values that the attribute can have when
        #     associated with an API Hub resource. Cardinality 1 would represent a
        #     single-valued attribute. It must not be less than 1 or greater than 20. If
        #     not specified, the cardinality would be set to 1 by default and represent a
        #     single-valued attribute.
        # @!attribute [r] mandatory
        #   @return [::Boolean]
        #     Output only. When mandatory is true, the attribute is mandatory for the
        #     resource specified in the scope. Only System defined attributes can be
        #     mandatory.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the attribute was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the attribute was last updated.
        class Attribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The value that can be assigned to the attribute when the data type is
          # enum.
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. The ID of the allowed value.
          #     * If provided, the same will be used. The service will throw an error if
          #     the specified id is already used by another allowed value in the same
          #     attribute resource.
          #     * If not provided, a system generated id derived from the display name
          #     will be used. In this case, the service will handle conflict resolution
          #     by adding a system generated suffix in case of duplicates.
          #
          #     This value should be 4-63 characters, and valid characters
          #     are /[a-z][0-9]-/.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. The display name of the allowed value.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. The detailed description of the allowed value.
          # @!attribute [rw] immutable
          #   @return [::Boolean]
          #     Optional. When set to true, the allowed value cannot be updated or
          #     deleted by the user. It can only be true for System defined attributes.
          class AllowedValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enumeration of attribute definition types.
          module DefinitionType
            # Attribute definition type unspecified.
            DEFINITION_TYPE_UNSPECIFIED = 0

            # The attribute is predefined by the API Hub. Note that only the list of
            # allowed values can be updated in this case via UpdateAttribute method.
            SYSTEM_DEFINED = 1

            # The attribute is defined by the user.
            USER_DEFINED = 2
          end

          # Enumeration for the scope of the attribute representing the resource in the
          # API Hub to which the attribute can be linked.
          module Scope
            # Scope Unspecified.
            SCOPE_UNSPECIFIED = 0

            # Attribute can be linked to an API.
            API = 1

            # Attribute can be linked to an API version.
            VERSION = 2

            # Attribute can be linked to a Spec.
            SPEC = 3

            # Attribute can be linked to an API Operation.
            API_OPERATION = 4

            # Attribute can be linked to a Deployment.
            DEPLOYMENT = 5

            # Attribute can be linked to a Dependency.
            DEPENDENCY = 6

            # Attribute can be linked to a definition.
            DEFINITION = 7

            # Attribute can be linked to a ExternalAPI.
            EXTERNAL_API = 8

            # Attribute can be linked to a Plugin.
            PLUGIN = 9
          end

          # Enumeration of attribute's data type.
          module DataType
            # Attribute data type unspecified.
            DATA_TYPE_UNSPECIFIED = 0

            # Attribute's value is of type enum.
            ENUM = 1

            # Attribute's value is of type json.
            JSON = 2

            # Attribute's value is of type string.
            STRING = 3

            # Attribute's value is of type uri.
            URI = 4
          end
        end

        # The spec contents.
        # @!attribute [rw] contents
        #   @return [::String]
        #     Required. The contents of the spec.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The mime type of the content for example application/json,
        #     application/yaml, application/wsdl etc.
        class SpecContents
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SpecDetails contains the details parsed from supported
        # spec types.
        # @!attribute [r] open_api_spec_details
        #   @return [::Google::Cloud::ApiHub::V1::OpenApiSpecDetails]
        #     Output only. Additional details apart from `OperationDetails` parsed from
        #     an OpenAPI spec. The OperationDetails parsed from the spec can be
        #     obtained by using
        #     {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_api_operations ListAPIOperations}
        #     method.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. The description of the spec.
        class SpecDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # OpenApiSpecDetails contains the details parsed from an OpenAPI spec in
        # addition to the fields mentioned in
        # {::Google::Cloud::ApiHub::V1::SpecDetails SpecDetails}.
        # @!attribute [r] format
        #   @return [::Google::Cloud::ApiHub::V1::OpenApiSpecDetails::Format]
        #     Output only. The format of the spec.
        # @!attribute [r] version
        #   @return [::String]
        #     Output only. The version in the spec.
        #     This maps to `info.version` in OpenAPI spec.
        # @!attribute [r] owner
        #   @return [::Google::Cloud::ApiHub::V1::Owner]
        #     Output only. Owner details for the spec.
        #     This maps to `info.contact` in OpenAPI spec.
        class OpenApiSpecDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumeration of spec formats.
          module Format
            # SpecFile type unspecified.
            FORMAT_UNSPECIFIED = 0

            # OpenAPI Spec v2.0.
            OPEN_API_SPEC_2_0 = 1

            # OpenAPI Spec v3.0.
            OPEN_API_SPEC_3_0 = 2

            # OpenAPI Spec v3.1.
            OPEN_API_SPEC_3_1 = 3
          end
        end

        # The operation details parsed from the spec.
        # @!attribute [rw] http_operation
        #   @return [::Google::Cloud::ApiHub::V1::HttpOperation]
        #     The HTTP Operation.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the operation behavior.
        #     For OpenAPI spec, this will map to `operation.description` in the
        #     spec, in case description is empty, `operation.summary` will be used.
        # @!attribute [rw] documentation
        #   @return [::Google::Cloud::ApiHub::V1::Documentation]
        #     Optional. Additional external documentation for this operation.
        #     For OpenAPI spec, this will map to `operation.documentation` in the spec.
        # @!attribute [rw] deprecated
        #   @return [::Boolean]
        #     Optional. For OpenAPI spec, this will be set if `operation.deprecated`is
        #     marked as `true` in the spec.
        class OperationDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The HTTP Operation.
        # @!attribute [rw] path
        #   @return [::Google::Cloud::ApiHub::V1::Path]
        #     Optional. The path details for the Operation.
        #     Note: Even though this field is optional, it is required for
        #     {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api_operation CreateApiOperation}
        #     API and we will fail the request if not provided.
        # @!attribute [rw] method
        #   @return [::Google::Cloud::ApiHub::V1::HttpOperation::Method]
        #     Optional. Operation method
        #     Note: Even though this field is optional, it is required for
        #     {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api_operation CreateApiOperation}
        #     API and we will fail the request if not provided.
        class HttpOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumeration of Method types.
          module Method
            # Method unspecified.
            METHOD_UNSPECIFIED = 0

            # Get Operation type.
            GET = 1

            # Put Operation type.
            PUT = 2

            # Post Operation type.
            POST = 3

            # Delete Operation type.
            DELETE = 4

            # Options Operation type.
            OPTIONS = 5

            # Head Operation type.
            HEAD = 6

            # Patch Operation type.
            PATCH = 7

            # Trace Operation type.
            TRACE = 8
          end
        end

        # The path details derived from the spec.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. Complete path relative to server endpoint.
        #     Note: Even though this field is optional, it is required for
        #     {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api_operation CreateApiOperation}
        #     API and we will fail the request if not provided.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A short description for the path applicable to all operations.
        class Path
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The schema details derived from the spec. Currently, this entity is supported
        # for OpenAPI spec only.
        # For OpenAPI spec, this maps to the schema defined in
        # the  `definitions` section for OpenAPI 2.0 version and in
        # `components.schemas` section for OpenAPI 3.0 and 3.1 version.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the schema.
        #     This will map to the name of the schema in the spec.
        # @!attribute [r] raw_value
        #   @return [::String]
        #     Output only. The raw value of the schema definition corresponding to the
        #     schema name in the spec.
        class Schema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Owner details.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The name of the owner.
        # @!attribute [rw] email
        #   @return [::String]
        #     Required. The email of the owner.
        class Owner
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Documentation details.
        # @!attribute [rw] external_uri
        #   @return [::String]
        #     Optional. The uri of the externally hosted documentation.
        class Documentation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The attribute values associated with resource.
        # @!attribute [rw] enum_values
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues::EnumAttributeValues]
        #     The attribute values associated with a resource in case attribute data
        #     type is enum.
        #
        #     Note: The following fields are mutually exclusive: `enum_values`, `string_values`, `json_values`, `uri_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_values
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues::StringAttributeValues]
        #     The attribute values associated with a resource in case attribute data
        #     type is string.
        #
        #     Note: The following fields are mutually exclusive: `string_values`, `enum_values`, `json_values`, `uri_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] json_values
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues::StringAttributeValues]
        #     The attribute values associated with a resource in case attribute data
        #     type is JSON.
        #
        #     Note: The following fields are mutually exclusive: `json_values`, `enum_values`, `string_values`, `uri_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] uri_values
        #   @return [::Google::Cloud::ApiHub::V1::AttributeValues::StringAttributeValues]
        #     The attribute values associated with a resource in case attribute data
        #     type is URL, URI or IP, like gs://bucket-name/object-name.
        #
        #     Note: The following fields are mutually exclusive: `uri_values`, `enum_values`, `string_values`, `json_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] attribute
        #   @return [::String]
        #     Output only. The name of the attribute.
        #     Format: projects/\\{project}/locations/\\{location}/attributes/\\{attribute}
        class AttributeValues
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The attribute values of data type enum.
          # @!attribute [rw] values
          #   @return [::Array<::Google::Cloud::ApiHub::V1::Attribute::AllowedValue>]
          #     Required. The attribute values in case attribute data type is enum.
          class EnumAttributeValues
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The attribute values of data type string or JSON.
          # @!attribute [rw] values
          #   @return [::Array<::String>]
          #     Required. The attribute values in case attribute data type is string or
          #     JSON.
          class StringAttributeValues
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A dependency resource defined in the API hub describes a dependency directed
        # from a consumer to a supplier entity. A dependency can be defined between two
        # {::Google::Cloud::ApiHub::V1::ApiOperation Operations} or between
        # an {::Google::Cloud::ApiHub::V1::ApiOperation Operation} and [External
        # API][google.cloud.apihub.v1.ExternalApi].
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the dependency in the API Hub.
        #
        #     Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
        # @!attribute [rw] consumer
        #   @return [::Google::Cloud::ApiHub::V1::DependencyEntityReference]
        #     Required. Immutable. The entity acting as the consumer in the dependency.
        # @!attribute [rw] supplier
        #   @return [::Google::Cloud::ApiHub::V1::DependencyEntityReference]
        #     Required. Immutable. The entity acting as the supplier in the dependency.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ApiHub::V1::Dependency::State]
        #     Output only. State of the dependency.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human readable description corresponding of the dependency.
        # @!attribute [r] discovery_mode
        #   @return [::Google::Cloud::ApiHub::V1::Dependency::DiscoveryMode]
        #     Output only. Discovery mode of the dependency.
        # @!attribute [r] error_detail
        #   @return [::Google::Cloud::ApiHub::V1::DependencyErrorDetail]
        #     Output only. Error details of a dependency if the system has detected it
        #     internally.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the dependency was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the dependency was last updated.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the
        #     dependency resource. The key is the attribute name. It will be of the
        #     format: `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        class Dependency
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states for a dependency.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # Dependency will be in a proposed state when it is newly identified by the
            # API hub on its own.
            PROPOSED = 1

            # Dependency will be in a validated state when it is validated by the
            # admin or manually created in the API hub.
            VALIDATED = 2
          end

          # Possible modes of discovering the dependency.
          module DiscoveryMode
            # Default value. This value is unused.
            DISCOVERY_MODE_UNSPECIFIED = 0

            # Manual mode of discovery when the dependency is defined by the user.
            MANUAL = 1
          end
        end

        # Reference to an entity participating in a dependency.
        # @!attribute [rw] operation_resource_name
        #   @return [::String]
        #     The resource name of an operation in the API Hub.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
        #
        #     Note: The following fields are mutually exclusive: `operation_resource_name`, `external_api_resource_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] external_api_resource_name
        #   @return [::String]
        #     The resource name of an external API in the API Hub.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/externalApis/{external_api}`
        #
        #     Note: The following fields are mutually exclusive: `external_api_resource_name`, `operation_resource_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name of the entity.
        class DependencyEntityReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details describing error condition of a dependency.
        # @!attribute [rw] error
        #   @return [::Google::Cloud::ApiHub::V1::DependencyErrorDetail::Error]
        #     Optional. Error in the dependency.
        # @!attribute [rw] error_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp at which the error was found.
        class DependencyErrorDetail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible values representing an error in the dependency.
          module Error
            # Default value used for no error in the dependency.
            ERROR_UNSPECIFIED = 0

            # Supplier entity has been deleted.
            SUPPLIER_NOT_FOUND = 1

            # Supplier entity has been recreated.
            SUPPLIER_RECREATED = 2
          end
        end

        # LintResponse contains the response from the linter.
        # @!attribute [rw] issues
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Issue>]
        #     Optional. Array of issues found in the analyzed document.
        # @!attribute [rw] summary
        #   @return [::Array<::Google::Cloud::ApiHub::V1::LintResponse::SummaryEntry>]
        #     Optional. Summary of all issue types and counts for each severity level.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::ApiHub::V1::LintState]
        #     Required. Lint state represents success or failure for linting.
        # @!attribute [rw] source
        #   @return [::String]
        #     Required. Name of the linting application.
        # @!attribute [rw] linter
        #   @return [::Google::Cloud::ApiHub::V1::Linter]
        #     Required. Name of the linter used.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. Timestamp when the linting response was generated.
        class LintResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Count of issues with a given severity.
          # @!attribute [rw] severity
          #   @return [::Google::Cloud::ApiHub::V1::Severity]
          #     Required. Severity of the issue.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     Required. Count of issues with the given severity.
          class SummaryEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Issue contains the details of a single issue found by the linter.
        # @!attribute [rw] code
        #   @return [::String]
        #     Required. Rule code unique to each rule defined in linter.
        # @!attribute [rw] path
        #   @return [::Array<::String>]
        #     Required. An array of strings indicating the location in the analyzed
        #     document where the rule was triggered.
        # @!attribute [rw] message
        #   @return [::String]
        #     Required. Human-readable message describing the issue found by the linter.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::ApiHub::V1::Severity]
        #     Required. Severity level of the rule violation.
        # @!attribute [rw] range
        #   @return [::Google::Cloud::ApiHub::V1::Range]
        #     Required. Object describing where in the file the issue was found.
        class Issue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Object describing where in the file the issue was found.
        # @!attribute [rw] start
        #   @return [::Google::Cloud::ApiHub::V1::Point]
        #     Required. Start of the issue.
        # @!attribute [rw] end
        #   @return [::Google::Cloud::ApiHub::V1::Point]
        #     Required. End of the issue.
        class Range
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Point within the file (line and character).
        # @!attribute [rw] line
        #   @return [::Integer]
        #     Required. Line number (zero-indexed).
        # @!attribute [rw] character
        #   @return [::Integer]
        #     Required. Character position within the line (zero-indexed).
        class Point
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have {::Google::Longrunning::Operation#error Operation.error} value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An ApiHubInstance represents the instance resources of the API Hub.
        # Currently, only one ApiHub instance is allowed for each project.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Format:
        #     `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update timestamp.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ApiHub::V1::ApiHubInstance::State]
        #     Output only. The current state of the ApiHub instance.
        # @!attribute [r] state_message
        #   @return [::String]
        #     Output only. Extra information about ApiHub instance state. Currently the
        #     message would be populated when state is `FAILED`.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::ApiHub::V1::ApiHubInstance::Config]
        #     Required. Config of the ApiHub instance.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Instance labels to represent user-provided metadata.
        #     Refer to cloud documentation on labels for more details.
        #     https://cloud.google.com/compute/docs/labeling-resources
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the ApiHub instance.
        class ApiHubInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Available configurations to provision an ApiHub Instance.
          # @!attribute [rw] cmek_key_name
          #   @return [::String]
          #     Optional. The Customer Managed Encryption Key (CMEK) used for data
          #     encryption. The CMEK name should follow the format of
          #     `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
          #     where the location must match the instance location.
          #     If the CMEK is not provided, a GMEK will be created for the instance.
          # @!attribute [rw] disable_search
          #   @return [::Boolean]
          #     Optional. If true, the search will be disabled for the instance. The
          #     default value is false.
          # @!attribute [rw] vertex_location
          #   @return [::String]
          #     Optional. The name of the Vertex AI location where the data store is
          #     stored.
          # @!attribute [rw] encryption_type
          #   @return [::Google::Cloud::ApiHub::V1::ApiHubInstance::Config::EncryptionType]
          #     Optional. Encryption type for the region. If the encryption type is CMEK,
          #     the cmek_key_name must be provided. If no encryption type is provided,
          #     GMEK will be used.
          class Config
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Types of data encryption.
            module EncryptionType
              # Encryption type unspecified.
              ENCRYPTION_TYPE_UNSPECIFIED = 0

              # Default encryption using Google managed encryption key.
              GMEK = 1

              # Encryption using customer managed encryption key.
              CMEK = 2
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of the ApiHub Instance.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The ApiHub instance has not been initialized or has been deleted.
            INACTIVE = 1

            # The ApiHub instance is being created.
            CREATING = 2

            # The ApiHub instance has been created and is ready for use.
            ACTIVE = 3

            # The ApiHub instance is being updated.
            UPDATING = 4

            # The ApiHub instance is being deleted.
            DELETING = 5

            # The ApiHub instance encountered an error during a state change.
            FAILED = 6
          end
        end

        # An external API represents an API being provided by external sources. This
        # can be used to model third-party APIs and can be used to define dependencies.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Format:
        #     `projects/{project}/locations/{location}/externalApi/{externalApi}`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the external API. Max length is 63 characters
        #     (Unicode Code Points).
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the external API. Max length is 2000 characters
        #     (Unicode Code Points).
        # @!attribute [rw] endpoints
        #   @return [::Array<::String>]
        #     Optional. List of endpoints on which this API is accessible.
        # @!attribute [rw] paths
        #   @return [::Array<::String>]
        #     Optional. List of paths served by this API.
        # @!attribute [rw] documentation
        #   @return [::Google::Cloud::ApiHub::V1::Documentation]
        #     Optional. Documentation of the external API.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::AttributeValues}]
        #     Optional. The list of user defined attributes associated with the Version
        #     resource. The key is the attribute name. It will be of the format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`.
        #     The value is the attribute values associated with the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update timestamp.
        class ExternalApi
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::AttributeValues]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # ConfigValueOption represents an option for a config variable of type enum or
        # multi select.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. Id of the option.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the option.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the option.
        class ConfigValueOption
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Secret provides a reference to entries in Secret Manager.
        # @!attribute [rw] secret_version
        #   @return [::String]
        #     Required. The resource name of the secret version in the format,
        #     format as: `projects/*/secrets/*/versions/*`.
        class Secret
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ConfigVariableTemplate represents a configuration variable template present
        # in a Plugin Config.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the config variable. Must be unique within the
        #     configuration.
        # @!attribute [rw] value_type
        #   @return [::Google::Cloud::ApiHub::V1::ConfigVariableTemplate::ValueType]
        #     Required. Type of the parameter: string, int, bool etc.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description.
        # @!attribute [rw] validation_regex
        #   @return [::String]
        #     Optional. Regular expression in RE2 syntax used for validating the `value`
        #     of a `ConfigVariable`.
        # @!attribute [rw] required
        #   @return [::Boolean]
        #     Optional. Flag represents that this `ConfigVariable` must be provided for a
        #     PluginInstance.
        # @!attribute [rw] enum_options
        #   @return [::Array<::Google::Cloud::ApiHub::V1::ConfigValueOption>]
        #     Optional. Enum options. To be populated if `ValueType` is `ENUM`.
        # @!attribute [rw] multi_select_options
        #   @return [::Array<::Google::Cloud::ApiHub::V1::ConfigValueOption>]
        #     Optional. Multi select options. To be populated if `ValueType` is
        #     `MULTI_SELECT`.
        class ConfigVariableTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # ValueType indicates the data type of the value.
          module ValueType
            # Value type is not specified.
            VALUE_TYPE_UNSPECIFIED = 0

            # Value type is string.
            STRING = 1

            # Value type is integer.
            INT = 2

            # Value type is boolean.
            BOOL = 3

            # Value type is secret.
            SECRET = 4

            # Value type is enum.
            ENUM = 5

            # Value type is multi select.
            MULTI_SELECT = 6

            # Value type is multi string.
            MULTI_STRING = 7

            # Value type is multi int.
            MULTI_INT = 8
          end
        end

        # ConfigVariable represents a additional configuration variable present in a
        # PluginInstance Config or AuthConfig, based on a ConfigVariableTemplate.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     Optional. The config variable value in case of config variable of type
        #     string.
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `int_value`, `bool_value`, `secret_value`, `enum_value`, `multi_select_values`, `multi_string_values`, `multi_int_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int_value
        #   @return [::Integer]
        #     Optional. The config variable value in case of config variable of type
        #     integer.
        #
        #     Note: The following fields are mutually exclusive: `int_value`, `string_value`, `bool_value`, `secret_value`, `enum_value`, `multi_select_values`, `multi_string_values`, `multi_int_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     Optional. The config variable value in case of config variable of type
        #     boolean.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `string_value`, `int_value`, `secret_value`, `enum_value`, `multi_select_values`, `multi_string_values`, `multi_int_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] secret_value
        #   @return [::Google::Cloud::ApiHub::V1::Secret]
        #     Optional. The config variable value in case of config variable of type
        #     secret.
        #
        #     Note: The following fields are mutually exclusive: `secret_value`, `string_value`, `int_value`, `bool_value`, `enum_value`, `multi_select_values`, `multi_string_values`, `multi_int_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] enum_value
        #   @return [::Google::Cloud::ApiHub::V1::ConfigValueOption]
        #     Optional. The config variable value in case of config variable of type
        #     enum.
        #
        #     Note: The following fields are mutually exclusive: `enum_value`, `string_value`, `int_value`, `bool_value`, `secret_value`, `multi_select_values`, `multi_string_values`, `multi_int_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] multi_select_values
        #   @return [::Google::Cloud::ApiHub::V1::ConfigVariable::MultiSelectValues]
        #     Optional. The config variable value in case of config variable of type
        #     multi select.
        #
        #     Note: The following fields are mutually exclusive: `multi_select_values`, `string_value`, `int_value`, `bool_value`, `secret_value`, `enum_value`, `multi_string_values`, `multi_int_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] multi_string_values
        #   @return [::Google::Cloud::ApiHub::V1::ConfigVariable::MultiStringValues]
        #     Optional. The config variable value in case of config variable of type
        #     multi string.
        #
        #     Note: The following fields are mutually exclusive: `multi_string_values`, `string_value`, `int_value`, `bool_value`, `secret_value`, `enum_value`, `multi_select_values`, `multi_int_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] multi_int_values
        #   @return [::Google::Cloud::ApiHub::V1::ConfigVariable::MultiIntValues]
        #     Optional. The config variable value in case of config variable of type
        #     multi integer.
        #
        #     Note: The following fields are mutually exclusive: `multi_int_values`, `string_value`, `int_value`, `bool_value`, `secret_value`, `enum_value`, `multi_select_values`, `multi_string_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] key
        #   @return [::String]
        #     Output only. Key will be the
        #     {::Google::Cloud::ApiHub::V1::ConfigVariableTemplate#id id} to uniquely identify
        #     the config variable.
        class ConfigVariable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The config variable value of data type multi select.
          # @!attribute [rw] values
          #   @return [::Array<::Google::Cloud::ApiHub::V1::ConfigValueOption>]
          #     Optional. The config variable value of data type multi select.
          class MultiSelectValues
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The config variable value of data type multi string.
          # @!attribute [rw] values
          #   @return [::Array<::String>]
          #     Optional. The config variable value of data type multi string.
          class MultiStringValues
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The config variable value of data type multi int.
          # @!attribute [rw] values
          #   @return [::Array<::Integer>]
          #     Optional. The config variable value of data type multi int.
          class MultiIntValues
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Config for Google service account authentication.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Required. The service account to be used for authenticating request.
        #
        #     The `iam.serviceAccounts.getAccessToken` permission should be granted on
        #     this service account to the impersonator service account.
        class GoogleServiceAccountConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AuthConfig represents the authentication information.
        # @!attribute [rw] google_service_account_config
        #   @return [::Google::Cloud::ApiHub::V1::GoogleServiceAccountConfig]
        #     Google Service Account.
        #
        #     Note: The following fields are mutually exclusive: `google_service_account_config`, `user_password_config`, `api_key_config`, `oauth2_client_credentials_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] user_password_config
        #   @return [::Google::Cloud::ApiHub::V1::AuthConfig::UserPasswordConfig]
        #     User Password.
        #
        #     Note: The following fields are mutually exclusive: `user_password_config`, `google_service_account_config`, `api_key_config`, `oauth2_client_credentials_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] api_key_config
        #   @return [::Google::Cloud::ApiHub::V1::AuthConfig::ApiKeyConfig]
        #     Api Key Config.
        #
        #     Note: The following fields are mutually exclusive: `api_key_config`, `google_service_account_config`, `user_password_config`, `oauth2_client_credentials_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oauth2_client_credentials_config
        #   @return [::Google::Cloud::ApiHub::V1::AuthConfig::Oauth2ClientCredentialsConfig]
        #     Oauth2.0 Client Credentials.
        #
        #     Note: The following fields are mutually exclusive: `oauth2_client_credentials_config`, `google_service_account_config`, `user_password_config`, `api_key_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] auth_type
        #   @return [::Google::Cloud::ApiHub::V1::AuthType]
        #     Required. The authentication type.
        class AuthConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Parameters to support Username and Password Authentication.
          # @!attribute [rw] username
          #   @return [::String]
          #     Required. Username.
          # @!attribute [rw] password
          #   @return [::Google::Cloud::ApiHub::V1::Secret]
          #     Required. Secret version reference containing the password.
          #     The `secretmanager.versions.access` permission should be
          #     granted to the service account accessing the secret.
          class UserPasswordConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Parameters to support Oauth 2.0 client credentials grant authentication.
          # See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     Required. The client identifier.
          # @!attribute [rw] client_secret
          #   @return [::Google::Cloud::ApiHub::V1::Secret]
          #     Required. Secret version reference containing the client secret.
          #     The `secretmanager.versions.access` permission should be
          #     granted to the service account accessing the secret.
          class Oauth2ClientCredentialsConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Config for authentication with API key.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The parameter name of the API key.
          #     E.g. If the API request is "https://example.com/act?api_key=<API KEY>",
          #     "api_key" would be the parameter name.
          # @!attribute [rw] api_key
          #   @return [::Google::Cloud::ApiHub::V1::Secret]
          #     Required. The name of the SecretManager secret version resource storing
          #     the API key. Format:
          #     `projects/{project}/secrets/{secrete}/versions/{version}`. The
          #     `secretmanager.versions.access` permission should be granted to the
          #     service account accessing the secret.
          # @!attribute [rw] http_element_location
          #   @return [::Google::Cloud::ApiHub::V1::AuthConfig::ApiKeyConfig::HttpElementLocation]
          #     Required. The location of the API key.
          #     The default value is QUERY.
          class ApiKeyConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum of location an HTTP element can be.
            module HttpElementLocation
              # HTTP element location not specified.
              HTTP_ELEMENT_LOCATION_UNSPECIFIED = 0

              # Element is in the HTTP request query.
              QUERY = 1

              # Element is in the HTTP request header.
              HEADER = 2

              # Element is in the HTTP request path.
              PATH = 3

              # Element is in the HTTP request body.
              BODY = 4

              # Element is in the HTTP request cookie.
              COOKIE = 5
            end
          end
        end

        # SourceMetadata represents the metadata for a resource at the source.
        # @!attribute [r] plugin_instance_action_source
        #   @return [::Google::Cloud::ApiHub::V1::SourceMetadata::PluginInstanceActionSource]
        #     Output only. The source of the resource is a plugin instance action.
        # @!attribute [r] source_type
        #   @return [::Google::Cloud::ApiHub::V1::SourceMetadata::SourceType]
        #     Output only. The type of the source.
        # @!attribute [r] original_resource_id
        #   @return [::String]
        #     Output only. The unique identifier of the resource at the source.
        # @!attribute [r] original_resource_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the resource was created at the source.
        # @!attribute [r] original_resource_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the resource was last updated at the source.
        class SourceMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # PluginInstanceActionSource represents the plugin instance action source.
          # @!attribute [r] plugin_instance
          #   @return [::String]
          #     Output only. The resource name of the source plugin instance.
          #     Format is
          #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`
          # @!attribute [r] action_id
          #   @return [::String]
          #     Output only. The id of the plugin instance action.
          class PluginInstanceActionSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible types of the source.
          module SourceType
            # Source type not specified.
            SOURCE_TYPE_UNSPECIFIED = 0

            # Source type plugin.
            PLUGIN = 1
          end
        end

        # Respresents an API Observation observed in one of the sources.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the discovered API Observation.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/discoveredApiObservations/{discovered_api_observation}`
        # @!attribute [rw] style
        #   @return [::Google::Cloud::ApiHub::V1::DiscoveredApiObservation::Style]
        #     Optional. Style of ApiObservation
        # @!attribute [rw] server_ips
        #   @return [::Array<::String>]
        #     Optional. The IP address (IPv4 or IPv6) of the origin server that the
        #     request was sent to. This field can include port information. Examples:
        #     `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Optional. The hostname of requests processed for this Observation.
        # @!attribute [rw] last_event_detected_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Last event detected time stamp
        # @!attribute [rw] source_locations
        #   @return [::Array<::String>]
        #     Optional. The location of the observation source.
        # @!attribute [rw] api_operation_count
        #   @return [::Integer]
        #     Optional. The number of observed API Operations.
        # @!attribute [rw] origin
        #   @return [::String]
        #     Optional. For an observation pushed from a gcp resource, this would be the
        #     gcp project id.
        # @!attribute [rw] source_types
        #   @return [::Array<::Google::Cloud::ApiHub::V1::DiscoveredApiObservation::SourceType>]
        #     Optional. The type of the source from which the observation was collected.
        # @!attribute [r] known_operations_count
        #   @return [::Integer]
        #     Output only. The number of known API Operations.
        # @!attribute [r] unknown_operations_count
        #   @return [::Integer]
        #     Output only. The number of unknown API Operations.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp of the observation in API Hub.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp of the observation in API Hub.
        # @!attribute [r] source_metadata
        #   @return [::Google::Cloud::ApiHub::V1::SourceMetadata]
        #     Output only. The metadata of the source from which the observation was
        #     collected.
        class DiscoveredApiObservation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # DiscoveredApiObservation protocol style
          module Style
            # Unknown style
            STYLE_UNSPECIFIED = 0

            # Style is Rest API
            REST = 1

            # Style is Grpc API
            GRPC = 2

            # Style is GraphQL API
            GRAPHQL = 3
          end

          # The possible types of the source from which the observation was collected.
          module SourceType
            # Source type not specified.
            SOURCE_TYPE_UNSPECIFIED = 0

            # GCP external load balancer.
            GCP_XLB = 1

            # GCP internal load balancer.
            GCP_ILB = 2
          end
        end

        # DiscoveredApiOperation represents an API Operation observed in one of the
        # sources.
        # @!attribute [rw] http_operation
        #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails]
        #     Optional. An HTTP Operation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the discovered API Operation.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/discoveredApiObservations/{discovered_api_observation}/discoveredApiOperations/{discovered_api_operation}`
        # @!attribute [rw] first_seen_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. First seen time stamp
        # @!attribute [rw] last_seen_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Last seen time stamp
        # @!attribute [rw] count
        #   @return [::Integer]
        #     Optional. The number of occurrences of this API Operation.
        # @!attribute [r] classification
        #   @return [::Google::Cloud::ApiHub::V1::DiscoveredApiOperation::Classification]
        #     Output only. The classification of the discovered API operation.
        # @!attribute [r] match_results
        #   @return [::Array<::Google::Cloud::ApiHub::V1::DiscoveredApiOperation::MatchResult>]
        #     Output only. The list of matched results for the discovered API operation.
        #     This will be populated only if the classification is known. The current
        #     usecase is for a single match. Keeping it repeated to support multiple
        #     matches in future.
        # @!attribute [r] source_metadata
        #   @return [::Google::Cloud::ApiHub::V1::SourceMetadata]
        #     Output only. The metadata of the source from which the api operation was
        #     collected.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp of the discovered API operation in API Hub.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp of the discovered API operation in API Hub.
        class DiscoveredApiOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # MatchResult represents the result of matching a discovered API operation
          # with a catalog API operation.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The name of the matched API Operation.
          #
          #     Format:
          #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
          class MatchResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The classification of the discovered API operation.
          module Classification
            # Operation is not classified as known or unknown.
            CLASSIFICATION_UNSPECIFIED = 0

            # Operation has a matched catalog operation.
            KNOWN = 1

            # Operation does not have a matched catalog operation.
            UNKNOWN = 2
          end
        end

        # An HTTP-based API Operation, sometimes called a "REST" Operation.
        # @!attribute [rw] http_operation
        #   @return [::Google::Cloud::ApiHub::V1::HttpOperation]
        #     Required. An HTTP Operation.
        # @!attribute [rw] path_params
        #   @return [::Array<::Google::Cloud::ApiHub::V1::HttpOperationDetails::PathParam>]
        #     Optional. Path params of HttpOperation
        # @!attribute [rw] query_params
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::HttpOperationDetails::QueryParam}]
        #     Optional. Query params of HttpOperation
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::HttpRequest]
        #     Optional. Request metadata.
        # @!attribute [rw] response
        #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::HttpResponse]
        #     Optional. Response metadata.
        class HttpOperationDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # HTTP Path parameter.
          # @!attribute [rw] position
          #   @return [::Integer]
          #     Optional. Segment location in the path, 1-indexed
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::DataType]
          #     Optional. Data type of path param
          class PathParam
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An aggregation of HTTP query parameter occurrences.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of query param
          # @!attribute [rw] count
          #   @return [::Integer]
          #     Optional. The number of occurrences of this query parameter across
          #     transactions.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::DataType]
          #     Optional. Data type of path param
          class QueryParam
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An aggregation of HTTP header occurrences.
          # @!attribute [rw] name
          #   @return [::String]
          #     Header name.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     The number of occurrences of this Header across transactions.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::DataType]
          #     Data type of header
          class Header
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An aggregation of HTTP requests.
          # @!attribute [rw] headers
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::HttpOperationDetails::Header}]
          #     Optional. Unordered map from header name to header metadata
          class HttpRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::Header]
            class HeadersEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # An aggregation of HTTP responses.
          # @!attribute [rw] headers
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ApiHub::V1::HttpOperationDetails::Header}]
          #     Optional. Unordered map from header name to header metadata
          # @!attribute [rw] response_codes
          #   @return [::Google::Protobuf::Map{::Integer => ::Integer}]
          #     Optional. Map of status code to observed count
          class HttpResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::Header]
            class HeadersEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::Integer]
            # @!attribute [rw] value
            #   @return [::Integer]
            class ResponseCodesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ApiHub::V1::HttpOperationDetails::QueryParam]
          class QueryParamsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Type of data
          module DataType
            # Unspecified data type
            DATA_TYPE_UNSPECIFIED = 0

            # Boolean data type
            BOOL = 1

            # Integer data type
            INTEGER = 2

            # Float data type
            FLOAT = 3

            # String data type
            STRING = 4

            # UUID data type
            UUID = 5
          end
        end

        # Lint state represents success or failure for linting.
        module LintState
          # Lint state unspecified.
          LINT_STATE_UNSPECIFIED = 0

          # Linting was completed successfully.
          LINT_STATE_SUCCESS = 1

          # Linting encountered errors.
          LINT_STATE_ERROR = 2
        end

        # Enumeration of linter types.
        module Linter
          # Linter type unspecified.
          LINTER_UNSPECIFIED = 0

          # Linter type spectral.
          SPECTRAL = 1

          # Linter type other.
          OTHER = 2
        end

        # Severity of the issue.
        module Severity
          # Severity unspecified.
          SEVERITY_UNSPECIFIED = 0

          # Severity error.
          SEVERITY_ERROR = 1

          # Severity warning.
          SEVERITY_WARNING = 2

          # Severity info.
          SEVERITY_INFO = 3

          # Severity hint.
          SEVERITY_HINT = 4
        end

        # AuthType represents the authentication type.
        module AuthType
          # Authentication type not specified.
          AUTH_TYPE_UNSPECIFIED = 0

          # No authentication.
          NO_AUTH = 1

          # Google service account authentication.
          GOOGLE_SERVICE_ACCOUNT = 2

          # Username and password authentication.
          USER_PASSWORD = 3

          # API Key authentication.
          API_KEY = 4

          # Oauth 2.0 client credentials grant authentication.
          OAUTH2_CLIENT_CREDENTIALS = 5
        end

        # Enum for the plugin category.
        module PluginCategory
          # Default unspecified plugin type.
          PLUGIN_CATEGORY_UNSPECIFIED = 0

          # API_GATEWAY plugins represent plugins built for API Gateways like Apigee.
          API_GATEWAY = 1

          # API_PRODUCER plugins represent plugins built for API Producers like
          # Cloud Run, Application Integration etc.
          API_PRODUCER = 2
        end
      end
    end
  end
end
