# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # The CollectApiData method's request.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The regional location of the API hub instance and its resources.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] collection_type
        #   @return [::Google::Cloud::ApiHub::V1::CollectionType]
        #     Required. The type of collection. Applies to all entries in
        #     {::Google::Cloud::ApiHub::V1::CollectApiDataRequest#api_data api_data}.
        # @!attribute [rw] plugin_instance
        #   @return [::String]
        #     Required. The plugin instance collecting the API data.
        #     Format:
        #     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}`.
        # @!attribute [rw] action_id
        #   @return [::String]
        #     Required. The action ID to be used for collecting the API data.
        #     This should map to one of the action IDs specified
        #     in action configs in the plugin.
        # @!attribute [rw] api_data
        #   @return [::Google::Cloud::ApiHub::V1::ApiData]
        #     Required. The API data to be collected.
        class CollectApiDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The API data to be collected.
        # @!attribute [rw] api_metadata_list
        #   @return [::Google::Cloud::ApiHub::V1::ApiMetadataList]
        #     Optional. The list of API metadata.
        class ApiData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message to hold repeated API metadata.
        # @!attribute [rw] api_metadata
        #   @return [::Array<::Google::Cloud::ApiHub::V1::APIMetadata>]
        #     Required. The list of API metadata.
        class ApiMetadataList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The API metadata.
        # @!attribute [rw] api
        #   @return [::Google::Cloud::ApiHub::V1::Api]
        #     Required. The API resource to be pushed to Hub's collect layer. The ID of
        #     the API resource will be generated by Hub to ensure uniqueness across all
        #     APIs across systems.
        # @!attribute [rw] versions
        #   @return [::Array<::Google::Cloud::ApiHub::V1::VersionMetadata>]
        #     Optional. The list of versions present in an API resource.
        # @!attribute [rw] original_id
        #   @return [::String]
        #     Optional. The unique identifier of the API in the system where it was
        #     originally created.
        # @!attribute [rw] original_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp indicating when the API was created at the source.
        # @!attribute [rw] original_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. Timestamp indicating when the API was last updated at the source.
        class APIMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata associated with a version of the API resource.
        # @!attribute [rw] version
        #   @return [::Google::Cloud::ApiHub::V1::Version]
        #     Required. Represents a version of the API resource in API hub. The ID of
        #     the version will be generated by Hub.
        # @!attribute [rw] specs
        #   @return [::Array<::Google::Cloud::ApiHub::V1::SpecMetadata>]
        #     Optional. The specs associated with this version.
        #     Note that an API version can be associated with multiple specs.
        # @!attribute [rw] deployments
        #   @return [::Array<::Google::Cloud::ApiHub::V1::DeploymentMetadata>]
        #     Optional. The deployments linked to this API version.
        #     Note: A particular API version could be deployed to multiple deployments
        #     (for dev deployment, UAT deployment, etc.)
        # @!attribute [rw] original_id
        #   @return [::String]
        #     Optional. The unique identifier of the version in the system where it was
        #     originally created.
        # @!attribute [rw] original_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp indicating when the version was created at the source.
        # @!attribute [rw] original_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. Timestamp indicating when the version was last updated at the
        #     source.
        class VersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata associated with a spec of the API version.
        # @!attribute [rw] spec
        #   @return [::Google::Cloud::ApiHub::V1::Spec]
        #     Required. The spec resource to be pushed to Hub's collect layer. The ID of
        #     the spec will be generated by Hub.
        # @!attribute [rw] original_id
        #   @return [::String]
        #     Optional. The unique identifier of the spec in the system where it was
        #     originally created.
        # @!attribute [rw] original_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp indicating when the spec was created at the source.
        # @!attribute [rw] original_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. Timestamp indicating when the spec was last updated at the
        #     source.
        class SpecMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata associated with a deployment.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::ApiHub::V1::Deployment]
        #     Required. The deployment resource to be pushed to Hub's collect layer. The
        #     ID of the deployment will be generated by Hub.
        # @!attribute [rw] original_id
        #   @return [::String]
        #     Optional. The unique identifier of the deployment in the system where it
        #     was originally created.
        # @!attribute [rw] original_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp indicating when the deployment was created at the
        #     source.
        # @!attribute [rw] original_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. Timestamp indicating when the deployment was last updated at the
        #     source.
        class DeploymentMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The CollectApiData method's response.
        class CollectApiDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The type of the collect request.
        module CollectionType
          # The default value. This value is used if the collection type is omitted.
          COLLECTION_TYPE_UNSPECIFIED = 0

          # The collection type is upsert. This should be used when an API is created
          # or updated at the source.
          COLLECTION_TYPE_UPSERT = 1

          # The collection type is delete. This should be used when an API is deleted
          # at the source.
          COLLECTION_TYPE_DELETE = 2
        end
      end
    end
  end
end
