# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api CreateApi} method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the API resource.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] api_id
        #   @return [::String]
        #     Optional. The ID to use for the API resource, which will become the final
        #     component of the API's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another API resource in the API hub.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, and valid characters
        #     are /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] api
        #   @return [::Google::Cloud::ApiHub::V1::Api]
        #     Required. The API resource to create.
        class CreateApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_api GetApi} method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the API resource to retrieve.
        #     Format: `projects/{project}/locations/{location}/apis/{api}`
        class GetApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_api UpdateApi} method's request.
        # @!attribute [rw] api
        #   @return [::Google::Cloud::ApiHub::V1::Api]
        #     Required. The API resource to update.
        #
        #     The API resource's `name` field is used to identify the API resource to
        #     update.
        #     Format: `projects/{project}/locations/{location}/apis/{api}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#delete_api DeleteApi} method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the API resource to delete.
        #     Format: `projects/{project}/locations/{location}/apis/{api}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any versions from this API will also be deleted.
        #     Otherwise, the request will only work if the API has no versions.
        class DeleteApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_apis ListApis} method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of API resources.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of ApiResources.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. The
        #     comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are not
        #     case sensitive.
        #
        #     The following fields in the `ApiResource` are eligible for filtering:
        #
        #       * `owner.email` - The email of the team which owns the ApiResource.
        #       Allowed comparison operators: `=`.
        #       * `create_time` - The time at which the ApiResource was created. The
        #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
        #       format. Allowed comparison operators: `>` and `<`.
        #       * `display_name` - The display name of the ApiResource. Allowed
        #       comparison operators: `=`.
        #       * `target_user.enum_values.values.id` - The allowed value id of the
        #       target users attribute associated with the ApiResource. Allowed
        #       comparison operator is `:`.
        #       * `target_user.enum_values.values.display_name` - The allowed value
        #       display name of the target users attribute associated with the
        #       ApiResource. Allowed comparison operator is `:`.
        #       * `team.enum_values.values.id` - The allowed value id of the team
        #       attribute associated with the ApiResource. Allowed comparison operator is
        #       `:`.
        #       * `team.enum_values.values.display_name` - The allowed value display name
        #       of the team attribute associated with the ApiResource. Allowed comparison
        #       operator is `:`.
        #       * `business_unit.enum_values.values.id` - The allowed value id of the
        #       business unit attribute associated with the ApiResource. Allowed
        #       comparison operator is `:`.
        #       * `business_unit.enum_values.values.display_name` - The allowed value
        #       display name of the business unit attribute associated with the
        #       ApiResource. Allowed comparison operator is `:`.
        #       * `maturity_level.enum_values.values.id` - The allowed value id of the
        #       maturity level attribute associated with the ApiResource. Allowed
        #       comparison operator is `:`.
        #       * `maturity_level.enum_values.values.display_name` - The allowed value
        #       display name of the maturity level attribute associated with the
        #       ApiResource. Allowed comparison operator is `:`.
        #       * `api_style.enum_values.values.id` - The allowed value id of the
        #       api style attribute associated with the ApiResource. Allowed
        #       comparison operator is `:`.
        #       * `api_style.enum_values.values.display_name` - The allowed value display
        #       name of the api style attribute associated with the ApiResource. Allowed
        #       comparison operator is `:`.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.id` - The
        #       allowed value id of the user defined enum attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-id is a placeholder that can be replaced with
        #       any user defined enum attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.display_name`
        #       - The allowed value display name of the user defined enum attribute
        #       associated with the Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-display-name is a placeholder that can be
        #       replaced with any user defined enum attribute enum name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.string_values.values` - The
        #       allowed value of the user defined string attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-string is a placeholder that can be replaced with
        #       any user defined string attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.json_values.values` - The
        #       allowed value of the user defined JSON attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-json is a placeholder that can be replaced with
        #       any user defined JSON attribute name.
        #
        #     A filter function is also supported in the filter string. The filter
        #     function is `id(name)`. The `id(name)` function returns the id of the
        #     resource name. For example, `id(name) = \"api-1\"` is equivalent to
        #     `name = \"projects/test-project-id/locations/test-location-id/apis/api-1\"`
        #     provided the parent is
        #     `projects/test-project-id/locations/test-location-id`.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are supported. At most
        #     three filter fields are allowed in the filter string and if provided
        #     more than that then `INVALID_ARGUMENT` error is returned by the API.
        #
        #     Here are a few examples:
        #
        #       * `owner.email = \"apihub@google.com\"` -  - The owner team email is
        #       _apihub@google.com_.
        #       * `owner.email = \"apihub@google.com\" AND create_time <
        #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
        #       The owner team email is _apihub@google.com_ and the api was created
        #       before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
        #       * `owner.email = \"apihub@google.com\" OR team.enum_values.values.id:
        #       apihub-team-id` - The filter string specifies the APIs where the owner
        #       team email is _apihub@google.com_ or the id of the allowed value
        #       associated with the team attribute is _apihub-team-id_.
        #       * `owner.email = \"apihub@google.com\" OR
        #       team.enum_values.values.display_name: ApiHub Team` - The filter string
        #       specifies the APIs where the owner team email is _apihub@google.com_ or
        #       the display name of the allowed value associated with the team attribute
        #       is `ApiHub Team`.
        #       * `owner.email = \"apihub@google.com\" AND
        #       attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.enum_values.values.id:
        #       test_enum_id AND
        #       attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/1765\0f90-4a29-5431-b3d0-d5532da3764c.string_values.values:
        #       test_string_value`  - The filter string specifies the APIs where the
        #       owner team email is _apihub@google.com_ and the id of the allowed value
        #       associated with the user defined attribute of type enum is _test_enum_id_
        #       and the value of the user defined attribute of type string is _test_..
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of API resources to return. The service may
        #     return fewer than this value. If unspecified, at most 50 Apis will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListApis` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListApis` must match the call that provided the page token.
        class ListApisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_apis ListApis} method's response.
        # @!attribute [rw] apis
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Api>]
        #     The API resources present in the API hub.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApisResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_version CreateVersion} method's
        # request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for API version.
        #     Format: `projects/{project}/locations/{location}/apis/{api}`
        # @!attribute [rw] version_id
        #   @return [::String]
        #     Optional. The ID to use for the API version, which will become the final
        #     component of the version's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another version in the API resource.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, overall resource name which will be
        #     of format
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`,
        #     its length is limited to 700 characters and valid characters are
        #     /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] version
        #   @return [::Google::Cloud::ApiHub::V1::Version]
        #     Required. The version to create.
        class CreateVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_version GetVersion} method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the API version to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        class GetVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_version UpdateVersion} method's
        # request.
        # @!attribute [rw] version
        #   @return [::Google::Cloud::ApiHub::V1::Version]
        #     Required. The API version to update.
        #
        #     The version's `name` field is used to identify the API version to update.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#delete_version DeleteVersion} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the version to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any specs from this version will also be deleted.
        #     Otherwise, the request will only work if the version has no specs.
        class DeleteVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_versions ListVersions} method's
        # request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of API versions i.e., the
        #     API resource Format: `projects/{project}/locations/{location}/apis/{api}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of Versions.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string, a
        #     number, or a boolean. The comparison operator must be one of: `<`, `>` or
        #     `=`. Filters are not case sensitive.
        #
        #     The following fields in the `Version` are eligible for filtering:
        #
        #       * `display_name` - The display name of the Version. Allowed
        #       comparison operators: `=`.
        #       * `create_time` - The time at which the Version was created. The
        #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
        #       format. Allowed comparison operators: `>` and `<`.
        #       * `lifecycle.enum_values.values.id` - The allowed value id of the
        #       lifecycle attribute associated with the Version. Allowed comparison
        #       operators: `:`.
        #       * `lifecycle.enum_values.values.display_name` - The allowed value display
        #       name of the lifecycle attribute associated with the Version. Allowed
        #       comparison operators: `:`.
        #       * `compliance.enum_values.values.id` -  The allowed value id of the
        #       compliances attribute associated with the Version. Allowed comparison
        #       operators: `:`.
        #       * `compliance.enum_values.values.display_name` -  The allowed value
        #       display name of the compliances attribute associated with the Version.
        #       Allowed comparison operators: `:`.
        #       * `accreditation.enum_values.values.id` - The allowed value id of the
        #       accreditations attribute associated with the Version. Allowed
        #       comparison operators: `:`.
        #       * `accreditation.enum_values.values.display_name` - The allowed value
        #       display name of the accreditations attribute associated with the Version.
        #       Allowed comparison operators: `:`.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.id` - The
        #       allowed value id of the user defined enum attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-id is a placeholder that can be replaced with
        #       any user defined enum attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.display_name`
        #       - The allowed value display name of the user defined enum attribute
        #       associated with the Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-display-name is a placeholder that can be
        #       replaced with any user defined enum attribute enum name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.string_values.values` - The
        #       allowed value of the user defined string attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-string is a placeholder that can be replaced with
        #       any user defined string attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.json_values.values` - The
        #       allowed value of the user defined JSON attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-json is a placeholder that can be replaced with
        #       any user defined JSON attribute name.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are
        #     supported. At most three filter fields are allowed in the filter
        #     string and if provided more than that then `INVALID_ARGUMENT` error is
        #     returned by the API.
        #
        #     Here are a few examples:
        #
        #       * `lifecycle.enum_values.values.id: preview-id` - The filter string
        #       specifies that the id of the allowed value associated with the lifecycle
        #       attribute of the Version is _preview-id_.
        #       * `lifecycle.enum_values.values.display_name: \"Preview Display Name\"` -
        #       The filter string specifies that the display name of the allowed value
        #       associated with the lifecycle attribute of the Version is `Preview
        #       Display Name`.
        #       * `lifecycle.enum_values.values.id: preview-id AND create_time <
        #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
        #       The id of the allowed value associated with the lifecycle attribute of
        #       the Version is _preview-id_ and it was created before _2021-08-15
        #       14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
        #       * `compliance.enum_values.values.id: gdpr-id OR
        #       compliance.enum_values.values.id: pci-dss-id`
        #       - The id of the allowed value associated with the compliance attribute is
        #       _gdpr-id_ or _pci-dss-id_.
        #       * `lifecycle.enum_values.values.id: preview-id AND
        #       attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values:
        #       test`  - The filter string specifies that the id of the allowed value
        #       associated with the lifecycle attribute of the Version is _preview-id_
        #       and the value of the user defined attribute of type string is _test_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of versions to return. The service may return
        #     fewer than this value. If unspecified, at most 50 versions will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListVersions` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListVersions` must match the call that provided the page token.
        class ListVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_versions ListVersions} method's
        # response.
        # @!attribute [rw] versions
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Version>]
        #     The versions corresponding to an API.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_spec CreateSpec} method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for Spec.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] spec_id
        #   @return [::String]
        #     Optional. The ID to use for the spec, which will become the final component
        #     of the spec's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another spec in the API
        #     resource.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, overall resource name which will be
        #     of format
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`,
        #     its length is limited to 1000 characters and valid characters are
        #     /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] spec
        #   @return [::Google::Cloud::ApiHub::V1::Spec]
        #     Required. The spec to create.
        class CreateSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_spec GetSpec} method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        class GetSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_spec UpdateSpec} method's request.
        # @!attribute [rw] spec
        #   @return [::Google::Cloud::ApiHub::V1::Spec]
        #     Required. The spec to update.
        #
        #     The spec's `name` field is used to identify the spec to
        #     update. Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#delete_spec DeleteSpec} method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec  to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        class DeleteSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [ListSpecs][ListSpecs] method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of specs.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of Specs.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. The
        #     comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are not
        #     case sensitive.
        #
        #     The following fields in the `Spec` are eligible for filtering:
        #
        #       * `display_name` - The display name of the Spec. Allowed comparison
        #       operators: `=`.
        #       * `create_time` - The time at which the Spec was created. The
        #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
        #       format. Allowed comparison operators: `>` and `<`.
        #       * `spec_type.enum_values.values.id` - The allowed value id of the
        #       spec_type attribute associated with the Spec. Allowed comparison
        #       operators: `:`.
        #       * `spec_type.enum_values.values.display_name` - The allowed value display
        #       name of the spec_type attribute associated with the Spec. Allowed
        #       comparison operators: `:`.
        #       * `lint_response.json_values.values` - The json value of the
        #       lint_response attribute associated with the Spec. Allowed comparison
        #       operators: `:`.
        #       * `mime_type` - The MIME type of the Spec. Allowed comparison
        #       operators: `=`.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.id` - The
        #       allowed value id of the user defined enum attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-id is a placeholder that can be replaced with
        #       any user defined enum attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.display_name`
        #       - The allowed value display name of the user defined enum attribute
        #       associated with the Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-display-name is a placeholder that can be
        #       replaced with any user defined enum attribute enum name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.string_values.values` - The
        #       allowed value of the user defined string attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-string is a placeholder that can be replaced with
        #       any user defined string attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.json_values.values` - The
        #       allowed value of the user defined JSON attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-json is a placeholder that can be replaced with
        #       any user defined JSON attribute name.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are
        #     supported. At most three filter fields are allowed in the filter
        #     string and if provided more than that then `INVALID_ARGUMENT` error is
        #     returned by the API.
        #
        #     Here are a few examples:
        #
        #       * `spec_type.enum_values.values.id: rest-id` -  The filter
        #       string specifies that the id of the allowed value associated with the
        #       spec_type attribute is _rest-id_.
        #       * `spec_type.enum_values.values.display_name: \"Rest Display Name\"` -
        #       The filter string specifies that the display name of the allowed value
        #       associated with the spec_type attribute is `Rest Display Name`.
        #       * `spec_type.enum_values.values.id: grpc-id AND create_time <
        #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
        #       The id of the allowed value associated with the spec_type attribute is
        #       _grpc-id_ and the spec was created before _2021-08-15 14:50:00 UTC_ and
        #       after _2021-08-10 12:00:00 UTC_.
        #       * `spec_type.enum_values.values.id: rest-id OR
        #       spec_type.enum_values.values.id: grpc-id`
        #       - The id of the allowed value associated with the spec_type attribute is
        #       _rest-id_ or _grpc-id_.
        #       * `spec_type.enum_values.values.id: rest-id AND
        #       attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.enum_values.values.id:
        #       test`  - The filter string specifies that the id of the allowed value
        #       associated with the spec_type attribute is _rest-id_ and the id of the
        #       allowed value associated with the user defined attribute of type enum is
        #       _test_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of specs to return. The service may return
        #     fewer than this value. If unspecified, at most 50 specs will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListSpecs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListSpecs` must
        #     match the call that provided the page token.
        class ListSpecsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_specs ListSpecs} method's response.
        # @!attribute [rw] specs
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Spec>]
        #     The specs corresponding to an API Version.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListSpecsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_spec_contents GetSpecContents} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spec whose contents need to be retrieved.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
        class GetSpecContentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api_operation CreateApiOperation}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the operation resource.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] api_operation_id
        #   @return [::String]
        #     Optional. The ID to use for the operation resource, which will become the
        #     final component of the operation's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another operation resource in the API
        #     hub.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, overall resource name which
        #     will be of format
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`,
        #     its length is limited to 700 characters, and valid characters are
        #     /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] api_operation
        #   @return [::Google::Cloud::ApiHub::V1::ApiOperation]
        #     Required. The operation resource to create.
        class CreateApiOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_api_operation GetApiOperation} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the operation to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
        class GetApiOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_api_operation UpdateApiOperation}
        # method's request.
        # @!attribute [rw] api_operation
        #   @return [::Google::Cloud::ApiHub::V1::ApiOperation]
        #     Required. The apiOperation resource to update.
        #
        #     The operation resource's `name` field is used to identify the operation
        #     resource to update.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateApiOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#delete_api_operation DeleteApiOperation}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the operation resource to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
        class DeleteApiOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_api_operations ListApiOperations}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of operations i.e., the API
        #     version. Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of ApiOperations.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string or a
        #     boolean. The comparison operator must be one of: `<`, `>` or
        #     `=`. Filters are not case sensitive.
        #
        #     The following fields in the `ApiOperation` are eligible for filtering:
        #       * `name` - The ApiOperation resource name. Allowed comparison
        #       operators:
        #       `=`.
        #       * `details.http_operation.path.path` - The http operation's complete path
        #       relative to server endpoint. Allowed comparison operators: `=`.
        #       * `details.http_operation.method` - The http operation method type.
        #       Allowed comparison operators: `=`.
        #       * `details.deprecated` - Indicates if the ApiOperation is deprecated.
        #       Allowed values are True / False indicating the deprycation status of the
        #       ApiOperation. Allowed comparison operators: `=`.
        #       * `create_time` - The time at which the ApiOperation was created. The
        #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
        #       format. Allowed comparison operators: `>` and `<`.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.id` - The
        #       allowed value id of the user defined enum attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-id is a placeholder that can be replaced with
        #       any user defined enum attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.display_name`
        #       - The allowed value display name of the user defined enum attribute
        #       associated with the Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-display-name is a placeholder that can be
        #       replaced with any user defined enum attribute enum name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.string_values.values` - The
        #       allowed value of the user defined string attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-string is a placeholder that can be replaced with
        #       any user defined string attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.json_values.values` - The
        #       allowed value of the user defined JSON attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-json is a placeholder that can be replaced with
        #       any user defined JSON attribute name.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are supported. At most
        #     three filter fields are allowed in the filter string and if provided
        #     more than that then `INVALID_ARGUMENT` error is returned by the API.
        #
        #     Here are a few examples:
        #
        #       * `details.deprecated = True` -  The ApiOperation is deprecated.
        #       * `details.http_operation.method = GET AND create_time <
        #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
        #       The method of the http operation of the ApiOperation is _GET_ and the
        #       spec was created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10
        #       12:00:00 UTC_.
        #       * `details.http_operation.method = GET OR details.http_operation.method =
        #       POST`. - The http operation of the method of ApiOperation is _GET_ or
        #       _POST_.
        #       * `details.deprecated = True AND
        #       attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values:
        #       test`  - The filter string specifies that the ApiOperation is deprecated
        #       and the value of the user defined attribute of type string is _test_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of operations to return. The service may
        #     return fewer than this value. If unspecified, at most 50 operations will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListApiOperations` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListApiOperations` must match the call that provided the page token.
        class ListApiOperationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_api_operations ListApiOperations}
        # method's response.
        # @!attribute [rw] api_operations
        #   @return [::Array<::Google::Cloud::ApiHub::V1::ApiOperation>]
        #     The operations corresponding to an API version.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListApiOperationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_definition GetDefinition} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the definition to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
        class GetDefinitionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_deployment CreateDeployment}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the deployment resource.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] deployment_id
        #   @return [::String]
        #     Optional. The ID to use for the deployment resource, which will become the
        #     final component of the deployment's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another deployment resource in the API
        #     hub.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, and valid characters
        #     are /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::ApiHub::V1::Deployment]
        #     Required. The deployment resource to create.
        class CreateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_deployment GetDeployment} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment resource to retrieve.
        #     Format: `projects/{project}/locations/{location}/deployments/{deployment}`
        class GetDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_deployment UpdateDeployment}
        # method's request.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::ApiHub::V1::Deployment]
        #     Required. The deployment resource to update.
        #
        #     The deployment resource's `name` field is used to identify the deployment
        #     resource to update.
        #     Format: `projects/{project}/locations/{location}/deployments/{deployment}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#delete_deployment DeleteDeployment}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment resource to delete.
        #     Format: `projects/{project}/locations/{location}/deployments/{deployment}`
        class DeleteDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_deployments ListDeployments} method's
        # request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of deployment resources.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of Deployments.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string. The
        #     comparison operator must be one of: `<`, `>` or
        #     `=`. Filters are not case sensitive.
        #
        #     The following fields in the `Deployments` are eligible for filtering:
        #
        #       * `display_name` - The display name of the Deployment. Allowed
        #       comparison operators: `=`.
        #       * `create_time` - The time at which the Deployment was created. The
        #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
        #       format. Allowed comparison operators: `>` and `<`.
        #       * `resource_uri` - A URI to the deployment resource. Allowed
        #       comparison operators: `=`.
        #       * `api_versions` - The API versions linked to this deployment. Allowed
        #       comparison operators: `:`.
        #       * `source_project` - The project/organization at source for the
        #       deployment. Allowed comparison operators: `=`.
        #       * `source_environment` - The environment at source for the
        #       deployment. Allowed comparison operators: `=`.
        #       * `deployment_type.enum_values.values.id` - The allowed value id of the
        #       deployment_type attribute associated with the Deployment. Allowed
        #       comparison operators: `:`.
        #       * `deployment_type.enum_values.values.display_name` - The allowed value
        #       display name of the deployment_type attribute associated with the
        #       Deployment. Allowed comparison operators: `:`.
        #       * `slo.string_values.values` -The allowed string value of the slo
        #       attribute associated with the deployment. Allowed comparison
        #       operators: `:`.
        #       * `environment.enum_values.values.id` - The allowed value id of the
        #       environment attribute associated with the deployment. Allowed
        #       comparison operators: `:`.
        #       * `environment.enum_values.values.display_name` - The allowed value
        #       display name of the environment attribute associated with the deployment.
        #       Allowed comparison operators: `:`.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.id` - The
        #       allowed value id of the user defined enum attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-id is a placeholder that can be replaced with
        #       any user defined enum attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.enum_values.values.display_name`
        #       - The allowed value display name of the user defined enum attribute
        #       associated with the Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-enum-display-name is a placeholder that can be
        #       replaced with any user defined enum attribute enum name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.string_values.values` - The
        #       allowed value of the user defined string attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-string is a placeholder that can be replaced with
        #       any user defined string attribute name.
        #       * `attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/user-defined-attribute-id.json_values.values` - The
        #       allowed value of the user defined JSON attribute associated with the
        #       Resource. Allowed comparison operator is `:`. Here
        #       user-defined-attribute-json is a placeholder that can be replaced with
        #       any user defined JSON attribute name.
        #
        #     A filter function is also supported in the filter string. The filter
        #     function is `id(name)`. The `id(name)` function returns the id of the
        #     resource name. For example, `id(name) = \"deployment-1\"` is equivalent to
        #     `name =
        #     \"projects/test-project-id/locations/test-location-id/deployments/deployment-1\"`
        #     provided the parent is
        #     `projects/test-project-id/locations/test-location-id`.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are supported. At most
        #     three filter fields are allowed in the filter string and if provided
        #     more than that then `INVALID_ARGUMENT` error is returned by the API.
        #
        #     Here are a few examples:
        #
        #       * `environment.enum_values.values.id: staging-id` - The allowed value id
        #       of the environment attribute associated with the Deployment is
        #       _staging-id_.
        #       * `environment.enum_values.values.display_name: \"Staging Deployment\"` -
        #       The allowed value display name of the environment attribute associated
        #       with the Deployment is `Staging Deployment`.
        #       * `environment.enum_values.values.id: production-id AND create_time <
        #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
        #       The allowed value id of the environment attribute associated with the
        #       Deployment is _production-id_ and Deployment was created before
        #       _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
        #       * `environment.enum_values.values.id: production-id OR
        #       slo.string_values.values: \"99.99%\"`
        #       - The allowed value id of the environment attribute Deployment is
        #       _production-id_ or string value of the slo attribute is _99.99%_.
        #       * `environment.enum_values.values.id: staging-id AND
        #       attributes.projects/test-project-id/locations/test-location-id/
        #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values:
        #       test`  - The filter string specifies that the allowed value id of the
        #       environment attribute associated with the Deployment is _staging-id_ and
        #       the value of the user defined attribute of type string is _test_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of deployment resources to return. The service
        #     may return fewer than this value. If unspecified, at most 50 deployments
        #     will be returned. The maximum value is 1000; values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDeployments` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListDeployments` must match the call that provided the page token.
        class ListDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_deployments ListDeployments} method's
        # response.
        # @!attribute [rw] deployments
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Deployment>]
        #     The deployment resources present in the API hub.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_attribute CreateAttribute} method's
        # request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for Attribute.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] attribute_id
        #   @return [::String]
        #     Optional. The ID to use for the attribute, which will become the final
        #     component of the attribute's resource name. This field is optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another attribute resource in the API
        #     hub.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, and valid characters
        #     are /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] attribute
        #   @return [::Google::Cloud::ApiHub::V1::Attribute]
        #     Required. The attribute to create.
        class CreateAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_attribute GetAttribute} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the attribute to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`
        class GetAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_attribute UpdateAttribute} method's
        # request.
        # @!attribute [rw] attribute
        #   @return [::Google::Cloud::ApiHub::V1::Attribute]
        #     Required. The attribute to update.
        #
        #     The attribute's `name` field is used to identify the attribute to update.
        #     Format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#delete_attribute DeleteAttribute} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the attribute to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/attributes/{attribute}`
        class DeleteAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_attributes ListAttributes} method's
        # request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for Attribute.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of Attributes.
        #
        #     A filter expression consists of a field name, a comparison
        #     operator, and a value for filtering. The value must be a string or a
        #     boolean. The comparison operator must be one of: `<`, `>` or
        #     `=`. Filters are not case sensitive.
        #
        #     The following fields in the `Attribute` are eligible for filtering:
        #
        #       * `display_name` - The display name of the Attribute. Allowed
        #       comparison operators: `=`.
        #       * `definition_type` - The definition type of the attribute. Allowed
        #       comparison operators: `=`.
        #       * `scope` - The scope of the attribute. Allowed comparison operators:
        #       `=`.
        #       * `data_type` - The type of the data of the attribute. Allowed
        #       comparison operators: `=`.
        #       * `mandatory` - Denotes whether the attribute is mandatory or not.
        #       Allowed comparison operators: `=`.
        #       * `create_time` - The time at which the Attribute was created. The
        #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
        #       format. Allowed comparison operators: `>` and `<`.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are
        #     supported. At most three filter fields are allowed in the filter
        #     string and if provided more than that then `INVALID_ARGUMENT` error is
        #     returned by the API.
        #
        #     Here are a few examples:
        #
        #       * `display_name = production` -  - The display name of the attribute is
        #       _production_.
        #       * `(display_name = production) AND (create_time <
        #       \"2021-08-15T14:50:00Z\") AND (create_time > \"2021-08-10T12:00:00Z\")` -
        #       The display name of the attribute is _production_ and the attribute was
        #       created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00
        #       UTC_.
        #       * `display_name = production OR scope = api` -
        #       The attribute where the display name is _production_ or the scope is
        #       _api_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of attribute resources to return. The service
        #     may return fewer than this value. If unspecified, at most 50 attributes
        #     will be returned. The maximum value is 1000; values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListAttributes` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAttributes` must
        #     match the call that provided the page token.
        class ListAttributesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_attributes ListAttributes} method's
        # response.
        # @!attribute [rw] attributes
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Attribute>]
        #     The list of all attributes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAttributesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#search_resources SearchResources} method's
        # request.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The resource name of the location which will be of the type
        #     `projects/{project_id}/locations/{location_id}`. This field is used to
        #     identify the instance of API-Hub in which resources should be searched.
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. The free text search query. This query can contain keywords which
        #     could be related to any detail of the API-Hub resources such display names,
        #     descriptions, attributes etc.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of search results.
        #
        #     A filter expression consists of a field name, a comparison operator,
        #     and a value for filtering. The value must be a string, a number, or a
        #     boolean. The comparison operator must be `=`. Filters are not case
        #     sensitive.
        #
        #     The following field names are eligible for filtering:
        #        * `resource_type` - The type of resource in the search results.
        #        Must be one of the following: `Api`, `ApiOperation`, `Deployment`,
        #        `Definition`, `Spec` or `Version`. This field can only be specified once
        #        in the filter.
        #
        #     Here are is an example:
        #
        #       * `resource_type = Api` - The resource_type is _Api_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of search results to return. The service may
        #     return fewer than this value. If unspecified at most 10 search results will
        #     be returned. If value is negative then `INVALID_ARGUMENT` error is
        #     returned. The maximum value is 25; values above 25 will be coerced to 25.
        #     While paginating, you can specify a new page size parameter for each page
        #     of search results to be listed.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     [SearchResources][SearchResources]
        #     call. Specify this parameter to retrieve the next page of transactions.
        #
        #     When paginating, you must specify the `page_token` parameter and all the
        #     other parameters except
        #     {::Google::Cloud::ApiHub::V1::SearchResourcesRequest#page_size page_size}
        #     should be specified with the same value which was used in the previous
        #     call. If the other fields are set with a different value than the previous
        #     call then `INVALID_ARGUMENT` error is returned.
        class SearchResourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ApiHubResource is one of the resources such as Api, Operation, Deployment,
        # Definition, Spec and Version resources stored in API-Hub.
        # @!attribute [rw] api
        #   @return [::Google::Cloud::ApiHub::V1::Api]
        #     This represents Api resource in search results. Only name, display_name,
        #     description and owner fields are populated in search results.
        #
        #     Note: The following fields are mutually exclusive: `api`, `operation`, `deployment`, `spec`, `definition`, `version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] operation
        #   @return [::Google::Cloud::ApiHub::V1::ApiOperation]
        #     This represents ApiOperation resource in search results. Only name,
        #     description, spec and details fields are populated in search results.
        #
        #     Note: The following fields are mutually exclusive: `operation`, `api`, `deployment`, `spec`, `definition`, `version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::ApiHub::V1::Deployment]
        #     This represents Deployment resource in search results. Only name,
        #     display_name, description, deployment_type and api_versions fields are
        #     populated in search results.
        #
        #     Note: The following fields are mutually exclusive: `deployment`, `api`, `operation`, `spec`, `definition`, `version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] spec
        #   @return [::Google::Cloud::ApiHub::V1::Spec]
        #     This represents Spec resource in search results. Only name,
        #     display_name, description, spec_type and documentation fields are
        #     populated in search results.
        #
        #     Note: The following fields are mutually exclusive: `spec`, `api`, `operation`, `deployment`, `definition`, `version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] definition
        #   @return [::Google::Cloud::ApiHub::V1::Definition]
        #     This represents Definition resource in search results.
        #     Only name field is populated in search results.
        #
        #     Note: The following fields are mutually exclusive: `definition`, `api`, `operation`, `deployment`, `spec`, `version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] version
        #   @return [::Google::Cloud::ApiHub::V1::Version]
        #     This represents Version resource in search results. Only name,
        #     display_name, description, lifecycle, compliance and accreditation fields
        #     are populated in search results.
        #
        #     Note: The following fields are mutually exclusive: `version`, `api`, `operation`, `deployment`, `spec`, `definition`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ApiHubResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the search results.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::ApiHub::V1::ApiHubResource]
        #     This represents the ApiHubResource.
        #     Note: Only selected fields of the resources are populated in response.
        class SearchResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the
        # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#search_resources SearchResources} method.
        # @!attribute [rw] search_results
        #   @return [::Array<::Google::Cloud::ApiHub::V1::SearchResult>]
        #     List of search results according to the filter and search query specified.
        #     The order of search results represents the ranking.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pass this token in the
        #     {::Google::Cloud::ApiHub::V1::SearchResourcesRequest SearchResourcesRequest}
        #     to continue to list results. If all results have been returned, this field
        #     is an empty string or not present in the response.
        class SearchResourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client#create_dependency CreateDependency}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the dependency resource.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] dependency_id
        #   @return [::String]
        #     Optional. The ID to use for the dependency resource, which will become the
        #     final component of the dependency's resource name. This field is optional.
        #     * If provided, the same will be used. The service will throw an error if
        #     duplicate id is provided by the client.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, and valid characters
        #     are `[a-z][A-Z][0-9]-_`.
        # @!attribute [rw] dependency
        #   @return [::Google::Cloud::ApiHub::V1::Dependency]
        #     Required. The dependency resource to create.
        class CreateDependencyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The [GetDependency][.ApiHubDependencies.GetDependency]
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the dependency resource to retrieve.
        #     Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
        class GetDependencyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client#update_dependency UpdateDependency}
        # method's request.
        # @!attribute [rw] dependency
        #   @return [::Google::Cloud::ApiHub::V1::Dependency]
        #     Required. The dependency resource to update.
        #
        #     The dependency's `name` field is used to identify the dependency to update.
        #     Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateDependencyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client#delete_dependency DeleteDependency}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the dependency resource to delete.
        #     Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
        class DeleteDependencyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client#list_dependencies ListDependencies}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of dependency resources.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of Dependencies.
        #
        #     A filter expression consists of a field name, a comparison operator, and
        #     a value for filtering. The value must be a string. Allowed comparison
        #     operator is `=`. Filters are not case sensitive.
        #
        #     The following fields in the `Dependency` are eligible for filtering:
        #
        #       * `consumer.operation_resource_name` - The operation resource name for
        #       the consumer entity involved in a dependency. Allowed comparison
        #       operators: `=`.
        #       * `consumer.external_api_resource_name` - The external api resource name
        #       for the consumer entity involved in a dependency. Allowed comparison
        #       operators: `=`.
        #       * `supplier.operation_resource_name` - The operation resource name for
        #       the supplier entity involved in a dependency. Allowed comparison
        #       operators: `=`.
        #       * `supplier.external_api_resource_name` - The external api resource name
        #       for the supplier entity involved in a dependency. Allowed comparison
        #       operators: `=`.
        #
        #     Expressions are combined with either `AND` logic operator or `OR` logical
        #     operator but not both of them together i.e. only one of the `AND` or `OR`
        #     operator can be used throughout the filter string and both the operators
        #     cannot be used together. No other logical operators are supported. At most
        #     three filter fields are allowed in the filter string and if provided
        #     more than that then `INVALID_ARGUMENT` error is returned by the API.
        #
        #     For example, `consumer.operation_resource_name =
        #     \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\" OR
        #     supplier.operation_resource_name =
        #     \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\"` - The
        #     dependencies with either consumer or supplier operation resource name as
        #     _projects/p1/locations/global/apis/a1/versions/v1/operations/o1_.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of dependency resources to return. The service
        #     may return fewer than this value. If unspecified, at most 50 dependencies
        #     will be returned. The maximum value is 1000; values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDependencies` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListDependencies` must
        #     match the call that provided the page token.
        class ListDependenciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The
        # {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client#list_dependencies ListDependencies}
        # method's response.
        # @!attribute [rw] dependencies
        #   @return [::Array<::Google::Cloud::ApiHub::V1::Dependency>]
        #     The dependency resources present in the API hub.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDependenciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_external_api CreateExternalApi}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the External API resource.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] external_api_id
        #   @return [::String]
        #     Optional. The ID to use for the External API resource, which will become
        #     the final component of the External API's resource name. This field is
        #     optional.
        #
        #     * If provided, the same will be used. The service will throw an error if
        #     the specified id is already used by another External API resource in the
        #     API hub.
        #     * If not provided, a system generated id will be used.
        #
        #     This value should be 4-500 characters, and valid characters
        #     are /[a-z][A-Z][0-9]-_/.
        # @!attribute [rw] external_api
        #   @return [::Google::Cloud::ApiHub::V1::ExternalApi]
        #     Required. The External API resource to create.
        class CreateExternalApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_external_api GetExternalApi} method's
        # request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the External API resource to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/externalApis/{externalApi}`
        class GetExternalApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_external_api UpdateExternalApi}
        # method's request.
        # @!attribute [rw] external_api
        #   @return [::Google::Cloud::ApiHub::V1::ExternalApi]
        #     Required. The External API resource to update.
        #
        #     The External API resource's `name` field is used to identify the External
        #     API resource to update. Format:
        #     `projects/{project}/locations/{location}/externalApis/{externalApi}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateExternalApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#delete_external_api DeleteExternalApi}
        # method's request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the External API resource to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/externalApis/{externalApi}`
        class DeleteExternalApiRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_external_apis ListExternalApis}
        # method's request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of External API resources.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of External API resources to return. The
        #     service may return fewer than this value. If unspecified, at most 50
        #     ExternalApis will be returned. The maximum value is 1000; values above 1000
        #     will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListExternalApis` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters (except page_size) provided to
        #     `ListExternalApis` must match the call that provided the page token.
        class ListExternalApisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_external_apis ListExternalApis}
        # method's response.
        # @!attribute [rw] external_apis
        #   @return [::Array<::Google::Cloud::ApiHub::V1::ExternalApi>]
        #     The External API resources present in the API hub.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListExternalApisResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
