# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/apihub/v1/curate_service.proto for package 'Google.Cloud.ApiHub.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/apihub/v1/curate_service_pb'

module Google
  module Cloud
    module ApiHub
      module V1
        module ApiHubCurate
          # This service is used for managing curations for processing API data consumed
          # from collect layer.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.apihub.v1.ApiHubCurate'

            # Create a curation resource in the API hub.
            # Once a curation resource is created, plugin instances can start using it.
            rpc :CreateCuration, ::Google::Cloud::ApiHub::V1::CreateCurationRequest, ::Google::Cloud::ApiHub::V1::Curation
            # Get curation resource details.
            rpc :GetCuration, ::Google::Cloud::ApiHub::V1::GetCurationRequest, ::Google::Cloud::ApiHub::V1::Curation
            # List curation resources in the API hub.
            rpc :ListCurations, ::Google::Cloud::ApiHub::V1::ListCurationsRequest, ::Google::Cloud::ApiHub::V1::ListCurationsResponse
            # Update a curation resource in the API hub. The following fields in the
            # [curation][google.cloud.apihub.v1.Curation] can be updated:
            #
            # * [display_name][google.cloud.apihub.v1.Curation.display_name]
            # * [description][google.cloud.apihub.v1.Curation.description]
            #
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateApiRequest.update_mask]
            # should be used to specify the fields being updated.
            rpc :UpdateCuration, ::Google::Cloud::ApiHub::V1::UpdateCurationRequest, ::Google::Cloud::ApiHub::V1::Curation
            # Delete a curation resource in the API hub. A curation can only be deleted
            # if it's not being used by any plugin instance.
            rpc :DeleteCuration, ::Google::Cloud::ApiHub::V1::DeleteCurationRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
