# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/apihub/v1/apihub_service.proto for package 'Google.Cloud.ApiHub.V1'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/apihub/v1/apihub_service_pb'

module Google
  module Cloud
    module ApiHub
      module V1
        module ApiHub
          # This service provides all methods related to the API hub.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.apihub.v1.ApiHub'

            # Create an API resource in the API hub.
            # Once an API resource is created, versions can be added to it.
            rpc :CreateApi, ::Google::Cloud::ApiHub::V1::CreateApiRequest, ::Google::Cloud::ApiHub::V1::Api
            # Get API resource details including the API versions contained in it.
            rpc :GetApi, ::Google::Cloud::ApiHub::V1::GetApiRequest, ::Google::Cloud::ApiHub::V1::Api
            # List API resources in the API hub.
            rpc :ListApis, ::Google::Cloud::ApiHub::V1::ListApisRequest, ::Google::Cloud::ApiHub::V1::ListApisResponse
            # Update an API resource in the API hub. The following fields in the
            # [API][google.cloud.apihub.v1.Api] can be updated:
            #
            # * [display_name][google.cloud.apihub.v1.Api.display_name]
            # * [description][google.cloud.apihub.v1.Api.description]
            # * [owner][google.cloud.apihub.v1.Api.owner]
            # * [documentation][google.cloud.apihub.v1.Api.documentation]
            # * [target_user][google.cloud.apihub.v1.Api.target_user]
            # * [team][google.cloud.apihub.v1.Api.team]
            # * [business_unit][google.cloud.apihub.v1.Api.business_unit]
            # * [maturity_level][google.cloud.apihub.v1.Api.maturity_level]
            # * [api_style][google.cloud.apihub.v1.Api.api_style]
            # * [attributes][google.cloud.apihub.v1.Api.attributes]
            #
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateApiRequest.update_mask]
            # should be used to specify the fields being updated.
            #
            # Updating the owner field requires complete owner message
            # and updates both owner and email fields.
            rpc :UpdateApi, ::Google::Cloud::ApiHub::V1::UpdateApiRequest, ::Google::Cloud::ApiHub::V1::Api
            # Delete an API resource in the API hub. API can only be deleted if all
            # underlying versions are deleted.
            rpc :DeleteApi, ::Google::Cloud::ApiHub::V1::DeleteApiRequest, ::Google::Protobuf::Empty
            # Create an API version for an API resource in the API hub.
            rpc :CreateVersion, ::Google::Cloud::ApiHub::V1::CreateVersionRequest, ::Google::Cloud::ApiHub::V1::Version
            # Get details about the API version of an API resource. This will include
            # information about the specs and operations present in the API
            # version as well as the deployments linked to it.
            rpc :GetVersion, ::Google::Cloud::ApiHub::V1::GetVersionRequest, ::Google::Cloud::ApiHub::V1::Version
            # List API versions of an API resource in the API hub.
            rpc :ListVersions, ::Google::Cloud::ApiHub::V1::ListVersionsRequest, ::Google::Cloud::ApiHub::V1::ListVersionsResponse
            # Update API version. The following fields in the
            # [version][google.cloud.apihub.v1.Version] can be updated currently:
            #
            # * [display_name][google.cloud.apihub.v1.Version.display_name]
            # * [description][google.cloud.apihub.v1.Version.description]
            # * [documentation][google.cloud.apihub.v1.Version.documentation]
            # * [deployments][google.cloud.apihub.v1.Version.deployments]
            # * [lifecycle][google.cloud.apihub.v1.Version.lifecycle]
            # * [compliance][google.cloud.apihub.v1.Version.compliance]
            # * [accreditation][google.cloud.apihub.v1.Version.accreditation]
            # * [attributes][google.cloud.apihub.v1.Version.attributes]
            #
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateVersionRequest.update_mask]
            # should be used to specify the fields being updated.
            rpc :UpdateVersion, ::Google::Cloud::ApiHub::V1::UpdateVersionRequest, ::Google::Cloud::ApiHub::V1::Version
            # Delete an API version. Version can only be deleted if all underlying specs,
            # operations, definitions and linked deployments are deleted.
            rpc :DeleteVersion, ::Google::Cloud::ApiHub::V1::DeleteVersionRequest, ::Google::Protobuf::Empty
            # Add a spec to an API version in the API hub.
            # Multiple specs can be added to an API version.
            # Note, while adding a spec, at least one of `contents` or `source_uri` must
            # be provided. If `contents` is provided, then `spec_type` must also be
            # provided.
            #
            # On adding a spec with contents to the version, the operations present in it
            # will be added to the version.Note that the file contents in the spec should
            # be of the same type as defined in the
            # `projects/{project}/locations/{location}/attributes/system-spec-type`
            # attribute associated with spec resource. Note that specs of various types
            # can be uploaded, however parsing of details is supported for OpenAPI spec
            # currently.
            #
            # In order to access the information parsed from the spec, use the
            # [GetSpec][google.cloud.apihub.v1.ApiHub.GetSpec] method.
            # In order to access the raw contents for a particular spec, use the
            # [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method.
            # In order to access the operations parsed from the spec, use the
            # [ListAPIOperations][google.cloud.apihub.v1.ApiHub.ListApiOperations]
            # method.
            rpc :CreateSpec, ::Google::Cloud::ApiHub::V1::CreateSpecRequest, ::Google::Cloud::ApiHub::V1::Spec
            # Get details about the information parsed from a spec.
            # Note that this method does not return the raw spec contents.
            # Use [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method
            # to retrieve the same.
            rpc :GetSpec, ::Google::Cloud::ApiHub::V1::GetSpecRequest, ::Google::Cloud::ApiHub::V1::Spec
            # Get spec contents.
            rpc :GetSpecContents, ::Google::Cloud::ApiHub::V1::GetSpecContentsRequest, ::Google::Cloud::ApiHub::V1::SpecContents
            # List specs corresponding to a particular API resource.
            rpc :ListSpecs, ::Google::Cloud::ApiHub::V1::ListSpecsRequest, ::Google::Cloud::ApiHub::V1::ListSpecsResponse
            # Update spec. The following fields in the
            # [spec][google.cloud.apihub.v1.Spec] can be updated:
            #
            # * [display_name][google.cloud.apihub.v1.Spec.display_name]
            # * [source_uri][google.cloud.apihub.v1.Spec.source_uri]
            # * [lint_response][google.cloud.apihub.v1.Spec.lint_response]
            # * [attributes][google.cloud.apihub.v1.Spec.attributes]
            # * [contents][google.cloud.apihub.v1.Spec.contents]
            # * [spec_type][google.cloud.apihub.v1.Spec.spec_type]
            #
            # In case of an OAS spec, updating spec contents can lead to:
            # 1. Creation, deletion and update of operations.
            # 2. Creation, deletion and update of definitions.
            # 3. Update of other info parsed out from the new spec.
            #
            # In case of contents or source_uri being present in update mask, spec_type
            # must also be present. Also, spec_type can not be present in update mask if
            # contents or source_uri is not present.
            #
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateSpecRequest.update_mask]
            # should be used to specify the fields being updated.
            rpc :UpdateSpec, ::Google::Cloud::ApiHub::V1::UpdateSpecRequest, ::Google::Cloud::ApiHub::V1::Spec
            # Delete a spec.
            # Deleting a spec will also delete the associated operations from the
            # version.
            rpc :DeleteSpec, ::Google::Cloud::ApiHub::V1::DeleteSpecRequest, ::Google::Protobuf::Empty
            # Create an apiOperation in an API version.
            # An apiOperation can be created only if the version has no apiOperations
            # which were created by parsing a spec.
            rpc :CreateApiOperation, ::Google::Cloud::ApiHub::V1::CreateApiOperationRequest, ::Google::Cloud::ApiHub::V1::ApiOperation
            # Get details about a particular operation in API version.
            rpc :GetApiOperation, ::Google::Cloud::ApiHub::V1::GetApiOperationRequest, ::Google::Cloud::ApiHub::V1::ApiOperation
            # List operations in an API version.
            rpc :ListApiOperations, ::Google::Cloud::ApiHub::V1::ListApiOperationsRequest, ::Google::Cloud::ApiHub::V1::ListApiOperationsResponse
            # Update an operation in an API version. The following fields in the
            # [ApiOperation resource][google.cloud.apihub.v1.ApiOperation] can be
            # updated:
            #
            # * [details.description][ApiOperation.details.description]
            # * [details.documentation][ApiOperation.details.documentation]
            # * [details.http_operation.path][ApiOperation.details.http_operation.path.path]
            # * [details.http_operation.method][ApiOperation.details.http_operation.method]
            # * [details.deprecated][ApiOperation.details.deprecated]
            # * [attributes][google.cloud.apihub.v1.ApiOperation.attributes]
            #
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateApiOperationRequest.update_mask]
            # should be used to specify the fields being updated.
            #
            # An operation can be updated only if the operation was created via
            # [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation] API.
            # If the operation was created by parsing the spec, then it can be edited by
            # updating the spec.
            rpc :UpdateApiOperation, ::Google::Cloud::ApiHub::V1::UpdateApiOperationRequest, ::Google::Cloud::ApiHub::V1::ApiOperation
            # Delete an operation in an API version and we can delete only the
            # operations created via create API. If the operation was created by parsing
            # the spec, then it can be deleted by editing or deleting the spec.
            rpc :DeleteApiOperation, ::Google::Cloud::ApiHub::V1::DeleteApiOperationRequest, ::Google::Protobuf::Empty
            # Get details about a definition in an API version.
            rpc :GetDefinition, ::Google::Cloud::ApiHub::V1::GetDefinitionRequest, ::Google::Cloud::ApiHub::V1::Definition
            # Create a deployment resource in the API hub.
            # Once a deployment resource is created, it can be associated with API
            # versions.
            rpc :CreateDeployment, ::Google::Cloud::ApiHub::V1::CreateDeploymentRequest, ::Google::Cloud::ApiHub::V1::Deployment
            # Get details about a deployment and the API versions linked to it.
            rpc :GetDeployment, ::Google::Cloud::ApiHub::V1::GetDeploymentRequest, ::Google::Cloud::ApiHub::V1::Deployment
            # List deployment resources in the API hub.
            rpc :ListDeployments, ::Google::Cloud::ApiHub::V1::ListDeploymentsRequest, ::Google::Cloud::ApiHub::V1::ListDeploymentsResponse
            # Update a deployment resource in the API hub. The following fields in the
            # [deployment resource][google.cloud.apihub.v1.Deployment] can be
            # updated:
            #
            # * [display_name][google.cloud.apihub.v1.Deployment.display_name]
            # * [description][google.cloud.apihub.v1.Deployment.description]
            # * [documentation][google.cloud.apihub.v1.Deployment.documentation]
            # * [deployment_type][google.cloud.apihub.v1.Deployment.deployment_type]
            # * [resource_uri][google.cloud.apihub.v1.Deployment.resource_uri]
            # * [endpoints][google.cloud.apihub.v1.Deployment.endpoints]
            # * [slo][google.cloud.apihub.v1.Deployment.slo]
            # * [environment][google.cloud.apihub.v1.Deployment.environment]
            # * [attributes][google.cloud.apihub.v1.Deployment.attributes]
            # * [source_project] [google.cloud.apihub.v1.Deployment.source_project]
            # * [source_environment]
            # [google.cloud.apihub.v1.Deployment.source_environment]
            # * [management_url][google.cloud.apihub.v1.Deployment.management_url]
            # * [source_uri][google.cloud.apihub.v1.Deployment.source_uri]
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateDeploymentRequest.update_mask]
            # should be used to specify the fields being updated.
            rpc :UpdateDeployment, ::Google::Cloud::ApiHub::V1::UpdateDeploymentRequest, ::Google::Cloud::ApiHub::V1::Deployment
            # Delete a deployment resource in the API hub.
            rpc :DeleteDeployment, ::Google::Cloud::ApiHub::V1::DeleteDeploymentRequest, ::Google::Protobuf::Empty
            # Create a user defined attribute.
            #
            # Certain pre defined attributes are already created by the API hub. These
            # attributes will have type as `SYSTEM_DEFINED` and can be listed via
            # [ListAttributes][google.cloud.apihub.v1.ApiHub.ListAttributes] method.
            # Allowed values for the same can be updated via
            # [UpdateAttribute][google.cloud.apihub.v1.ApiHub.UpdateAttribute] method.
            rpc :CreateAttribute, ::Google::Cloud::ApiHub::V1::CreateAttributeRequest, ::Google::Cloud::ApiHub::V1::Attribute
            # Get details about the attribute.
            rpc :GetAttribute, ::Google::Cloud::ApiHub::V1::GetAttributeRequest, ::Google::Cloud::ApiHub::V1::Attribute
            # Update the attribute.  The following fields in the
            # [Attribute resource][google.cloud.apihub.v1.Attribute] can be updated:
            #
            # * [display_name][google.cloud.apihub.v1.Attribute.display_name]
            # The display name can be updated for user defined attributes only.
            # * [description][google.cloud.apihub.v1.Attribute.description]
            # The description can be updated for user defined attributes only.
            # * [allowed_values][google.cloud.apihub.v1.Attribute.allowed_values]
            # To update the list of allowed values, clients need to use the fetched list
            # of allowed values and add or remove values to or from the same list.
            # The mutable allowed values can be updated for both user defined and System
            # defined attributes. The immutable allowed values cannot be updated or
            # deleted. The updated list of allowed values cannot be empty. If an allowed
            # value that is already used by some resource's attribute is deleted, then
            # the association between the resource and the attribute value will also be
            # deleted.
            # * [cardinality][google.cloud.apihub.v1.Attribute.cardinality]
            # The cardinality can be updated for user defined attributes only.
            # Cardinality can only be increased during an update.
            #
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateAttributeRequest.update_mask]
            # should be used to specify the fields being updated.
            rpc :UpdateAttribute, ::Google::Cloud::ApiHub::V1::UpdateAttributeRequest, ::Google::Cloud::ApiHub::V1::Attribute
            # Delete an attribute.
            #
            # Note: System defined attributes cannot be deleted. All
            # associations of the attribute being deleted with any API hub resource will
            # also get deleted.
            rpc :DeleteAttribute, ::Google::Cloud::ApiHub::V1::DeleteAttributeRequest, ::Google::Protobuf::Empty
            # List all attributes.
            rpc :ListAttributes, ::Google::Cloud::ApiHub::V1::ListAttributesRequest, ::Google::Cloud::ApiHub::V1::ListAttributesResponse
            # Search across API-Hub resources.
            rpc :SearchResources, ::Google::Cloud::ApiHub::V1::SearchResourcesRequest, ::Google::Cloud::ApiHub::V1::SearchResourcesResponse
            # Create an External API resource in the API hub.
            rpc :CreateExternalApi, ::Google::Cloud::ApiHub::V1::CreateExternalApiRequest, ::Google::Cloud::ApiHub::V1::ExternalApi
            # Get details about an External API resource in the API hub.
            rpc :GetExternalApi, ::Google::Cloud::ApiHub::V1::GetExternalApiRequest, ::Google::Cloud::ApiHub::V1::ExternalApi
            # Update an External API resource in the API hub. The following fields can be
            # updated:
            #
            # * [display_name][google.cloud.apihub.v1.ExternalApi.display_name]
            # * [description][google.cloud.apihub.v1.ExternalApi.description]
            # * [documentation][google.cloud.apihub.v1.ExternalApi.documentation]
            # * [endpoints][google.cloud.apihub.v1.ExternalApi.endpoints]
            # * [paths][google.cloud.apihub.v1.ExternalApi.paths]
            #
            # The
            # [update_mask][google.cloud.apihub.v1.UpdateExternalApiRequest.update_mask]
            # should be used to specify the fields being updated.
            rpc :UpdateExternalApi, ::Google::Cloud::ApiHub::V1::UpdateExternalApiRequest, ::Google::Cloud::ApiHub::V1::ExternalApi
            # Delete an External API resource in the API hub.
            rpc :DeleteExternalApi, ::Google::Cloud::ApiHub::V1::DeleteExternalApiRequest, ::Google::Protobuf::Empty
            # List External API resources in the API hub.
            rpc :ListExternalApis, ::Google::Cloud::ApiHub::V1::ListExternalApisRequest, ::Google::Cloud::ApiHub::V1::ListExternalApisResponse
          end

          Stub = Service.rpc_stub_class
        end
        module ApiHubDependencies
          # This service provides methods for various operations related to a
          # [Dependency][google.cloud.apihub.v1.Dependency] in the API hub.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.apihub.v1.ApiHubDependencies'

            # Create a dependency between two entities in the API hub.
            rpc :CreateDependency, ::Google::Cloud::ApiHub::V1::CreateDependencyRequest, ::Google::Cloud::ApiHub::V1::Dependency
            # Get details about a dependency resource in the API hub.
            rpc :GetDependency, ::Google::Cloud::ApiHub::V1::GetDependencyRequest, ::Google::Cloud::ApiHub::V1::Dependency
            # Update a dependency based on the
            # [update_mask][google.cloud.apihub.v1.UpdateDependencyRequest.update_mask]
            # provided in the request.
            #
            # The following fields in the [dependency][google.cloud.apihub.v1.Dependency]
            # can be updated:
            # * [description][google.cloud.apihub.v1.Dependency.description]
            rpc :UpdateDependency, ::Google::Cloud::ApiHub::V1::UpdateDependencyRequest, ::Google::Cloud::ApiHub::V1::Dependency
            # Delete the dependency resource.
            rpc :DeleteDependency, ::Google::Cloud::ApiHub::V1::DeleteDependencyRequest, ::Google::Protobuf::Empty
            # List dependencies based on the provided filter and pagination parameters.
            rpc :ListDependencies, ::Google::Cloud::ApiHub::V1::ListDependenciesRequest, ::Google::Cloud::ApiHub::V1::ListDependenciesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
