# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/apihub/v1/runtime_project_attachment_service_pb"
require "google/cloud/api_hub/v1/runtime_project_attachment_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module ApiHub
      module V1
        module RuntimeProjectAttachmentService
          module Rest
            ##
            # REST client for the RuntimeProjectAttachmentService service.
            #
            # This service is used for managing the runtime project attachments.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "apihub.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :runtime_project_attachment_service_stub

              ##
              # Configure the RuntimeProjectAttachmentService Client class.
              #
              # See {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all RuntimeProjectAttachmentService clients
              #   ::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ApiHub", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_runtime_project_attachment.timeout = 60.0

                  default_config.rpcs.get_runtime_project_attachment.timeout = 60.0
                  default_config.rpcs.get_runtime_project_attachment.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_runtime_project_attachments.timeout = 60.0
                  default_config.rpcs.list_runtime_project_attachments.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_runtime_project_attachment.timeout = 60.0

                  default_config.rpcs.lookup_runtime_project_attachment.timeout = 60.0
                  default_config.rpcs.lookup_runtime_project_attachment.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the RuntimeProjectAttachmentService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @runtime_project_attachment_service_stub.universe_domain
              end

              ##
              # Create a new RuntimeProjectAttachmentService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the RuntimeProjectAttachmentService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @runtime_project_attachment_service_stub = ::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @runtime_project_attachment_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @runtime_project_attachment_service_stub.endpoint
                  config.universe_domain = @runtime_project_attachment_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @runtime_project_attachment_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @runtime_project_attachment_service_stub.logger
              end

              # Service calls

              ##
              # Attaches a runtime project to the host project.
              #
              # @overload create_runtime_project_attachment(request, options = nil)
              #   Pass arguments to `create_runtime_project_attachment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateRuntimeProjectAttachmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateRuntimeProjectAttachmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_runtime_project_attachment(parent: nil, runtime_project_attachment_id: nil, runtime_project_attachment: nil)
              #   Pass arguments to `create_runtime_project_attachment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for the Runtime Project Attachment.
              #     Format: `projects/{project}/locations/{location}`
              #   @param runtime_project_attachment_id [::String]
              #     Required. The ID to use for the Runtime Project Attachment, which will
              #     become the final component of the Runtime Project Attachment's name. The ID
              #     must be the same as the project ID of the Google cloud project specified in
              #     the runtime_project_attachment.runtime_project field.
              #   @param runtime_project_attachment [::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment, ::Hash]
              #     Required. The Runtime Project Attachment to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateRuntimeProjectAttachmentRequest.new
              #
              #   # Call the create_runtime_project_attachment method.
              #   result = client.create_runtime_project_attachment request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::RuntimeProjectAttachment.
              #   p result
              #
              def create_runtime_project_attachment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateRuntimeProjectAttachmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_runtime_project_attachment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_runtime_project_attachment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_runtime_project_attachment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @runtime_project_attachment_service_stub.create_runtime_project_attachment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a runtime project attachment.
              #
              # @overload get_runtime_project_attachment(request, options = nil)
              #   Pass arguments to `get_runtime_project_attachment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetRuntimeProjectAttachmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetRuntimeProjectAttachmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_runtime_project_attachment(name: nil)
              #   Pass arguments to `get_runtime_project_attachment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the API resource to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetRuntimeProjectAttachmentRequest.new
              #
              #   # Call the get_runtime_project_attachment method.
              #   result = client.get_runtime_project_attachment request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::RuntimeProjectAttachment.
              #   p result
              #
              def get_runtime_project_attachment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetRuntimeProjectAttachmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_runtime_project_attachment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_runtime_project_attachment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_runtime_project_attachment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @runtime_project_attachment_service_stub.get_runtime_project_attachment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List runtime projects attached to the host project.
              #
              # @overload list_runtime_project_attachments(request, options = nil)
              #   Pass arguments to `list_runtime_project_attachments` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListRuntimeProjectAttachmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListRuntimeProjectAttachmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_runtime_project_attachments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_runtime_project_attachments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of runtime project
              #     attachments. Format: `projects/{project}/locations/{location}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of runtime project attachments to return. The
              #     service may return fewer than this value. If unspecified, at most 50
              #     runtime project attachments will be returned. The maximum value is 1000;
              #     values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `ListRuntimeProjectAttachments` call. Provide this to retrieve the
              #     subsequent page.
              #
              #     When paginating, all other parameters (except page_size) provided to
              #     `ListRuntimeProjectAttachments` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Optional. An expression that filters the list of RuntimeProjectAttachments.
              #
              #     A filter expression consists of a field name, a comparison
              #     operator, and a value for filtering. The value must be a string. All
              #     standard operators as documented at https://google.aip.dev/160 are
              #     supported.
              #
              #     The following fields in the `RuntimeProjectAttachment` are eligible for
              #     filtering:
              #
              #       * `name` - The name of the RuntimeProjectAttachment.
              #       * `create_time` - The time at which the RuntimeProjectAttachment was
              #       created. The value should be in the
              #       (RFC3339)[https://tools.ietf.org/html/rfc3339] format.
              #       * `runtime_project` - The Google cloud project associated with the
              #       RuntimeProjectAttachment.
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListRuntimeProjectAttachmentsRequest.new
              #
              #   # Call the list_runtime_project_attachments method.
              #   result = client.list_runtime_project_attachments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::RuntimeProjectAttachment.
              #     p item
              #   end
              #
              def list_runtime_project_attachments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListRuntimeProjectAttachmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_runtime_project_attachments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_runtime_project_attachments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_runtime_project_attachments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @runtime_project_attachment_service_stub.list_runtime_project_attachments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @runtime_project_attachment_service_stub, :list_runtime_project_attachments, "runtime_project_attachments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a runtime project attachment in the API Hub. This call will detach
              # the runtime project from the host project.
              #
              # @overload delete_runtime_project_attachment(request, options = nil)
              #   Pass arguments to `delete_runtime_project_attachment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteRuntimeProjectAttachmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteRuntimeProjectAttachmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_runtime_project_attachment(name: nil)
              #   Pass arguments to `delete_runtime_project_attachment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Runtime Project Attachment to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteRuntimeProjectAttachmentRequest.new
              #
              #   # Call the delete_runtime_project_attachment method.
              #   result = client.delete_runtime_project_attachment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_runtime_project_attachment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteRuntimeProjectAttachmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_runtime_project_attachment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_runtime_project_attachment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_runtime_project_attachment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @runtime_project_attachment_service_stub.delete_runtime_project_attachment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Look up a runtime project attachment. This API can be called in the context
              # of any project.
              #
              # @overload lookup_runtime_project_attachment(request, options = nil)
              #   Pass arguments to `lookup_runtime_project_attachment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::LookupRuntimeProjectAttachmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::LookupRuntimeProjectAttachmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload lookup_runtime_project_attachment(name: nil)
              #   Pass arguments to `lookup_runtime_project_attachment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Runtime project ID to look up runtime project attachment for.
              #     Lookup happens across all regions. Expected format:
              #     `projects/{project}/locations/{location}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::LookupRuntimeProjectAttachmentResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::LookupRuntimeProjectAttachmentResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::LookupRuntimeProjectAttachmentRequest.new
              #
              #   # Call the lookup_runtime_project_attachment method.
              #   result = client.lookup_runtime_project_attachment request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::LookupRuntimeProjectAttachmentResponse.
              #   p result
              #
              def lookup_runtime_project_attachment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::LookupRuntimeProjectAttachmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.lookup_runtime_project_attachment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.lookup_runtime_project_attachment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.lookup_runtime_project_attachment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @runtime_project_attachment_service_stub.lookup_runtime_project_attachment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the RuntimeProjectAttachmentService REST API.
              #
              # This class represents the configuration for RuntimeProjectAttachmentService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_runtime_project_attachment to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_runtime_project_attachment.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ApiHub::V1::RuntimeProjectAttachmentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_runtime_project_attachment.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "apihub.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the RuntimeProjectAttachmentService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_runtime_project_attachment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_runtime_project_attachment
                  ##
                  # RPC-specific configuration for `get_runtime_project_attachment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_runtime_project_attachment
                  ##
                  # RPC-specific configuration for `list_runtime_project_attachments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_runtime_project_attachments
                  ##
                  # RPC-specific configuration for `delete_runtime_project_attachment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_runtime_project_attachment
                  ##
                  # RPC-specific configuration for `lookup_runtime_project_attachment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :lookup_runtime_project_attachment

                  # @private
                  def initialize parent_rpcs = nil
                    create_runtime_project_attachment_config = parent_rpcs.create_runtime_project_attachment if parent_rpcs.respond_to? :create_runtime_project_attachment
                    @create_runtime_project_attachment = ::Gapic::Config::Method.new create_runtime_project_attachment_config
                    get_runtime_project_attachment_config = parent_rpcs.get_runtime_project_attachment if parent_rpcs.respond_to? :get_runtime_project_attachment
                    @get_runtime_project_attachment = ::Gapic::Config::Method.new get_runtime_project_attachment_config
                    list_runtime_project_attachments_config = parent_rpcs.list_runtime_project_attachments if parent_rpcs.respond_to? :list_runtime_project_attachments
                    @list_runtime_project_attachments = ::Gapic::Config::Method.new list_runtime_project_attachments_config
                    delete_runtime_project_attachment_config = parent_rpcs.delete_runtime_project_attachment if parent_rpcs.respond_to? :delete_runtime_project_attachment
                    @delete_runtime_project_attachment = ::Gapic::Config::Method.new delete_runtime_project_attachment_config
                    lookup_runtime_project_attachment_config = parent_rpcs.lookup_runtime_project_attachment if parent_rpcs.respond_to? :lookup_runtime_project_attachment
                    @lookup_runtime_project_attachment = ::Gapic::Config::Method.new lookup_runtime_project_attachment_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
