# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ApiHub
      module V1
        module LintingService
          # Path helper methods for the LintingService API.
          module Paths
            ##
            # Create a fully-qualified Spec resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
            #
            # @param project [String]
            # @param location [String]
            # @param api [String]
            # @param version [String]
            # @param spec [String]
            #
            # @return [::String]
            def spec_path project:, location:, api:, version:, spec:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "api cannot contain /" if api.to_s.include? "/"
              raise ::ArgumentError, "version cannot contain /" if version.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apis/#{api}/versions/#{version}/specs/#{spec}"
            end

            ##
            # Create a fully-qualified StyleGuide resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`
            #
            # @param project [String]
            # @param location [String]
            # @param plugin [String]
            #
            # @return [::String]
            def style_guide_path project:, location:, plugin:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/plugins/#{plugin}/styleGuide"
            end

            extend self
          end
        end
      end
    end
  end
end
