# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/apihub/v1/apihub_service_pb"
require "google/cloud/api_hub/v1/api_hub_dependencies/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module ApiHub
      module V1
        module ApiHubDependencies
          module Rest
            ##
            # REST client for the ApiHubDependencies service.
            #
            # This service provides methods for various operations related to a
            # {::Google::Cloud::ApiHub::V1::Dependency Dependency} in the API hub.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "apihub.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :api_hub_dependencies_stub

              ##
              # Configure the ApiHubDependencies Client class.
              #
              # See {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ApiHubDependencies clients
              #   ::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ApiHub", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_dependency.timeout = 60.0

                  default_config.rpcs.get_dependency.timeout = 60.0
                  default_config.rpcs.get_dependency.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_dependency.timeout = 60.0

                  default_config.rpcs.delete_dependency.timeout = 60.0

                  default_config.rpcs.list_dependencies.timeout = 60.0
                  default_config.rpcs.list_dependencies.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ApiHubDependencies Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @api_hub_dependencies_stub.universe_domain
              end

              ##
              # Create a new ApiHubDependencies REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ApiHubDependencies client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @api_hub_dependencies_stub = ::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @api_hub_dependencies_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @api_hub_dependencies_stub.endpoint
                  config.universe_domain = @api_hub_dependencies_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @api_hub_dependencies_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @api_hub_dependencies_stub.logger
              end

              # Service calls

              ##
              # Create a dependency between two entities in the API hub.
              #
              # @overload create_dependency(request, options = nil)
              #   Pass arguments to `create_dependency` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateDependencyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateDependencyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_dependency(parent: nil, dependency_id: nil, dependency: nil)
              #   Pass arguments to `create_dependency` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for the dependency resource.
              #     Format: `projects/{project}/locations/{location}`
              #   @param dependency_id [::String]
              #     Optional. The ID to use for the dependency resource, which will become the
              #     final component of the dependency's resource name. This field is optional.
              #     * If provided, the same will be used. The service will throw an error if
              #     duplicate id is provided by the client.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, and valid characters
              #     are `[a-z][A-Z][0-9]-_`.
              #   @param dependency [::Google::Cloud::ApiHub::V1::Dependency, ::Hash]
              #     Required. The dependency resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Dependency]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Dependency]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateDependencyRequest.new
              #
              #   # Call the create_dependency method.
              #   result = client.create_dependency request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Dependency.
              #   p result
              #
              def create_dependency request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateDependencyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_dependency.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_dependency.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_dependency.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_dependencies_stub.create_dependency request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about a dependency resource in the API hub.
              #
              # @overload get_dependency(request, options = nil)
              #   Pass arguments to `get_dependency` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetDependencyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetDependencyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_dependency(name: nil)
              #   Pass arguments to `get_dependency` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the dependency resource to retrieve.
              #     Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Dependency]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Dependency]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetDependencyRequest.new
              #
              #   # Call the get_dependency method.
              #   result = client.get_dependency request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Dependency.
              #   p result
              #
              def get_dependency request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetDependencyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_dependency.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_dependency.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_dependency.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_dependencies_stub.get_dependency request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a dependency based on the
              # {::Google::Cloud::ApiHub::V1::UpdateDependencyRequest#update_mask update_mask}
              # provided in the request.
              #
              # The following fields in the {::Google::Cloud::ApiHub::V1::Dependency dependency}
              # can be updated:
              # * {::Google::Cloud::ApiHub::V1::Dependency#description description}
              #
              # @overload update_dependency(request, options = nil)
              #   Pass arguments to `update_dependency` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateDependencyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateDependencyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_dependency(dependency: nil, update_mask: nil)
              #   Pass arguments to `update_dependency` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dependency [::Google::Cloud::ApiHub::V1::Dependency, ::Hash]
              #     Required. The dependency resource to update.
              #
              #     The dependency's `name` field is used to identify the dependency to update.
              #     Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Dependency]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Dependency]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateDependencyRequest.new
              #
              #   # Call the update_dependency method.
              #   result = client.update_dependency request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Dependency.
              #   p result
              #
              def update_dependency request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateDependencyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_dependency.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_dependency.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_dependency.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_dependencies_stub.update_dependency request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete the dependency resource.
              #
              # @overload delete_dependency(request, options = nil)
              #   Pass arguments to `delete_dependency` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteDependencyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteDependencyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_dependency(name: nil)
              #   Pass arguments to `delete_dependency` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the dependency resource to delete.
              #     Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteDependencyRequest.new
              #
              #   # Call the delete_dependency method.
              #   result = client.delete_dependency request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_dependency request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteDependencyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_dependency.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_dependency.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_dependency.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_dependencies_stub.delete_dependency request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List dependencies based on the provided filter and pagination parameters.
              #
              # @overload list_dependencies(request, options = nil)
              #   Pass arguments to `list_dependencies` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListDependenciesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListDependenciesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_dependencies(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_dependencies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent which owns this collection of dependency resources.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Optional. An expression that filters the list of Dependencies.
              #
              #     A filter expression consists of a field name, a comparison operator, and
              #     a value for filtering. The value must be a string. Allowed comparison
              #     operator is `=`. Filters are not case sensitive.
              #
              #     The following fields in the `Dependency` are eligible for filtering:
              #
              #       * `consumer.operation_resource_name` - The operation resource name for
              #       the consumer entity involved in a dependency. Allowed comparison
              #       operators: `=`.
              #       * `consumer.external_api_resource_name` - The external api resource name
              #       for the consumer entity involved in a dependency. Allowed comparison
              #       operators: `=`.
              #       * `supplier.operation_resource_name` - The operation resource name for
              #       the supplier entity involved in a dependency. Allowed comparison
              #       operators: `=`.
              #       * `supplier.external_api_resource_name` - The external api resource name
              #       for the supplier entity involved in a dependency. Allowed comparison
              #       operators: `=`.
              #
              #     Expressions are combined with either `AND` logic operator or `OR` logical
              #     operator but not both of them together i.e. only one of the `AND` or `OR`
              #     operator can be used throughout the filter string and both the operators
              #     cannot be used together. No other logical operators are supported. At most
              #     three filter fields are allowed in the filter string and if provided
              #     more than that then `INVALID_ARGUMENT` error is returned by the API.
              #
              #     For example, `consumer.operation_resource_name =
              #     \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\" OR
              #     supplier.operation_resource_name =
              #     \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\"` - The
              #     dependencies with either consumer or supplier operation resource name as
              #     _projects/p1/locations/global/apis/a1/versions/v1/operations/o1_.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of dependency resources to return. The service
              #     may return fewer than this value. If unspecified, at most 50 dependencies
              #     will be returned. The maximum value is 1000; values above 1000 will be
              #     coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListDependencies` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListDependencies` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Dependency>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Dependency>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListDependenciesRequest.new
              #
              #   # Call the list_dependencies method.
              #   result = client.list_dependencies request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::Dependency.
              #     p item
              #   end
              #
              def list_dependencies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListDependenciesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_dependencies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_dependencies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_dependencies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_dependencies_stub.list_dependencies request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_dependencies_stub, :list_dependencies, "dependencies", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ApiHubDependencies REST API.
              #
              # This class represents the configuration for ApiHubDependencies REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_dependency to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_dependency.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ApiHub::V1::ApiHubDependencies::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_dependency.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "apihub.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ApiHubDependencies API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_dependency`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_dependency
                  ##
                  # RPC-specific configuration for `get_dependency`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dependency
                  ##
                  # RPC-specific configuration for `update_dependency`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_dependency
                  ##
                  # RPC-specific configuration for `delete_dependency`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_dependency
                  ##
                  # RPC-specific configuration for `list_dependencies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_dependencies

                  # @private
                  def initialize parent_rpcs = nil
                    create_dependency_config = parent_rpcs.create_dependency if parent_rpcs.respond_to? :create_dependency
                    @create_dependency = ::Gapic::Config::Method.new create_dependency_config
                    get_dependency_config = parent_rpcs.get_dependency if parent_rpcs.respond_to? :get_dependency
                    @get_dependency = ::Gapic::Config::Method.new get_dependency_config
                    update_dependency_config = parent_rpcs.update_dependency if parent_rpcs.respond_to? :update_dependency
                    @update_dependency = ::Gapic::Config::Method.new update_dependency_config
                    delete_dependency_config = parent_rpcs.delete_dependency if parent_rpcs.respond_to? :delete_dependency
                    @delete_dependency = ::Gapic::Config::Method.new delete_dependency_config
                    list_dependencies_config = parent_rpcs.list_dependencies if parent_rpcs.respond_to? :list_dependencies
                    @list_dependencies = ::Gapic::Config::Method.new list_dependencies_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
