# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/apihub/v1/apihub_service_pb"
require "google/cloud/api_hub/v1/api_hub/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module ApiHub
      module V1
        module ApiHub
          module Rest
            ##
            # REST client for the ApiHub service.
            #
            # This service provides all methods related to the API hub.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "apihub.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :api_hub_stub

              ##
              # Configure the ApiHub Client class.
              #
              # See {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ApiHub clients
              #   ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ApiHub", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_api.timeout = 60.0

                  default_config.rpcs.get_api.timeout = 60.0
                  default_config.rpcs.get_api.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_apis.timeout = 60.0
                  default_config.rpcs.list_apis.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_api.timeout = 60.0

                  default_config.rpcs.delete_api.timeout = 300.0

                  default_config.rpcs.create_version.timeout = 60.0

                  default_config.rpcs.get_version.timeout = 60.0
                  default_config.rpcs.get_version.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_versions.timeout = 60.0
                  default_config.rpcs.list_versions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_version.timeout = 60.0

                  default_config.rpcs.delete_version.timeout = 300.0

                  default_config.rpcs.create_spec.timeout = 60.0

                  default_config.rpcs.get_spec.timeout = 60.0
                  default_config.rpcs.get_spec.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_spec_contents.timeout = 60.0
                  default_config.rpcs.get_spec_contents.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_specs.timeout = 60.0
                  default_config.rpcs.list_specs.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_spec.timeout = 60.0

                  default_config.rpcs.delete_spec.timeout = 300.0

                  default_config.rpcs.get_api_operation.timeout = 60.0
                  default_config.rpcs.get_api_operation.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_api_operations.timeout = 60.0
                  default_config.rpcs.list_api_operations.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_definition.timeout = 60.0
                  default_config.rpcs.get_definition.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_deployment.timeout = 60.0

                  default_config.rpcs.get_deployment.timeout = 60.0
                  default_config.rpcs.get_deployment.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_deployments.timeout = 60.0
                  default_config.rpcs.list_deployments.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_deployment.timeout = 60.0

                  default_config.rpcs.delete_deployment.timeout = 60.0

                  default_config.rpcs.create_attribute.timeout = 60.0

                  default_config.rpcs.get_attribute.timeout = 60.0
                  default_config.rpcs.get_attribute.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_attribute.timeout = 60.0

                  default_config.rpcs.delete_attribute.timeout = 60.0

                  default_config.rpcs.list_attributes.timeout = 60.0
                  default_config.rpcs.list_attributes.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.search_resources.timeout = 60.0
                  default_config.rpcs.search_resources.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_external_api.timeout = 60.0

                  default_config.rpcs.get_external_api.timeout = 60.0
                  default_config.rpcs.get_external_api.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_external_api.timeout = 60.0

                  default_config.rpcs.delete_external_api.timeout = 60.0

                  default_config.rpcs.list_external_apis.timeout = 60.0
                  default_config.rpcs.list_external_apis.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ApiHub Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @api_hub_stub.universe_domain
              end

              ##
              # Create a new ApiHub REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ApiHub client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @api_hub_stub = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @api_hub_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @api_hub_stub.endpoint
                  config.universe_domain = @api_hub_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @api_hub_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @api_hub_stub.logger
              end

              # Service calls

              ##
              # Create an API resource in the API hub.
              # Once an API resource is created, versions can be added to it.
              #
              # @overload create_api(request, options = nil)
              #   Pass arguments to `create_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_api(parent: nil, api_id: nil, api: nil)
              #   Pass arguments to `create_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for the API resource.
              #     Format: `projects/{project}/locations/{location}`
              #   @param api_id [::String]
              #     Optional. The ID to use for the API resource, which will become the final
              #     component of the API's resource name. This field is optional.
              #
              #     * If provided, the same will be used. The service will throw an error if
              #     the specified id is already used by another API resource in the API hub.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, and valid characters
              #     are /[a-z][A-Z][0-9]-_/.
              #   @param api [::Google::Cloud::ApiHub::V1::Api, ::Hash]
              #     Required. The API resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Api]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Api]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateApiRequest.new
              #
              #   # Call the create_api method.
              #   result = client.create_api request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Api.
              #   p result
              #
              def create_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.create_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get API resource details including the API versions contained in it.
              #
              # @overload get_api(request, options = nil)
              #   Pass arguments to `get_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_api(name: nil)
              #   Pass arguments to `get_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the API resource to retrieve.
              #     Format: `projects/{project}/locations/{location}/apis/{api}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Api]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Api]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetApiRequest.new
              #
              #   # Call the get_api method.
              #   result = client.get_api request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Api.
              #   p result
              #
              def get_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List API resources in the API hub.
              #
              # @overload list_apis(request, options = nil)
              #   Pass arguments to `list_apis` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListApisRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListApisRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_apis(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_apis` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of API resources.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Optional. An expression that filters the list of ApiResources.
              #
              #     A filter expression consists of a field name, a comparison
              #     operator, and a value for filtering. The value must be a string. The
              #     comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are not
              #     case sensitive.
              #
              #     The following fields in the `ApiResource` are eligible for filtering:
              #
              #       * `owner.email` - The email of the team which owns the ApiResource.
              #       Allowed comparison operators: `=`.
              #       * `create_time` - The time at which the ApiResource was created. The
              #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
              #       format. Allowed comparison operators: `>` and `<`.
              #       * `display_name` - The display name of the ApiResource. Allowed
              #       comparison operators: `=`.
              #       * `target_user.enum_values.values.id` - The allowed value id of the
              #       target users attribute associated with the ApiResource. Allowed
              #       comparison operator is `:`.
              #       * `target_user.enum_values.values.display_name` - The allowed value
              #       display name of the target users attribute associated with the
              #       ApiResource. Allowed comparison operator is `:`.
              #       * `team.enum_values.values.id` - The allowed value id of the team
              #       attribute associated with the ApiResource. Allowed comparison operator is
              #       `:`.
              #       * `team.enum_values.values.display_name` - The allowed value display name
              #       of the team attribute associated with the ApiResource. Allowed comparison
              #       operator is `:`.
              #       * `business_unit.enum_values.values.id` - The allowed value id of the
              #       business unit attribute associated with the ApiResource. Allowed
              #       comparison operator is `:`.
              #       * `business_unit.enum_values.values.display_name` - The allowed value
              #       display name of the business unit attribute associated with the
              #       ApiResource. Allowed comparison operator is `:`.
              #       * `maturity_level.enum_values.values.id` - The allowed value id of the
              #       maturity level attribute associated with the ApiResource. Allowed
              #       comparison operator is `:`.
              #       * `maturity_level.enum_values.values.display_name` - The allowed value
              #       display name of the maturity level attribute associated with the
              #       ApiResource. Allowed comparison operator is `:`.
              #       * `api_style.enum_values.values.id` - The allowed value id of the
              #       api style attribute associated with the ApiResource. Allowed
              #       comparison operator is `:`.
              #       * `api_style.enum_values.values.display_name` - The allowed value display
              #       name of the api style attribute associated with the ApiResource. Allowed
              #       comparison operator is `:`.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.id` - The
              #       allowed value id of the user defined enum attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-id is a placeholder that can be replaced with
              #       any user defined enum attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.display_name`
              #       - The allowed value display name of the user defined enum attribute
              #       associated with the Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-display-name is a placeholder that can be
              #       replaced with any user defined enum attribute enum name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.string_values.values` - The
              #       allowed value of the user defined string attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-string is a placeholder that can be replaced with
              #       any user defined string attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.json_values.values` - The
              #       allowed value of the user defined JSON attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-json is a placeholder that can be replaced with
              #       any user defined JSON attribute name.
              #
              #     A filter function is also supported in the filter string. The filter
              #     function is `id(name)`. The `id(name)` function returns the id of the
              #     resource name. For example, `id(name) = \"api-1\"` is equivalent to
              #     `name = \"projects/test-project-id/locations/test-location-id/apis/api-1\"`
              #     provided the parent is
              #     `projects/test-project-id/locations/test-location-id`.
              #
              #     Expressions are combined with either `AND` logic operator or `OR` logical
              #     operator but not both of them together i.e. only one of the `AND` or `OR`
              #     operator can be used throughout the filter string and both the operators
              #     cannot be used together. No other logical operators are supported. At most
              #     three filter fields are allowed in the filter string and if provided
              #     more than that then `INVALID_ARGUMENT` error is returned by the API.
              #
              #     Here are a few examples:
              #
              #       * `owner.email = \"apihub@google.com\"` -  - The owner team email is
              #       _apihub@google.com_.
              #       * `owner.email = \"apihub@google.com\" AND create_time <
              #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
              #       The owner team email is _apihub@google.com_ and the api was created
              #       before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
              #       * `owner.email = \"apihub@google.com\" OR team.enum_values.values.id:
              #       apihub-team-id` - The filter string specifies the APIs where the owner
              #       team email is _apihub@google.com_ or the id of the allowed value
              #       associated with the team attribute is _apihub-team-id_.
              #       * `owner.email = \"apihub@google.com\" OR
              #       team.enum_values.values.display_name: ApiHub Team` - The filter string
              #       specifies the APIs where the owner team email is _apihub@google.com_ or
              #       the display name of the allowed value associated with the team attribute
              #       is `ApiHub Team`.
              #       * `owner.email = \"apihub@google.com\" AND
              #       attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.enum_values.values.id:
              #       test_enum_id AND
              #       attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/1765\0f90-4a29-5431-b3d0-d5532da3764c.string_values.values:
              #       test_string_value`  - The filter string specifies the APIs where the
              #       owner team email is _apihub@google.com_ and the id of the allowed value
              #       associated with the user defined attribute of type enum is _test_enum_id_
              #       and the value of the user defined attribute of type string is _test_..
              #   @param page_size [::Integer]
              #     Optional. The maximum number of API resources to return. The service may
              #     return fewer than this value. If unspecified, at most 50 Apis will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListApis` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters (except page_size) provided to
              #     `ListApis` must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Api>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Api>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListApisRequest.new
              #
              #   # Call the list_apis method.
              #   result = client.list_apis request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::Api.
              #     p item
              #   end
              #
              def list_apis request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListApisRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_apis.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_apis.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_apis.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.list_apis request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :list_apis, "apis", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update an API resource in the API hub. The following fields in the
              # {::Google::Cloud::ApiHub::V1::Api API} can be updated:
              #
              # * {::Google::Cloud::ApiHub::V1::Api#display_name display_name}
              # * {::Google::Cloud::ApiHub::V1::Api#description description}
              # * {::Google::Cloud::ApiHub::V1::Api#owner owner}
              # * {::Google::Cloud::ApiHub::V1::Api#documentation documentation}
              # * {::Google::Cloud::ApiHub::V1::Api#target_user target_user}
              # * {::Google::Cloud::ApiHub::V1::Api#team team}
              # * {::Google::Cloud::ApiHub::V1::Api#business_unit business_unit}
              # * {::Google::Cloud::ApiHub::V1::Api#maturity_level maturity_level}
              # * {::Google::Cloud::ApiHub::V1::Api#api_style api_style}
              # * {::Google::Cloud::ApiHub::V1::Api#attributes attributes}
              #
              # The
              # {::Google::Cloud::ApiHub::V1::UpdateApiRequest#update_mask update_mask}
              # should be used to specify the fields being updated.
              #
              # Updating the owner field requires complete owner message
              # and updates both owner and email fields.
              #
              # @overload update_api(request, options = nil)
              #   Pass arguments to `update_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_api(api: nil, update_mask: nil)
              #   Pass arguments to `update_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param api [::Google::Cloud::ApiHub::V1::Api, ::Hash]
              #     Required. The API resource to update.
              #
              #     The API resource's `name` field is used to identify the API resource to
              #     update.
              #     Format: `projects/{project}/locations/{location}/apis/{api}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Api]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Api]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateApiRequest.new
              #
              #   # Call the update_api method.
              #   result = client.update_api request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Api.
              #   p result
              #
              def update_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.update_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an API resource in the API hub. API can only be deleted if all
              # underlying versions are deleted.
              #
              # @overload delete_api(request, options = nil)
              #   Pass arguments to `delete_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api(name: nil, force: nil)
              #   Pass arguments to `delete_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the API resource to delete.
              #     Format: `projects/{project}/locations/{location}/apis/{api}`
              #   @param force [::Boolean]
              #     Optional. If set to true, any versions from this API will also be deleted.
              #     Otherwise, the request will only work if the API has no versions.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteApiRequest.new
              #
              #   # Call the delete_api method.
              #   result = client.delete_api request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.delete_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create an API version for an API resource in the API hub.
              #
              # @overload create_version(request, options = nil)
              #   Pass arguments to `create_version` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_version(parent: nil, version_id: nil, version: nil)
              #   Pass arguments to `create_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for API version.
              #     Format: `projects/{project}/locations/{location}/apis/{api}`
              #   @param version_id [::String]
              #     Optional. The ID to use for the API version, which will become the final
              #     component of the version's resource name. This field is optional.
              #
              #     * If provided, the same will be used. The service will throw an error if
              #     the specified id is already used by another version in the API resource.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, overall resource name which will be
              #     of format
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`,
              #     its length is limited to 700 characters and valid characters are
              #     /[a-z][A-Z][0-9]-_/.
              #   @param version [::Google::Cloud::ApiHub::V1::Version, ::Hash]
              #     Required. The version to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Version]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Version]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateVersionRequest.new
              #
              #   # Call the create_version method.
              #   result = client.create_version request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Version.
              #   p result
              #
              def create_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.create_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about the API version of an API resource. This will include
              # information about the specs and operations present in the API
              # version as well as the deployments linked to it.
              #
              # @overload get_version(request, options = nil)
              #   Pass arguments to `get_version` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_version(name: nil)
              #   Pass arguments to `get_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the API version to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Version]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Version]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetVersionRequest.new
              #
              #   # Call the get_version method.
              #   result = client.get_version request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Version.
              #   p result
              #
              def get_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List API versions of an API resource in the API hub.
              #
              # @overload list_versions(request, options = nil)
              #   Pass arguments to `list_versions` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_versions(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent which owns this collection of API versions i.e., the
              #     API resource Format: `projects/{project}/locations/{location}/apis/{api}`
              #   @param filter [::String]
              #     Optional. An expression that filters the list of Versions.
              #
              #     A filter expression consists of a field name, a comparison
              #     operator, and a value for filtering. The value must be a string, a
              #     number, or a boolean. The comparison operator must be one of: `<`, `>` or
              #     `=`. Filters are not case sensitive.
              #
              #     The following fields in the `Version` are eligible for filtering:
              #
              #       * `display_name` - The display name of the Version. Allowed
              #       comparison operators: `=`.
              #       * `create_time` - The time at which the Version was created. The
              #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
              #       format. Allowed comparison operators: `>` and `<`.
              #       * `lifecycle.enum_values.values.id` - The allowed value id of the
              #       lifecycle attribute associated with the Version. Allowed comparison
              #       operators: `:`.
              #       * `lifecycle.enum_values.values.display_name` - The allowed value display
              #       name of the lifecycle attribute associated with the Version. Allowed
              #       comparison operators: `:`.
              #       * `compliance.enum_values.values.id` -  The allowed value id of the
              #       compliances attribute associated with the Version. Allowed comparison
              #       operators: `:`.
              #       * `compliance.enum_values.values.display_name` -  The allowed value
              #       display name of the compliances attribute associated with the Version.
              #       Allowed comparison operators: `:`.
              #       * `accreditation.enum_values.values.id` - The allowed value id of the
              #       accreditations attribute associated with the Version. Allowed
              #       comparison operators: `:`.
              #       * `accreditation.enum_values.values.display_name` - The allowed value
              #       display name of the accreditations attribute associated with the Version.
              #       Allowed comparison operators: `:`.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.id` - The
              #       allowed value id of the user defined enum attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-id is a placeholder that can be replaced with
              #       any user defined enum attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.display_name`
              #       - The allowed value display name of the user defined enum attribute
              #       associated with the Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-display-name is a placeholder that can be
              #       replaced with any user defined enum attribute enum name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.string_values.values` - The
              #       allowed value of the user defined string attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-string is a placeholder that can be replaced with
              #       any user defined string attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.json_values.values` - The
              #       allowed value of the user defined JSON attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-json is a placeholder that can be replaced with
              #       any user defined JSON attribute name.
              #
              #     Expressions are combined with either `AND` logic operator or `OR` logical
              #     operator but not both of them together i.e. only one of the `AND` or `OR`
              #     operator can be used throughout the filter string and both the operators
              #     cannot be used together. No other logical operators are
              #     supported. At most three filter fields are allowed in the filter
              #     string and if provided more than that then `INVALID_ARGUMENT` error is
              #     returned by the API.
              #
              #     Here are a few examples:
              #
              #       * `lifecycle.enum_values.values.id: preview-id` - The filter string
              #       specifies that the id of the allowed value associated with the lifecycle
              #       attribute of the Version is _preview-id_.
              #       * `lifecycle.enum_values.values.display_name: \"Preview Display Name\"` -
              #       The filter string specifies that the display name of the allowed value
              #       associated with the lifecycle attribute of the Version is `Preview
              #       Display Name`.
              #       * `lifecycle.enum_values.values.id: preview-id AND create_time <
              #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
              #       The id of the allowed value associated with the lifecycle attribute of
              #       the Version is _preview-id_ and it was created before _2021-08-15
              #       14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
              #       * `compliance.enum_values.values.id: gdpr-id OR
              #       compliance.enum_values.values.id: pci-dss-id`
              #       - The id of the allowed value associated with the compliance attribute is
              #       _gdpr-id_ or _pci-dss-id_.
              #       * `lifecycle.enum_values.values.id: preview-id AND
              #       attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values:
              #       test`  - The filter string specifies that the id of the allowed value
              #       associated with the lifecycle attribute of the Version is _preview-id_
              #       and the value of the user defined attribute of type string is _test_.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of versions to return. The service may return
              #     fewer than this value. If unspecified, at most 50 versions will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListVersions` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters (except page_size) provided to
              #     `ListVersions` must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Version>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Version>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListVersionsRequest.new
              #
              #   # Call the list_versions method.
              #   result = client.list_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::Version.
              #     p item
              #   end
              #
              def list_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.list_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :list_versions, "versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update API version. The following fields in the
              # {::Google::Cloud::ApiHub::V1::Version version} can be updated currently:
              #
              # * {::Google::Cloud::ApiHub::V1::Version#display_name display_name}
              # * {::Google::Cloud::ApiHub::V1::Version#description description}
              # * {::Google::Cloud::ApiHub::V1::Version#documentation documentation}
              # * {::Google::Cloud::ApiHub::V1::Version#deployments deployments}
              # * {::Google::Cloud::ApiHub::V1::Version#lifecycle lifecycle}
              # * {::Google::Cloud::ApiHub::V1::Version#compliance compliance}
              # * {::Google::Cloud::ApiHub::V1::Version#accreditation accreditation}
              # * {::Google::Cloud::ApiHub::V1::Version#attributes attributes}
              #
              # The
              # {::Google::Cloud::ApiHub::V1::UpdateVersionRequest#update_mask update_mask}
              # should be used to specify the fields being updated.
              #
              # @overload update_version(request, options = nil)
              #   Pass arguments to `update_version` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_version(version: nil, update_mask: nil)
              #   Pass arguments to `update_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param version [::Google::Cloud::ApiHub::V1::Version, ::Hash]
              #     Required. The API version to update.
              #
              #     The version's `name` field is used to identify the API version to update.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Version]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Version]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateVersionRequest.new
              #
              #   # Call the update_version method.
              #   result = client.update_version request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Version.
              #   p result
              #
              def update_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.update_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an API version. Version can only be deleted if all underlying specs,
              # operations, definitions and linked deployments are deleted.
              #
              # @overload delete_version(request, options = nil)
              #   Pass arguments to `delete_version` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_version(name: nil, force: nil)
              #   Pass arguments to `delete_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the version to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
              #   @param force [::Boolean]
              #     Optional. If set to true, any specs from this version will also be deleted.
              #     Otherwise, the request will only work if the version has no specs.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteVersionRequest.new
              #
              #   # Call the delete_version method.
              #   result = client.delete_version request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.delete_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Add a spec to an API version in the API hub.
              # Multiple specs can be added to an API version.
              # Note, while adding a spec, at least one of `contents` or `source_uri` must
              # be provided. If `contents` is provided, then `spec_type` must also be
              # provided.
              #
              # On adding a spec with contents to the version, the operations present in it
              # will be added to the version.Note that the file contents in the spec should
              # be of the same type as defined in the
              # `projects/{project}/locations/{location}/attributes/system-spec-type`
              # attribute associated with spec resource. Note that specs of various types
              # can be uploaded, however parsing of details is supported for OpenAPI spec
              # currently.
              #
              # In order to access the information parsed from the spec, use the
              # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_spec GetSpec} method.
              # In order to access the raw contents for a particular spec, use the
              # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_spec_contents GetSpecContents} method.
              # In order to access the operations parsed from the spec, use the
              # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_api_operations ListAPIOperations}
              # method.
              #
              # @overload create_spec(request, options = nil)
              #   Pass arguments to `create_spec` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_spec(parent: nil, spec_id: nil, spec: nil)
              #   Pass arguments to `create_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for Spec.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
              #   @param spec_id [::String]
              #     Optional. The ID to use for the spec, which will become the final component
              #     of the spec's resource name. This field is optional.
              #
              #     * If provided, the same will be used. The service will throw an error if
              #     the specified id is already used by another spec in the API
              #     resource.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, overall resource name which will be
              #     of format
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`,
              #     its length is limited to 1000 characters and valid characters are
              #     /[a-z][A-Z][0-9]-_/.
              #   @param spec [::Google::Cloud::ApiHub::V1::Spec, ::Hash]
              #     Required. The spec to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Spec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Spec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateSpecRequest.new
              #
              #   # Call the create_spec method.
              #   result = client.create_spec request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Spec.
              #   p result
              #
              def create_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.create_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about the information parsed from a spec.
              # Note that this method does not return the raw spec contents.
              # Use {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#get_spec_contents GetSpecContents} method
              # to retrieve the same.
              #
              # @overload get_spec(request, options = nil)
              #   Pass arguments to `get_spec` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_spec(name: nil)
              #   Pass arguments to `get_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Spec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Spec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetSpecRequest.new
              #
              #   # Call the get_spec method.
              #   result = client.get_spec request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Spec.
              #   p result
              #
              def get_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get spec contents.
              #
              # @overload get_spec_contents(request, options = nil)
              #   Pass arguments to `get_spec_contents` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetSpecContentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetSpecContentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_spec_contents(name: nil)
              #   Pass arguments to `get_spec_contents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec whose contents need to be retrieved.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::SpecContents]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::SpecContents]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetSpecContentsRequest.new
              #
              #   # Call the get_spec_contents method.
              #   result = client.get_spec_contents request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::SpecContents.
              #   p result
              #
              def get_spec_contents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetSpecContentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_spec_contents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_spec_contents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_spec_contents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_spec_contents request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List specs corresponding to a particular API resource.
              #
              # @overload list_specs(request, options = nil)
              #   Pass arguments to `list_specs` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListSpecsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListSpecsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_specs(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_specs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of specs.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
              #   @param filter [::String]
              #     Optional. An expression that filters the list of Specs.
              #
              #     A filter expression consists of a field name, a comparison
              #     operator, and a value for filtering. The value must be a string. The
              #     comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are not
              #     case sensitive.
              #
              #     The following fields in the `Spec` are eligible for filtering:
              #
              #       * `display_name` - The display name of the Spec. Allowed comparison
              #       operators: `=`.
              #       * `create_time` - The time at which the Spec was created. The
              #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
              #       format. Allowed comparison operators: `>` and `<`.
              #       * `spec_type.enum_values.values.id` - The allowed value id of the
              #       spec_type attribute associated with the Spec. Allowed comparison
              #       operators: `:`.
              #       * `spec_type.enum_values.values.display_name` - The allowed value display
              #       name of the spec_type attribute associated with the Spec. Allowed
              #       comparison operators: `:`.
              #       * `lint_response.json_values.values` - The json value of the
              #       lint_response attribute associated with the Spec. Allowed comparison
              #       operators: `:`.
              #       * `mime_type` - The MIME type of the Spec. Allowed comparison
              #       operators: `=`.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.id` - The
              #       allowed value id of the user defined enum attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-id is a placeholder that can be replaced with
              #       any user defined enum attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.display_name`
              #       - The allowed value display name of the user defined enum attribute
              #       associated with the Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-display-name is a placeholder that can be
              #       replaced with any user defined enum attribute enum name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.string_values.values` - The
              #       allowed value of the user defined string attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-string is a placeholder that can be replaced with
              #       any user defined string attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.json_values.values` - The
              #       allowed value of the user defined JSON attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-json is a placeholder that can be replaced with
              #       any user defined JSON attribute name.
              #
              #     Expressions are combined with either `AND` logic operator or `OR` logical
              #     operator but not both of them together i.e. only one of the `AND` or `OR`
              #     operator can be used throughout the filter string and both the operators
              #     cannot be used together. No other logical operators are
              #     supported. At most three filter fields are allowed in the filter
              #     string and if provided more than that then `INVALID_ARGUMENT` error is
              #     returned by the API.
              #
              #     Here are a few examples:
              #
              #       * `spec_type.enum_values.values.id: rest-id` -  The filter
              #       string specifies that the id of the allowed value associated with the
              #       spec_type attribute is _rest-id_.
              #       * `spec_type.enum_values.values.display_name: \"Rest Display Name\"` -
              #       The filter string specifies that the display name of the allowed value
              #       associated with the spec_type attribute is `Rest Display Name`.
              #       * `spec_type.enum_values.values.id: grpc-id AND create_time <
              #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
              #       The id of the allowed value associated with the spec_type attribute is
              #       _grpc-id_ and the spec was created before _2021-08-15 14:50:00 UTC_ and
              #       after _2021-08-10 12:00:00 UTC_.
              #       * `spec_type.enum_values.values.id: rest-id OR
              #       spec_type.enum_values.values.id: grpc-id`
              #       - The id of the allowed value associated with the spec_type attribute is
              #       _rest-id_ or _grpc-id_.
              #       * `spec_type.enum_values.values.id: rest-id AND
              #       attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.enum_values.values.id:
              #       test`  - The filter string specifies that the id of the allowed value
              #       associated with the spec_type attribute is _rest-id_ and the id of the
              #       allowed value associated with the user defined attribute of type enum is
              #       _test_.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of specs to return. The service may return
              #     fewer than this value. If unspecified, at most 50 specs will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListSpecs` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListSpecs` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Spec>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Spec>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListSpecsRequest.new
              #
              #   # Call the list_specs method.
              #   result = client.list_specs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::Spec.
              #     p item
              #   end
              #
              def list_specs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListSpecsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_specs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_specs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_specs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.list_specs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :list_specs, "specs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update spec. The following fields in the
              # {::Google::Cloud::ApiHub::V1::Spec spec} can be updated:
              #
              # * {::Google::Cloud::ApiHub::V1::Spec#display_name display_name}
              # * {::Google::Cloud::ApiHub::V1::Spec#source_uri source_uri}
              # * {::Google::Cloud::ApiHub::V1::Spec#lint_response lint_response}
              # * {::Google::Cloud::ApiHub::V1::Spec#attributes attributes}
              # * {::Google::Cloud::ApiHub::V1::Spec#contents contents}
              # * {::Google::Cloud::ApiHub::V1::Spec#spec_type spec_type}
              #
              # In case of an OAS spec, updating spec contents can lead to:
              # 1. Creation, deletion and update of operations.
              # 2. Creation, deletion and update of definitions.
              # 3. Update of other info parsed out from the new spec.
              #
              # In case of contents or source_uri being present in update mask, spec_type
              # must also be present. Also, spec_type can not be present in update mask if
              # contents or source_uri is not present.
              #
              # The
              # {::Google::Cloud::ApiHub::V1::UpdateSpecRequest#update_mask update_mask}
              # should be used to specify the fields being updated.
              #
              # @overload update_spec(request, options = nil)
              #   Pass arguments to `update_spec` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_spec(spec: nil, update_mask: nil)
              #   Pass arguments to `update_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param spec [::Google::Cloud::ApiHub::V1::Spec, ::Hash]
              #     Required. The spec to update.
              #
              #     The spec's `name` field is used to identify the spec to
              #     update. Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Spec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Spec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateSpecRequest.new
              #
              #   # Call the update_spec method.
              #   result = client.update_spec request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Spec.
              #   p result
              #
              def update_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.update_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a spec.
              # Deleting a spec will also delete the associated operations from the
              # version.
              #
              # @overload delete_spec(request, options = nil)
              #   Pass arguments to `delete_spec` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_spec(name: nil)
              #   Pass arguments to `delete_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the spec  to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteSpecRequest.new
              #
              #   # Call the delete_spec method.
              #   result = client.delete_spec request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.delete_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create an apiOperation in an API version.
              # An apiOperation can be created only if the version has no apiOperations
              # which were created by parsing a spec.
              #
              # @overload create_api_operation(request, options = nil)
              #   Pass arguments to `create_api_operation` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateApiOperationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateApiOperationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_api_operation(parent: nil, api_operation_id: nil, api_operation: nil)
              #   Pass arguments to `create_api_operation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for the operation resource.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
              #   @param api_operation_id [::String]
              #     Optional. The ID to use for the operation resource, which will become the
              #     final component of the operation's resource name. This field is optional.
              #
              #     * If provided, the same will be used. The service will throw an error if
              #     the specified id is already used by another operation resource in the API
              #     hub.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, overall resource name which
              #     will be of format
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`,
              #     its length is limited to 700 characters, and valid characters are
              #     /[a-z][A-Z][0-9]-_/.
              #   @param api_operation [::Google::Cloud::ApiHub::V1::ApiOperation, ::Hash]
              #     Required. The operation resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::ApiOperation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::ApiOperation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateApiOperationRequest.new
              #
              #   # Call the create_api_operation method.
              #   result = client.create_api_operation request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::ApiOperation.
              #   p result
              #
              def create_api_operation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateApiOperationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_api_operation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_api_operation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_api_operation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.create_api_operation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about a particular operation in API version.
              #
              # @overload get_api_operation(request, options = nil)
              #   Pass arguments to `get_api_operation` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetApiOperationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetApiOperationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_api_operation(name: nil)
              #   Pass arguments to `get_api_operation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the operation to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::ApiOperation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::ApiOperation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetApiOperationRequest.new
              #
              #   # Call the get_api_operation method.
              #   result = client.get_api_operation request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::ApiOperation.
              #   p result
              #
              def get_api_operation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetApiOperationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_api_operation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_api_operation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_api_operation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_api_operation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List operations in an API version.
              #
              # @overload list_api_operations(request, options = nil)
              #   Pass arguments to `list_api_operations` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListApiOperationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListApiOperationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_api_operations(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_api_operations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent which owns this collection of operations i.e., the API
              #     version. Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
              #   @param filter [::String]
              #     Optional. An expression that filters the list of ApiOperations.
              #
              #     A filter expression consists of a field name, a comparison
              #     operator, and a value for filtering. The value must be a string or a
              #     boolean. The comparison operator must be one of: `<`, `>` or
              #     `=`. Filters are not case sensitive.
              #
              #     The following fields in the `ApiOperation` are eligible for filtering:
              #       * `name` - The ApiOperation resource name. Allowed comparison
              #       operators:
              #       `=`.
              #       * `details.http_operation.path.path` - The http operation's complete path
              #       relative to server endpoint. Allowed comparison operators: `=`.
              #       * `details.http_operation.method` - The http operation method type.
              #       Allowed comparison operators: `=`.
              #       * `details.deprecated` - Indicates if the ApiOperation is deprecated.
              #       Allowed values are True / False indicating the deprycation status of the
              #       ApiOperation. Allowed comparison operators: `=`.
              #       * `create_time` - The time at which the ApiOperation was created. The
              #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
              #       format. Allowed comparison operators: `>` and `<`.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.id` - The
              #       allowed value id of the user defined enum attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-id is a placeholder that can be replaced with
              #       any user defined enum attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.display_name`
              #       - The allowed value display name of the user defined enum attribute
              #       associated with the Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-display-name is a placeholder that can be
              #       replaced with any user defined enum attribute enum name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.string_values.values` - The
              #       allowed value of the user defined string attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-string is a placeholder that can be replaced with
              #       any user defined string attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.json_values.values` - The
              #       allowed value of the user defined JSON attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-json is a placeholder that can be replaced with
              #       any user defined JSON attribute name.
              #
              #     Expressions are combined with either `AND` logic operator or `OR` logical
              #     operator but not both of them together i.e. only one of the `AND` or `OR`
              #     operator can be used throughout the filter string and both the operators
              #     cannot be used together. No other logical operators are supported. At most
              #     three filter fields are allowed in the filter string and if provided
              #     more than that then `INVALID_ARGUMENT` error is returned by the API.
              #
              #     Here are a few examples:
              #
              #       * `details.deprecated = True` -  The ApiOperation is deprecated.
              #       * `details.http_operation.method = GET AND create_time <
              #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
              #       The method of the http operation of the ApiOperation is _GET_ and the
              #       spec was created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10
              #       12:00:00 UTC_.
              #       * `details.http_operation.method = GET OR details.http_operation.method =
              #       POST`. - The http operation of the method of ApiOperation is _GET_ or
              #       _POST_.
              #       * `details.deprecated = True AND
              #       attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values:
              #       test`  - The filter string specifies that the ApiOperation is deprecated
              #       and the value of the user defined attribute of type string is _test_.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of operations to return. The service may
              #     return fewer than this value. If unspecified, at most 50 operations will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListApiOperations` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters (except page_size) provided to
              #     `ListApiOperations` must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::ApiOperation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::ApiOperation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListApiOperationsRequest.new
              #
              #   # Call the list_api_operations method.
              #   result = client.list_api_operations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::ApiOperation.
              #     p item
              #   end
              #
              def list_api_operations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListApiOperationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_api_operations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_api_operations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_api_operations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.list_api_operations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :list_api_operations, "api_operations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update an operation in an API version. The following fields in the
              # {::Google::Cloud::ApiHub::V1::ApiOperation ApiOperation resource} can be
              # updated:
              #
              # * [details.description][ApiOperation.details.description]
              # * [details.documentation][ApiOperation.details.documentation]
              # * [details.http_operation.path][ApiOperation.details.http_operation.path.path]
              # * [details.http_operation.method][ApiOperation.details.http_operation.method]
              # * [details.deprecated][ApiOperation.details.deprecated]
              # * {::Google::Cloud::ApiHub::V1::ApiOperation#attributes attributes}
              #
              # The
              # {::Google::Cloud::ApiHub::V1::UpdateApiOperationRequest#update_mask update_mask}
              # should be used to specify the fields being updated.
              #
              # An operation can be updated only if the operation was created via
              # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#create_api_operation CreateApiOperation} API.
              # If the operation was created by parsing the spec, then it can be edited by
              # updating the spec.
              #
              # @overload update_api_operation(request, options = nil)
              #   Pass arguments to `update_api_operation` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateApiOperationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateApiOperationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_api_operation(api_operation: nil, update_mask: nil)
              #   Pass arguments to `update_api_operation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param api_operation [::Google::Cloud::ApiHub::V1::ApiOperation, ::Hash]
              #     Required. The apiOperation resource to update.
              #
              #     The operation resource's `name` field is used to identify the operation
              #     resource to update.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::ApiOperation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::ApiOperation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateApiOperationRequest.new
              #
              #   # Call the update_api_operation method.
              #   result = client.update_api_operation request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::ApiOperation.
              #   p result
              #
              def update_api_operation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateApiOperationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_api_operation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_api_operation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_api_operation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.update_api_operation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an operation in an API version and we can delete only the
              # operations created via create API. If the operation was created by parsing
              # the spec, then it can be deleted by editing or deleting the spec.
              #
              # @overload delete_api_operation(request, options = nil)
              #   Pass arguments to `delete_api_operation` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteApiOperationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteApiOperationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_api_operation(name: nil)
              #   Pass arguments to `delete_api_operation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the operation resource to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteApiOperationRequest.new
              #
              #   # Call the delete_api_operation method.
              #   result = client.delete_api_operation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_api_operation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteApiOperationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_api_operation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_api_operation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_api_operation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.delete_api_operation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about a definition in an API version.
              #
              # @overload get_definition(request, options = nil)
              #   Pass arguments to `get_definition` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetDefinitionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetDefinitionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_definition(name: nil)
              #   Pass arguments to `get_definition` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the definition to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Definition]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Definition]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetDefinitionRequest.new
              #
              #   # Call the get_definition method.
              #   result = client.get_definition request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Definition.
              #   p result
              #
              def get_definition request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetDefinitionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_definition.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_definition.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_definition.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_definition request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a deployment resource in the API hub.
              # Once a deployment resource is created, it can be associated with API
              # versions.
              #
              # @overload create_deployment(request, options = nil)
              #   Pass arguments to `create_deployment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_deployment(parent: nil, deployment_id: nil, deployment: nil)
              #   Pass arguments to `create_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for the deployment resource.
              #     Format: `projects/{project}/locations/{location}`
              #   @param deployment_id [::String]
              #     Optional. The ID to use for the deployment resource, which will become the
              #     final component of the deployment's resource name. This field is optional.
              #
              #     * If provided, the same will be used. The service will throw an error if
              #     the specified id is already used by another deployment resource in the API
              #     hub.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, and valid characters
              #     are /[a-z][A-Z][0-9]-_/.
              #   @param deployment [::Google::Cloud::ApiHub::V1::Deployment, ::Hash]
              #     Required. The deployment resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateDeploymentRequest.new
              #
              #   # Call the create_deployment method.
              #   result = client.create_deployment request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Deployment.
              #   p result
              #
              def create_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.create_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about a deployment and the API versions linked to it.
              #
              # @overload get_deployment(request, options = nil)
              #   Pass arguments to `get_deployment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_deployment(name: nil)
              #   Pass arguments to `get_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment resource to retrieve.
              #     Format: `projects/{project}/locations/{location}/deployments/{deployment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetDeploymentRequest.new
              #
              #   # Call the get_deployment method.
              #   result = client.get_deployment request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Deployment.
              #   p result
              #
              def get_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List deployment resources in the API hub.
              #
              # @overload list_deployments(request, options = nil)
              #   Pass arguments to `list_deployments` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListDeploymentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListDeploymentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_deployments(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_deployments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of deployment resources.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Optional. An expression that filters the list of Deployments.
              #
              #     A filter expression consists of a field name, a comparison
              #     operator, and a value for filtering. The value must be a string. The
              #     comparison operator must be one of: `<`, `>` or
              #     `=`. Filters are not case sensitive.
              #
              #     The following fields in the `Deployments` are eligible for filtering:
              #
              #       * `display_name` - The display name of the Deployment. Allowed
              #       comparison operators: `=`.
              #       * `create_time` - The time at which the Deployment was created. The
              #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
              #       format. Allowed comparison operators: `>` and `<`.
              #       * `resource_uri` - A URI to the deployment resource. Allowed
              #       comparison operators: `=`.
              #       * `api_versions` - The API versions linked to this deployment. Allowed
              #       comparison operators: `:`.
              #       * `source_project` - The project/organization at source for the
              #       deployment. Allowed comparison operators: `=`.
              #       * `source_environment` - The environment at source for the
              #       deployment. Allowed comparison operators: `=`.
              #       * `deployment_type.enum_values.values.id` - The allowed value id of the
              #       deployment_type attribute associated with the Deployment. Allowed
              #       comparison operators: `:`.
              #       * `deployment_type.enum_values.values.display_name` - The allowed value
              #       display name of the deployment_type attribute associated with the
              #       Deployment. Allowed comparison operators: `:`.
              #       * `slo.string_values.values` -The allowed string value of the slo
              #       attribute associated with the deployment. Allowed comparison
              #       operators: `:`.
              #       * `environment.enum_values.values.id` - The allowed value id of the
              #       environment attribute associated with the deployment. Allowed
              #       comparison operators: `:`.
              #       * `environment.enum_values.values.display_name` - The allowed value
              #       display name of the environment attribute associated with the deployment.
              #       Allowed comparison operators: `:`.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.id` - The
              #       allowed value id of the user defined enum attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-id is a placeholder that can be replaced with
              #       any user defined enum attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.enum_values.values.display_name`
              #       - The allowed value display name of the user defined enum attribute
              #       associated with the Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-enum-display-name is a placeholder that can be
              #       replaced with any user defined enum attribute enum name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.string_values.values` - The
              #       allowed value of the user defined string attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-string is a placeholder that can be replaced with
              #       any user defined string attribute name.
              #       * `attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/user-defined-attribute-id.json_values.values` - The
              #       allowed value of the user defined JSON attribute associated with the
              #       Resource. Allowed comparison operator is `:`. Here
              #       user-defined-attribute-json is a placeholder that can be replaced with
              #       any user defined JSON attribute name.
              #
              #     A filter function is also supported in the filter string. The filter
              #     function is `id(name)`. The `id(name)` function returns the id of the
              #     resource name. For example, `id(name) = \"deployment-1\"` is equivalent to
              #     `name =
              #     \"projects/test-project-id/locations/test-location-id/deployments/deployment-1\"`
              #     provided the parent is
              #     `projects/test-project-id/locations/test-location-id`.
              #
              #     Expressions are combined with either `AND` logic operator or `OR` logical
              #     operator but not both of them together i.e. only one of the `AND` or `OR`
              #     operator can be used throughout the filter string and both the operators
              #     cannot be used together. No other logical operators are supported. At most
              #     three filter fields are allowed in the filter string and if provided
              #     more than that then `INVALID_ARGUMENT` error is returned by the API.
              #
              #     Here are a few examples:
              #
              #       * `environment.enum_values.values.id: staging-id` - The allowed value id
              #       of the environment attribute associated with the Deployment is
              #       _staging-id_.
              #       * `environment.enum_values.values.display_name: \"Staging Deployment\"` -
              #       The allowed value display name of the environment attribute associated
              #       with the Deployment is `Staging Deployment`.
              #       * `environment.enum_values.values.id: production-id AND create_time <
              #       \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
              #       The allowed value id of the environment attribute associated with the
              #       Deployment is _production-id_ and Deployment was created before
              #       _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_.
              #       * `environment.enum_values.values.id: production-id OR
              #       slo.string_values.values: \"99.99%\"`
              #       - The allowed value id of the environment attribute Deployment is
              #       _production-id_ or string value of the slo attribute is _99.99%_.
              #       * `environment.enum_values.values.id: staging-id AND
              #       attributes.projects/test-project-id/locations/test-location-id/
              #       attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values:
              #       test`  - The filter string specifies that the allowed value id of the
              #       environment attribute associated with the Deployment is _staging-id_ and
              #       the value of the user defined attribute of type string is _test_.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of deployment resources to return. The service
              #     may return fewer than this value. If unspecified, at most 50 deployments
              #     will be returned. The maximum value is 1000; values above 1000 will be
              #     coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListDeployments` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters (except page_size) provided to
              #     `ListDeployments` must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Deployment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Deployment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListDeploymentsRequest.new
              #
              #   # Call the list_deployments method.
              #   result = client.list_deployments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::Deployment.
              #     p item
              #   end
              #
              def list_deployments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListDeploymentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_deployments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_deployments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_deployments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.list_deployments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :list_deployments, "deployments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a deployment resource in the API hub. The following fields in the
              # {::Google::Cloud::ApiHub::V1::Deployment deployment resource} can be
              # updated:
              #
              # * {::Google::Cloud::ApiHub::V1::Deployment#display_name display_name}
              # * {::Google::Cloud::ApiHub::V1::Deployment#description description}
              # * {::Google::Cloud::ApiHub::V1::Deployment#documentation documentation}
              # * {::Google::Cloud::ApiHub::V1::Deployment#deployment_type deployment_type}
              # * {::Google::Cloud::ApiHub::V1::Deployment#resource_uri resource_uri}
              # * {::Google::Cloud::ApiHub::V1::Deployment#endpoints endpoints}
              # * {::Google::Cloud::ApiHub::V1::Deployment#slo slo}
              # * {::Google::Cloud::ApiHub::V1::Deployment#environment environment}
              # * {::Google::Cloud::ApiHub::V1::Deployment#attributes attributes}
              # * [source_project] [google.cloud.apihub.v1.Deployment.source_project]
              # * [source_environment]
              # [google.cloud.apihub.v1.Deployment.source_environment]
              # * {::Google::Cloud::ApiHub::V1::Deployment#management_url management_url}
              # * {::Google::Cloud::ApiHub::V1::Deployment#source_uri source_uri}
              # The
              # {::Google::Cloud::ApiHub::V1::UpdateDeploymentRequest#update_mask update_mask}
              # should be used to specify the fields being updated.
              #
              # @overload update_deployment(request, options = nil)
              #   Pass arguments to `update_deployment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_deployment(deployment: nil, update_mask: nil)
              #   Pass arguments to `update_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param deployment [::Google::Cloud::ApiHub::V1::Deployment, ::Hash]
              #     Required. The deployment resource to update.
              #
              #     The deployment resource's `name` field is used to identify the deployment
              #     resource to update.
              #     Format: `projects/{project}/locations/{location}/deployments/{deployment}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateDeploymentRequest.new
              #
              #   # Call the update_deployment method.
              #   result = client.update_deployment request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Deployment.
              #   p result
              #
              def update_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.update_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a deployment resource in the API hub.
              #
              # @overload delete_deployment(request, options = nil)
              #   Pass arguments to `delete_deployment` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_deployment(name: nil)
              #   Pass arguments to `delete_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment resource to delete.
              #     Format: `projects/{project}/locations/{location}/deployments/{deployment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteDeploymentRequest.new
              #
              #   # Call the delete_deployment method.
              #   result = client.delete_deployment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.delete_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a user defined attribute.
              #
              # Certain pre defined attributes are already created by the API hub. These
              # attributes will have type as `SYSTEM_DEFINED` and can be listed via
              # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#list_attributes ListAttributes} method.
              # Allowed values for the same can be updated via
              # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client#update_attribute UpdateAttribute} method.
              #
              # @overload create_attribute(request, options = nil)
              #   Pass arguments to `create_attribute` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateAttributeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateAttributeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_attribute(parent: nil, attribute_id: nil, attribute: nil)
              #   Pass arguments to `create_attribute` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for Attribute.
              #     Format: `projects/{project}/locations/{location}`
              #   @param attribute_id [::String]
              #     Optional. The ID to use for the attribute, which will become the final
              #     component of the attribute's resource name. This field is optional.
              #
              #     * If provided, the same will be used. The service will throw an error if
              #     the specified id is already used by another attribute resource in the API
              #     hub.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, and valid characters
              #     are /[a-z][A-Z][0-9]-_/.
              #   @param attribute [::Google::Cloud::ApiHub::V1::Attribute, ::Hash]
              #     Required. The attribute to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Attribute]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Attribute]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateAttributeRequest.new
              #
              #   # Call the create_attribute method.
              #   result = client.create_attribute request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Attribute.
              #   p result
              #
              def create_attribute request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateAttributeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_attribute.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_attribute.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_attribute.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.create_attribute request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about the attribute.
              #
              # @overload get_attribute(request, options = nil)
              #   Pass arguments to `get_attribute` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetAttributeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetAttributeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_attribute(name: nil)
              #   Pass arguments to `get_attribute` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the attribute to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/attributes/{attribute}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Attribute]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Attribute]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetAttributeRequest.new
              #
              #   # Call the get_attribute method.
              #   result = client.get_attribute request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Attribute.
              #   p result
              #
              def get_attribute request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetAttributeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_attribute.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_attribute.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_attribute.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_attribute request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update the attribute.  The following fields in the
              # {::Google::Cloud::ApiHub::V1::Attribute Attribute resource} can be updated:
              #
              # * {::Google::Cloud::ApiHub::V1::Attribute#display_name display_name}
              # The display name can be updated for user defined attributes only.
              # * {::Google::Cloud::ApiHub::V1::Attribute#description description}
              # The description can be updated for user defined attributes only.
              # * {::Google::Cloud::ApiHub::V1::Attribute#allowed_values allowed_values}
              # To update the list of allowed values, clients need to use the fetched list
              # of allowed values and add or remove values to or from the same list.
              # The mutable allowed values can be updated for both user defined and System
              # defined attributes. The immutable allowed values cannot be updated or
              # deleted. The updated list of allowed values cannot be empty. If an allowed
              # value that is already used by some resource's attribute is deleted, then
              # the association between the resource and the attribute value will also be
              # deleted.
              # * {::Google::Cloud::ApiHub::V1::Attribute#cardinality cardinality}
              # The cardinality can be updated for user defined attributes only.
              # Cardinality can only be increased during an update.
              #
              # The
              # {::Google::Cloud::ApiHub::V1::UpdateAttributeRequest#update_mask update_mask}
              # should be used to specify the fields being updated.
              #
              # @overload update_attribute(request, options = nil)
              #   Pass arguments to `update_attribute` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateAttributeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateAttributeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_attribute(attribute: nil, update_mask: nil)
              #   Pass arguments to `update_attribute` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param attribute [::Google::Cloud::ApiHub::V1::Attribute, ::Hash]
              #     Required. The attribute to update.
              #
              #     The attribute's `name` field is used to identify the attribute to update.
              #     Format:
              #     `projects/{project}/locations/{location}/attributes/{attribute}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::Attribute]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::Attribute]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateAttributeRequest.new
              #
              #   # Call the update_attribute method.
              #   result = client.update_attribute request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::Attribute.
              #   p result
              #
              def update_attribute request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateAttributeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_attribute.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_attribute.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_attribute.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.update_attribute request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an attribute.
              #
              # Note: System defined attributes cannot be deleted. All
              # associations of the attribute being deleted with any API hub resource will
              # also get deleted.
              #
              # @overload delete_attribute(request, options = nil)
              #   Pass arguments to `delete_attribute` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteAttributeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteAttributeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_attribute(name: nil)
              #   Pass arguments to `delete_attribute` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the attribute to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/attributes/{attribute}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteAttributeRequest.new
              #
              #   # Call the delete_attribute method.
              #   result = client.delete_attribute request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_attribute request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteAttributeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_attribute.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_attribute.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_attribute.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.delete_attribute request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List all attributes.
              #
              # @overload list_attributes(request, options = nil)
              #   Pass arguments to `list_attributes` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListAttributesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListAttributesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_attributes(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_attributes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for Attribute.
              #     Format: `projects/{project}/locations/{location}`
              #   @param filter [::String]
              #     Optional. An expression that filters the list of Attributes.
              #
              #     A filter expression consists of a field name, a comparison
              #     operator, and a value for filtering. The value must be a string or a
              #     boolean. The comparison operator must be one of: `<`, `>` or
              #     `=`. Filters are not case sensitive.
              #
              #     The following fields in the `Attribute` are eligible for filtering:
              #
              #       * `display_name` - The display name of the Attribute. Allowed
              #       comparison operators: `=`.
              #       * `definition_type` - The definition type of the attribute. Allowed
              #       comparison operators: `=`.
              #       * `scope` - The scope of the attribute. Allowed comparison operators:
              #       `=`.
              #       * `data_type` - The type of the data of the attribute. Allowed
              #       comparison operators: `=`.
              #       * `mandatory` - Denotes whether the attribute is mandatory or not.
              #       Allowed comparison operators: `=`.
              #       * `create_time` - The time at which the Attribute was created. The
              #       value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
              #       format. Allowed comparison operators: `>` and `<`.
              #
              #     Expressions are combined with either `AND` logic operator or `OR` logical
              #     operator but not both of them together i.e. only one of the `AND` or `OR`
              #     operator can be used throughout the filter string and both the operators
              #     cannot be used together. No other logical operators are
              #     supported. At most three filter fields are allowed in the filter
              #     string and if provided more than that then `INVALID_ARGUMENT` error is
              #     returned by the API.
              #
              #     Here are a few examples:
              #
              #       * `display_name = production` -  - The display name of the attribute is
              #       _production_.
              #       * `(display_name = production) AND (create_time <
              #       \"2021-08-15T14:50:00Z\") AND (create_time > \"2021-08-10T12:00:00Z\")` -
              #       The display name of the attribute is _production_ and the attribute was
              #       created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00
              #       UTC_.
              #       * `display_name = production OR scope = api` -
              #       The attribute where the display name is _production_ or the scope is
              #       _api_.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of attribute resources to return. The service
              #     may return fewer than this value. If unspecified, at most 50 attributes
              #     will be returned. The maximum value is 1000; values above 1000 will be
              #     coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListAttributes` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListAttributes` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Attribute>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::Attribute>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListAttributesRequest.new
              #
              #   # Call the list_attributes method.
              #   result = client.list_attributes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::Attribute.
              #     p item
              #   end
              #
              def list_attributes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListAttributesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_attributes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_attributes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_attributes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.list_attributes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :list_attributes, "attributes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Search across API-Hub resources.
              #
              # @overload search_resources(request, options = nil)
              #   Pass arguments to `search_resources` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::SearchResourcesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::SearchResourcesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_resources(location: nil, query: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_resources` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param location [::String]
              #     Required. The resource name of the location which will be of the type
              #     `projects/{project_id}/locations/{location_id}`. This field is used to
              #     identify the instance of API-Hub in which resources should be searched.
              #   @param query [::String]
              #     Required. The free text search query. This query can contain keywords which
              #     could be related to any detail of the API-Hub resources such display names,
              #     descriptions, attributes etc.
              #   @param filter [::String]
              #     Optional. An expression that filters the list of search results.
              #
              #     A filter expression consists of a field name, a comparison operator,
              #     and a value for filtering. The value must be a string, a number, or a
              #     boolean. The comparison operator must be `=`. Filters are not case
              #     sensitive.
              #
              #     The following field names are eligible for filtering:
              #        * `resource_type` - The type of resource in the search results.
              #        Must be one of the following: `Api`, `ApiOperation`, `Deployment`,
              #        `Definition`, `Spec` or `Version`. This field can only be specified once
              #        in the filter.
              #
              #     Here are is an example:
              #
              #       * `resource_type = Api` - The resource_type is _Api_.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of search results to return. The service may
              #     return fewer than this value. If unspecified at most 10 search results will
              #     be returned. If value is negative then `INVALID_ARGUMENT` error is
              #     returned. The maximum value is 25; values above 25 will be coerced to 25.
              #     While paginating, you can specify a new page size parameter for each page
              #     of search results to be listed.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     [SearchResources][SearchResources]
              #     call. Specify this parameter to retrieve the next page of transactions.
              #
              #     When paginating, you must specify the `page_token` parameter and all the
              #     other parameters except
              #     {::Google::Cloud::ApiHub::V1::SearchResourcesRequest#page_size page_size}
              #     should be specified with the same value which was used in the previous
              #     call. If the other fields are set with a different value than the previous
              #     call then `INVALID_ARGUMENT` error is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::SearchResult>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::SearchResult>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::SearchResourcesRequest.new
              #
              #   # Call the search_resources method.
              #   result = client.search_resources request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::SearchResult.
              #     p item
              #   end
              #
              def search_resources request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::SearchResourcesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_resources.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_resources.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_resources.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.search_resources request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :search_resources, "search_results", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create an External API resource in the API hub.
              #
              # @overload create_external_api(request, options = nil)
              #   Pass arguments to `create_external_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::CreateExternalApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::CreateExternalApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_external_api(parent: nil, external_api_id: nil, external_api: nil)
              #   Pass arguments to `create_external_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for the External API resource.
              #     Format: `projects/{project}/locations/{location}`
              #   @param external_api_id [::String]
              #     Optional. The ID to use for the External API resource, which will become
              #     the final component of the External API's resource name. This field is
              #     optional.
              #
              #     * If provided, the same will be used. The service will throw an error if
              #     the specified id is already used by another External API resource in the
              #     API hub.
              #     * If not provided, a system generated id will be used.
              #
              #     This value should be 4-500 characters, and valid characters
              #     are /[a-z][A-Z][0-9]-_/.
              #   @param external_api [::Google::Cloud::ApiHub::V1::ExternalApi, ::Hash]
              #     Required. The External API resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::ExternalApi]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::ExternalApi]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::CreateExternalApiRequest.new
              #
              #   # Call the create_external_api method.
              #   result = client.create_external_api request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::ExternalApi.
              #   p result
              #
              def create_external_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::CreateExternalApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_external_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_external_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_external_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.create_external_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details about an External API resource in the API hub.
              #
              # @overload get_external_api(request, options = nil)
              #   Pass arguments to `get_external_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::GetExternalApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::GetExternalApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_external_api(name: nil)
              #   Pass arguments to `get_external_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the External API resource to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/externalApis/{externalApi}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::ExternalApi]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::ExternalApi]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::GetExternalApiRequest.new
              #
              #   # Call the get_external_api method.
              #   result = client.get_external_api request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::ExternalApi.
              #   p result
              #
              def get_external_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::GetExternalApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_external_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_external_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_external_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.get_external_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update an External API resource in the API hub. The following fields can be
              # updated:
              #
              # * {::Google::Cloud::ApiHub::V1::ExternalApi#display_name display_name}
              # * {::Google::Cloud::ApiHub::V1::ExternalApi#description description}
              # * {::Google::Cloud::ApiHub::V1::ExternalApi#documentation documentation}
              # * {::Google::Cloud::ApiHub::V1::ExternalApi#endpoints endpoints}
              # * {::Google::Cloud::ApiHub::V1::ExternalApi#paths paths}
              #
              # The
              # {::Google::Cloud::ApiHub::V1::UpdateExternalApiRequest#update_mask update_mask}
              # should be used to specify the fields being updated.
              #
              # @overload update_external_api(request, options = nil)
              #   Pass arguments to `update_external_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::UpdateExternalApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::UpdateExternalApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_external_api(external_api: nil, update_mask: nil)
              #   Pass arguments to `update_external_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param external_api [::Google::Cloud::ApiHub::V1::ExternalApi, ::Hash]
              #     Required. The External API resource to update.
              #
              #     The External API resource's `name` field is used to identify the External
              #     API resource to update. Format:
              #     `projects/{project}/locations/{location}/externalApis/{externalApi}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ApiHub::V1::ExternalApi]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ApiHub::V1::ExternalApi]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::UpdateExternalApiRequest.new
              #
              #   # Call the update_external_api method.
              #   result = client.update_external_api request
              #
              #   # The returned object is of type Google::Cloud::ApiHub::V1::ExternalApi.
              #   p result
              #
              def update_external_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::UpdateExternalApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_external_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_external_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_external_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.update_external_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an External API resource in the API hub.
              #
              # @overload delete_external_api(request, options = nil)
              #   Pass arguments to `delete_external_api` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::DeleteExternalApiRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::DeleteExternalApiRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_external_api(name: nil)
              #   Pass arguments to `delete_external_api` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the External API resource to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/externalApis/{externalApi}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::DeleteExternalApiRequest.new
              #
              #   # Call the delete_external_api method.
              #   result = client.delete_external_api request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_external_api request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::DeleteExternalApiRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_external_api.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_external_api.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_external_api.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.delete_external_api request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List External API resources in the API hub.
              #
              # @overload list_external_apis(request, options = nil)
              #   Pass arguments to `list_external_apis` via a request object, either of type
              #   {::Google::Cloud::ApiHub::V1::ListExternalApisRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ApiHub::V1::ListExternalApisRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_external_apis(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_external_apis` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of External API resources.
              #     Format: `projects/{project}/locations/{location}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of External API resources to return. The
              #     service may return fewer than this value. If unspecified, at most 50
              #     ExternalApis will be returned. The maximum value is 1000; values above 1000
              #     will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListExternalApis` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters (except page_size) provided to
              #     `ListExternalApis` must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::ExternalApi>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ApiHub::V1::ExternalApi>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/api_hub/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ApiHub::V1::ListExternalApisRequest.new
              #
              #   # Call the list_external_apis method.
              #   result = client.list_external_apis request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ApiHub::V1::ExternalApi.
              #     p item
              #   end
              #
              def list_external_apis request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ApiHub::V1::ListExternalApisRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_external_apis.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ApiHub::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_external_apis.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_external_apis.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @api_hub_stub.list_external_apis request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @api_hub_stub, :list_external_apis, "external_apis", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ApiHub REST API.
              #
              # This class represents the configuration for ApiHub REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_api to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_api.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ApiHub::V1::ApiHub::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_api.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "apihub.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ApiHub API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_api
                  ##
                  # RPC-specific configuration for `get_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_api
                  ##
                  # RPC-specific configuration for `list_apis`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_apis
                  ##
                  # RPC-specific configuration for `update_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_api
                  ##
                  # RPC-specific configuration for `delete_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api
                  ##
                  # RPC-specific configuration for `create_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_version
                  ##
                  # RPC-specific configuration for `get_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_version
                  ##
                  # RPC-specific configuration for `list_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_versions
                  ##
                  # RPC-specific configuration for `update_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_version
                  ##
                  # RPC-specific configuration for `delete_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_version
                  ##
                  # RPC-specific configuration for `create_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_spec
                  ##
                  # RPC-specific configuration for `get_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_spec
                  ##
                  # RPC-specific configuration for `get_spec_contents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_spec_contents
                  ##
                  # RPC-specific configuration for `list_specs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_specs
                  ##
                  # RPC-specific configuration for `update_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_spec
                  ##
                  # RPC-specific configuration for `delete_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_spec
                  ##
                  # RPC-specific configuration for `create_api_operation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_api_operation
                  ##
                  # RPC-specific configuration for `get_api_operation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_api_operation
                  ##
                  # RPC-specific configuration for `list_api_operations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_api_operations
                  ##
                  # RPC-specific configuration for `update_api_operation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_api_operation
                  ##
                  # RPC-specific configuration for `delete_api_operation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_api_operation
                  ##
                  # RPC-specific configuration for `get_definition`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_definition
                  ##
                  # RPC-specific configuration for `create_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_deployment
                  ##
                  # RPC-specific configuration for `get_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_deployment
                  ##
                  # RPC-specific configuration for `list_deployments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_deployments
                  ##
                  # RPC-specific configuration for `update_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_deployment
                  ##
                  # RPC-specific configuration for `delete_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_deployment
                  ##
                  # RPC-specific configuration for `create_attribute`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_attribute
                  ##
                  # RPC-specific configuration for `get_attribute`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_attribute
                  ##
                  # RPC-specific configuration for `update_attribute`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_attribute
                  ##
                  # RPC-specific configuration for `delete_attribute`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_attribute
                  ##
                  # RPC-specific configuration for `list_attributes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_attributes
                  ##
                  # RPC-specific configuration for `search_resources`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_resources
                  ##
                  # RPC-specific configuration for `create_external_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_external_api
                  ##
                  # RPC-specific configuration for `get_external_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_external_api
                  ##
                  # RPC-specific configuration for `update_external_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_external_api
                  ##
                  # RPC-specific configuration for `delete_external_api`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_external_api
                  ##
                  # RPC-specific configuration for `list_external_apis`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_external_apis

                  # @private
                  def initialize parent_rpcs = nil
                    create_api_config = parent_rpcs.create_api if parent_rpcs.respond_to? :create_api
                    @create_api = ::Gapic::Config::Method.new create_api_config
                    get_api_config = parent_rpcs.get_api if parent_rpcs.respond_to? :get_api
                    @get_api = ::Gapic::Config::Method.new get_api_config
                    list_apis_config = parent_rpcs.list_apis if parent_rpcs.respond_to? :list_apis
                    @list_apis = ::Gapic::Config::Method.new list_apis_config
                    update_api_config = parent_rpcs.update_api if parent_rpcs.respond_to? :update_api
                    @update_api = ::Gapic::Config::Method.new update_api_config
                    delete_api_config = parent_rpcs.delete_api if parent_rpcs.respond_to? :delete_api
                    @delete_api = ::Gapic::Config::Method.new delete_api_config
                    create_version_config = parent_rpcs.create_version if parent_rpcs.respond_to? :create_version
                    @create_version = ::Gapic::Config::Method.new create_version_config
                    get_version_config = parent_rpcs.get_version if parent_rpcs.respond_to? :get_version
                    @get_version = ::Gapic::Config::Method.new get_version_config
                    list_versions_config = parent_rpcs.list_versions if parent_rpcs.respond_to? :list_versions
                    @list_versions = ::Gapic::Config::Method.new list_versions_config
                    update_version_config = parent_rpcs.update_version if parent_rpcs.respond_to? :update_version
                    @update_version = ::Gapic::Config::Method.new update_version_config
                    delete_version_config = parent_rpcs.delete_version if parent_rpcs.respond_to? :delete_version
                    @delete_version = ::Gapic::Config::Method.new delete_version_config
                    create_spec_config = parent_rpcs.create_spec if parent_rpcs.respond_to? :create_spec
                    @create_spec = ::Gapic::Config::Method.new create_spec_config
                    get_spec_config = parent_rpcs.get_spec if parent_rpcs.respond_to? :get_spec
                    @get_spec = ::Gapic::Config::Method.new get_spec_config
                    get_spec_contents_config = parent_rpcs.get_spec_contents if parent_rpcs.respond_to? :get_spec_contents
                    @get_spec_contents = ::Gapic::Config::Method.new get_spec_contents_config
                    list_specs_config = parent_rpcs.list_specs if parent_rpcs.respond_to? :list_specs
                    @list_specs = ::Gapic::Config::Method.new list_specs_config
                    update_spec_config = parent_rpcs.update_spec if parent_rpcs.respond_to? :update_spec
                    @update_spec = ::Gapic::Config::Method.new update_spec_config
                    delete_spec_config = parent_rpcs.delete_spec if parent_rpcs.respond_to? :delete_spec
                    @delete_spec = ::Gapic::Config::Method.new delete_spec_config
                    create_api_operation_config = parent_rpcs.create_api_operation if parent_rpcs.respond_to? :create_api_operation
                    @create_api_operation = ::Gapic::Config::Method.new create_api_operation_config
                    get_api_operation_config = parent_rpcs.get_api_operation if parent_rpcs.respond_to? :get_api_operation
                    @get_api_operation = ::Gapic::Config::Method.new get_api_operation_config
                    list_api_operations_config = parent_rpcs.list_api_operations if parent_rpcs.respond_to? :list_api_operations
                    @list_api_operations = ::Gapic::Config::Method.new list_api_operations_config
                    update_api_operation_config = parent_rpcs.update_api_operation if parent_rpcs.respond_to? :update_api_operation
                    @update_api_operation = ::Gapic::Config::Method.new update_api_operation_config
                    delete_api_operation_config = parent_rpcs.delete_api_operation if parent_rpcs.respond_to? :delete_api_operation
                    @delete_api_operation = ::Gapic::Config::Method.new delete_api_operation_config
                    get_definition_config = parent_rpcs.get_definition if parent_rpcs.respond_to? :get_definition
                    @get_definition = ::Gapic::Config::Method.new get_definition_config
                    create_deployment_config = parent_rpcs.create_deployment if parent_rpcs.respond_to? :create_deployment
                    @create_deployment = ::Gapic::Config::Method.new create_deployment_config
                    get_deployment_config = parent_rpcs.get_deployment if parent_rpcs.respond_to? :get_deployment
                    @get_deployment = ::Gapic::Config::Method.new get_deployment_config
                    list_deployments_config = parent_rpcs.list_deployments if parent_rpcs.respond_to? :list_deployments
                    @list_deployments = ::Gapic::Config::Method.new list_deployments_config
                    update_deployment_config = parent_rpcs.update_deployment if parent_rpcs.respond_to? :update_deployment
                    @update_deployment = ::Gapic::Config::Method.new update_deployment_config
                    delete_deployment_config = parent_rpcs.delete_deployment if parent_rpcs.respond_to? :delete_deployment
                    @delete_deployment = ::Gapic::Config::Method.new delete_deployment_config
                    create_attribute_config = parent_rpcs.create_attribute if parent_rpcs.respond_to? :create_attribute
                    @create_attribute = ::Gapic::Config::Method.new create_attribute_config
                    get_attribute_config = parent_rpcs.get_attribute if parent_rpcs.respond_to? :get_attribute
                    @get_attribute = ::Gapic::Config::Method.new get_attribute_config
                    update_attribute_config = parent_rpcs.update_attribute if parent_rpcs.respond_to? :update_attribute
                    @update_attribute = ::Gapic::Config::Method.new update_attribute_config
                    delete_attribute_config = parent_rpcs.delete_attribute if parent_rpcs.respond_to? :delete_attribute
                    @delete_attribute = ::Gapic::Config::Method.new delete_attribute_config
                    list_attributes_config = parent_rpcs.list_attributes if parent_rpcs.respond_to? :list_attributes
                    @list_attributes = ::Gapic::Config::Method.new list_attributes_config
                    search_resources_config = parent_rpcs.search_resources if parent_rpcs.respond_to? :search_resources
                    @search_resources = ::Gapic::Config::Method.new search_resources_config
                    create_external_api_config = parent_rpcs.create_external_api if parent_rpcs.respond_to? :create_external_api
                    @create_external_api = ::Gapic::Config::Method.new create_external_api_config
                    get_external_api_config = parent_rpcs.get_external_api if parent_rpcs.respond_to? :get_external_api
                    @get_external_api = ::Gapic::Config::Method.new get_external_api_config
                    update_external_api_config = parent_rpcs.update_external_api if parent_rpcs.respond_to? :update_external_api
                    @update_external_api = ::Gapic::Config::Method.new update_external_api_config
                    delete_external_api_config = parent_rpcs.delete_external_api if parent_rpcs.respond_to? :delete_external_api
                    @delete_external_api = ::Gapic::Config::Method.new delete_external_api_config
                    list_external_apis_config = parent_rpcs.list_external_apis if parent_rpcs.respond_to? :list_external_apis
                    @list_external_apis = ::Gapic::Config::Method.new list_external_apis_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
