# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/apigateway/v1/apigateway_service_pb"
require "google/cloud/api_gateway/v1/api_gateway_service/rest"


class ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_gateways
    # Create test objects.
    client_result = ::Google::Cloud::ApiGateway::V1::ListGatewaysResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_gateways_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_list_gateways_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_gateways_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_gateways({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_gateways parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_gateways ::Google::Cloud::ApiGateway::V1::ListGatewaysRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_gateways({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_gateways(::Google::Cloud::ApiGateway::V1::ListGatewaysRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_gateways_client_stub.call_count
      end
    end
  end

  def test_get_gateway
    # Create test objects.
    client_result = ::Google::Cloud::ApiGateway::V1::Gateway.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_get_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_gateway({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_gateway name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_gateway ::Google::Cloud::ApiGateway::V1::GetGatewayRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_gateway({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_gateway(::Google::Cloud::ApiGateway::V1::GetGatewayRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_gateway_client_stub.call_count
      end
    end
  end

  def test_create_gateway
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gateway_id = "hello world"
    gateway = {}

    create_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_create_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_gateway({ parent: parent, gateway_id: gateway_id, gateway: gateway }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_gateway parent: parent, gateway_id: gateway_id, gateway: gateway do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_gateway ::Google::Cloud::ApiGateway::V1::CreateGatewayRequest.new(parent: parent, gateway_id: gateway_id, gateway: gateway) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_gateway({ parent: parent, gateway_id: gateway_id, gateway: gateway }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_gateway(::Google::Cloud::ApiGateway::V1::CreateGatewayRequest.new(parent: parent, gateway_id: gateway_id, gateway: gateway), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_gateway_client_stub.call_count
      end
    end
  end

  def test_update_gateway
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    gateway = {}

    update_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_update_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_gateway({ update_mask: update_mask, gateway: gateway }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_gateway update_mask: update_mask, gateway: gateway do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_gateway ::Google::Cloud::ApiGateway::V1::UpdateGatewayRequest.new(update_mask: update_mask, gateway: gateway) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_gateway({ update_mask: update_mask, gateway: gateway }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_gateway(::Google::Cloud::ApiGateway::V1::UpdateGatewayRequest.new(update_mask: update_mask, gateway: gateway), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_gateway_client_stub.call_count
      end
    end
  end

  def test_delete_gateway
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_delete_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_gateway({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_gateway name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_gateway ::Google::Cloud::ApiGateway::V1::DeleteGatewayRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_gateway({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_gateway(::Google::Cloud::ApiGateway::V1::DeleteGatewayRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_gateway_client_stub.call_count
      end
    end
  end

  def test_list_apis
    # Create test objects.
    client_result = ::Google::Cloud::ApiGateway::V1::ListApisResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_apis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_list_apis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_apis_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_apis({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_apis parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_apis ::Google::Cloud::ApiGateway::V1::ListApisRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_apis({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_apis(::Google::Cloud::ApiGateway::V1::ListApisRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_apis_client_stub.call_count
      end
    end
  end

  def test_get_api
    # Create test objects.
    client_result = ::Google::Cloud::ApiGateway::V1::Api.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_get_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api ::Google::Cloud::ApiGateway::V1::GetApiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api(::Google::Cloud::ApiGateway::V1::GetApiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_client_stub.call_count
      end
    end
  end

  def test_create_api
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_id = "hello world"
    api = {}

    create_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_create_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api({ parent: parent, api_id: api_id, api: api }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api parent: parent, api_id: api_id, api: api do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api ::Google::Cloud::ApiGateway::V1::CreateApiRequest.new(parent: parent, api_id: api_id, api: api) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api({ parent: parent, api_id: api_id, api: api }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api(::Google::Cloud::ApiGateway::V1::CreateApiRequest.new(parent: parent, api_id: api_id, api: api), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_client_stub.call_count
      end
    end
  end

  def test_update_api
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    api = {}

    update_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_update_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api({ update_mask: update_mask, api: api }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api update_mask: update_mask, api: api do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api ::Google::Cloud::ApiGateway::V1::UpdateApiRequest.new(update_mask: update_mask, api: api) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api({ update_mask: update_mask, api: api }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api(::Google::Cloud::ApiGateway::V1::UpdateApiRequest.new(update_mask: update_mask, api: api), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_client_stub.call_count
      end
    end
  end

  def test_delete_api
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_api_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_delete_api_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api ::Google::Cloud::ApiGateway::V1::DeleteApiRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api(::Google::Cloud::ApiGateway::V1::DeleteApiRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_client_stub.call_count
      end
    end
  end

  def test_list_api_configs
    # Create test objects.
    client_result = ::Google::Cloud::ApiGateway::V1::ListApiConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_api_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_list_api_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_api_configs_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_api_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_api_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_api_configs ::Google::Cloud::ApiGateway::V1::ListApiConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_api_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_api_configs(::Google::Cloud::ApiGateway::V1::ListApiConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_api_configs_client_stub.call_count
      end
    end
  end

  def test_get_api_config
    # Create test objects.
    client_result = ::Google::Cloud::ApiGateway::V1::ApiConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CONFIG_VIEW_UNSPECIFIED

    get_api_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_get_api_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_api_config_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_api_config({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_api_config name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_api_config ::Google::Cloud::ApiGateway::V1::GetApiConfigRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_api_config({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_api_config(::Google::Cloud::ApiGateway::V1::GetApiConfigRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_api_config_client_stub.call_count
      end
    end
  end

  def test_create_api_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    api_config_id = "hello world"
    api_config = {}

    create_api_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_create_api_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_api_config_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_api_config({ parent: parent, api_config_id: api_config_id, api_config: api_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_api_config parent: parent, api_config_id: api_config_id, api_config: api_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_api_config ::Google::Cloud::ApiGateway::V1::CreateApiConfigRequest.new(parent: parent, api_config_id: api_config_id, api_config: api_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_api_config({ parent: parent, api_config_id: api_config_id, api_config: api_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_api_config(::Google::Cloud::ApiGateway::V1::CreateApiConfigRequest.new(parent: parent, api_config_id: api_config_id, api_config: api_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_api_config_client_stub.call_count
      end
    end
  end

  def test_update_api_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    api_config = {}

    update_api_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_update_api_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_api_config_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_api_config({ update_mask: update_mask, api_config: api_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_api_config update_mask: update_mask, api_config: api_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_api_config ::Google::Cloud::ApiGateway::V1::UpdateApiConfigRequest.new(update_mask: update_mask, api_config: api_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_api_config({ update_mask: update_mask, api_config: api_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_api_config(::Google::Cloud::ApiGateway::V1::UpdateApiConfigRequest.new(update_mask: update_mask, api_config: api_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_api_config_client_stub.call_count
      end
    end
  end

  def test_delete_api_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_api_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::ServiceStub.stub :transcode_delete_api_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_api_config_client_stub do
        # Create client
        client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_api_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_api_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_api_config ::Google::Cloud::ApiGateway::V1::DeleteApiConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_api_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_api_config(::Google::Cloud::ApiGateway::V1::DeleteApiConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_api_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ApiGateway::V1::ApiGatewayService::Rest::Client::Configuration, config
  end
end
