# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AlloyDB
      module V1beta
        # Message for requesting list of Clusters
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. For the required format, see the
        #     comment on the Cluster.name field. Additionally, you can perform an
        #     aggregated list operation by specifying a value with the following format:
        #      * projects/\\{project}/locations/-
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Clusters
        # @!attribute [rw] clusters
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::Cluster>]
        #     The list of Cluster
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Cluster
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Cluster.name field.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::AlloyDB::V1beta::ClusterView]
        #     Optional. The view of the cluster to return. Returns all default fields if
        #     not set.
        class GetClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location of the new cluster. For the required
        #     format, see the comment on the Cluster.name field.
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. ID of the requesting object (the secondary cluster).
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::AlloyDB::V1beta::Cluster]
        #     Required. Configuration of the requesting object (the secondary cluster).
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class CreateSecondaryClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Cluster
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location of the new cluster. For the required format, see the
        #     comment on the Cluster.name field.
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::AlloyDB::V1beta::Cluster]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class CreateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Cluster
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Cluster resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::AlloyDB::V1beta::Cluster]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, update succeeds even if cluster is not found. In
        #     that case, a new cluster is created and `update_mask` is ignored.
        class UpdateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Destination for Export. Export will be done to cloud storage.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. The path to the file in Google Cloud Storage where the export
        #     will be stored. The URI is in the form `gs://bucketName/fileName`.
        class GcsDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Export cluster request.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::AlloyDB::V1beta::GcsDestination]
        #     Required. Option to export data to cloud storage.
        # @!attribute [rw] csv_export_options
        #   @return [::Google::Cloud::AlloyDB::V1beta::ExportClusterRequest::CsvExportOptions]
        #     Options for exporting data in CSV format. Required field to be set for
        #     CSV file type.
        #
        #     Note: The following fields are mutually exclusive: `csv_export_options`, `sql_export_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sql_export_options
        #   @return [::Google::Cloud::AlloyDB::V1beta::ExportClusterRequest::SqlExportOptions]
        #     Options for exporting data in SQL format. Required field to be set for
        #     SQL file type.
        #
        #     Note: The following fields are mutually exclusive: `sql_export_options`, `csv_export_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the cluster.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. Name of the database where the export command will be executed.
        #     Note - Value provided should be the same as expected from
        #     `SELECT current_database();` and NOT as a resource reference.
        class ExportClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Options for exporting data in CSV format.
          # @!attribute [rw] select_query
          #   @return [::String]
          #     Required. The SELECT query used to extract the data.
          # @!attribute [rw] field_delimiter
          #   @return [::String]
          #     Optional. Specifies the character that separates columns within each row
          #     (line) of the file. The default is comma. The value of this argument has
          #     to be a character in Hex ASCII Code.
          # @!attribute [rw] quote_character
          #   @return [::String]
          #     Optional. Specifies the quoting character to be used when a data value is
          #     quoted. The default is double-quote. The value of this argument has to be
          #     a character in Hex ASCII Code.
          # @!attribute [rw] escape_character
          #   @return [::String]
          #     Optional. Specifies the character that should appear before a data
          #     character that needs to be escaped. The default is the same as quote
          #     character. The value of this argument has to be a character in Hex ASCII
          #     Code.
          class CsvExportOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Options for exporting data in SQL format.
          # @!attribute [rw] tables
          #   @return [::Array<::String>]
          #     Optional. Tables to export from.
          # @!attribute [rw] schema_only
          #   @return [::Boolean]
          #     Optional. If true, only export the schema.
          # @!attribute [rw] clean_target_objects
          #   @return [::Boolean]
          #     Optional. If true, output commands to DROP all the dumped database
          #     objects prior to outputting the commands for creating them.
          # @!attribute [rw] if_exist_target_objects
          #   @return [::Boolean]
          #     Optional. If true, use DROP ... IF EXISTS commands to check for the
          #     object's existence before dropping it in clean_target_objects mode.
          class SqlExportOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response of export cluster rpc.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::AlloyDB::V1beta::GcsDestination]
        #     Required. Option to export data to cloud storage.
        class ExportClusterResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Import cluster request.
        # @!attribute [rw] sql_import_options
        #   @return [::Google::Cloud::AlloyDB::V1beta::ImportClusterRequest::SqlImportOptions]
        #     Options for importing data in SQL format.
        #
        #     Note: The following fields are mutually exclusive: `sql_import_options`, `csv_import_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] csv_import_options
        #   @return [::Google::Cloud::AlloyDB::V1beta::ImportClusterRequest::CsvImportOptions]
        #     Options for importing data in CSV format.
        #
        #     Note: The following fields are mutually exclusive: `csv_import_options`, `sql_import_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the cluster.
        # @!attribute [rw] gcs_uri
        #   @return [::String]
        #     Required. The path to the file in Google Cloud Storage where the source
        #     file for import will be stored. The URI is in the form
        #     `gs://bucketName/fileName`.
        # @!attribute [rw] database
        #   @return [::String]
        #     Optional. Name of the database to which the import will be done.
        #     For import from SQL file, this is required only if the file does not
        #     specify a database.
        #     Note - Value provided should be the same as expected from `SELECT
        #     current_database();` and NOT as a resource reference.
        # @!attribute [rw] user
        #   @return [::String]
        #     Optional. Database user to be used for importing the data.
        #     Note - Value provided should be the same as expected from
        #     `SELECT current_user;` and NOT as a resource reference.
        class ImportClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Options for importing data in SQL format.
          class SqlImportOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Options for importing data in CSV format.
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The database table to import CSV file into.
          # @!attribute [rw] columns
          #   @return [::Array<::String>]
          #     Optional. The columns to which CSV data is imported. If not specified,
          #     all columns of the database table are loaded with CSV data.
          # @!attribute [rw] field_delimiter
          #   @return [::String]
          #     Optional. Specifies the character that separates columns within each row
          #     (line) of the file. The default is comma. The value of this argument has
          #     to be a character in Hex ASCII Code.
          # @!attribute [rw] quote_character
          #   @return [::String]
          #     Optional. Specifies the quoting character to be used when a data value is
          #     quoted. The default is double-quote. The value of this argument has to be
          #     a character in Hex ASCII Code.
          # @!attribute [rw] escape_character
          #   @return [::String]
          #     Optional. Specifies the character that should appear before a data
          #     character that needs to be escaped. The default is same as quote
          #     character. The value of this argument has to be a character in Hex ASCII
          #     Code.
          class CsvImportOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response of import rpc.
        # @!attribute [rw] bytes_downloaded
        #   @return [::Integer]
        #     Required. Size of the object downloaded from Google Cloud Storage in bytes.
        class ImportClusterResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Upgrades a cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the cluster.
        # @!attribute [rw] version
        #   @return [::Google::Cloud::AlloyDB::V1beta::DatabaseVersion]
        #     Required. The version the cluster is going to be upgraded to.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the Cluster.
        #     If an etag is provided and does not match the current etag of the Cluster,
        #     upgrade will be blocked and an ABORTED error will be returned.
        class UpgradeClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpgradeClusterResponse contains the response for upgrade cluster operation.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Status]
        #     Status of upgrade operation.
        # @!attribute [rw] message
        #   @return [::String]
        #     A user friendly message summarising the upgrade operation details and the
        #     next steps for the user if there is any.
        # @!attribute [rw] cluster_upgrade_details
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::ClusterUpgradeDetails>]
        #     Array of upgrade details for the current cluster and all the secondary
        #     clusters associated with this cluster.
        class UpgradeClusterResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Stage information for different stages in the upgrade process.
          # @!attribute [rw] stage
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Stage]
          #     The stage.
          # @!attribute [rw] status
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Status]
          #     Status of the stage.
          # @!attribute [rw] logs_url
          #   @return [::String]
          #     logs_url is the URL for the logs associated with a stage if that stage
          #     has logs. Right now, only three stages have logs: ALLOYDB_PRECHECK,
          #     PG_UPGRADE_CHECK, PRIMARY_INSTANCE_UPGRADE.
          class StageInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details regarding the upgrade of instances associated with a cluster.
          # @!attribute [rw] name
          #   @return [::String]
          #     Normalized name of the instance.
          # @!attribute [rw] upgrade_status
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Status]
          #     Upgrade status of the instance.
          # @!attribute [rw] instance_type
          #   @return [::Google::Cloud::AlloyDB::V1beta::Instance::InstanceType]
          #     Instance type.
          class InstanceUpgradeDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Upgrade details of a cluster. This cluster can be primary or secondary.
          # @!attribute [rw] name
          #   @return [::String]
          #     Normalized name of the cluster
          # @!attribute [rw] upgrade_status
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Status]
          #     Upgrade status of the cluster.
          # @!attribute [rw] cluster_type
          #   @return [::Google::Cloud::AlloyDB::V1beta::Cluster::ClusterType]
          #     Cluster type which can either be primary or secondary.
          # @!attribute [rw] database_version
          #   @return [::Google::Cloud::AlloyDB::V1beta::DatabaseVersion]
          #     Database version of the cluster after the upgrade operation. This will be
          #     the target version if the upgrade was successful otherwise it remains the
          #     same as that before the upgrade operation.
          # @!attribute [rw] stage_info
          #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::StageInfo>]
          #     Array containing stage info associated with this cluster.
          # @!attribute [rw] instance_upgrade_details
          #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::InstanceUpgradeDetails>]
          #     Upgrade details of the instances directly associated with this cluster.
          class ClusterUpgradeDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Status of upgrade operation.
          module Status
            # Unspecified status.
            STATUS_UNSPECIFIED = 0

            # Not started.
            NOT_STARTED = 4

            # In progress.
            IN_PROGRESS = 5

            # Operation succeeded.
            SUCCESS = 1

            # Operation failed.
            FAILED = 2

            # Operation partially succeeded.
            PARTIAL_SUCCESS = 3

            # Cancel is in progress.
            CANCEL_IN_PROGRESS = 6

            # Cancellation complete.
            CANCELLED = 7
          end

          # Stage in the upgrade.
          module Stage
            # Unspecified stage.
            STAGE_UNSPECIFIED = 0

            # Pre-upgrade custom checks, not covered by pg_upgrade.
            ALLOYDB_PRECHECK = 1

            # Pre-upgrade pg_upgrade checks.
            PG_UPGRADE_CHECK = 2

            # Clone the original cluster.
            PREPARE_FOR_UPGRADE = 5

            # Upgrade the primary instance(downtime).
            PRIMARY_INSTANCE_UPGRADE = 3

            # This stage is read pool upgrade.
            READ_POOL_INSTANCES_UPGRADE = 4

            # Rollback in case of critical failures.
            ROLLBACK = 6

            # Cleanup.
            CLEANUP = 7
          end
        end

        # Message for deleting a Cluster
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Cluster.name field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the Cluster.
        #     If an etag is provided and does not match the current etag of the Cluster,
        #     deletion will be blocked and an ABORTED error will be returned.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Whether to cascade delete child instances for given cluster.
        class DeleteClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for switching over to a cluster
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Cluster.name field
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class SwitchoverClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for promoting a Cluster
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Cluster.name field
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the Cluster.
        #     If an etag is provided and does not match the current etag of the Cluster,
        #     deletion will be blocked and an ABORTED error will be returned.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class PromoteClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for restoring a Cluster from a backup or another cluster at a given
        # point in time.
        # NEXT_ID: 11
        # @!attribute [rw] backup_source
        #   @return [::Google::Cloud::AlloyDB::V1beta::BackupSource]
        #     Backup source.
        #
        #     Note: The following fields are mutually exclusive: `backup_source`, `continuous_backup_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] continuous_backup_source
        #   @return [::Google::Cloud::AlloyDB::V1beta::ContinuousBackupSource]
        #     ContinuousBackup source. Continuous backup needs to be enabled in the
        #     source cluster for this operation to succeed.
        #
        #     Note: The following fields are mutually exclusive: `continuous_backup_source`, `backup_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. For the required format, see the
        #     comment on the Cluster.name field.
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::AlloyDB::V1beta::Cluster]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class RestoreClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Instances
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. For the required format, see the
        #     comment on the Instance.name field. Additionally, you can perform an
        #     aggregated list operation by specifying a value with one of the following
        #     formats:
        #      * projects/\\{project}/locations/-/clusters/-
        #      * projects/\\{project}/locations/\\{region}/clusters/-
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Instances
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::Instance>]
        #     The list of Instance
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Instance
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Instance.name field.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::AlloyDB::V1beta::InstanceView]
        #     The view of the instance to return.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Instance
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. For the required format, see the
        #     comment on the Instance.name field.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AlloyDB::V1beta::Instance]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class CreateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Secondary Instance
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. For the required format, see the
        #     comment on the Instance.name field.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AlloyDB::V1beta::Instance]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class CreateSecondaryInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # See usage below for notes.
        # @!attribute [rw] create_instance_requests
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::CreateInstanceRequest>]
        #     Required. Primary and read replica instances to be created. This list
        #     should not be empty.
        class CreateInstanceRequests
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a batch of instances under the specified cluster.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource.
        # @!attribute [rw] requests
        #   @return [::Google::Cloud::AlloyDB::V1beta::CreateInstanceRequests]
        #     Required. Resources being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class BatchCreateInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating batches of instances in a cluster.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::Instance>]
        #     Created instances.
        class BatchCreateInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for metadata that is specific to BatchCreateInstances API.
        # NEXT_ID: 3
        # @!attribute [rw] instance_targets
        #   @return [::Array<::String>]
        #     The instances being created in the API call. Each string in this list
        #     is the server defined resource path for target instances in the request
        #     and for the format of each string, see the comment on the Instance.name
        #     field.
        # @!attribute [rw] instance_statuses
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::AlloyDB::V1beta::BatchCreateInstanceStatus}]
        #     A map representing state of the instances involved in the
        #     BatchCreateInstances operation during the operation execution.
        #     The instance state will be in STATE_UNSPECIFIED state if the instance has
        #     not yet been picked up for processing.
        #     The key of the map is the name of the instance resource.
        #     For the format, see the comment on the Instance.name field.
        class BatchCreateInstancesMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::AlloyDB::V1beta::BatchCreateInstanceStatus]
          class InstanceStatusesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for current status of an instance in the BatchCreateInstances
        # operation.
        # For example, lets say a BatchCreateInstances workflow has 4 instances,
        # Instance1 through Instance4. Lets also assume that 2 instances succeeded
        # but the third failed to create and the 4th was never picked up for creation
        # because of failure of the previous one. Then, resulting states would look
        # something like:
        #   1. Instance1 = ROLLED_BACK
        #   2. Instance2 = ROLLED_BACK
        #   3. Instance3 = FAILED
        #   4. Instance4 = FAILED
        #
        # However, while the operation is running, the instance might be in other
        # states including PENDING_CREATE, ACTIVE, DELETING and CREATING. The states
        # / do not get further updated once the operation is done.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::AlloyDB::V1beta::BatchCreateInstanceStatus::State]
        #     The current state of an instance involved in the batch create operation.
        #     Once the operation is complete, the final state of the instances in the
        #     LRO can be one of:
        #       1. ACTIVE, indicating that instances were created successfully
        #       2. FAILED, indicating that a particular instance failed creation
        #       3. ROLLED_BACK indicating that although the instance was created
        #          successfully, it had to be rolled back and deleted due to failure in
        #          other steps of the workflow.
        # @!attribute [rw] error_msg
        #   @return [::String]
        #     DEPRECATED - Use the error field instead.
        #     Error, if any error occurred and is available, during instance creation.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     The RPC status of the instance creation operation. This field will be
        #     present if an error happened during the instance creation.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::AlloyDB::V1beta::Instance::InstanceType]
        class BatchCreateInstanceStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State contains all valid instance states for the BatchCreateInstances
          # operation. This is mainly used for status reporting through the LRO
          # metadata.
          module State
            # The state of the instance is unknown.
            STATE_UNSPECIFIED = 0

            # Instance is pending creation and has not yet been picked up for
            # processing in the backend.
            PENDING_CREATE = 1

            # The instance is active and running.
            READY = 2

            # The instance is being created.
            CREATING = 3

            # The instance is being deleted.
            DELETING = 4

            # The creation of the instance failed or a fatal error occurred during
            # an operation on the instance or a batch of instances.
            FAILED = 5

            # The instance was created successfully, but was rolled back and deleted
            # due to some other failure during BatchCreateInstances operation.
            ROLLED_BACK = 6
          end
        end

        # Message for updating a Instance
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Instance resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::AlloyDB::V1beta::Instance]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, update succeeds even if instance is not found. In
        #     that case, a new instance is created and `update_mask` is ignored.
        class UpdateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Instance
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Instance.name field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the Instance.
        #     If an etag is provided and does not match the current etag of the Instance,
        #     deletion will be blocked and an ABORTED error will be returned.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class DeleteInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for triggering failover on an Instance
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Instance.name field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class FailoverInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for triggering fault injection on an instance
        # @!attribute [rw] fault_type
        #   @return [::Google::Cloud::AlloyDB::V1beta::InjectFaultRequest::FaultType]
        #     Required. The type of fault to be injected in an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Instance.name field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        class InjectFaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # FaultType contains all valid types of faults that can be injected to an
          # instance.
          module FaultType
            # The fault type is unknown.
            FAULT_TYPE_UNSPECIFIED = 0

            # Stop the VM
            STOP_VM = 1
          end
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the Instance.name field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, performs request validation, for example, permission
        #     checks and any other type of validation, but does not actually execute the
        #     create request.
        # @!attribute [rw] node_ids
        #   @return [::Array<::String>]
        #     Optional. Full name of the nodes as obtained from INSTANCE_VIEW_FULL to
        #     restart upon. Applicable only to read instances.
        class RestartInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ExecuteSql rpc.
        # @!attribute [rw] password
        #   @return [::String]
        #     Optional. The database native user’s password.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Required. The instance where the SQL will be executed. For the required
        #     format, see the comment on the Instance.name field.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. Name of the database where the query will be executed.
        #     Note - Value provided should be the same as expected from `SELECT
        #     current_database();` and NOT as a resource reference.
        # @!attribute [rw] user
        #   @return [::String]
        #     Required. Database user to be used for executing the SQL.
        #     Note - Value provided should be the same as expected from
        #     `SELECT current_user;` and NOT as a resource reference.
        # @!attribute [rw] sql_statement
        #   @return [::String]
        #     Required. SQL statement to execute on database. Any valid statement is
        #     permitted, including DDL, DML, DQL statements.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validates the sql statement by performing
        #     syntax and semantic validation and doesn't execute the query.
        class ExecuteSqlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Execute a SQL statement response.
        # @!attribute [rw] sql_results
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::SqlResult>]
        #     SqlResult represents the results for the execution of sql statements.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::AlloyDB::V1beta::ExecuteSqlMetadata]
        #     Any additional metadata information regarding the execution of the sql
        #     statement.
        class ExecuteSqlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Any additional metadata information regarding the execution of the SQL
        # @!attribute [rw] message
        #   @return [::String]
        #     Message related to SQL execution. Marked as core content since it
        #     can potentially contain details related to the query or result set. This
        #     field can be used to convey messages such as "when the SQL result set
        #     exceeds the acceptable response size limits."
        # @!attribute [rw] partial_result
        #   @return [::Boolean]
        #     Set to true if SQL returned a result set larger than the acceptable
        #     response size limits and the result was truncated.
        # @!attribute [rw] sql_statement_execution_duration
        #   @return [::Google::Protobuf::Duration]
        #     The time duration taken to execute the sql statement.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::AlloyDB::V1beta::ExecuteSqlMetadata::Status]
        #     Status of SQL execution.
        class ExecuteSqlMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Status contains all valid Status a SQL execution can end up in.
          module Status
            # The status is unknown.
            STATUS_UNSPECIFIED = 0

            # No error during SQL execution i.e. All SQL statements ran to completion.
            # The "message" will be empty.
            OK = 1

            # Same as OK, except indicates that only partial results were
            # returned. The "message" field will contain details on why results were
            # truncated.
            PARTIAL = 2

            # Error during SQL execution. Atleast 1 SQL statement execution resulted in
            # a error. Side effects of other statements are rolled back.  The "message"
            # field will contain human readable error given by Postgres of the first
            # bad SQL statement. SQL execution errors don't constitute API errors as
            # defined in https://google.aip.dev/193 but will be returned as part of
            # this message.
            ERROR = 3
          end
        end

        # Message for requesting list of Backups
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListBackupsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListBackupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Backups
        # @!attribute [rw] backups
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::Backup>]
        #     The list of Backup
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Backup
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Backup
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] backup_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::AlloyDB::V1beta::Backup]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, the backend validates the request, but doesn't actually
        #     execute it.
        class CreateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Backup
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Backup resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::AlloyDB::V1beta::Backup]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, the backend validates the request, but doesn't actually
        #     execute it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, update succeeds even if instance is not found. In
        #     that case, a new backup is created and `update_mask` is ignored.
        class UpdateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Backup
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource. For the required format, see the comment on
        #     the Backup.name field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, the backend validates the request, but doesn't actually
        #     execute it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the Backup.
        #     If an etag is provided and does not match the current etag of the Backup,
        #     deletion will be blocked and an ABORTED error will be returned.
        class DeleteBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for listing the information about the supported Database flags.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. The required format is:
        #      * projects/\\{project}/locations/\\{location}
        #
        #     Regardless of the parent specified here, as long it is contains a valid
        #     project and location, the service will return a static list of supported
        #     flags resources. Note that we do not yet support region-specific
        #     flags.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::AlloyDB::V1beta::SupportedDatabaseFlag::Scope]
        #     Optional. The scope for which supported flags are requested. If not
        #     specified, default is DATABASE.
        class ListSupportedDatabaseFlagsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing SupportedDatabaseFlags.
        # @!attribute [rw] supported_database_flags
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::SupportedDatabaseFlag>]
        #     The list of SupportedDatabaseFlags.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListSupportedDatabaseFlagsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requests to generate a client certificate signed by the Cluster
        # CA.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. The required format is:
        #      * projects/\\{project}/locations/\\{location}/clusters/\\{cluster}
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] pem_csr
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Optional. A pem-encoded X.509 certificate signing request (CSR). It is
        #     recommended to use public_key instead.
        # @!attribute [rw] cert_duration
        #   @return [::Google::Protobuf::Duration]
        #     Optional. An optional hint to the endpoint to generate the client
        #     certificate with the requested duration. The duration can be from 1 hour to
        #     24 hours. The endpoint may or may not honor the hint. If the hint is left
        #     unspecified or is not honored, then the endpoint will pick an appropriate
        #     default duration.
        # @!attribute [rw] public_key
        #   @return [::String]
        #     Optional. The public key from the client.
        # @!attribute [rw] use_metadata_exchange
        #   @return [::Boolean]
        #     Optional. An optional hint to the endpoint to generate a client certificate
        #     that can be used by AlloyDB connectors to exchange additional metadata with
        #     the server after TLS handshake.
        class GenerateClientCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message returned by a GenerateClientCertificate operation.
        # @!attribute [r] pem_certificate
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. The pem-encoded, signed X.509 certificate.
        # @!attribute [r] pem_certificate_chain
        #   @return [::Array<::String>]
        #     Output only. The pem-encoded chain that may be used to verify the X.509
        #     certificate. Expected to be in issuer-to-root order according to RFC 5246.
        # @!attribute [rw] ca_cert
        #   @return [::String]
        #     Optional. The pem-encoded cluster ca X.509 certificate.
        class GenerateClientCertificateResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetConnectionInfo.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource. The required format is:
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}/instances/\\{instance}
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class GetConnectionInfoRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] batch_create_instances_metadata
        #   @return [::Google::Cloud::AlloyDB::V1beta::BatchCreateInstancesMetadata]
        #     Output only. BatchCreateInstances related metadata.
        #
        #     Note: The following fields are mutually exclusive: `batch_create_instances_metadata`, `promote_cluster_status`, `upgrade_cluster_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] promote_cluster_status
        #   @return [::Google::Cloud::AlloyDB::V1beta::PromoteClusterStatus]
        #     Output only. PromoteClusterStatus related metadata.
        #
        #     Note: The following fields are mutually exclusive: `promote_cluster_status`, `batch_create_instances_metadata`, `upgrade_cluster_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] upgrade_cluster_status
        #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterStatus]
        #     Output only. UpgradeClusterStatus related metadata.
        #
        #     Note: The following fields are mutually exclusive: `upgrade_cluster_status`, `batch_create_instances_metadata`, `promote_cluster_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for current status of the database during Promote Cluster operation.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AlloyDB::V1beta::PromoteClusterStatus::State]
        #     Output only. The current state of the promoted secondary's database.
        #     Once the operation is complete, the final state of the database in the
        #     LRO can be one of:
        #       1. PROMOTE_CLUSTER_AVAILABLE_FOR_READ, indicating that the promote
        #       operation has failed mid-way, the database is still only available for
        #       read.
        #       2. PROMOTE_CLUSTER_COMPLETED, indicating that a promote operation
        #       completed successfully. The database is available for both read and write
        #       requests
        class PromoteClusterStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State contains all valid states of the database during promote cluster
          # operation. This is used for status reporting through the LRO metadata.
          module State
            # The state of the database is unknown.
            STATE_UNSPECIFIED = 0

            # The database is only available for read.
            PROMOTE_CLUSTER_AVAILABLE_FOR_READ = 1

            # The database is available for both read and write. The promote operation
            # is near completion.
            PROMOTE_CLUSTER_AVAILABLE_FOR_WRITE = 2

            # The promote operation is completed and the database is available for
            # write.
            PROMOTE_CLUSTER_COMPLETED = 3
          end
        end

        # Message for current status of the Major Version Upgrade operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Status]
        #     Cluster Major Version Upgrade state.
        # @!attribute [rw] cancellable
        #   @return [::Boolean]
        #     Whether the operation is cancellable.
        # @!attribute [rw] source_version
        #   @return [::Google::Cloud::AlloyDB::V1beta::DatabaseVersion]
        #     Source database major version.
        # @!attribute [rw] target_version
        #   @return [::Google::Cloud::AlloyDB::V1beta::DatabaseVersion]
        #     Target database major version.
        # @!attribute [rw] stages
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::UpgradeClusterStatus::StageStatus>]
        #     Status of all upgrade stages.
        class UpgradeClusterStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Status of an upgrade stage.
          # @!attribute [rw] read_pool_instances_upgrade
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterStatus::ReadPoolInstancesUpgradeStageStatus]
          #     Read pool instances upgrade metadata.
          # @!attribute [rw] stage
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Stage]
          #     Upgrade stage.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterResponse::Status]
          #     State of this stage.
          # @!attribute [r] schedule
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterStatus::StageStatus::StageSchedule]
          #     Output only. Timing information for the stage execution.
          class StageStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Timing information for the stage execution.
            # @!attribute [rw] estimated_start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     When the stage is expected to start. Set only if the stage has not
            #     started yet.
            # @!attribute [rw] actual_start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Actual start time of the stage. Set only if the stage has started.
            # @!attribute [rw] estimated_end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     When the stage is expected to end. Set only if the stage has not
            #     completed yet.
            # @!attribute [rw] actual_end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Actual end time of the stage. Set only if the stage has completed.
            class StageSchedule
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Read pool instances upgrade specific status.
          # @!attribute [rw] upgrade_stats
          #   @return [::Google::Cloud::AlloyDB::V1beta::UpgradeClusterStatus::ReadPoolInstancesUpgradeStageStatus::Stats]
          #     Read pool instances upgrade statistics.
          class ReadPoolInstancesUpgradeStageStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Upgrade stats for read pool instances.
            # @!attribute [rw] not_started
            #   @return [::Integer]
            #     Number of read pool instances for which upgrade has not started.
            # @!attribute [rw] ongoing
            #   @return [::Integer]
            #     Number of read pool instances undergoing upgrade.
            # @!attribute [rw] success
            #   @return [::Integer]
            #     Number of read pool instances successfully upgraded.
            # @!attribute [rw] failed
            #   @return [::Integer]
            #     Number of read pool instances which failed to upgrade.
            class Stats
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Message for requesting list of Users
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListUsersRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListUsersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Users
        # @!attribute [rw] users
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::User>]
        #     The list of User
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListUsersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a User
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the User.name field.
        class GetUserRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a User
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] user_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        # @!attribute [rw] user
        #   @return [::Google::Cloud::AlloyDB::V1beta::User]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, the backend validates the request, but doesn't actually
        #     execute it.
        class CreateUserRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a User
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     User resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] user
        #   @return [::Google::Cloud::AlloyDB::V1beta::User]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, the backend validates the request, but doesn't actually
        #     execute it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. Allow missing fields in the update mask.
        class UpdateUserRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a User
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource. For the required format, see the
        #     comment on the User.name field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server ignores the
        #     request if it has already been completed. The server guarantees that for at
        #     least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, the backend validates the request, but doesn't actually
        #     execute it.
        class DeleteUserRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for ListDatabases request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListDatabasesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of databases to return. The service may return
        #     fewer than this value. If unspecified, 2000 is the default page_size. The
        #     max value of page_size will be 4000, values above max will be coerced to
        #     max.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDatabases` call.
        #     This should be provided to retrieve the subsequent page.
        #     This field is currently not supported, its value will be ignored if passed.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        #     This field is currently not supported, its value will be ignored if passed.
        class ListDatabasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for ListDatabases response.
        # @!attribute [rw] databases
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::Database>]
        #     The list of databases.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying the next page of results the server should return.
        #     If this field is omitted, there are no subsequent pages.
        class ListDatabasesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for CreateDatabase request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] database_id
        #   @return [::String]
        #     Required. ID of the requesting object.
        # @!attribute [rw] database
        #   @return [::Google::Cloud::AlloyDB::V1beta::Database]
        #     Required. The resource being created.
        class CreateDatabaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
