# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AlloyDB
      module V1beta
        # SqlResult represents the result for the execution of a sql statement.
        # @!attribute [rw] columns
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::SqlResultColumn>]
        #     List of columns included in the result. This also includes the data type
        #     of the column.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::SqlResultRow>]
        #     Rows returned by the SQL statement.
        class SqlResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains the name and datatype of a column in a SQL Result.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the column.
        # @!attribute [rw] type
        #   @return [::String]
        #     Datatype of the column as reported by the postgres driver.
        #     Common type names are "VARCHAR", "TEXT", "NVARCHAR", "DECIMAL", "BOOL",
        #     "INT", and "BIGINT".
        class SqlResultColumn
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single row from a sql result.
        # @!attribute [rw] values
        #   @return [::Array<::Google::Cloud::AlloyDB::V1beta::SqlResultValue>]
        #     List of values in a row of sql result.
        class SqlResultRow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single value in a row from a sql result.
        # @!attribute [rw] value
        #   @return [::String]
        #     The cell value represented in string format.
        #     Timestamps are converted to string using RFC3339Nano format.
        # @!attribute [rw] null_value
        #   @return [::Boolean]
        #     Set to true if cell value is null.
        class SqlResultValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
