# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/alloydb/v1alpha/csql_service_pb"
require "google/cloud/alloy_db/v1alpha/alloy_db_cloud_sql_admin"

class ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_restore_from_cloud_sql
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    cloudsql_backup_run_source = {}
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}

    restore_from_cloud_sql_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restore_from_cloud_sql, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::RestoreFromCloudSQLRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::CloudSQLBackupRunSource), request["cloudsql_backup_run_source"]
      assert_equal :cloudsql_backup_run_source, request.source
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Cluster), request["cluster"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restore_from_cloud_sql_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restore_from_cloud_sql({ cloudsql_backup_run_source: cloudsql_backup_run_source, parent: parent, cluster_id: cluster_id, cluster: cluster }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restore_from_cloud_sql cloudsql_backup_run_source: cloudsql_backup_run_source, parent: parent, cluster_id: cluster_id, cluster: cluster do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restore_from_cloud_sql ::Google::Cloud::AlloyDB::V1alpha::RestoreFromCloudSQLRequest.new(cloudsql_backup_run_source: cloudsql_backup_run_source, parent: parent, cluster_id: cluster_id, cluster: cluster) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restore_from_cloud_sql({ cloudsql_backup_run_source: cloudsql_backup_run_source, parent: parent, cluster_id: cluster_id, cluster: cluster }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restore_from_cloud_sql(::Google::Cloud::AlloyDB::V1alpha::RestoreFromCloudSQLRequest.new(cloudsql_backup_run_source: cloudsql_backup_run_source, parent: parent, cluster_id: cluster_id, cluster: cluster), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restore_from_cloud_sql_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::AlloyDBCloudSQLAdmin::Operations, client.operations_client
  end
end
