# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/alloydb/v1alpha/service_pb"
require "google/cloud/alloy_db/v1alpha/alloy_db_admin"

class ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_clusters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ListClustersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clusters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_clusters, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ListClustersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_clusters_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_clusters ::Google::Cloud::AlloyDB::V1alpha::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_clusters(::Google::Cloud::AlloyDB::V1alpha::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_clusters_client_stub.call_rpc_count
    end
  end

  def test_get_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::Cluster.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CLUSTER_VIEW_UNSPECIFIED

    get_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::GetClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :CLUSTER_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_cluster({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_cluster name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_cluster ::Google::Cloud::AlloyDB::V1alpha::GetClusterRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_cluster({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_cluster(::Google::Cloud::AlloyDB::V1alpha::GetClusterRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_cluster_client_stub.call_rpc_count
    end
  end

  def test_create_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}
    request_id = "hello world"
    validate_only = true

    create_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::CreateClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Cluster), request["cluster"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_cluster parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_cluster ::Google::Cloud::AlloyDB::V1alpha::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_cluster(::Google::Cloud::AlloyDB::V1alpha::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_cluster_client_stub.call_rpc_count
    end
  end

  def test_update_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    cluster = {}
    request_id = "hello world"
    validate_only = true
    allow_missing = true

    update_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::UpdateClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Cluster), request["cluster"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_cluster update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_cluster ::Google::Cloud::AlloyDB::V1alpha::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_cluster(::Google::Cloud::AlloyDB::V1alpha::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_cluster_client_stub.call_rpc_count
    end
  end

  def test_export_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_destination = {}
    csv_export_options = {}
    name = "hello world"
    database = "hello world"

    export_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::GcsDestination), request["gcs_destination"]
      assert_equal :gcs_destination, request.destination
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest::CsvExportOptions), request["csv_export_options"]
      assert_equal :csv_export_options, request.export_options
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["database"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_cluster({ gcs_destination: gcs_destination, csv_export_options: csv_export_options, name: name, database: database }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_cluster gcs_destination: gcs_destination, csv_export_options: csv_export_options, name: name, database: database do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_cluster ::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest.new(gcs_destination: gcs_destination, csv_export_options: csv_export_options, name: name, database: database) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_cluster({ gcs_destination: gcs_destination, csv_export_options: csv_export_options, name: name, database: database }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_cluster(::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest.new(gcs_destination: gcs_destination, csv_export_options: csv_export_options, name: name, database: database), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_cluster_client_stub.call_rpc_count
    end
  end

  def test_import_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    sql_import_options = {}
    name = "hello world"
    gcs_uri = "hello world"
    database = "hello world"
    user = "hello world"

    import_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest::SqlImportOptions), request["sql_import_options"]
      assert_equal :sql_import_options, request.import_options
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["gcs_uri"]
      assert_equal "hello world", request["database"]
      assert_equal "hello world", request["user"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_cluster({ sql_import_options: sql_import_options, name: name, gcs_uri: gcs_uri, database: database, user: user }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_cluster sql_import_options: sql_import_options, name: name, gcs_uri: gcs_uri, database: database, user: user do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_cluster ::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest.new(sql_import_options: sql_import_options, name: name, gcs_uri: gcs_uri, database: database, user: user) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_cluster({ sql_import_options: sql_import_options, name: name, gcs_uri: gcs_uri, database: database, user: user }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_cluster(::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest.new(sql_import_options: sql_import_options, name: name, gcs_uri: gcs_uri, database: database, user: user), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_cluster_client_stub.call_rpc_count
    end
  end

  def test_upgrade_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    version = :DATABASE_VERSION_UNSPECIFIED
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    upgrade_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upgrade_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::UpgradeClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :DATABASE_VERSION_UNSPECIFIED, request["version"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upgrade_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upgrade_cluster({ name: name, version: version, request_id: request_id, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upgrade_cluster name: name, version: version, request_id: request_id, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upgrade_cluster ::Google::Cloud::AlloyDB::V1alpha::UpgradeClusterRequest.new(name: name, version: version, request_id: request_id, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upgrade_cluster({ name: name, version: version, request_id: request_id, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upgrade_cluster(::Google::Cloud::AlloyDB::V1alpha::UpgradeClusterRequest.new(name: name, version: version, request_id: request_id, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upgrade_cluster_client_stub.call_rpc_count
    end
  end

  def test_delete_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"
    validate_only = true
    force = true

    delete_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::DeleteClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_cluster({ name: name, request_id: request_id, etag: etag, validate_only: validate_only, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_cluster name: name, request_id: request_id, etag: etag, validate_only: validate_only, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_cluster ::Google::Cloud::AlloyDB::V1alpha::DeleteClusterRequest.new(name: name, request_id: request_id, etag: etag, validate_only: validate_only, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_cluster({ name: name, request_id: request_id, etag: etag, validate_only: validate_only, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_cluster(::Google::Cloud::AlloyDB::V1alpha::DeleteClusterRequest.new(name: name, request_id: request_id, etag: etag, validate_only: validate_only, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_cluster_client_stub.call_rpc_count
    end
  end

  def test_promote_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"
    validate_only = true

    promote_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :promote_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::PromoteClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, promote_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.promote_cluster({ name: name, request_id: request_id, etag: etag, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.promote_cluster name: name, request_id: request_id, etag: etag, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.promote_cluster ::Google::Cloud::AlloyDB::V1alpha::PromoteClusterRequest.new(name: name, request_id: request_id, etag: etag, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.promote_cluster({ name: name, request_id: request_id, etag: etag, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.promote_cluster(::Google::Cloud::AlloyDB::V1alpha::PromoteClusterRequest.new(name: name, request_id: request_id, etag: etag, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, promote_cluster_client_stub.call_rpc_count
    end
  end

  def test_switchover_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true

    switchover_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :switchover_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::SwitchoverClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, switchover_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.switchover_cluster({ name: name, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.switchover_cluster name: name, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.switchover_cluster ::Google::Cloud::AlloyDB::V1alpha::SwitchoverClusterRequest.new(name: name, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.switchover_cluster({ name: name, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.switchover_cluster(::Google::Cloud::AlloyDB::V1alpha::SwitchoverClusterRequest.new(name: name, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, switchover_cluster_client_stub.call_rpc_count
    end
  end

  def test_restore_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    backup_source = {}
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}
    request_id = "hello world"
    validate_only = true

    restore_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restore_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::RestoreClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::BackupSource), request["backup_source"]
      assert_equal :backup_source, request.source
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Cluster), request["cluster"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restore_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restore_cluster({ backup_source: backup_source, parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restore_cluster backup_source: backup_source, parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restore_cluster ::Google::Cloud::AlloyDB::V1alpha::RestoreClusterRequest.new(backup_source: backup_source, parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restore_cluster({ backup_source: backup_source, parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restore_cluster(::Google::Cloud::AlloyDB::V1alpha::RestoreClusterRequest.new(backup_source: backup_source, parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restore_cluster_client_stub.call_rpc_count
    end
  end

  def test_create_secondary_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}
    request_id = "hello world"
    validate_only = true

    create_secondary_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_secondary_cluster, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Cluster), request["cluster"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_secondary_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_secondary_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_secondary_cluster parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_secondary_cluster ::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_secondary_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_secondary_cluster(::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_secondary_cluster_client_stub.call_rpc_count
    end
  end

  def test_list_instances
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ListInstancesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_instances, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ListInstancesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_instances_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_instances ::Google::Cloud::AlloyDB::V1alpha::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_instances(::Google::Cloud::AlloyDB::V1alpha::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_instances_client_stub.call_rpc_count
    end
  end

  def test_get_instance
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::Instance.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :INSTANCE_VIEW_UNSPECIFIED

    get_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instance, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::GetInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :INSTANCE_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instance_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instance({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instance name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instance ::Google::Cloud::AlloyDB::V1alpha::GetInstanceRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instance({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instance(::Google::Cloud::AlloyDB::V1alpha::GetInstanceRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instance_client_stub.call_rpc_count
    end
  end

  def test_create_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}
    request_id = "hello world"
    validate_only = true

    create_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_instance, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["instance_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Instance), request["instance"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_instance_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_instance parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_instance ::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_instance(::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_instance_client_stub.call_rpc_count
    end
  end

  def test_create_secondary_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}
    request_id = "hello world"
    validate_only = true

    create_secondary_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_secondary_instance, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryInstanceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["instance_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Instance), request["instance"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_secondary_instance_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_secondary_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_secondary_instance parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_secondary_instance ::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_secondary_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_secondary_instance(::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_secondary_instance_client_stub.call_rpc_count
    end
  end

  def test_batch_create_instances
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = {}
    request_id = "hello world"

    batch_create_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_instances, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::BatchCreateInstancesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequests), request["requests"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_instances_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_instances({ parent: parent, requests: requests, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_instances parent: parent, requests: requests, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_instances ::Google::Cloud::AlloyDB::V1alpha::BatchCreateInstancesRequest.new(parent: parent, requests: requests, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_instances({ parent: parent, requests: requests, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_instances(::Google::Cloud::AlloyDB::V1alpha::BatchCreateInstancesRequest.new(parent: parent, requests: requests, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_instances_client_stub.call_rpc_count
    end
  end

  def test_update_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    instance = {}
    request_id = "hello world"
    validate_only = true
    allow_missing = true

    update_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_instance, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::UpdateInstanceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Instance), request["instance"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_instance_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_instance({ update_mask: update_mask, instance: instance, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_instance update_mask: update_mask, instance: instance, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_instance ::Google::Cloud::AlloyDB::V1alpha::UpdateInstanceRequest.new(update_mask: update_mask, instance: instance, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_instance({ update_mask: update_mask, instance: instance, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_instance(::Google::Cloud::AlloyDB::V1alpha::UpdateInstanceRequest.new(update_mask: update_mask, instance: instance, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_instance_client_stub.call_rpc_count
    end
  end

  def test_delete_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"
    validate_only = true

    delete_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_instance, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::DeleteInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_instance_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_instance({ name: name, request_id: request_id, etag: etag, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_instance name: name, request_id: request_id, etag: etag, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_instance ::Google::Cloud::AlloyDB::V1alpha::DeleteInstanceRequest.new(name: name, request_id: request_id, etag: etag, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_instance({ name: name, request_id: request_id, etag: etag, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_instance(::Google::Cloud::AlloyDB::V1alpha::DeleteInstanceRequest.new(name: name, request_id: request_id, etag: etag, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_instance_client_stub.call_rpc_count
    end
  end

  def test_failover_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true

    failover_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :failover_instance, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::FailoverInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, failover_instance_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.failover_instance({ name: name, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.failover_instance name: name, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.failover_instance ::Google::Cloud::AlloyDB::V1alpha::FailoverInstanceRequest.new(name: name, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.failover_instance({ name: name, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.failover_instance(::Google::Cloud::AlloyDB::V1alpha::FailoverInstanceRequest.new(name: name, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, failover_instance_client_stub.call_rpc_count
    end
  end

  def test_inject_fault
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    fault_type = :FAULT_TYPE_UNSPECIFIED
    name = "hello world"
    request_id = "hello world"
    validate_only = true

    inject_fault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :inject_fault, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest, request
      assert_equal :FAULT_TYPE_UNSPECIFIED, request["fault_type"]
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, inject_fault_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.inject_fault({ fault_type: fault_type, name: name, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.inject_fault fault_type: fault_type, name: name, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.inject_fault ::Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest.new(fault_type: fault_type, name: name, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.inject_fault({ fault_type: fault_type, name: name, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.inject_fault(::Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest.new(fault_type: fault_type, name: name, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, inject_fault_client_stub.call_rpc_count
    end
  end

  def test_restart_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    node_ids = ["hello world"]

    restart_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restart_instance, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::RestartInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal ["hello world"], request["node_ids"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restart_instance_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restart_instance({ name: name, request_id: request_id, validate_only: validate_only, node_ids: node_ids }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restart_instance name: name, request_id: request_id, validate_only: validate_only, node_ids: node_ids do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restart_instance ::Google::Cloud::AlloyDB::V1alpha::RestartInstanceRequest.new(name: name, request_id: request_id, validate_only: validate_only, node_ids: node_ids) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restart_instance({ name: name, request_id: request_id, validate_only: validate_only, node_ids: node_ids }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restart_instance(::Google::Cloud::AlloyDB::V1alpha::RestartInstanceRequest.new(name: name, request_id: request_id, validate_only: validate_only, node_ids: node_ids), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restart_instance_client_stub.call_rpc_count
    end
  end

  def test_execute_sql
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    password = "hello world"
    instance = "hello world"
    database = "hello world"
    user = "hello world"
    sql_statement = "hello world"
    validate_only = true

    execute_sql_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :execute_sql, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlRequest, request
      assert_equal "hello world", request["password"]
      assert_equal :password, request.user_credential
      assert_equal "hello world", request["instance"]
      assert_equal "hello world", request["database"]
      assert_equal "hello world", request["user"]
      assert_equal "hello world", request["sql_statement"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_sql_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_sql({ password: password, instance: instance, database: database, user: user, sql_statement: sql_statement, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_sql password: password, instance: instance, database: database, user: user, sql_statement: sql_statement, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_sql ::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlRequest.new(password: password, instance: instance, database: database, user: user, sql_statement: sql_statement, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_sql({ password: password, instance: instance, database: database, user: user, sql_statement: sql_statement, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_sql(::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlRequest.new(password: password, instance: instance, database: database, user: user, sql_statement: sql_statement, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_sql_client_stub.call_rpc_count
    end
  end

  def test_list_backups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ListBackupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backups, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ListBackupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backups_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backups ::Google::Cloud::AlloyDB::V1alpha::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backups(::Google::Cloud::AlloyDB::V1alpha::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backups_client_stub.call_rpc_count
    end
  end

  def test_get_backup
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::Backup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::GetBackupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup ::Google::Cloud::AlloyDB::V1alpha::GetBackupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup(::Google::Cloud::AlloyDB::V1alpha::GetBackupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_client_stub.call_rpc_count
    end
  end

  def test_create_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_id = "hello world"
    backup = {}
    request_id = "hello world"
    validate_only = true

    create_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backup, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::CreateBackupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["backup_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Backup), request["backup"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backup_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backup({ parent: parent, backup_id: backup_id, backup: backup, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backup parent: parent, backup_id: backup_id, backup: backup, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backup ::Google::Cloud::AlloyDB::V1alpha::CreateBackupRequest.new(parent: parent, backup_id: backup_id, backup: backup, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backup({ parent: parent, backup_id: backup_id, backup: backup, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backup(::Google::Cloud::AlloyDB::V1alpha::CreateBackupRequest.new(parent: parent, backup_id: backup_id, backup: backup, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backup_client_stub.call_rpc_count
    end
  end

  def test_update_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup = {}
    request_id = "hello world"
    validate_only = true
    allow_missing = true

    update_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::UpdateBackupRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Backup), request["backup"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup({ update_mask: update_mask, backup: backup, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup update_mask: update_mask, backup: backup, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup ::Google::Cloud::AlloyDB::V1alpha::UpdateBackupRequest.new(update_mask: update_mask, backup: backup, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup({ update_mask: update_mask, backup: backup, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup(::Google::Cloud::AlloyDB::V1alpha::UpdateBackupRequest.new(update_mask: update_mask, backup: backup, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_client_stub.call_rpc_count
    end
  end

  def test_delete_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    delete_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::DeleteBackupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup name: name, request_id: request_id, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup ::Google::Cloud::AlloyDB::V1alpha::DeleteBackupRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup(::Google::Cloud::AlloyDB::V1alpha::DeleteBackupRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_client_stub.call_rpc_count
    end
  end

  def test_list_supported_database_flags
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    scope = :SCOPE_UNSPECIFIED

    list_supported_database_flags_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_supported_database_flags, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :SCOPE_UNSPECIFIED, request["scope"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_supported_database_flags_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_supported_database_flags({ parent: parent, page_size: page_size, page_token: page_token, scope: scope }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_supported_database_flags parent: parent, page_size: page_size, page_token: page_token, scope: scope do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_supported_database_flags ::Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsRequest.new(parent: parent, page_size: page_size, page_token: page_token, scope: scope) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_supported_database_flags({ parent: parent, page_size: page_size, page_token: page_token, scope: scope }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_supported_database_flags(::Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsRequest.new(parent: parent, page_size: page_size, page_token: page_token, scope: scope), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_supported_database_flags_client_stub.call_rpc_count
    end
  end

  def test_generate_client_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    request_id = "hello world"
    pem_csr = "hello world"
    cert_duration = {}
    public_key = "hello world"
    use_metadata_exchange = true

    generate_client_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_client_certificate, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["pem_csr"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["cert_duration"]
      assert_equal "hello world", request["public_key"]
      assert_equal true, request["use_metadata_exchange"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_client_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_client_certificate({ parent: parent, request_id: request_id, pem_csr: pem_csr, cert_duration: cert_duration, public_key: public_key, use_metadata_exchange: use_metadata_exchange }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_client_certificate parent: parent, request_id: request_id, pem_csr: pem_csr, cert_duration: cert_duration, public_key: public_key, use_metadata_exchange: use_metadata_exchange do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_client_certificate ::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateRequest.new(parent: parent, request_id: request_id, pem_csr: pem_csr, cert_duration: cert_duration, public_key: public_key, use_metadata_exchange: use_metadata_exchange) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_client_certificate({ parent: parent, request_id: request_id, pem_csr: pem_csr, cert_duration: cert_duration, public_key: public_key, use_metadata_exchange: use_metadata_exchange }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_client_certificate(::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateRequest.new(parent: parent, request_id: request_id, pem_csr: pem_csr, cert_duration: cert_duration, public_key: public_key, use_metadata_exchange: use_metadata_exchange), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_client_certificate_client_stub.call_rpc_count
    end
  end

  def test_get_connection_info
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ConnectionInfo.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    request_id = "hello world"

    get_connection_info_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connection_info, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::GetConnectionInfoRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connection_info_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connection_info({ parent: parent, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connection_info parent: parent, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connection_info ::Google::Cloud::AlloyDB::V1alpha::GetConnectionInfoRequest.new(parent: parent, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connection_info({ parent: parent, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connection_info(::Google::Cloud::AlloyDB::V1alpha::GetConnectionInfoRequest.new(parent: parent, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connection_info_client_stub.call_rpc_count
    end
  end

  def test_list_users
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ListUsersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_users_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_users, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ListUsersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_users_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_users({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_users parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_users ::Google::Cloud::AlloyDB::V1alpha::ListUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_users({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_users(::Google::Cloud::AlloyDB::V1alpha::ListUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_users_client_stub.call_rpc_count
    end
  end

  def test_get_user
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::User.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_user_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_user, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::GetUserRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_user_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_user({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_user name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_user ::Google::Cloud::AlloyDB::V1alpha::GetUserRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_user({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_user(::Google::Cloud::AlloyDB::V1alpha::GetUserRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_user_client_stub.call_rpc_count
    end
  end

  def test_create_user
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::User.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    user_id = "hello world"
    user = {}
    request_id = "hello world"
    validate_only = true

    create_user_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_user, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::CreateUserRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["user_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::User), request["user"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_user_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_user({ parent: parent, user_id: user_id, user: user, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_user parent: parent, user_id: user_id, user: user, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_user ::Google::Cloud::AlloyDB::V1alpha::CreateUserRequest.new(parent: parent, user_id: user_id, user: user, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_user({ parent: parent, user_id: user_id, user: user, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_user(::Google::Cloud::AlloyDB::V1alpha::CreateUserRequest.new(parent: parent, user_id: user_id, user: user, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_user_client_stub.call_rpc_count
    end
  end

  def test_update_user
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::User.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    user = {}
    request_id = "hello world"
    validate_only = true
    allow_missing = true

    update_user_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_user, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::UpdateUserRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::User), request["user"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_user_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_user({ update_mask: update_mask, user: user, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_user update_mask: update_mask, user: user, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_user ::Google::Cloud::AlloyDB::V1alpha::UpdateUserRequest.new(update_mask: update_mask, user: user, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_user({ update_mask: update_mask, user: user, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_user(::Google::Cloud::AlloyDB::V1alpha::UpdateUserRequest.new(update_mask: update_mask, user: user, request_id: request_id, validate_only: validate_only, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_user_client_stub.call_rpc_count
    end
  end

  def test_delete_user
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true

    delete_user_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_user, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::DeleteUserRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_user_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_user({ name: name, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_user name: name, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_user ::Google::Cloud::AlloyDB::V1alpha::DeleteUserRequest.new(name: name, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_user({ name: name, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_user(::Google::Cloud::AlloyDB::V1alpha::DeleteUserRequest.new(name: name, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_user_client_stub.call_rpc_count
    end
  end

  def test_list_databases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::ListDatabasesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_databases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_databases, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::ListDatabasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_databases_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_databases parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_databases ::Google::Cloud::AlloyDB::V1alpha::ListDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_databases(::Google::Cloud::AlloyDB::V1alpha::ListDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_databases_client_stub.call_rpc_count
    end
  end

  def test_create_database
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AlloyDB::V1alpha::Database.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    database_id = "hello world"
    database = {}

    create_database_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_database, name
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::CreateDatabaseRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["database_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AlloyDB::V1alpha::Database), request["database"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_database_client_stub do
      # Create client
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_database({ parent: parent, database_id: database_id, database: database }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_database parent: parent, database_id: database_id, database: database do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_database ::Google::Cloud::AlloyDB::V1alpha::CreateDatabaseRequest.new(parent: parent, database_id: database_id, database: database) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_database({ parent: parent, database_id: database_id, database: database }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_database(::Google::Cloud::AlloyDB::V1alpha::CreateDatabaseRequest.new(parent: parent, database_id: database_id, database: database), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_database_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Operations, client.operations_client
  end
end
