# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/alloydb/v1alpha/service_pb"
require "google/cloud/alloy_db/v1alpha/alloy_db_admin/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module AlloyDB
      module V1alpha
        module AlloyDBAdmin
          module Rest
            ##
            # REST client for the AlloyDBAdmin service.
            #
            # Service describing handlers for resources
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "alloydb.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :alloy_db_admin_stub

              ##
              # Configure the AlloyDBAdmin Client class.
              #
              # See {::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AlloyDBAdmin clients
              #   ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AlloyDB", "V1alpha"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config.rpcs.list_clusters.timeout = 60.0
                  default_config.rpcs.list_clusters.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_cluster.timeout = 60.0
                  default_config.rpcs.get_cluster.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_instances.timeout = 60.0
                  default_config.rpcs.list_instances.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_instance.timeout = 60.0
                  default_config.rpcs.get_instance.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_backups.timeout = 60.0
                  default_config.rpcs.list_backups.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_backup.timeout = 60.0
                  default_config.rpcs.get_backup.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_supported_database_flags.timeout = 60.0
                  default_config.rpcs.list_supported_database_flags.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.generate_client_certificate.timeout = 60.0
                  default_config.rpcs.generate_client_certificate.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_connection_info.timeout = 60.0
                  default_config.rpcs.get_connection_info.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_users.timeout = 60.0
                  default_config.rpcs.list_users.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_user.timeout = 60.0
                  default_config.rpcs.get_user.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_database.timeout = 60.0
                  default_config.rpcs.create_database.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AlloyDBAdmin Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @alloy_db_admin_stub.universe_domain
              end

              ##
              # Create a new AlloyDBAdmin REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AlloyDBAdmin client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @alloy_db_admin_stub = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @alloy_db_admin_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @alloy_db_admin_stub.endpoint
                  config.universe_domain = @alloy_db_admin_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @alloy_db_admin_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @alloy_db_admin_stub.endpoint
                  config.universe_domain = @alloy_db_admin_stub.universe_domain
                  config.logger = @alloy_db_admin_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @alloy_db_admin_stub.logger
              end

              # Service calls

              ##
              # Lists Clusters in a given project and location.
              #
              # @overload list_clusters(request, options = nil)
              #   Pass arguments to `list_clusters` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ListClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ListClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource. For the required format, see the
              #     comment on the Cluster.name field. Additionally, you can perform an
              #     aggregated list operation by specifying a value with the following format:
              #      * projects/\\{project}/locations/-
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Cluster>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Cluster>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ListClustersRequest.new
              #
              #   # Call the list_clusters method.
              #   result = client.list_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AlloyDB::V1alpha::Cluster.
              #     p item
              #   end
              #
              def list_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ListClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.list_clusters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @alloy_db_admin_stub, :list_clusters, "clusters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Cluster.
              #
              # @overload get_cluster(request, options = nil)
              #   Pass arguments to `get_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::GetClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::GetClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cluster(name: nil, view: nil)
              #   Pass arguments to `get_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Cluster.name field.
              #   @param view [::Google::Cloud::AlloyDB::V1alpha::ClusterView]
              #     Optional. The view of the cluster to return. Returns all default fields if
              #     not set.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::Cluster]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::Cluster]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::GetClusterRequest.new
              #
              #   # Call the get_cluster method.
              #   result = client.get_cluster request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::Cluster.
              #   p result
              #
              def get_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::GetClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.get_cluster request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Cluster in a given project and location.
              #
              # @overload create_cluster(request, options = nil)
              #   Pass arguments to `create_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::CreateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::CreateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_cluster(parent: nil, cluster_id: nil, cluster: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location of the new cluster. For the required format, see the
              #     comment on the Cluster.name field.
              #   @param cluster_id [::String]
              #     Required. ID of the requesting object.
              #   @param cluster [::Google::Cloud::AlloyDB::V1alpha::Cluster, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::CreateClusterRequest.new
              #
              #   # Call the create_cluster method.
              #   result = client.create_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::CreateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.create_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Cluster.
              #
              # @overload update_cluster(request, options = nil)
              #   Pass arguments to `update_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::UpdateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::UpdateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_cluster(update_mask: nil, cluster: nil, request_id: nil, validate_only: nil, allow_missing: nil)
              #   Pass arguments to `update_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     Cluster resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param cluster [::Google::Cloud::AlloyDB::V1alpha::Cluster, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, update succeeds even if cluster is not found. In
              #     that case, a new cluster is created and `update_mask` is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::UpdateClusterRequest.new
              #
              #   # Call the update_cluster method.
              #   result = client.update_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::UpdateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.update_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports data from the cluster.
              # Imperative only.
              #
              # @overload export_cluster(request, options = nil)
              #   Pass arguments to `export_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_cluster(gcs_destination: nil, csv_export_options: nil, sql_export_options: nil, name: nil, database: nil)
              #   Pass arguments to `export_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_destination [::Google::Cloud::AlloyDB::V1alpha::GcsDestination, ::Hash]
              #     Required. Option to export data to cloud storage.
              #   @param csv_export_options [::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest::CsvExportOptions, ::Hash]
              #     Options for exporting data in CSV format. Required field to be set for
              #     CSV file type.
              #
              #     Note: The following parameters are mutually exclusive: `csv_export_options`, `sql_export_options`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param sql_export_options [::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest::SqlExportOptions, ::Hash]
              #     Options for exporting data in SQL format. Required field to be set for
              #     SQL file type.
              #
              #     Note: The following parameters are mutually exclusive: `sql_export_options`, `csv_export_options`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param name [::String]
              #     Required. The resource name of the cluster.
              #   @param database [::String]
              #     Required. Name of the database where the export command will be executed.
              #     Note - Value provided should be the same as expected from
              #     `SELECT current_database();` and NOT as a resource reference.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest.new
              #
              #   # Call the export_cluster method.
              #   result = client.export_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ExportClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.export_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports data to the cluster.
              # Imperative only.
              #
              # @overload import_cluster(request, options = nil)
              #   Pass arguments to `import_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_cluster(sql_import_options: nil, csv_import_options: nil, name: nil, gcs_uri: nil, database: nil, user: nil)
              #   Pass arguments to `import_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param sql_import_options [::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest::SqlImportOptions, ::Hash]
              #     Options for importing data in SQL format.
              #
              #     Note: The following parameters are mutually exclusive: `sql_import_options`, `csv_import_options`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param csv_import_options [::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest::CsvImportOptions, ::Hash]
              #     Options for importing data in CSV format.
              #
              #     Note: The following parameters are mutually exclusive: `csv_import_options`, `sql_import_options`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param name [::String]
              #     Required. The resource name of the cluster.
              #   @param gcs_uri [::String]
              #     Required. The path to the file in Google Cloud Storage where the source
              #     file for import will be stored. The URI is in the form
              #     `gs://bucketName/fileName`.
              #   @param database [::String]
              #     Optional. Name of the database to which the import will be done.
              #     For import from SQL file, this is required only if the file does not
              #     specify a database.
              #     Note - Value provided should be the same as expected from `SELECT
              #     current_database();` and NOT as a resource reference.
              #   @param user [::String]
              #     Optional. Database user to be used for importing the data.
              #     Note - Value provided should be the same as expected from
              #     `SELECT current_user;` and NOT as a resource reference.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest.new
              #
              #   # Call the import_cluster method.
              #   result = client.import_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ImportClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.import_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Upgrades a single Cluster.
              # Imperative only.
              #
              # @overload upgrade_cluster(request, options = nil)
              #   Pass arguments to `upgrade_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::UpgradeClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::UpgradeClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload upgrade_cluster(name: nil, version: nil, request_id: nil, validate_only: nil, etag: nil)
              #   Pass arguments to `upgrade_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the cluster.
              #   @param version [::Google::Cloud::AlloyDB::V1alpha::DatabaseVersion]
              #     Required. The version the cluster is going to be upgraded to.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              #   @param etag [::String]
              #     Optional. The current etag of the Cluster.
              #     If an etag is provided and does not match the current etag of the Cluster,
              #     upgrade will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::UpgradeClusterRequest.new
              #
              #   # Call the upgrade_cluster method.
              #   result = client.upgrade_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def upgrade_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::UpgradeClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.upgrade_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.upgrade_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.upgrade_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.upgrade_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Cluster.
              #
              # @overload delete_cluster(request, options = nil)
              #   Pass arguments to `delete_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::DeleteClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::DeleteClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_cluster(name: nil, request_id: nil, etag: nil, validate_only: nil, force: nil)
              #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Cluster.name field.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param etag [::String]
              #     Optional. The current etag of the Cluster.
              #     If an etag is provided and does not match the current etag of the Cluster,
              #     deletion will be blocked and an ABORTED error will be returned.
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              #   @param force [::Boolean]
              #     Optional. Whether to cascade delete child instances for given cluster.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::DeleteClusterRequest.new
              #
              #   # Call the delete_cluster method.
              #   result = client.delete_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::DeleteClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.delete_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Promotes a SECONDARY cluster. This turns down replication
              # from the PRIMARY cluster and promotes a secondary cluster
              # into its own standalone cluster.
              # Imperative only.
              #
              # @overload promote_cluster(request, options = nil)
              #   Pass arguments to `promote_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::PromoteClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::PromoteClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload promote_cluster(name: nil, request_id: nil, etag: nil, validate_only: nil)
              #   Pass arguments to `promote_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Cluster.name field
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param etag [::String]
              #     Optional. The current etag of the Cluster.
              #     If an etag is provided and does not match the current etag of the Cluster,
              #     deletion will be blocked and an ABORTED error will be returned.
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::PromoteClusterRequest.new
              #
              #   # Call the promote_cluster method.
              #   result = client.promote_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def promote_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::PromoteClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.promote_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.promote_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.promote_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.promote_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Switches the roles of PRIMARY and SECONDARY clusters without any data loss.
              # This promotes the SECONDARY cluster to PRIMARY and sets up the original
              # PRIMARY cluster to replicate from this newly promoted cluster.
              #
              # @overload switchover_cluster(request, options = nil)
              #   Pass arguments to `switchover_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::SwitchoverClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::SwitchoverClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload switchover_cluster(name: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `switchover_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Cluster.name field
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::SwitchoverClusterRequest.new
              #
              #   # Call the switchover_cluster method.
              #   result = client.switchover_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def switchover_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::SwitchoverClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.switchover_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.switchover_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.switchover_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.switchover_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Cluster in a given project and location, with a volume
              # restored from the provided source, either a backup ID or a point-in-time
              # and a source cluster.
              #
              # @overload restore_cluster(request, options = nil)
              #   Pass arguments to `restore_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::RestoreClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::RestoreClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restore_cluster(backup_source: nil, continuous_backup_source: nil, parent: nil, cluster_id: nil, cluster: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `restore_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param backup_source [::Google::Cloud::AlloyDB::V1alpha::BackupSource, ::Hash]
              #     Backup source.
              #
              #     Note: The following parameters are mutually exclusive: `backup_source`, `continuous_backup_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param continuous_backup_source [::Google::Cloud::AlloyDB::V1alpha::ContinuousBackupSource, ::Hash]
              #     ContinuousBackup source. Continuous backup needs to be enabled in the
              #     source cluster for this operation to succeed.
              #
              #     Note: The following parameters are mutually exclusive: `continuous_backup_source`, `backup_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The name of the parent resource. For the required format, see the
              #     comment on the Cluster.name field.
              #   @param cluster_id [::String]
              #     Required. ID of the requesting object.
              #   @param cluster [::Google::Cloud::AlloyDB::V1alpha::Cluster, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::RestoreClusterRequest.new
              #
              #   # Call the restore_cluster method.
              #   result = client.restore_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::RestoreClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restore_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restore_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restore_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.restore_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a cluster of type SECONDARY in the given location using
              # the primary cluster as the source.
              #
              # @overload create_secondary_cluster(request, options = nil)
              #   Pass arguments to `create_secondary_cluster` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_secondary_cluster(parent: nil, cluster_id: nil, cluster: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_secondary_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location of the new cluster. For the required
              #     format, see the comment on the Cluster.name field.
              #   @param cluster_id [::String]
              #     Required. ID of the requesting object (the secondary cluster).
              #   @param cluster [::Google::Cloud::AlloyDB::V1alpha::Cluster, ::Hash]
              #     Required. Configuration of the requesting object (the secondary cluster).
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::CreateSecondaryClusterRequest.new
              #
              #   # Call the create_secondary_cluster method.
              #   result = client.create_secondary_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_secondary_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_secondary_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_secondary_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_secondary_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.create_secondary_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Instances in a given project and location.
              #
              # @overload list_instances(request, options = nil)
              #   Pass arguments to `list_instances` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ListInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ListInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_instances(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_instances` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource. For the required format, see the
              #     comment on the Instance.name field. Additionally, you can perform an
              #     aggregated list operation by specifying a value with one of the following
              #     formats:
              #      * projects/\\{project}/locations/-/clusters/-
              #      * projects/\\{project}/locations/\\{region}/clusters/-
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Instance>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Instance>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ListInstancesRequest.new
              #
              #   # Call the list_instances method.
              #   result = client.list_instances request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AlloyDB::V1alpha::Instance.
              #     p item
              #   end
              #
              def list_instances request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ListInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_instances.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_instances.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.list_instances request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @alloy_db_admin_stub, :list_instances, "instances", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Instance.
              #
              # @overload get_instance(request, options = nil)
              #   Pass arguments to `get_instance` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::GetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::GetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_instance(name: nil, view: nil)
              #   Pass arguments to `get_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Instance.name field.
              #   @param view [::Google::Cloud::AlloyDB::V1alpha::InstanceView]
              #     The view of the instance to return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::Instance]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::Instance]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::GetInstanceRequest.new
              #
              #   # Call the get_instance method.
              #   result = client.get_instance request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::Instance.
              #   p result
              #
              def get_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::GetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.get_instance request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Instance in a given project and location.
              #
              # @overload create_instance(request, options = nil)
              #   Pass arguments to `create_instance` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_instance(parent: nil, instance_id: nil, instance: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource. For the required format, see the
              #     comment on the Instance.name field.
              #   @param instance_id [::String]
              #     Required. ID of the requesting object.
              #   @param instance [::Google::Cloud::AlloyDB::V1alpha::Instance, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequest.new
              #
              #   # Call the create_instance method.
              #   result = client.create_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.create_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new SECONDARY Instance in a given project and location.
              #
              # @overload create_secondary_instance(request, options = nil)
              #   Pass arguments to `create_secondary_instance` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_secondary_instance(parent: nil, instance_id: nil, instance: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_secondary_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource. For the required format, see the
              #     comment on the Instance.name field.
              #   @param instance_id [::String]
              #     Required. ID of the requesting object.
              #   @param instance [::Google::Cloud::AlloyDB::V1alpha::Instance, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::CreateSecondaryInstanceRequest.new
              #
              #   # Call the create_secondary_instance method.
              #   result = client.create_secondary_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_secondary_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::CreateSecondaryInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_secondary_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_secondary_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_secondary_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.create_secondary_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates new instances under the given project, location and cluster.
              # There can be only one primary instance in a cluster. If the primary
              # instance exists in the cluster as well as this request, then API will
              # throw an error.
              # The primary instance should exist before any read pool instance is
              # created. If the primary instance is a part of the request payload, then
              # the API will take care of creating instances in the correct order.
              # This method is here to support Google-internal use cases, and is not meant
              # for external customers to consume. Please do not start relying on it; its
              # behavior is subject to change without notice.
              #
              # @overload batch_create_instances(request, options = nil)
              #   Pass arguments to `batch_create_instances` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::BatchCreateInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::BatchCreateInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_create_instances(parent: nil, requests: nil, request_id: nil)
              #   Pass arguments to `batch_create_instances` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource.
              #   @param requests [::Google::Cloud::AlloyDB::V1alpha::CreateInstanceRequests, ::Hash]
              #     Required. Resources being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::BatchCreateInstancesRequest.new
              #
              #   # Call the batch_create_instances method.
              #   result = client.batch_create_instances request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_create_instances request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::BatchCreateInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_create_instances.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_create_instances.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_create_instances.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.batch_create_instances request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Instance.
              #
              # @overload update_instance(request, options = nil)
              #   Pass arguments to `update_instance` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::UpdateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::UpdateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_instance(update_mask: nil, instance: nil, request_id: nil, validate_only: nil, allow_missing: nil)
              #   Pass arguments to `update_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     Instance resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param instance [::Google::Cloud::AlloyDB::V1alpha::Instance, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, update succeeds even if instance is not found. In
              #     that case, a new instance is created and `update_mask` is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::UpdateInstanceRequest.new
              #
              #   # Call the update_instance method.
              #   result = client.update_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::UpdateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.update_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Instance.
              #
              # @overload delete_instance(request, options = nil)
              #   Pass arguments to `delete_instance` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::DeleteInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::DeleteInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_instance(name: nil, request_id: nil, etag: nil, validate_only: nil)
              #   Pass arguments to `delete_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Instance.name field.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param etag [::String]
              #     Optional. The current etag of the Instance.
              #     If an etag is provided and does not match the current etag of the Instance,
              #     deletion will be blocked and an ABORTED error will be returned.
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::DeleteInstanceRequest.new
              #
              #   # Call the delete_instance method.
              #   result = client.delete_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::DeleteInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.delete_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Forces a Failover for a highly available instance.
              # Failover promotes the HA standby instance as the new primary.
              # Imperative only.
              #
              # @overload failover_instance(request, options = nil)
              #   Pass arguments to `failover_instance` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::FailoverInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::FailoverInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload failover_instance(name: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `failover_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Instance.name field.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::FailoverInstanceRequest.new
              #
              #   # Call the failover_instance method.
              #   result = client.failover_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def failover_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::FailoverInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.failover_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.failover_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.failover_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.failover_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Injects fault in an instance.
              # Imperative only.
              #
              # @overload inject_fault(request, options = nil)
              #   Pass arguments to `inject_fault` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload inject_fault(fault_type: nil, name: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `inject_fault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param fault_type [::Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest::FaultType]
              #     Required. The type of fault to be injected in an instance.
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Instance.name field.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest.new
              #
              #   # Call the inject_fault method.
              #   result = client.inject_fault request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def inject_fault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::InjectFaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.inject_fault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.inject_fault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.inject_fault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.inject_fault request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restart an Instance in a cluster.
              # Imperative only.
              #
              # @overload restart_instance(request, options = nil)
              #   Pass arguments to `restart_instance` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::RestartInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::RestartInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restart_instance(name: nil, request_id: nil, validate_only: nil, node_ids: nil)
              #   Pass arguments to `restart_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the Instance.name field.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, performs request validation, for example, permission
              #     checks and any other type of validation, but does not actually execute the
              #     create request.
              #   @param node_ids [::Array<::String>]
              #     Optional. Full name of the nodes as obtained from INSTANCE_VIEW_FULL to
              #     restart upon. Applicable only to read instances.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::RestartInstanceRequest.new
              #
              #   # Call the restart_instance method.
              #   result = client.restart_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restart_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::RestartInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restart_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restart_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restart_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.restart_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Executes a SQL statement in a database inside an AlloyDB instance.
              #
              # @overload execute_sql(request, options = nil)
              #   Pass arguments to `execute_sql` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload execute_sql(password: nil, instance: nil, database: nil, user: nil, sql_statement: nil, validate_only: nil)
              #   Pass arguments to `execute_sql` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param password [::String]
              #     Optional. The database native user’s password.
              #   @param instance [::String]
              #     Required. The instance where the SQL will be executed. For the required
              #     format, see the comment on the Instance.name field.
              #   @param database [::String]
              #     Required. Name of the database where the query will be executed.
              #     Note - Value provided should be the same as expected from `SELECT
              #     current_database();` and NOT as a resource reference.
              #   @param user [::String]
              #     Required. Database user to be used for executing the SQL.
              #     Note - Value provided should be the same as expected from
              #     `SELECT current_user;` and NOT as a resource reference.
              #   @param sql_statement [::String]
              #     Required. SQL statement to execute on database. Any valid statement is
              #     permitted, including DDL, DML, DQL statements.
              #   @param validate_only [::Boolean]
              #     Optional. If set, validates the sql statement by performing
              #     syntax and semantic validation and doesn't execute the query.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ExecuteSqlRequest.new
              #
              #   # Call the execute_sql method.
              #   result = client.execute_sql request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::ExecuteSqlResponse.
              #   p result
              #
              def execute_sql request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ExecuteSqlRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.execute_sql.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.execute_sql.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.execute_sql.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.execute_sql request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Backups in a given project and location.
              #
              # @overload list_backups(request, options = nil)
              #   Pass arguments to `list_backups` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ListBackupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ListBackupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_backups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_backups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListBackupsRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Backup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Backup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ListBackupsRequest.new
              #
              #   # Call the list_backups method.
              #   result = client.list_backups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AlloyDB::V1alpha::Backup.
              #     p item
              #   end
              #
              def list_backups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ListBackupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_backups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_backups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.list_backups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @alloy_db_admin_stub, :list_backups, "backups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Backup.
              #
              # @overload get_backup(request, options = nil)
              #   Pass arguments to `get_backup` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::GetBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::GetBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_backup(name: nil)
              #   Pass arguments to `get_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::Backup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::Backup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::GetBackupRequest.new
              #
              #   # Call the get_backup method.
              #   result = client.get_backup request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::Backup.
              #   p result
              #
              def get_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::GetBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.get_backup request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Backup in a given project and location.
              #
              # @overload create_backup(request, options = nil)
              #   Pass arguments to `create_backup` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::CreateBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::CreateBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_backup(parent: nil, backup_id: nil, backup: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param backup_id [::String]
              #     Required. ID of the requesting object.
              #   @param backup [::Google::Cloud::AlloyDB::V1alpha::Backup, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, the backend validates the request, but doesn't actually
              #     execute it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::CreateBackupRequest.new
              #
              #   # Call the create_backup method.
              #   result = client.create_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::CreateBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.create_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Backup.
              #
              # @overload update_backup(request, options = nil)
              #   Pass arguments to `update_backup` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::UpdateBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::UpdateBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_backup(update_mask: nil, backup: nil, request_id: nil, validate_only: nil, allow_missing: nil)
              #   Pass arguments to `update_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     Backup resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param backup [::Google::Cloud::AlloyDB::V1alpha::Backup, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, the backend validates the request, but doesn't actually
              #     execute it.
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, update succeeds even if instance is not found. In
              #     that case, a new backup is created and `update_mask` is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::UpdateBackupRequest.new
              #
              #   # Call the update_backup method.
              #   result = client.update_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::UpdateBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.update_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Backup.
              #
              # @overload delete_backup(request, options = nil)
              #   Pass arguments to `delete_backup` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::DeleteBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::DeleteBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_backup(name: nil, request_id: nil, validate_only: nil, etag: nil)
              #   Pass arguments to `delete_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource. For the required format, see the comment on
              #     the Backup.name field.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, the backend validates the request, but doesn't actually
              #     execute it.
              #   @param etag [::String]
              #     Optional. The current etag of the Backup.
              #     If an etag is provided and does not match the current etag of the Backup,
              #     deletion will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::DeleteBackupRequest.new
              #
              #   # Call the delete_backup method.
              #   result = client.delete_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::DeleteBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.delete_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists SupportedDatabaseFlags for a given project and location.
              #
              # @overload list_supported_database_flags(request, options = nil)
              #   Pass arguments to `list_supported_database_flags` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_supported_database_flags(parent: nil, page_size: nil, page_token: nil, scope: nil)
              #   Pass arguments to `list_supported_database_flags` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource. The required format is:
              #      * projects/\\{project}/locations/\\{location}
              #
              #     Regardless of the parent specified here, as long it is contains a valid
              #     project and location, the service will return a static list of supported
              #     flags resources. Note that we do not yet support region-specific
              #     flags.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param scope [::Google::Cloud::AlloyDB::V1alpha::SupportedDatabaseFlag::Scope]
              #     Optional. The scope for which supported flags are requested. If not
              #     specified, default is DATABASE.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::SupportedDatabaseFlag>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::SupportedDatabaseFlag>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsRequest.new
              #
              #   # Call the list_supported_database_flags method.
              #   result = client.list_supported_database_flags request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AlloyDB::V1alpha::SupportedDatabaseFlag.
              #     p item
              #   end
              #
              def list_supported_database_flags request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ListSupportedDatabaseFlagsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_supported_database_flags.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_supported_database_flags.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_supported_database_flags.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.list_supported_database_flags request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @alloy_db_admin_stub, :list_supported_database_flags, "supported_database_flags", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generate a client certificate signed by a Cluster CA.
              # The sole purpose of this endpoint is to support AlloyDB connectors and the
              # Auth Proxy client. The endpoint's behavior is subject to change without
              # notice, so do not rely on its behavior remaining constant. Future changes
              # will not break AlloyDB connectors or the Auth Proxy client.
              #
              # @overload generate_client_certificate(request, options = nil)
              #   Pass arguments to `generate_client_certificate` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_client_certificate(parent: nil, request_id: nil, pem_csr: nil, cert_duration: nil, public_key: nil, use_metadata_exchange: nil)
              #   Pass arguments to `generate_client_certificate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource. The required format is:
              #      * projects/\\{project}/locations/\\{location}/clusters/\\{cluster}
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param pem_csr [::String]
              #     Optional. A pem-encoded X.509 certificate signing request (CSR). It is
              #     recommended to use public_key instead.
              #   @param cert_duration [::Google::Protobuf::Duration, ::Hash]
              #     Optional. An optional hint to the endpoint to generate the client
              #     certificate with the requested duration. The duration can be from 1 hour to
              #     24 hours. The endpoint may or may not honor the hint. If the hint is left
              #     unspecified or is not honored, then the endpoint will pick an appropriate
              #     default duration.
              #   @param public_key [::String]
              #     Optional. The public key from the client.
              #   @param use_metadata_exchange [::Boolean]
              #     Optional. An optional hint to the endpoint to generate a client certificate
              #     that can be used by AlloyDB connectors to exchange additional metadata with
              #     the server after TLS handshake.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateRequest.new
              #
              #   # Call the generate_client_certificate method.
              #   result = client.generate_client_certificate request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateResponse.
              #   p result
              #
              def generate_client_certificate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::GenerateClientCertificateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_client_certificate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_client_certificate.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_client_certificate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.generate_client_certificate request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get instance metadata used for a connection.
              #
              # @overload get_connection_info(request, options = nil)
              #   Pass arguments to `get_connection_info` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::GetConnectionInfoRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::GetConnectionInfoRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connection_info(parent: nil, request_id: nil)
              #   Pass arguments to `get_connection_info` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource. The required format is:
              #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}/instances/\\{instance}
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::ConnectionInfo]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::ConnectionInfo]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::GetConnectionInfoRequest.new
              #
              #   # Call the get_connection_info method.
              #   result = client.get_connection_info request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::ConnectionInfo.
              #   p result
              #
              def get_connection_info request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::GetConnectionInfoRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connection_info.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connection_info.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connection_info.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.get_connection_info request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Users in a given project and location.
              #
              # @overload list_users(request, options = nil)
              #   Pass arguments to `list_users` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ListUsersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ListUsersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_users(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_users` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListUsersRequest
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::User>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::User>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ListUsersRequest.new
              #
              #   # Call the list_users method.
              #   result = client.list_users request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AlloyDB::V1alpha::User.
              #     p item
              #   end
              #
              def list_users request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ListUsersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_users.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_users.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_users.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.list_users request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @alloy_db_admin_stub, :list_users, "users", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single User.
              #
              # @overload get_user(request, options = nil)
              #   Pass arguments to `get_user` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::GetUserRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::GetUserRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_user(name: nil)
              #   Pass arguments to `get_user` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the User.name field.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::User]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::User]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::GetUserRequest.new
              #
              #   # Call the get_user method.
              #   result = client.get_user request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::User.
              #   p result
              #
              def get_user request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::GetUserRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_user.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_user.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_user.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.get_user request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new User in a given project, location, and cluster.
              #
              # @overload create_user(request, options = nil)
              #   Pass arguments to `create_user` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::CreateUserRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::CreateUserRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_user(parent: nil, user_id: nil, user: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_user` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param user_id [::String]
              #     Required. ID of the requesting object.
              #   @param user [::Google::Cloud::AlloyDB::V1alpha::User, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, the backend validates the request, but doesn't actually
              #     execute it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::User]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::User]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::CreateUserRequest.new
              #
              #   # Call the create_user method.
              #   result = client.create_user request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::User.
              #   p result
              #
              def create_user request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::CreateUserRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_user.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_user.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_user.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.create_user request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single User.
              #
              # @overload update_user(request, options = nil)
              #   Pass arguments to `update_user` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::UpdateUserRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::UpdateUserRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_user(update_mask: nil, user: nil, request_id: nil, validate_only: nil, allow_missing: nil)
              #   Pass arguments to `update_user` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     User resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param user [::Google::Cloud::AlloyDB::V1alpha::User, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, the backend validates the request, but doesn't actually
              #     execute it.
              #   @param allow_missing [::Boolean]
              #     Optional. Allow missing fields in the update mask.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::User]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::User]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::UpdateUserRequest.new
              #
              #   # Call the update_user method.
              #   result = client.update_user request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::User.
              #   p result
              #
              def update_user request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::UpdateUserRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_user.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_user.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_user.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.update_user request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single User.
              #
              # @overload delete_user(request, options = nil)
              #   Pass arguments to `delete_user` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::DeleteUserRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::DeleteUserRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_user(name: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `delete_user` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource. For the required format, see the
              #     comment on the User.name field.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server ignores the
              #     request if it has already been completed. The server guarantees that for at
              #     least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if the original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set, the backend validates the request, but doesn't actually
              #     execute it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::DeleteUserRequest.new
              #
              #   # Call the delete_user method.
              #   result = client.delete_user request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_user request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::DeleteUserRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_user.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_user.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_user.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.delete_user request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Databases in a given project and location.
              #
              # @overload list_databases(request, options = nil)
              #   Pass arguments to `list_databases` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::ListDatabasesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::ListDatabasesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_databases(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_databases` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListDatabasesRequest.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of databases to return. The service may return
              #     fewer than this value. If unspecified, 2000 is the default page_size. The
              #     max value of page_size will be 4000, values above max will be coerced to
              #     max.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListDatabases` call.
              #     This should be provided to retrieve the subsequent page.
              #     This field is currently not supported, its value will be ignored if passed.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #     This field is currently not supported, its value will be ignored if passed.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Database>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AlloyDB::V1alpha::Database>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::ListDatabasesRequest.new
              #
              #   # Call the list_databases method.
              #   result = client.list_databases request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AlloyDB::V1alpha::Database.
              #     p item
              #   end
              #
              def list_databases request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::ListDatabasesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_databases.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_databases.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_databases.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.list_databases request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @alloy_db_admin_stub, :list_databases, "databases", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Database in a given project, location, and cluster.
              #
              # @overload create_database(request, options = nil)
              #   Pass arguments to `create_database` via a request object, either of type
              #   {::Google::Cloud::AlloyDB::V1alpha::CreateDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AlloyDB::V1alpha::CreateDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_database(parent: nil, database_id: nil, database: nil)
              #   Pass arguments to `create_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param database_id [::String]
              #     Required. ID of the requesting object.
              #   @param database [::Google::Cloud::AlloyDB::V1alpha::Database, ::Hash]
              #     Required. The resource being created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AlloyDB::V1alpha::Database]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AlloyDB::V1alpha::Database]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/alloy_db/v1alpha"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AlloyDB::V1alpha::CreateDatabaseRequest.new
              #
              #   # Call the create_database method.
              #   result = client.create_database request
              #
              #   # The returned object is of type Google::Cloud::AlloyDB::V1alpha::Database.
              #   p result
              #
              def create_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AlloyDB::V1alpha::CreateDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AlloyDB::V1alpha::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @alloy_db_admin_stub.create_database request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AlloyDBAdmin REST API.
              #
              # This class represents the configuration for AlloyDBAdmin REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_clusters to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_clusters.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AlloyDB::V1alpha::AlloyDBAdmin::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_clusters.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "alloydb.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the AlloyDBAdmin API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_clusters
                  ##
                  # RPC-specific configuration for `get_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cluster
                  ##
                  # RPC-specific configuration for `create_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cluster
                  ##
                  # RPC-specific configuration for `update_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_cluster
                  ##
                  # RPC-specific configuration for `export_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_cluster
                  ##
                  # RPC-specific configuration for `import_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_cluster
                  ##
                  # RPC-specific configuration for `upgrade_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :upgrade_cluster
                  ##
                  # RPC-specific configuration for `delete_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cluster
                  ##
                  # RPC-specific configuration for `promote_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :promote_cluster
                  ##
                  # RPC-specific configuration for `switchover_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :switchover_cluster
                  ##
                  # RPC-specific configuration for `restore_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_cluster
                  ##
                  # RPC-specific configuration for `create_secondary_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_secondary_cluster
                  ##
                  # RPC-specific configuration for `list_instances`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_instances
                  ##
                  # RPC-specific configuration for `get_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_instance
                  ##
                  # RPC-specific configuration for `create_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_instance
                  ##
                  # RPC-specific configuration for `create_secondary_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_secondary_instance
                  ##
                  # RPC-specific configuration for `batch_create_instances`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_create_instances
                  ##
                  # RPC-specific configuration for `update_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_instance
                  ##
                  # RPC-specific configuration for `delete_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_instance
                  ##
                  # RPC-specific configuration for `failover_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :failover_instance
                  ##
                  # RPC-specific configuration for `inject_fault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :inject_fault
                  ##
                  # RPC-specific configuration for `restart_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restart_instance
                  ##
                  # RPC-specific configuration for `execute_sql`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :execute_sql
                  ##
                  # RPC-specific configuration for `list_backups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backups
                  ##
                  # RPC-specific configuration for `get_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup
                  ##
                  # RPC-specific configuration for `create_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_backup
                  ##
                  # RPC-specific configuration for `update_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_backup
                  ##
                  # RPC-specific configuration for `delete_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_backup
                  ##
                  # RPC-specific configuration for `list_supported_database_flags`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_supported_database_flags
                  ##
                  # RPC-specific configuration for `generate_client_certificate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_client_certificate
                  ##
                  # RPC-specific configuration for `get_connection_info`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connection_info
                  ##
                  # RPC-specific configuration for `list_users`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_users
                  ##
                  # RPC-specific configuration for `get_user`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_user
                  ##
                  # RPC-specific configuration for `create_user`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_user
                  ##
                  # RPC-specific configuration for `update_user`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_user
                  ##
                  # RPC-specific configuration for `delete_user`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_user
                  ##
                  # RPC-specific configuration for `list_databases`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_databases
                  ##
                  # RPC-specific configuration for `create_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_database

                  # @private
                  def initialize parent_rpcs = nil
                    list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                    @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                    get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                    @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                    create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                    @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                    update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                    @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                    export_cluster_config = parent_rpcs.export_cluster if parent_rpcs.respond_to? :export_cluster
                    @export_cluster = ::Gapic::Config::Method.new export_cluster_config
                    import_cluster_config = parent_rpcs.import_cluster if parent_rpcs.respond_to? :import_cluster
                    @import_cluster = ::Gapic::Config::Method.new import_cluster_config
                    upgrade_cluster_config = parent_rpcs.upgrade_cluster if parent_rpcs.respond_to? :upgrade_cluster
                    @upgrade_cluster = ::Gapic::Config::Method.new upgrade_cluster_config
                    delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                    @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                    promote_cluster_config = parent_rpcs.promote_cluster if parent_rpcs.respond_to? :promote_cluster
                    @promote_cluster = ::Gapic::Config::Method.new promote_cluster_config
                    switchover_cluster_config = parent_rpcs.switchover_cluster if parent_rpcs.respond_to? :switchover_cluster
                    @switchover_cluster = ::Gapic::Config::Method.new switchover_cluster_config
                    restore_cluster_config = parent_rpcs.restore_cluster if parent_rpcs.respond_to? :restore_cluster
                    @restore_cluster = ::Gapic::Config::Method.new restore_cluster_config
                    create_secondary_cluster_config = parent_rpcs.create_secondary_cluster if parent_rpcs.respond_to? :create_secondary_cluster
                    @create_secondary_cluster = ::Gapic::Config::Method.new create_secondary_cluster_config
                    list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                    @list_instances = ::Gapic::Config::Method.new list_instances_config
                    get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                    @get_instance = ::Gapic::Config::Method.new get_instance_config
                    create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                    @create_instance = ::Gapic::Config::Method.new create_instance_config
                    create_secondary_instance_config = parent_rpcs.create_secondary_instance if parent_rpcs.respond_to? :create_secondary_instance
                    @create_secondary_instance = ::Gapic::Config::Method.new create_secondary_instance_config
                    batch_create_instances_config = parent_rpcs.batch_create_instances if parent_rpcs.respond_to? :batch_create_instances
                    @batch_create_instances = ::Gapic::Config::Method.new batch_create_instances_config
                    update_instance_config = parent_rpcs.update_instance if parent_rpcs.respond_to? :update_instance
                    @update_instance = ::Gapic::Config::Method.new update_instance_config
                    delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                    @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                    failover_instance_config = parent_rpcs.failover_instance if parent_rpcs.respond_to? :failover_instance
                    @failover_instance = ::Gapic::Config::Method.new failover_instance_config
                    inject_fault_config = parent_rpcs.inject_fault if parent_rpcs.respond_to? :inject_fault
                    @inject_fault = ::Gapic::Config::Method.new inject_fault_config
                    restart_instance_config = parent_rpcs.restart_instance if parent_rpcs.respond_to? :restart_instance
                    @restart_instance = ::Gapic::Config::Method.new restart_instance_config
                    execute_sql_config = parent_rpcs.execute_sql if parent_rpcs.respond_to? :execute_sql
                    @execute_sql = ::Gapic::Config::Method.new execute_sql_config
                    list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                    @list_backups = ::Gapic::Config::Method.new list_backups_config
                    get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                    @get_backup = ::Gapic::Config::Method.new get_backup_config
                    create_backup_config = parent_rpcs.create_backup if parent_rpcs.respond_to? :create_backup
                    @create_backup = ::Gapic::Config::Method.new create_backup_config
                    update_backup_config = parent_rpcs.update_backup if parent_rpcs.respond_to? :update_backup
                    @update_backup = ::Gapic::Config::Method.new update_backup_config
                    delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                    @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                    list_supported_database_flags_config = parent_rpcs.list_supported_database_flags if parent_rpcs.respond_to? :list_supported_database_flags
                    @list_supported_database_flags = ::Gapic::Config::Method.new list_supported_database_flags_config
                    generate_client_certificate_config = parent_rpcs.generate_client_certificate if parent_rpcs.respond_to? :generate_client_certificate
                    @generate_client_certificate = ::Gapic::Config::Method.new generate_client_certificate_config
                    get_connection_info_config = parent_rpcs.get_connection_info if parent_rpcs.respond_to? :get_connection_info
                    @get_connection_info = ::Gapic::Config::Method.new get_connection_info_config
                    list_users_config = parent_rpcs.list_users if parent_rpcs.respond_to? :list_users
                    @list_users = ::Gapic::Config::Method.new list_users_config
                    get_user_config = parent_rpcs.get_user if parent_rpcs.respond_to? :get_user
                    @get_user = ::Gapic::Config::Method.new get_user_config
                    create_user_config = parent_rpcs.create_user if parent_rpcs.respond_to? :create_user
                    @create_user = ::Gapic::Config::Method.new create_user_config
                    update_user_config = parent_rpcs.update_user if parent_rpcs.respond_to? :update_user
                    @update_user = ::Gapic::Config::Method.new update_user_config
                    delete_user_config = parent_rpcs.delete_user if parent_rpcs.respond_to? :delete_user
                    @delete_user = ::Gapic::Config::Method.new delete_user_config
                    list_databases_config = parent_rpcs.list_databases if parent_rpcs.respond_to? :list_databases
                    @list_databases = ::Gapic::Config::Method.new list_databases_config
                    create_database_config = parent_rpcs.create_database if parent_rpcs.respond_to? :create_database
                    @create_database = ::Gapic::Config::Method.new create_database_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
