# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AlloyDB
      module V1
        # The username/password for a database user. Used for specifying initial
        # users at cluster creation time.
        # @!attribute [rw] user
        #   @return [::String]
        #     The database username.
        # @!attribute [rw] password
        #   @return [::String]
        #     The initial password for the user.
        class UserPassword
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Subset of the source instance configuration that is available when reading
        # the cluster resource.
        # @!attribute [r] host_port
        #   @return [::String]
        #     Output only. The host and port of the on-premises instance in host:port
        #     format
        # @!attribute [r] reference_id
        #   @return [::String]
        #     Output only. Place holder for the external source identifier(e.g DMS job
        #     name) that created the cluster.
        # @!attribute [r] source_type
        #   @return [::Google::Cloud::AlloyDB::V1::MigrationSource::MigrationSourceType]
        #     Output only. Type of migration source.
        class MigrationSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Denote the type of migration source that created this cluster.
          module MigrationSourceType
            # Migration source is unknown.
            MIGRATION_SOURCE_TYPE_UNSPECIFIED = 0

            # DMS source means the cluster was created via DMS migration job.
            DMS = 1
          end
        end

        # EncryptionConfig describes the encryption config of a cluster or a backup
        # that is encrypted with a CMEK (customer-managed encryption key).
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     The fully-qualified resource name of the KMS key.
        #     Each Cloud KMS key is regionalized and has the following format:
        #     projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
        class EncryptionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # EncryptionInfo describes the encryption information of a cluster or a backup.
        # @!attribute [r] encryption_type
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionInfo::Type]
        #     Output only. Type of encryption.
        # @!attribute [r] kms_key_versions
        #   @return [::Array<::String>]
        #     Output only. Cloud KMS key versions that are being used to protect the
        #     database or the backup.
        class EncryptionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible encryption types.
          module Type
            # Encryption type not specified. Defaults to GOOGLE_DEFAULT_ENCRYPTION.
            TYPE_UNSPECIFIED = 0

            # The data is encrypted at rest with a key that is fully managed by Google.
            # No key version will be populated. This is the default state.
            GOOGLE_DEFAULT_ENCRYPTION = 1

            # The data is encrypted at rest with a key that is managed by the customer.
            # KMS key versions will be populated.
            CUSTOMER_MANAGED_ENCRYPTION = 2
          end
        end

        # SSL configuration.
        # @!attribute [rw] ssl_mode
        #   @return [::Google::Cloud::AlloyDB::V1::SslConfig::SslMode]
        #     Optional. SSL mode. Specifies client-server SSL/TLS connection behavior.
        # @!attribute [rw] ca_source
        #   @return [::Google::Cloud::AlloyDB::V1::SslConfig::CaSource]
        #     Optional. Certificate Authority (CA) source. Only CA_SOURCE_MANAGED is
        #     supported currently, and is the default value.
        class SslConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # SSL mode options.
          module SslMode
            # SSL mode is not specified. Defaults to ENCRYPTED_ONLY.
            SSL_MODE_UNSPECIFIED = 0

            # SSL connections are optional. CA verification not enforced.
            SSL_MODE_ALLOW = 1

            # SSL connections are required. CA verification not enforced.
            # Clients may use locally self-signed certificates (default psql client
            # behavior).
            SSL_MODE_REQUIRE = 2

            # SSL connections are required. CA verification enforced.
            # Clients must have certificates signed by a Cluster CA, for example, using
            # GenerateClientCertificate.
            SSL_MODE_VERIFY_CA = 3

            # SSL connections are optional. CA verification not enforced.
            ALLOW_UNENCRYPTED_AND_ENCRYPTED = 4

            # SSL connections are required. CA verification not enforced.
            ENCRYPTED_ONLY = 5
          end

          # Certificate Authority (CA) source for SSL/TLS certificates.
          module CaSource
            # Certificate Authority (CA) source not specified. Defaults to
            # CA_SOURCE_MANAGED.
            CA_SOURCE_UNSPECIFIED = 0

            # Certificate Authority (CA) managed by the AlloyDB Cluster.
            CA_SOURCE_MANAGED = 1
          end
        end

        # Message describing the user-specified automated backup policy.
        #
        # All fields in the automated backup policy are optional. Defaults for each
        # field are provided if they are not set.
        # @!attribute [rw] weekly_schedule
        #   @return [::Google::Cloud::AlloyDB::V1::AutomatedBackupPolicy::WeeklySchedule]
        #     Weekly schedule for the Backup.
        # @!attribute [rw] time_based_retention
        #   @return [::Google::Cloud::AlloyDB::V1::AutomatedBackupPolicy::TimeBasedRetention]
        #     Time-based Backup retention policy.
        #
        #     Note: The following fields are mutually exclusive: `time_based_retention`, `quantity_based_retention`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] quantity_based_retention
        #   @return [::Google::Cloud::AlloyDB::V1::AutomatedBackupPolicy::QuantityBasedRetention]
        #     Quantity-based Backup retention policy to retain recent backups.
        #
        #     Note: The following fields are mutually exclusive: `quantity_based_retention`, `time_based_retention`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether automated automated backups are enabled. If not set, defaults to
        #     true.
        # @!attribute [rw] backup_window
        #   @return [::Google::Protobuf::Duration]
        #     The length of the time window during which a backup can be
        #     taken. If a backup does not succeed within this time window, it will be
        #     canceled and considered failed.
        #
        #     The backup window must be at least 5 minutes long. There is no upper bound
        #     on the window. If not set, it defaults to 1 hour.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionConfig]
        #     Optional. The encryption config can be specified to encrypt the
        #     backups with a customer-managed encryption key (CMEK). When this field is
        #     not specified, the backup will use the cluster's encryption config.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location where the backup will be stored. Currently, the only supported
        #     option is to store the backup in the same region as the cluster.
        #
        #     If empty, defaults to the region of the cluster.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels to apply to backups created using this configuration.
        class AutomatedBackupPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A weekly schedule starts a backup at prescribed start times within a
          # day, for the specified days of the week.
          #
          # The weekly schedule message is flexible and can be used to create many
          # types of schedules. For example, to have a daily backup that starts at
          # 22:00, configure the `start_times` field to have one element "22:00" and
          # the `days_of_week` field to have all seven days of the week.
          # @!attribute [rw] start_times
          #   @return [::Array<::Google::Type::TimeOfDay>]
          #     The times during the day to start a backup. The start times are assumed
          #     to be in UTC and to be an exact hour (e.g., 04:00:00).
          #
          #     If no start times are provided, a single fixed start time is chosen
          #     arbitrarily.
          # @!attribute [rw] days_of_week
          #   @return [::Array<::Google::Type::DayOfWeek>]
          #     The days of the week to perform a backup.
          #
          #     If this field is left empty, the default of every day of the week is
          #     used.
          class WeeklySchedule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A time based retention policy specifies that all backups within a certain
          # time period should be retained.
          # @!attribute [rw] retention_period
          #   @return [::Google::Protobuf::Duration]
          #     The retention period.
          class TimeBasedRetention
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A quantity based policy specifies that a certain number of the most recent
          # successful backups should be retained.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     The number of backups to retain.
          class QuantityBasedRetention
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # ContinuousBackupConfig describes the continuous backups recovery
        # configurations of a cluster.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether ContinuousBackup is enabled.
        # @!attribute [rw] recovery_window_days
        #   @return [::Integer]
        #     The number of days that are eligible to restore from using PITR. To support
        #     the entire recovery window, backups and logs are retained for one day more
        #     than the recovery window. If not set, defaults to 14 days.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionConfig]
        #     The encryption config can be specified to encrypt the
        #     backups with a customer-managed encryption key (CMEK). When this field is
        #     not specified, the backup will use the cluster's encryption config.
        class ContinuousBackupConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ContinuousBackupInfo describes the continuous backup properties of a
        # cluster.
        # @!attribute [r] encryption_info
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionInfo]
        #     Output only. The encryption information for the WALs and backups required
        #     for ContinuousBackup.
        # @!attribute [r] enabled_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When ContinuousBackup was most recently enabled. Set to null
        #     if ContinuousBackup is not enabled.
        # @!attribute [r] schedule
        #   @return [::Array<::Google::Type::DayOfWeek>]
        #     Output only. Days of the week on which a continuous backup is taken.
        # @!attribute [r] earliest_restorable_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The earliest restorable time that can be restored to. If
        #     continuous backups and recovery was recently enabled, the earliest
        #     restorable time is the creation time of the earliest eligible backup within
        #     this cluster's continuous backup recovery window. After a cluster has had
        #     continuous backups enabled for the duration of its recovery window, the
        #     earliest restorable time becomes "now minus the recovery window". For
        #     example, assuming a point in time recovery is attempted at 04/16/2025
        #     3:23:00PM with a 14d recovery window, the earliest restorable time would be
        #     04/02/2025 3:23:00PM. This field is only visible if the
        #     CLUSTER_VIEW_CONTINUOUS_BACKUP cluster view is provided.
        class ContinuousBackupInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing a BackupSource.
        # @!attribute [r] backup_uid
        #   @return [::String]
        #     Output only. The system-generated UID of the backup which was used to
        #     create this resource. The UID is generated when the backup is created, and
        #     it is retained until the backup is deleted.
        # @!attribute [rw] backup_name
        #   @return [::String]
        #     Required. The name of the backup resource with the format:
        #      * projects/\\{project}/locations/\\{region}/backups/\\{backup_id}
        class BackupSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing a ContinuousBackupSource.
        # @!attribute [rw] cluster
        #   @return [::String]
        #     Required. The source cluster from which to restore. This cluster must have
        #     continuous backup enabled for this operation to succeed. For the required
        #     format, see the comment on the Cluster.name field.
        # @!attribute [rw] point_in_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. The point in time to restore to.
        class ContinuousBackupSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MaintenanceUpdatePolicy defines the policy for system updates.
        # @!attribute [rw] maintenance_windows
        #   @return [::Array<::Google::Cloud::AlloyDB::V1::MaintenanceUpdatePolicy::MaintenanceWindow>]
        #     Preferred windows to perform maintenance. Currently limited to 1.
        # @!attribute [rw] deny_maintenance_periods
        #   @return [::Array<::Google::Cloud::AlloyDB::V1::MaintenanceUpdatePolicy::DenyMaintenancePeriod>]
        #     Periods to deny maintenance. Currently limited to 1.
        class MaintenanceUpdatePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # MaintenanceWindow specifies a preferred day and time for maintenance.
          # @!attribute [rw] day
          #   @return [::Google::Type::DayOfWeek]
          #     Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
          # @!attribute [rw] start_time
          #   @return [::Google::Type::TimeOfDay]
          #     Preferred time to start the maintenance operation on the specified day.
          #     Maintenance will start within 1 hour of this time.
          class MaintenanceWindow
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # DenyMaintenancePeriod definition. Excepting emergencies, maintenance
          # will not be scheduled to start within this deny period. The start_date must
          # be less than the end_date.
          # @!attribute [rw] start_date
          #   @return [::Google::Type::Date]
          #     Deny period start date.
          #     This can be:
          #     * A full date, with non-zero year, month and day values OR
          #     * A month and day value, with a zero year for recurring
          # @!attribute [rw] end_date
          #   @return [::Google::Type::Date]
          #     Deny period end date.
          #     This can be:
          #     * A full date, with non-zero year, month and day values OR
          #     * A month and day value, with a zero year for recurring
          # @!attribute [rw] time
          #   @return [::Google::Type::TimeOfDay]
          #     Time in UTC when the deny period starts on start_date and ends on
          #     end_date. This can be:
          #     * Full time OR
          #     * All zeros for 00:00:00 UTC
          class DenyMaintenancePeriod
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # MaintenanceSchedule stores the maintenance schedule generated from
        # the MaintenanceUpdatePolicy, once a maintenance rollout is triggered, if
        # MaintenanceWindow is set, and if there is no conflicting DenyPeriod.
        # The schedule is cleared once the update takes place. This field cannot be
        # manually changed; modify the MaintenanceUpdatePolicy instead.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The scheduled start time for the maintenance.
        class MaintenanceSchedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A cluster is a collection of regional AlloyDB resources. It can include a
        # primary instance and one or more read pool instances.
        # All cluster resources share a storage layer, which scales as needed.
        # @!attribute [r] backup_source
        #   @return [::Google::Cloud::AlloyDB::V1::BackupSource]
        #     Output only. Cluster created from backup.
        #
        #     Note: The following fields are mutually exclusive: `backup_source`, `migration_source`, `cloudsql_backup_run_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] migration_source
        #   @return [::Google::Cloud::AlloyDB::V1::MigrationSource]
        #     Output only. Cluster created via DMS migration.
        #
        #     Note: The following fields are mutually exclusive: `migration_source`, `backup_source`, `cloudsql_backup_run_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] cloudsql_backup_run_source
        #   @return [::Google::Cloud::AlloyDB::V1::CloudSQLBackupRunSource]
        #     Output only. Cluster created from CloudSQL snapshot.
        #
        #     Note: The following fields are mutually exclusive: `cloudsql_backup_run_source`, `backup_source`, `migration_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the cluster resource with the format:
        #      * projects/\\{project}/locations/\\{region}/clusters/\\{cluster_id}
        #     where the cluster ID segment should satisfy the regex expression
        #     `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
        #     The prefix of the cluster resource name is the name of the parent resource:
        #      * projects/\\{project}/locations/\\{region}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-settable and human-readable display name for the Cluster.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The system-generated UID of the resource. The UID is assigned
        #     when the resource is created, and it is retained until it is deleted.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Delete time stamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [r] state
        #   @return [::Google::Cloud::AlloyDB::V1::Cluster::State]
        #     Output only. The current serving state of the cluster.
        # @!attribute [r] cluster_type
        #   @return [::Google::Cloud::AlloyDB::V1::Cluster::ClusterType]
        #     Output only. The type of the cluster. This is an output-only field and it's
        #     populated at the Cluster creation time or the Cluster promotion
        #     time. The cluster type is determined by which RPC was used to create
        #     the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
        # @!attribute [rw] database_version
        #   @return [::Google::Cloud::AlloyDB::V1::DatabaseVersion]
        #     Optional. The database engine major version. This is an optional field and
        #     it is populated at the Cluster creation time. If a database version is not
        #     supplied at cluster creation time, then a default database version will
        #     be used.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::AlloyDB::V1::Cluster::NetworkConfig]
        # @!attribute [rw] network
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Required. The resource link for the VPC network in which cluster resources
        #     are created and from which they are accessible via Private IP. The network
        #     must belong to the same project as the cluster. It is specified in the
        #     form: `projects/{project}/global/networks/{network_id}`. This is required
        #     to create a cluster. Deprecated, use network_config.network instead.
        # @!attribute [rw] etag
        #   @return [::String]
        #     For Resource freshness validation (https://google.aip.dev/154)
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Annotations to allow client tools to store small amount of arbitrary data.
        #     This is distinct from labels.
        #     https://google.aip.dev/128
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Reconciling (https://google.aip.dev/128#reconciliation).
        #     Set to true if the current state of Cluster does not match the user's
        #     intended state, and the service is actively updating the resource to
        #     reconcile them. This can happen due to user-triggered updates or
        #     system actions like failover or maintenance.
        # @!attribute [rw] initial_user
        #   @return [::Google::Cloud::AlloyDB::V1::UserPassword]
        #     Input only. Initial user to setup during cluster creation.
        #     If used in `RestoreCluster` this is ignored.
        # @!attribute [rw] automated_backup_policy
        #   @return [::Google::Cloud::AlloyDB::V1::AutomatedBackupPolicy]
        #     The automated backup policy for this cluster.
        #
        #     If no policy is provided then the default policy will be used. If backups
        #     are supported for the cluster, the default policy takes one backup a day,
        #     has a backup window of 1 hour, and retains backups for 14 days.
        #     For more information on the defaults, consult the
        #     documentation for the message type.
        # @!attribute [rw] ssl_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::AlloyDB::V1::SslConfig]
        #     SSL configuration for this AlloyDB cluster.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionConfig]
        #     Optional. The encryption config can be specified to encrypt the data disks
        #     and other persistent data resources of a cluster with a
        #     customer-managed encryption key (CMEK). When this field is not
        #     specified, the cluster will then use default encryption scheme to
        #     protect the user data.
        # @!attribute [r] encryption_info
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionInfo]
        #     Output only. The encryption information for the cluster.
        # @!attribute [rw] continuous_backup_config
        #   @return [::Google::Cloud::AlloyDB::V1::ContinuousBackupConfig]
        #     Optional. Continuous backup configuration for this cluster.
        # @!attribute [r] continuous_backup_info
        #   @return [::Google::Cloud::AlloyDB::V1::ContinuousBackupInfo]
        #     Output only. Continuous backup properties for this cluster.
        # @!attribute [rw] secondary_config
        #   @return [::Google::Cloud::AlloyDB::V1::Cluster::SecondaryConfig]
        #     Cross Region replication config specific to SECONDARY cluster.
        # @!attribute [r] primary_config
        #   @return [::Google::Cloud::AlloyDB::V1::Cluster::PrimaryConfig]
        #     Output only. Cross Region replication config specific to PRIMARY cluster.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] psc_config
        #   @return [::Google::Cloud::AlloyDB::V1::Cluster::PscConfig]
        #     Optional. The configuration for Private Service Connect (PSC) for the
        #     cluster.
        # @!attribute [rw] maintenance_update_policy
        #   @return [::Google::Cloud::AlloyDB::V1::MaintenanceUpdatePolicy]
        #     Optional. The maintenance update policy determines when to allow or deny
        #     updates.
        # @!attribute [r] maintenance_schedule
        #   @return [::Google::Cloud::AlloyDB::V1::MaintenanceSchedule]
        #     Output only. The maintenance schedule for the cluster, generated for a
        #     specific rollout if a maintenance window is set.
        # @!attribute [rw] subscription_type
        #   @return [::Google::Cloud::AlloyDB::V1::SubscriptionType]
        #     Optional. Subscription type of the cluster.
        # @!attribute [r] trial_metadata
        #   @return [::Google::Cloud::AlloyDB::V1::Cluster::TrialMetadata]
        #     Output only. Metadata for free trial clusters
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag keys/values directly bound to this
        #     resource. For example:
        #     ```
        #     "123/environment": "production",
        #     "123/costCenter": "marketing"
        #     ```
        class Cluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata related to network configuration.
          # @!attribute [rw] network
          #   @return [::String]
          #     Optional. The resource link for the VPC network in which cluster
          #     resources are created and from which they are accessible via Private IP.
          #     The network must belong to the same project as the cluster. It is
          #     specified in the form:
          #     `projects/{project_number}/global/networks/{network_id}`. This is
          #     required to create a cluster.
          # @!attribute [rw] allocated_ip_range
          #   @return [::String]
          #     Optional. Name of the allocated IP range for the private IP AlloyDB
          #     cluster, for example: "google-managed-services-default". If set, the
          #     instance IPs for this cluster will be created in the allocated range. The
          #     range name must comply with RFC 1035. Specifically, the name must be 1-63
          #     characters long and match the regular expression
          #     `[a-z]([-a-z0-9]*[a-z0-9])?`.
          #     Field name is intended to be consistent with Cloud SQL.
          class NetworkConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration information for the secondary cluster. This should be set
          # if and only if the cluster is of type SECONDARY.
          # @!attribute [rw] primary_cluster_name
          #   @return [::String]
          #     The name of the primary cluster name with the format:
          #     * projects/\\{project}/locations/\\{region}/clusters/\\{cluster_id}
          class SecondaryConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for the primary cluster. It has the list of clusters that are
          # replicating from this cluster. This should be set if and only if the
          # cluster is of type PRIMARY.
          # @!attribute [r] secondary_cluster_names
          #   @return [::Array<::String>]
          #     Output only. Names of the clusters that are replicating from this
          #     cluster.
          class PrimaryConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # PscConfig contains PSC related configuration at a cluster level.
          # @!attribute [rw] psc_enabled
          #   @return [::Boolean]
          #     Optional. Create an instance that allows connections from Private Service
          #     Connect endpoints to the instance.
          # @!attribute [r] service_owned_project_number
          #   @return [::Integer]
          #     Output only. The project number that needs to be allowlisted on the
          #     network attachment to enable outbound connectivity.
          class PscConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains information and all metadata related to TRIAL clusters.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     start time of the trial cluster.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     End time of the trial cluster.
          # @!attribute [rw] upgrade_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Upgrade time of trial cluster to Standard cluster.
          # @!attribute [rw] grace_end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     grace end time of the cluster.
          class TrialMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Cluster State
          module State
            # The state of the cluster is unknown.
            STATE_UNSPECIFIED = 0

            # The cluster is active and running.
            READY = 1

            # This is unused. Even when all instances in the cluster are stopped, the
            # cluster remains in READY state.
            STOPPED = 2

            # The cluster is empty and has no associated resources.
            # All instances, associated storage and backups have been deleted.
            EMPTY = 3

            # The cluster is being created.
            CREATING = 4

            # The cluster is being deleted.
            DELETING = 5

            # The creation of the cluster failed.
            FAILED = 6

            # The cluster is bootstrapping with data from some other source.
            # Direct mutations to the cluster (e.g. adding read pool) are not allowed.
            BOOTSTRAPPING = 7

            # The cluster is under maintenance. AlloyDB regularly performs maintenance
            # and upgrades on customer clusters. Updates on the cluster are
            # not allowed while the cluster is in this state.
            MAINTENANCE = 8

            # The cluster is being promoted.
            PROMOTING = 9
          end

          # Type of Cluster
          module ClusterType
            # The type of the cluster is unknown.
            CLUSTER_TYPE_UNSPECIFIED = 0

            # Primary cluster that support read and write operations.
            PRIMARY = 1

            # Secondary cluster that is replicating from another region.
            # This only supports read.
            SECONDARY = 2
          end
        end

        # An Instance is a computing unit that an end customer can connect to.
        # It's the main unit of computing resources in AlloyDB.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the instance resource with the format:
        #      * projects/\\{project}/locations/\\{region}/clusters/\\{cluster_id}/instances/\\{instance_id}
        #     where the cluster and instance ID segments should satisfy the regex
        #     expression `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`, e.g. 1-63 characters of
        #     lowercase letters, numbers, and dashes, starting with a letter, and ending
        #     with a letter or number. For more details see https://google.aip.dev/122.
        #     The prefix of the instance resource name is the name of the parent
        #     resource:
        #      * projects/\\{project}/locations/\\{region}/clusters/\\{cluster_id}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-settable and human-readable display name for the Instance.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The system-generated UID of the resource. The UID is assigned
        #     when the resource is created, and it is retained until it is deleted.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Delete time stamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [r] state
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::State]
        #     Output only. The current serving state of the instance.
        # @!attribute [rw] instance_type
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::InstanceType]
        #     Required. The type of the instance. Specified at creation time.
        # @!attribute [rw] machine_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::MachineConfig]
        #     Configurations for the machines that host the underlying
        #     database engine.
        # @!attribute [rw] availability_type
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::AvailabilityType]
        #     Availability type of an Instance.
        #     If empty, defaults to REGIONAL for primary instances.
        #     For read pools, availability_type is always UNSPECIFIED. Instances in the
        #     read pools are evenly distributed across available zones within the region
        #     (i.e. read pools with more than one node will have a node in at
        #     least two zones).
        # @!attribute [rw] gce_zone
        #   @return [::String]
        #     The Compute Engine zone that the instance should serve from, per
        #     https://cloud.google.com/compute/docs/regions-zones
        #     This can ONLY be specified for ZONAL instances.
        #     If present for a REGIONAL instance, an error will be thrown.
        #     If this is absent for a ZONAL instance, instance is created in a random
        #     zone with available capacity.
        # @!attribute [rw] database_flags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Database flags. Set at the instance level.
        #     They are copied from the primary instance on secondary instance creation.
        #     Flags that have restrictions default to the value at primary
        #     instance on read instances during creation. Read instances can set new
        #     flags or override existing flags that are relevant for reads, for example,
        #     for enabling columnar cache on a read instance. Flags set on read instance
        #     might or might not be present on the primary instance.
        #
        #
        #     This is a list of "key": "value" pairs.
        #     "key": The name of the flag. These flags are passed at instance setup time,
        #     so include both server options and system variables for Postgres. Flags are
        #     specified with underscores, not hyphens.
        #     "value": The value of the flag. Booleans are set to **on** for true
        #     and **off** for false. This field must be omitted if the flag
        #     doesn't take a value.
        # @!attribute [r] writable_node
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::Node]
        #     Output only. This is set for the read-write VM of the PRIMARY instance
        #     only.
        # @!attribute [r] nodes
        #   @return [::Array<::Google::Cloud::AlloyDB::V1::Instance::Node>]
        #     Output only. List of available read-only VMs in this instance, including
        #     the standby for a PRIMARY instance.
        # @!attribute [rw] query_insights_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::QueryInsightsInstanceConfig]
        #     Configuration for query insights.
        # @!attribute [rw] observability_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::ObservabilityInstanceConfig]
        #     Configuration for observability.
        # @!attribute [rw] read_pool_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::ReadPoolConfig]
        #     Read pool instance configuration.
        #     This is required if the value of instanceType is READ_POOL.
        # @!attribute [r] ip_address
        #   @return [::String]
        #     Output only. The IP address for the Instance.
        #     This is the connection endpoint for an end-user application.
        # @!attribute [r] public_ip_address
        #   @return [::String]
        #     Output only. The public IP addresses for the Instance. This is available
        #     ONLY when enable_public_ip is set. This is the connection endpoint for an
        #     end-user application.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Reconciling (https://google.aip.dev/128#reconciliation).
        #     Set to true if the current state of Instance does not match the user's
        #     intended state, and the service is actively updating the resource to
        #     reconcile them. This can happen due to user-triggered updates or
        #     system actions like failover or maintenance.
        # @!attribute [rw] etag
        #   @return [::String]
        #     For Resource freshness validation (https://google.aip.dev/154)
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Annotations to allow client tools to store small amount of arbitrary data.
        #     This is distinct from labels.
        #     https://google.aip.dev/128
        # @!attribute [rw] client_connection_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::ClientConnectionConfig]
        #     Optional. Client connection specific configurations
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] psc_instance_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::PscInstanceConfig]
        #     Optional. The configuration for Private Service Connect (PSC) for the
        #     instance.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::InstanceNetworkConfig]
        #     Optional. Instance-level network configuration.
        # @!attribute [r] outbound_public_ip_addresses
        #   @return [::Array<::String>]
        #     Output only. All outbound public IP addresses configured for the instance.
        # @!attribute [rw] activation_policy
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::ActivationPolicy]
        #     Optional. Specifies whether an instance needs to spin up. Once the instance
        #     is active, the activation policy can be updated to the `NEVER` to stop the
        #     instance. Likewise, the activation policy can be updated to `ALWAYS` to
        #     start the instance.
        #     There are restrictions around when an instance can/cannot be activated (for
        #     example, a read pool instance should be stopped before stopping primary
        #     etc.). Please refer to the API documentation for more details.
        # @!attribute [rw] connection_pool_config
        #   @return [::Google::Cloud::AlloyDB::V1::Instance::ConnectionPoolConfig]
        #     Optional. The configuration for Managed Connection Pool (MCP).
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # MachineConfig describes the configuration of a machine.
          # @!attribute [rw] cpu_count
          #   @return [::Integer]
          #     The number of CPU's in the VM instance.
          # @!attribute [rw] machine_type
          #   @return [::String]
          #     Machine type of the VM instance. E.g. "n2-highmem-4",
          #     "n2-highmem-8", "c4a-highmem-4-lssd".
          #     cpu_count must match the number of vCPUs in the machine type.
          class MachineConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details of a single node in the instance.
          # Nodes in an AlloyDB instance are ephemeral, they can change during
          # update, failover, autohealing and resize operations.
          # @!attribute [r] zone_id
          #   @return [::String]
          #     Output only. The Compute Engine zone of the VM e.g. "us-central1-b".
          # @!attribute [r] id
          #   @return [::String]
          #     Output only. The identifier of the VM e.g.
          #     "test-read-0601-407e52be-ms3l".
          # @!attribute [r] ip
          #   @return [::String]
          #     Output only. The private IP address of the VM e.g. "10.57.0.34".
          # @!attribute [r] state
          #   @return [::String]
          #     Output only. Determined by state of the compute VM and postgres-service
          #     health. Compute VM state can have values listed in
          #     https://cloud.google.com/compute/docs/instances/instance-life-cycle and
          #     postgres-service health can have values: HEALTHY and UNHEALTHY.
          class Node
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # QueryInsights Instance specific configuration.
          # @!attribute [rw] record_application_tags
          #   @return [::Boolean]
          #     Record application tags for an instance.
          #     This flag is turned "on" by default.
          # @!attribute [rw] record_client_address
          #   @return [::Boolean]
          #     Record client address for an instance. Client address is PII information.
          #     This flag is turned "on" by default.
          # @!attribute [rw] query_string_length
          #   @return [::Integer]
          #     Query string length. The default value is 1024.
          #     Any integer between 256 and 4500 is considered valid.
          # @!attribute [rw] query_plans_per_minute
          #   @return [::Integer]
          #     Number of query execution plans captured by Insights per minute
          #     for all queries combined. The default value is 5.
          #     Any integer between 0 and 20 is considered valid.
          class QueryInsightsInstanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Observability Instance specific configuration.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Observability feature status for an instance.
          #     This flag is turned "off" by default.
          # @!attribute [rw] preserve_comments
          #   @return [::Boolean]
          #     Preserve comments in query string for an instance.
          #     This flag is turned "off" by default.
          # @!attribute [rw] track_wait_events
          #   @return [::Boolean]
          #     Track wait events during query execution for an instance.
          #     This flag is turned "on" by default but tracking is enabled only after
          #     observability enabled flag is also turned on.
          # @!attribute [r] track_wait_event_types
          #   @return [::Boolean]
          #     Output only. Track wait event types during query execution for an
          #     instance. This flag is turned "on" by default but tracking is enabled
          #     only after observability enabled flag is also turned on. This is
          #     read-only flag and only modifiable by internal API.
          # @!attribute [rw] max_query_string_length
          #   @return [::Integer]
          #     Query string length. The default value is 10k.
          # @!attribute [rw] record_application_tags
          #   @return [::Boolean]
          #     Record application tags for an instance.
          #     This flag is turned "off" by default.
          # @!attribute [rw] query_plans_per_minute
          #   @return [::Integer]
          #     Number of query execution plans captured by Insights per minute
          #     for all queries combined. The default value is 200.
          #     Any integer between 0 to 200 is considered valid.
          # @!attribute [rw] track_active_queries
          #   @return [::Boolean]
          #     Track actively running queries on the instance.
          #     If not set, this flag is "off" by default.
          class ObservabilityInstanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for a read pool instance.
          # @!attribute [rw] node_count
          #   @return [::Integer]
          #     Read capacity, i.e. number of nodes in a read pool instance.
          class ReadPoolConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Client connection configuration
          # @!attribute [rw] require_connectors
          #   @return [::Boolean]
          #     Optional. Configuration to enforce connectors only (ex: AuthProxy)
          #     connections to the database.
          # @!attribute [rw] ssl_config
          #   @return [::Google::Cloud::AlloyDB::V1::SslConfig]
          #     Optional. SSL configuration option for this instance.
          class ClientConnectionConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for setting up a PSC interface to enable outbound
          # connectivity.
          # @!attribute [rw] network_attachment_resource
          #   @return [::String]
          #     The network attachment resource created in the consumer network to which
          #     the PSC interface will be linked. This is of the format:
          #     "projects/$\\{CONSUMER_PROJECT}/regions/$\\{REGION}/networkAttachments/$\\{NETWORK_ATTACHMENT_NAME}".
          #     The network attachment must be in the same region as the instance.
          class PscInterfaceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for setting up PSC service automation. Consumer projects in
          # the configs will be allowlisted automatically for the instance.
          # @!attribute [rw] consumer_project
          #   @return [::String]
          #     The consumer project to which the PSC service automation endpoint will
          #     be created.
          # @!attribute [rw] consumer_network
          #   @return [::String]
          #     The consumer network for the PSC service automation, example:
          #     "projects/vpc-host-project/global/networks/default".
          #     The consumer network might be hosted a different project than the
          #     consumer project.
          # @!attribute [r] ip_address
          #   @return [::String]
          #     Output only. The IP address of the PSC service automation endpoint.
          # @!attribute [r] status
          #   @return [::String]
          #     Output only. The status of the PSC service automation connection.
          #     Possible values:
          #       "STATE_UNSPECIFIED" - An invalid state as the default case.
          #       "ACTIVE" - The connection has been created successfully.
          #       "FAILED" - The connection is not functional since some resources on the
          #     connection fail to be created.
          #       "CREATING" - The connection is being created.
          #       "DELETING" - The connection is being deleted.
          #       "CREATE_REPAIRING" - The connection is being repaired to complete
          #     creation.
          #       "DELETE_REPAIRING" - The connection is being repaired to complete
          #     deletion.
          # @!attribute [r] consumer_network_status
          #   @return [::String]
          #     Output only. The status of the service connection policy.
          #     Possible values:
          #       "STATE_UNSPECIFIED" - Default state, when Connection Map is created
          #     initially.
          #       "VALID" - Set when policy and map configuration is valid, and their
          #     matching can lead to allowing creation of PSC Connections subject to
          #     other constraints like connections limit.
          #       "CONNECTION_POLICY_MISSING" - No Service Connection Policy found for
          #     this network and Service Class
          #       "POLICY_LIMIT_REACHED" - Service Connection Policy limit reached for
          #       this network and Service Class
          #       "CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED" - The consumer instance
          #     project is not in AllowedGoogleProducersResourceHierarchyLevels of the
          #     matching ServiceConnectionPolicy.
          class PscAutoConnectionConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # PscInstanceConfig contains PSC related configuration at an
          # instance level.
          # @!attribute [r] service_attachment_link
          #   @return [::String]
          #     Output only. The service attachment created when Private
          #     Service Connect (PSC) is enabled for the instance.
          #     The name of the resource will be in the format of
          #     `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
          # @!attribute [rw] allowed_consumer_projects
          #   @return [::Array<::String>]
          #     Optional. List of consumer projects that are allowed to create
          #     PSC endpoints to service-attachments to this instance.
          # @!attribute [r] psc_dns_name
          #   @return [::String]
          #     Output only. The DNS name of the instance for PSC connectivity.
          #     Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
          # @!attribute [rw] psc_interface_configs
          #   @return [::Array<::Google::Cloud::AlloyDB::V1::Instance::PscInterfaceConfig>]
          #     Optional. Configurations for setting up PSC interfaces attached to the
          #     instance which are used for outbound connectivity. Only primary instances
          #     can have PSC interface attached. Currently we only support 0 or 1 PSC
          #     interface.
          # @!attribute [rw] psc_auto_connections
          #   @return [::Array<::Google::Cloud::AlloyDB::V1::Instance::PscAutoConnectionConfig>]
          #     Optional. Configurations for setting up PSC service automation.
          class PscInstanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata related to instance-level network configuration.
          # @!attribute [rw] authorized_external_networks
          #   @return [::Array<::Google::Cloud::AlloyDB::V1::Instance::InstanceNetworkConfig::AuthorizedNetwork>]
          #     Optional. A list of external network authorized to access this instance.
          # @!attribute [rw] enable_public_ip
          #   @return [::Boolean]
          #     Optional. Enabling public ip for the instance.
          # @!attribute [rw] enable_outbound_public_ip
          #   @return [::Boolean]
          #     Optional. Enabling an outbound public IP address to support a database
          #     server sending requests out into the internet.
          # @!attribute [r] network
          #   @return [::String]
          #     Output only. The resource link for the VPC network in which instance
          #     resources are created and from which they are accessible via Private IP.
          #     This will be the same value as the parent cluster's network. It is
          #     specified in the form: //
          #     `projects/{project_number}/global/networks/{network_id}`.
          # @!attribute [rw] allocated_ip_range_override
          #   @return [::String]
          #     Optional. Name of the allocated IP range for the private IP AlloyDB
          #     instance, for example: "google-managed-services-default". If set, the
          #     instance IPs will be created from this allocated range and will override
          #     the IP range used by the parent cluster. The range name must comply with
          #     [RFC 1035](http://datatracker.ietf.org/doc/html/rfc1035). Specifically,
          #     the name must be 1-63 characters long and match the regular expression
          #     [a-z]([-a-z0-9]*[a-z0-9])?.
          class InstanceNetworkConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # AuthorizedNetwork contains metadata for an authorized network.
            # @!attribute [rw] cidr_range
            #   @return [::String]
            #     CIDR range for one authorzied network of the instance.
            class AuthorizedNetwork
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Configuration for Managed Connection Pool (MCP).
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Optional. Whether to enable Managed Connection Pool (MCP).
          # @!attribute [rw] flags
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Connection Pool flags, as a list of "key": "value" pairs.
          # @!attribute [r] pooler_count
          #   @return [::Integer]
          #     Output only. The number of running poolers per instance.
          class ConnectionPoolConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class FlagsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DatabaseFlagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Instance State
          module State
            # The state of the instance is unknown.
            STATE_UNSPECIFIED = 0

            # The instance is active and running.
            READY = 1

            # The instance is stopped. Instance name and IP resources are preserved.
            STOPPED = 2

            # The instance is being created.
            CREATING = 3

            # The instance is being deleted.
            DELETING = 4

            # The instance is down for maintenance.
            MAINTENANCE = 5

            # The creation of the instance failed or a fatal error occurred during
            # an operation on the instance.
            # Note: Instances in this state would tried to be auto-repaired. And
            # Customers should be able to restart, update or delete these instances.
            FAILED = 6

            # Index 7 is used in the producer apis for ROLLED_BACK state. Keeping that
            # index unused in case that state also needs to exposed via consumer apis
            # in future.
            # The instance has been configured to sync data from some other source.
            BOOTSTRAPPING = 8

            # The instance is being promoted.
            PROMOTING = 9
          end

          # Type of an Instance
          module InstanceType
            # The type of the instance is unknown.
            INSTANCE_TYPE_UNSPECIFIED = 0

            # PRIMARY instances support read and write operations.
            PRIMARY = 1

            # READ POOL instances support read operations only. Each read pool instance
            # consists of one or more homogeneous nodes.
            #  * Read pool of size 1 can only have zonal availability.
            #  * Read pools with node count of 2 or more can have regional
            #    availability (nodes are present in 2 or more zones in a region).
            READ_POOL = 2

            # SECONDARY instances support read operations only. SECONDARY instance
            # is a cross-region read replica
            SECONDARY = 3
          end

          # The Availability type of an instance. Potential values:
          #
          # - ZONAL: The instance serves data from only one zone. Outages in that
          #     zone affect instance availability.
          # - REGIONAL: The instance can serve data from more than one zone in a
          #     region (it is highly available).
          module AvailabilityType
            # This is an unknown Availability type.
            AVAILABILITY_TYPE_UNSPECIFIED = 0

            # Zonal available instance.
            ZONAL = 1

            # Regional (or Highly) available instance.
            REGIONAL = 2
          end

          # Specifies whether an instance needs to spin up.
          module ActivationPolicy
            # The policy is not specified.
            ACTIVATION_POLICY_UNSPECIFIED = 0

            # The instance is running.
            ALWAYS = 1

            # The instance is not running.
            NEVER = 2
          end
        end

        # ConnectionInfo singleton resource.
        # https://google.aip.dev/156
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the ConnectionInfo singleton resource, e.g.:
        #     projects/\\{project}/locations/\\{location}/clusters/*/instances/*/connectionInfo
        #     This field currently has no semantic meaning.
        # @!attribute [r] ip_address
        #   @return [::String]
        #     Output only. The private network IP address for the Instance. This is the
        #     default IP for the instance and is always created (even if enable_public_ip
        #     is set). This is the connection endpoint for an end-user application.
        # @!attribute [r] public_ip_address
        #   @return [::String]
        #     Output only. The public IP addresses for the Instance. This is available
        #     ONLY when enable_public_ip is set. This is the connection endpoint for an
        #     end-user application.
        # @!attribute [r] instance_uid
        #   @return [::String]
        #     Output only. The unique ID of the Instance.
        class ConnectionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing Backup object
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the backup resource with the format:
        #      * projects/\\{project}/locations/\\{region}/backups/\\{backup_id}
        #     where the cluster and backup ID segments should satisfy the regex
        #     expression `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`, e.g. 1-63 characters of
        #     lowercase letters, numbers, and dashes, starting with a letter, and ending
        #     with a letter or number. For more details see https://google.aip.dev/122.
        #     The prefix of the backup resource name is the name of the parent
        #     resource:
        #      * projects/\\{project}/locations/\\{region}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-settable and human-readable display name for the Backup.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The system-generated UID of the resource. The UID is assigned
        #     when the resource is created, and it is retained until it is deleted.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp
        #
        #     Users should not infer any meaning from this field. Its value is generally
        #     unrelated to the timing of the backup creation operation.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Delete time stamp
        # @!attribute [r] create_completion_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the resource finished being created.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [r] state
        #   @return [::Google::Cloud::AlloyDB::V1::Backup::State]
        #     Output only. The current state of the backup.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::AlloyDB::V1::Backup::Type]
        #     The backup type, which suggests the trigger for the backup.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description of the backup.
        # @!attribute [r] cluster_uid
        #   @return [::String]
        #     Output only. The system-generated UID of the cluster which was used to
        #     create this resource.
        # @!attribute [rw] cluster_name
        #   @return [::String]
        #     Required. The full resource name of the backup source cluster
        #     (e.g., projects/\\{project}/locations/\\{region}/clusters/\\{cluster_id}).
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Reconciling (https://google.aip.dev/128#reconciliation), if
        #     true, indicates that the service is actively updating the resource. This
        #     can happen due to user-triggered updates or system actions like failover or
        #     maintenance.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionConfig]
        #     Optional. The encryption config can be specified to encrypt the
        #     backup with a customer-managed encryption key (CMEK). When this field is
        #     not specified, the backup will then use default encryption scheme to
        #     protect the user data.
        # @!attribute [r] encryption_info
        #   @return [::Google::Cloud::AlloyDB::V1::EncryptionInfo]
        #     Output only. The encryption information for the backup.
        # @!attribute [rw] etag
        #   @return [::String]
        #     For Resource freshness validation (https://google.aip.dev/154)
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Annotations to allow client tools to store small amount of arbitrary data.
        #     This is distinct from labels.
        #     https://google.aip.dev/128
        # @!attribute [r] size_bytes
        #   @return [::Integer]
        #     Output only. The size of the backup in bytes.
        # @!attribute [r] expiry_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which after the backup is eligible to be garbage
        #     collected. It is the duration specified by the backup's retention policy,
        #     added to the backup's create_time.
        # @!attribute [r] expiry_quantity
        #   @return [::Google::Cloud::AlloyDB::V1::Backup::QuantityBasedExpiry]
        #     Output only. The QuantityBasedExpiry of the backup, specified by the
        #     backup's retention policy. Once the expiry quantity is over retention, the
        #     backup is eligible to be garbage collected.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] database_version
        #   @return [::Google::Cloud::AlloyDB::V1::DatabaseVersion]
        #     Output only. The database engine major version of the cluster this backup
        #     was created from. Any restored cluster created from this backup will have
        #     the same database version.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag keys/values directly bound to this
        #     resource. For example:
        #     ```
        #     "123/environment": "production",
        #     "123/costCenter": "marketing"
        #     ```
        class Backup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A backup's position in a quantity-based retention queue, of backups with
          # the same source cluster and type, with length, retention, specified by the
          # backup's retention policy.
          # Once the position is greater than the retention, the backup is eligible to
          # be garbage collected.
          #
          # Example: 5 backups from the same source cluster and type with a
          # quantity-based retention of 3 and denoted by backup_id (position,
          # retention).
          #
          # Safe: backup_5 (1, 3), backup_4, (2, 3), backup_3 (3, 3).
          # Awaiting garbage collection: backup_2 (4, 3), backup_1 (5, 3)
          # @!attribute [r] retention_count
          #   @return [::Integer]
          #     Output only. The backup's position among its backups with the same source
          #     cluster and type, by descending chronological order create time(i.e.
          #     newest first).
          # @!attribute [r] total_retention_count
          #   @return [::Integer]
          #     Output only. The length of the quantity-based queue, specified by the
          #     backup's retention policy.
          class QuantityBasedExpiry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Backup State
          module State
            # The state of the backup is unknown.
            STATE_UNSPECIFIED = 0

            # The backup is ready.
            READY = 1

            # The backup is creating.
            CREATING = 2

            # The backup failed.
            FAILED = 3

            # The backup is being deleted.
            DELETING = 4
          end

          # Backup Type
          module Type
            # Backup Type is unknown.
            TYPE_UNSPECIFIED = 0

            # ON_DEMAND backups that were triggered by the customer (e.g., not
            # AUTOMATED).
            ON_DEMAND = 1

            # AUTOMATED backups triggered by the automated backups scheduler pursuant
            # to an automated backup policy.
            AUTOMATED = 2

            # CONTINUOUS backups triggered by the automated backups scheduler
            # due to a continuous backup policy.
            CONTINUOUS = 3
          end
        end

        # SupportedDatabaseFlag gives general information about a database flag,
        # like type and allowed values. This is a static value that is defined
        # on the server side, and it cannot be modified by callers.
        # To set the Database flags on a particular Instance, a caller should modify
        # the Instance.database_flags field.
        # @!attribute [rw] string_restrictions
        #   @return [::Google::Cloud::AlloyDB::V1::SupportedDatabaseFlag::StringRestrictions]
        #     Restriction on STRING type value.
        #
        #     Note: The following fields are mutually exclusive: `string_restrictions`, `integer_restrictions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] integer_restrictions
        #   @return [::Google::Cloud::AlloyDB::V1::SupportedDatabaseFlag::IntegerRestrictions]
        #     Restriction on INTEGER type value.
        #
        #     Note: The following fields are mutually exclusive: `integer_restrictions`, `string_restrictions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] recommended_string_value
        #   @return [::String]
        #     The recommended value for a STRING flag.
        #
        #     Note: The following fields are mutually exclusive: `recommended_string_value`, `recommended_integer_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] recommended_integer_value
        #   @return [::Google::Protobuf::Int64Value]
        #     The recommended value for an INTEGER flag.
        #
        #     Note: The following fields are mutually exclusive: `recommended_integer_value`, `recommended_string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the flag resource, following Google Cloud conventions, e.g.:
        #      * projects/\\{project}/locations/\\{location}/flags/\\{flag}
        #     This field currently has no semantic meaning.
        # @!attribute [rw] flag_name
        #   @return [::String]
        #     The name of the database flag, e.g. "max_allowed_packets".
        #     The is a possibly key for the Instance.database_flags map field.
        # @!attribute [rw] value_type
        #   @return [::Google::Cloud::AlloyDB::V1::SupportedDatabaseFlag::ValueType]
        # @!attribute [rw] accepts_multiple_values
        #   @return [::Boolean]
        #     Whether the database flag accepts multiple values. If true,
        #     a comma-separated list of stringified values may be specified.
        # @!attribute [rw] supported_db_versions
        #   @return [::Array<::Google::Cloud::AlloyDB::V1::DatabaseVersion>]
        #     Major database engine versions for which this flag is supported.
        # @!attribute [rw] requires_db_restart
        #   @return [::Boolean]
        #     Whether setting or updating this flag on an Instance requires a database
        #     restart. If a flag that requires database restart is set, the backend
        #     will automatically restart the database (making sure to satisfy any
        #     availability SLO's).
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::AlloyDB::V1::SupportedDatabaseFlag::Scope]
        #     The scope of the flag.
        class SupportedDatabaseFlag
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Restrictions on STRING type values
          # @!attribute [rw] allowed_values
          #   @return [::Array<::String>]
          #     The list of allowed values, if bounded. This field will be empty
          #     if there is a unbounded number of allowed values.
          class StringRestrictions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Restrictions on INTEGER type values.
          # @!attribute [rw] min_value
          #   @return [::Google::Protobuf::Int64Value]
          #     The minimum value that can be specified, if applicable.
          # @!attribute [rw] max_value
          #   @return [::Google::Protobuf::Int64Value]
          #     The maximum value that can be specified, if applicable.
          class IntegerRestrictions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # ValueType describes the semantic type of the value that the flag accepts.
          # Regardless of the ValueType, the Instance.database_flags field accepts the
          # stringified version of the value, i.e. "20" or "3.14".
          module ValueType
            # This is an unknown flag type.
            VALUE_TYPE_UNSPECIFIED = 0

            # String type flag.
            STRING = 1

            # Integer type flag.
            INTEGER = 2

            # Float type flag.
            FLOAT = 3

            # Denotes that the flag does not accept any values.
            NONE = 4
          end

          # The scope of the flag.
          module Scope
            # The scope of the flag is not specified. Default is DATABASE.
            SCOPE_UNSPECIFIED = 0

            # The flag is a database flag.
            DATABASE = 1

            # The flag is a connection pool flag.
            CONNECTION_POOL = 2
          end
        end

        # Message describing User object.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the resource in the form of
        #     projects/\\{project}/locations/\\{location}/cluster/\\{cluster}/users/\\{user}.
        # @!attribute [rw] password
        #   @return [::String]
        #     Input only. Password for the user.
        # @!attribute [rw] database_roles
        #   @return [::Array<::String>]
        #     Optional. List of database roles this user has.
        #     The database role strings are subject to the PostgreSQL naming conventions.
        # @!attribute [rw] user_type
        #   @return [::Google::Cloud::AlloyDB::V1::User::UserType]
        #     Optional. Type of this user.
        # @!attribute [rw] keep_extra_roles
        #   @return [::Boolean]
        #     Input only. If the user already exists and it has additional roles, keep
        #     them granted.
        class User
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that details the user type.
          module UserType
            # Unspecified user type.
            USER_TYPE_UNSPECIFIED = 0

            # The default user type that authenticates via password-based
            # authentication.
            ALLOYDB_BUILT_IN = 1

            # Database user that can authenticate via IAM-Based authentication.
            ALLOYDB_IAM_USER = 2
          end
        end

        # Message describing Database object.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the resource in the form of
        #     `projects/{project}/locations/{location}/clusters/{cluster}/databases/{database}`.
        # @!attribute [rw] charset
        #   @return [::String]
        #     Optional. Immutable. Charset for the database.
        #     This field can contain any PostgreSQL supported charset name.
        #     Example values include "UTF8", "SQL_ASCII", etc.
        # @!attribute [rw] collation
        #   @return [::String]
        #     Optional. Immutable. lc_collate for the database.
        #     String sort order.
        #     Example values include "C", "POSIX", etc.
        # @!attribute [rw] character_type
        #   @return [::String]
        #     Optional. Immutable. lc_ctype for the database.
        #     Character classification (What is a letter? The upper-case equivalent?).
        #     Example values include "C", "POSIX", etc.
        # @!attribute [rw] database_template
        #   @return [::String]
        #     Input only. Immutable. Template of the database to be used for creating a
        #     new database.
        # @!attribute [rw] is_template_database
        #   @return [::Boolean]
        #     Optional. Whether the database is a template database.
        class Database
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # View on Instance. Pass this enum to rpcs that returns an Instance message to
        # control which subsets of fields to get.
        module InstanceView
          # INSTANCE_VIEW_UNSPECIFIED Not specified, equivalent to BASIC.
          INSTANCE_VIEW_UNSPECIFIED = 0

          # BASIC server responses for a primary or read instance include all the
          # relevant instance details, excluding the details of each node in the
          # instance. The default value.
          INSTANCE_VIEW_BASIC = 1

          # FULL response is equivalent to BASIC for primary instance (for now).
          # For read pool instance, this includes details of each node in the pool.
          INSTANCE_VIEW_FULL = 2
        end

        # View on Cluster. Pass this enum to rpcs that returns a cluster message to
        # control which subsets of fields to get.
        module ClusterView
          # CLUSTER_VIEW_UNSPECIFIED Not specified, equivalent to BASIC.
          CLUSTER_VIEW_UNSPECIFIED = 0

          # BASIC server responses include all the relevant cluster details, excluding
          # Cluster.ContinuousBackupInfo.EarliestRestorableTime and other view-specific
          # fields. The default value.
          CLUSTER_VIEW_BASIC = 1

          # CONTINUOUS_BACKUP response returns all the fields from BASIC plus
          # the earliest restorable time if continuous backups are enabled.
          # May increase latency.
          CLUSTER_VIEW_CONTINUOUS_BACKUP = 2
        end

        # The supported database engine versions.
        module DatabaseVersion
          # This is an unknown database version.
          DATABASE_VERSION_UNSPECIFIED = 0

          # DEPRECATED - The database version is Postgres 13.
          POSTGRES_13 = 1

          # The database version is Postgres 14.
          POSTGRES_14 = 2

          # The database version is Postgres 15.
          POSTGRES_15 = 3

          # The database version is Postgres 16.
          POSTGRES_16 = 4

          # The database version is Postgres 17.
          POSTGRES_17 = 5
        end

        # Subscription_type added to distinguish between Standard and Trial
        # subscriptions. By default, a subscription type is considered STANDARD unless
        # explicitly specified.
        module SubscriptionType
          # This is an unknown subscription type. By default, the subscription type is
          # STANDARD.
          SUBSCRIPTION_TYPE_UNSPECIFIED = 0

          # Standard subscription.
          STANDARD = 1

          # Trial subscription.
          TRIAL = 2
        end
      end
    end
  end
end
