# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/ai_platform"
require "gapic/common"
require "gapic/grpc"
require "gapic/rest"

class Google::Cloud::AIPlatform::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_data_foundry_service_grpc
    skip unless Google::Cloud::AIPlatform.data_foundry_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.data_foundry_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::DataFoundryService::Client, client
    end
  end

  def test_data_foundry_service_rest
    skip unless Google::Cloud::AIPlatform.data_foundry_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.data_foundry_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::DataFoundryService::Rest::Client, client
    end
  end

  def test_dataset_service_grpc
    skip unless Google::Cloud::AIPlatform.dataset_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.dataset_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::DatasetService::Client, client
    end
  end

  def test_dataset_service_rest
    skip unless Google::Cloud::AIPlatform.dataset_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.dataset_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client, client
    end
  end

  def test_deployment_resource_pool_service_grpc
    skip unless Google::Cloud::AIPlatform.deployment_resource_pool_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.deployment_resource_pool_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client, client
    end
  end

  def test_deployment_resource_pool_service_rest
    skip unless Google::Cloud::AIPlatform.deployment_resource_pool_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.deployment_resource_pool_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Rest::Client, client
    end
  end

  def test_endpoint_service_grpc
    skip unless Google::Cloud::AIPlatform.endpoint_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.endpoint_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::EndpointService::Client, client
    end
  end

  def test_endpoint_service_rest
    skip unless Google::Cloud::AIPlatform.endpoint_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.endpoint_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::EndpointService::Rest::Client, client
    end
  end

  def test_evaluation_service_grpc
    skip unless Google::Cloud::AIPlatform.evaluation_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.evaluation_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::EvaluationService::Client, client
    end
  end

  def test_evaluation_service_rest
    skip unless Google::Cloud::AIPlatform.evaluation_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.evaluation_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::EvaluationService::Rest::Client, client
    end
  end

  def test_feature_online_store_admin_service_grpc
    skip unless Google::Cloud::AIPlatform.feature_online_store_admin_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.feature_online_store_admin_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client, client
    end
  end

  def test_feature_online_store_admin_service_rest
    skip unless Google::Cloud::AIPlatform.feature_online_store_admin_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.feature_online_store_admin_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client, client
    end
  end

  def test_featurestore_online_serving_service_grpc
    skip unless Google::Cloud::AIPlatform.featurestore_online_serving_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.featurestore_online_serving_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeaturestoreOnlineServingService::Client, client
    end
  end

  def test_featurestore_online_serving_service_rest
    skip unless Google::Cloud::AIPlatform.featurestore_online_serving_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.featurestore_online_serving_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeaturestoreOnlineServingService::Rest::Client, client
    end
  end

  def test_feature_online_store_service_grpc
    skip unless Google::Cloud::AIPlatform.feature_online_store_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.feature_online_store_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client, client
    end
  end

  def test_feature_online_store_service_rest
    skip unless Google::Cloud::AIPlatform.feature_online_store_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.feature_online_store_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::Client, client
    end
  end

  def test_featurestore_service_grpc
    skip unless Google::Cloud::AIPlatform.featurestore_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.featurestore_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeaturestoreService::Client, client
    end
  end

  def test_featurestore_service_rest
    skip unless Google::Cloud::AIPlatform.featurestore_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.featurestore_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client, client
    end
  end

  def test_feature_registry_service_grpc
    skip unless Google::Cloud::AIPlatform.feature_registry_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.feature_registry_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client, client
    end
  end

  def test_feature_registry_service_rest
    skip unless Google::Cloud::AIPlatform.feature_registry_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.feature_registry_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::FeatureRegistryService::Rest::Client, client
    end
  end

  def test_gen_ai_cache_service_grpc
    skip unless Google::Cloud::AIPlatform.gen_ai_cache_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.gen_ai_cache_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::GenAiCacheService::Client, client
    end
  end

  def test_gen_ai_cache_service_rest
    skip unless Google::Cloud::AIPlatform.gen_ai_cache_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.gen_ai_cache_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::GenAiCacheService::Rest::Client, client
    end
  end

  def test_gen_ai_tuning_service_grpc
    skip unless Google::Cloud::AIPlatform.gen_ai_tuning_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.gen_ai_tuning_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::GenAiTuningService::Client, client
    end
  end

  def test_gen_ai_tuning_service_rest
    skip unless Google::Cloud::AIPlatform.gen_ai_tuning_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.gen_ai_tuning_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::GenAiTuningService::Rest::Client, client
    end
  end

  def test_index_endpoint_service_grpc
    skip unless Google::Cloud::AIPlatform.index_endpoint_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.index_endpoint_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::IndexEndpointService::Client, client
    end
  end

  def test_index_endpoint_service_rest
    skip unless Google::Cloud::AIPlatform.index_endpoint_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.index_endpoint_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::IndexEndpointService::Rest::Client, client
    end
  end

  def test_index_service_grpc
    skip unless Google::Cloud::AIPlatform.index_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.index_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::IndexService::Client, client
    end
  end

  def test_index_service_rest
    skip unless Google::Cloud::AIPlatform.index_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.index_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::IndexService::Rest::Client, client
    end
  end

  def test_job_service_grpc
    skip unless Google::Cloud::AIPlatform.job_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.job_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::JobService::Client, client
    end
  end

  def test_job_service_rest
    skip unless Google::Cloud::AIPlatform.job_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.job_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::JobService::Rest::Client, client
    end
  end

  def test_prediction_service_grpc
    skip unless Google::Cloud::AIPlatform.prediction_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.prediction_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::PredictionService::Client, client
    end
  end

  def test_prediction_service_rest
    skip unless Google::Cloud::AIPlatform.prediction_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.prediction_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::PredictionService::Rest::Client, client
    end
  end

  def test_llm_utility_service_grpc
    skip unless Google::Cloud::AIPlatform.llm_utility_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.llm_utility_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::LlmUtilityService::Client, client
    end
  end

  def test_llm_utility_service_rest
    skip unless Google::Cloud::AIPlatform.llm_utility_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.llm_utility_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::LlmUtilityService::Rest::Client, client
    end
  end

  def test_match_service_grpc
    skip unless Google::Cloud::AIPlatform.match_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.match_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::MatchService::Client, client
    end
  end

  def test_match_service_rest
    skip unless Google::Cloud::AIPlatform.match_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.match_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::MatchService::Rest::Client, client
    end
  end

  def test_metadata_service_grpc
    skip unless Google::Cloud::AIPlatform.metadata_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.metadata_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::MetadataService::Client, client
    end
  end

  def test_metadata_service_rest
    skip unless Google::Cloud::AIPlatform.metadata_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.metadata_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client, client
    end
  end

  def test_migration_service_grpc
    skip unless Google::Cloud::AIPlatform.migration_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.migration_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::MigrationService::Client, client
    end
  end

  def test_migration_service_rest
    skip unless Google::Cloud::AIPlatform.migration_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.migration_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::MigrationService::Rest::Client, client
    end
  end

  def test_model_garden_service_grpc
    skip unless Google::Cloud::AIPlatform.model_garden_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.model_garden_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ModelGardenService::Client, client
    end
  end

  def test_model_garden_service_rest
    skip unless Google::Cloud::AIPlatform.model_garden_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.model_garden_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ModelGardenService::Rest::Client, client
    end
  end

  def test_model_service_grpc
    skip unless Google::Cloud::AIPlatform.model_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.model_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ModelService::Client, client
    end
  end

  def test_model_service_rest
    skip unless Google::Cloud::AIPlatform.model_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.model_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ModelService::Rest::Client, client
    end
  end

  def test_notebook_service_grpc
    skip unless Google::Cloud::AIPlatform.notebook_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.notebook_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::NotebookService::Client, client
    end
  end

  def test_notebook_service_rest
    skip unless Google::Cloud::AIPlatform.notebook_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.notebook_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client, client
    end
  end

  def test_persistent_resource_service_grpc
    skip unless Google::Cloud::AIPlatform.persistent_resource_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.persistent_resource_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::PersistentResourceService::Client, client
    end
  end

  def test_persistent_resource_service_rest
    skip unless Google::Cloud::AIPlatform.persistent_resource_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.persistent_resource_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::PersistentResourceService::Rest::Client, client
    end
  end

  def test_pipeline_service_grpc
    skip unless Google::Cloud::AIPlatform.pipeline_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.pipeline_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::PipelineService::Client, client
    end
  end

  def test_pipeline_service_rest
    skip unless Google::Cloud::AIPlatform.pipeline_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.pipeline_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client, client
    end
  end

  def test_reasoning_engine_execution_service_grpc
    skip unless Google::Cloud::AIPlatform.reasoning_engine_execution_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.reasoning_engine_execution_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client, client
    end
  end

  def test_reasoning_engine_execution_service_rest
    skip unless Google::Cloud::AIPlatform.reasoning_engine_execution_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.reasoning_engine_execution_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Rest::Client, client
    end
  end

  def test_reasoning_engine_service_grpc
    skip unless Google::Cloud::AIPlatform.reasoning_engine_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.reasoning_engine_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ReasoningEngineService::Client, client
    end
  end

  def test_reasoning_engine_service_rest
    skip unless Google::Cloud::AIPlatform.reasoning_engine_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.reasoning_engine_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ReasoningEngineService::Rest::Client, client
    end
  end

  def test_schedule_service_grpc
    skip unless Google::Cloud::AIPlatform.schedule_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.schedule_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ScheduleService::Client, client
    end
  end

  def test_schedule_service_rest
    skip unless Google::Cloud::AIPlatform.schedule_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.schedule_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::ScheduleService::Rest::Client, client
    end
  end

  def test_specialist_pool_service_grpc
    skip unless Google::Cloud::AIPlatform.specialist_pool_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.specialist_pool_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::SpecialistPoolService::Client, client
    end
  end

  def test_specialist_pool_service_rest
    skip unless Google::Cloud::AIPlatform.specialist_pool_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.specialist_pool_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::SpecialistPoolService::Rest::Client, client
    end
  end

  def test_tensorboard_service_grpc
    skip unless Google::Cloud::AIPlatform.tensorboard_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.tensorboard_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::TensorboardService::Client, client
    end
  end

  def test_tensorboard_service_rest
    skip unless Google::Cloud::AIPlatform.tensorboard_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.tensorboard_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client, client
    end
  end

  def test_vertex_rag_data_service_grpc
    skip unless Google::Cloud::AIPlatform.vertex_rag_data_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.vertex_rag_data_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::VertexRagDataService::Client, client
    end
  end

  def test_vertex_rag_data_service_rest
    skip unless Google::Cloud::AIPlatform.vertex_rag_data_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.vertex_rag_data_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client, client
    end
  end

  def test_vertex_rag_service_grpc
    skip unless Google::Cloud::AIPlatform.vertex_rag_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.vertex_rag_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::VertexRagService::Client, client
    end
  end

  def test_vertex_rag_service_rest
    skip unless Google::Cloud::AIPlatform.vertex_rag_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.vertex_rag_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::VertexRagService::Rest::Client, client
    end
  end

  def test_vizier_service_grpc
    skip unless Google::Cloud::AIPlatform.vizier_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AIPlatform.vizier_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::VizierService::Client, client
    end
  end

  def test_vizier_service_rest
    skip unless Google::Cloud::AIPlatform.vizier_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AIPlatform.vizier_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AIPlatform::V1::VizierService::Rest::Client, client
    end
  end
end
