# Google Vertex AI API Samples

Vertex AI offers everything you need to build and use generative AI—from AI solutions, to Search and Conversation, to 100+ foundation models, to a unified AI platform.

## Description

These samples show how to use the [Google Vertex AI API](https://cloud.google.com/vertex-ai/).

## Build and Run
1.  **Enable APIs** - [Enable the Vertex AI API](https://console.cloud.google.com/flows/enableapi?apiid=aiplatform.googleapis.com)
    and create a new project or select an existing project.

1.  **Install and Initialize Cloud SDK**
    Follow instructions from the available [quickstarts](https://cloud.google.com/sdk/docs/quickstarts)

1.  **Clone the repo** and cd into this directory

    ```text
    git clone https://github.com/googleapis/google-cloud-ruby.git
    $ cd google-cloud-ruby/google-cloud-ai_platform
    ```

1. **Install Dependencies** via [Bundler](https://bundler.io).

    ```text
    $ bundle install
    ```

1. **Set Environment Variables**

    ```text
    $ export GOOGLE_CLOUD_PROJECT="YOUR_PROJECT_ID"
    ```

1. **Run samples**

    ```text
    bundle exec rake test
    ```

## Contributing changes

* See [CONTRIBUTING.md](../CONTRIBUTING.md)

## Licensing

* See [LICENSE](../LICENSE)
