# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/ai_platform/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :ai_platform do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module AIPlatform
      ##
      # Create a new client object for DataFoundryService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::DataFoundryService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-DataFoundryService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DataFoundryService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DataFoundryService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.data_foundry_service_available?}.
      #
      # ## About DataFoundryService
      #
      # Service for generating and preparing datasets for Gen AI evaluation.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.data_foundry_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:DataFoundryService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DataFoundryService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.data_foundry_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DataFoundryService service,
      # or if the versioned client gem needs an update to support the DataFoundryService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.data_foundry_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :DataFoundryService
        service_module = service_module.const_get :DataFoundryService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DatasetService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::DatasetService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-DatasetService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DatasetService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DatasetService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.dataset_service_available?}.
      #
      # ## About DatasetService
      #
      # The service that manages Vertex AI Dataset and its child resources.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.dataset_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:DatasetService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DatasetService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.dataset_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DatasetService service,
      # or if the versioned client gem needs an update to support the DatasetService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.dataset_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :DatasetService
        service_module = service_module.const_get :DatasetService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DeploymentResourcePoolService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-DeploymentResourcePoolService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DeploymentResourcePoolService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DeploymentResourcePoolService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.deployment_resource_pool_service_available?}.
      #
      # ## About DeploymentResourcePoolService
      #
      # A service that manages the DeploymentResourcePool resource.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.deployment_resource_pool_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:DeploymentResourcePoolService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DeploymentResourcePoolService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.deployment_resource_pool_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DeploymentResourcePoolService service,
      # or if the versioned client gem needs an update to support the DeploymentResourcePoolService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.deployment_resource_pool_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :DeploymentResourcePoolService
        service_module = service_module.const_get :DeploymentResourcePoolService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for EndpointService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::EndpointService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-EndpointService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the EndpointService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the EndpointService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.endpoint_service_available?}.
      #
      # ## About EndpointService
      #
      # A service for managing Vertex AI's Endpoints.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.endpoint_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:EndpointService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the EndpointService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.endpoint_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the EndpointService service,
      # or if the versioned client gem needs an update to support the EndpointService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.endpoint_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :EndpointService
        service_module = service_module.const_get :EndpointService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for EvaluationService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::EvaluationService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-EvaluationService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the EvaluationService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the EvaluationService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.evaluation_service_available?}.
      #
      # ## About EvaluationService
      #
      # Vertex AI Online Evaluation Service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.evaluation_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:EvaluationService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the EvaluationService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.evaluation_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the EvaluationService service,
      # or if the versioned client gem needs an update to support the EvaluationService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.evaluation_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :EvaluationService
        service_module = service_module.const_get :EvaluationService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for FeatureOnlineStoreAdminService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-FeatureOnlineStoreAdminService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the FeatureOnlineStoreAdminService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the FeatureOnlineStoreAdminService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.feature_online_store_admin_service_available?}.
      #
      # ## About FeatureOnlineStoreAdminService
      #
      # The service that handles CRUD and List for resources for
      # FeatureOnlineStore.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.feature_online_store_admin_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:FeatureOnlineStoreAdminService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the FeatureOnlineStoreAdminService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.feature_online_store_admin_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the FeatureOnlineStoreAdminService service,
      # or if the versioned client gem needs an update to support the FeatureOnlineStoreAdminService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.feature_online_store_admin_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :FeatureOnlineStoreAdminService
        service_module = service_module.const_get :FeatureOnlineStoreAdminService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for FeaturestoreOnlineServingService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::FeaturestoreOnlineServingService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-FeaturestoreOnlineServingService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the FeaturestoreOnlineServingService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the FeaturestoreOnlineServingService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.featurestore_online_serving_service_available?}.
      #
      # ## About FeaturestoreOnlineServingService
      #
      # A service for serving online feature values.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.featurestore_online_serving_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:FeaturestoreOnlineServingService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the FeaturestoreOnlineServingService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.featurestore_online_serving_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the FeaturestoreOnlineServingService service,
      # or if the versioned client gem needs an update to support the FeaturestoreOnlineServingService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.featurestore_online_serving_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :FeaturestoreOnlineServingService
        service_module = service_module.const_get :FeaturestoreOnlineServingService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for FeatureOnlineStoreService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-FeatureOnlineStoreService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the FeatureOnlineStoreService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the FeatureOnlineStoreService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.feature_online_store_service_available?}.
      #
      # ## About FeatureOnlineStoreService
      #
      # A service for fetching feature values from the online store.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.feature_online_store_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:FeatureOnlineStoreService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the FeatureOnlineStoreService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.feature_online_store_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the FeatureOnlineStoreService service,
      # or if the versioned client gem needs an update to support the FeatureOnlineStoreService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.feature_online_store_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :FeatureOnlineStoreService
        service_module = service_module.const_get :FeatureOnlineStoreService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for FeaturestoreService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::FeaturestoreService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-FeaturestoreService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the FeaturestoreService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the FeaturestoreService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.featurestore_service_available?}.
      #
      # ## About FeaturestoreService
      #
      # The service that handles CRUD and List for resources for Featurestore.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.featurestore_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:FeaturestoreService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the FeaturestoreService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.featurestore_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the FeaturestoreService service,
      # or if the versioned client gem needs an update to support the FeaturestoreService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.featurestore_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :FeaturestoreService
        service_module = service_module.const_get :FeaturestoreService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for FeatureRegistryService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::FeatureRegistryService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-FeatureRegistryService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the FeatureRegistryService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the FeatureRegistryService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.feature_registry_service_available?}.
      #
      # ## About FeatureRegistryService
      #
      # The service that handles CRUD and List for resources for
      # FeatureRegistry.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.feature_registry_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:FeatureRegistryService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the FeatureRegistryService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.feature_registry_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the FeatureRegistryService service,
      # or if the versioned client gem needs an update to support the FeatureRegistryService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.feature_registry_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :FeatureRegistryService
        service_module = service_module.const_get :FeatureRegistryService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for GenAiCacheService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::GenAiCacheService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-GenAiCacheService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the GenAiCacheService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the GenAiCacheService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.gen_ai_cache_service_available?}.
      #
      # ## About GenAiCacheService
      #
      # Service for managing Vertex AI's CachedContent resource.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.gen_ai_cache_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:GenAiCacheService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the GenAiCacheService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.gen_ai_cache_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the GenAiCacheService service,
      # or if the versioned client gem needs an update to support the GenAiCacheService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.gen_ai_cache_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :GenAiCacheService
        service_module = service_module.const_get :GenAiCacheService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for GenAiTuningService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::GenAiTuningService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-GenAiTuningService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the GenAiTuningService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the GenAiTuningService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.gen_ai_tuning_service_available?}.
      #
      # ## About GenAiTuningService
      #
      # A service for creating and managing GenAI Tuning Jobs.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.gen_ai_tuning_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:GenAiTuningService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the GenAiTuningService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.gen_ai_tuning_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the GenAiTuningService service,
      # or if the versioned client gem needs an update to support the GenAiTuningService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.gen_ai_tuning_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :GenAiTuningService
        service_module = service_module.const_get :GenAiTuningService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for IndexEndpointService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::IndexEndpointService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-IndexEndpointService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the IndexEndpointService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the IndexEndpointService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.index_endpoint_service_available?}.
      #
      # ## About IndexEndpointService
      #
      # A service for managing Vertex AI's IndexEndpoints.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.index_endpoint_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:IndexEndpointService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the IndexEndpointService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.index_endpoint_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the IndexEndpointService service,
      # or if the versioned client gem needs an update to support the IndexEndpointService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.index_endpoint_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :IndexEndpointService
        service_module = service_module.const_get :IndexEndpointService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for IndexService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::IndexService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-IndexService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the IndexService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the IndexService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.index_service_available?}.
      #
      # ## About IndexService
      #
      # A service for creating and managing Vertex AI's Index resources.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.index_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:IndexService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the IndexService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.index_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the IndexService service,
      # or if the versioned client gem needs an update to support the IndexService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.index_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :IndexService
        service_module = service_module.const_get :IndexService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for JobService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::JobService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-JobService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the JobService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the JobService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.job_service_available?}.
      #
      # ## About JobService
      #
      # A service for creating and managing Vertex AI's jobs.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.job_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:JobService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the JobService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.job_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the JobService service,
      # or if the versioned client gem needs an update to support the JobService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.job_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :JobService
        service_module = service_module.const_get :JobService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for PredictionService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::PredictionService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-PredictionService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the PredictionService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the PredictionService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.prediction_service_available?}.
      #
      # ## About PredictionService
      #
      # A service for online predictions and explanations.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.prediction_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:PredictionService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the PredictionService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.prediction_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the PredictionService service,
      # or if the versioned client gem needs an update to support the PredictionService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.prediction_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :PredictionService
        service_module = service_module.const_get :PredictionService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for LlmUtilityService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::LlmUtilityService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-LlmUtilityService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the LlmUtilityService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the LlmUtilityService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.llm_utility_service_available?}.
      #
      # ## About LlmUtilityService
      #
      # Service for LLM related utility functions.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.llm_utility_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:LlmUtilityService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the LlmUtilityService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.llm_utility_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the LlmUtilityService service,
      # or if the versioned client gem needs an update to support the LlmUtilityService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.llm_utility_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :LlmUtilityService
        service_module = service_module.const_get :LlmUtilityService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for MatchService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::MatchService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-MatchService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the MatchService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the MatchService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.match_service_available?}.
      #
      # ## About MatchService
      #
      # MatchService is a Google managed service for efficient vector similarity
      # search at scale.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.match_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:MatchService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the MatchService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.match_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the MatchService service,
      # or if the versioned client gem needs an update to support the MatchService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.match_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :MatchService
        service_module = service_module.const_get :MatchService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for MetadataService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::MetadataService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-MetadataService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the MetadataService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the MetadataService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.metadata_service_available?}.
      #
      # ## About MetadataService
      #
      # Service for reading and writing metadata entries.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.metadata_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:MetadataService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the MetadataService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.metadata_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the MetadataService service,
      # or if the versioned client gem needs an update to support the MetadataService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.metadata_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :MetadataService
        service_module = service_module.const_get :MetadataService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for MigrationService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::MigrationService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-MigrationService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the MigrationService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the MigrationService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.migration_service_available?}.
      #
      # ## About MigrationService
      #
      # A service that migrates resources from automl.googleapis.com,
      # datalabeling.googleapis.com and ml.googleapis.com to Vertex AI.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.migration_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:MigrationService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the MigrationService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.migration_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the MigrationService service,
      # or if the versioned client gem needs an update to support the MigrationService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.migration_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :MigrationService
        service_module = service_module.const_get :MigrationService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ModelGardenService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::ModelGardenService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-ModelGardenService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ModelGardenService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ModelGardenService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.model_garden_service_available?}.
      #
      # ## About ModelGardenService
      #
      # The interface of Model Garden Service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.model_garden_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:ModelGardenService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ModelGardenService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.model_garden_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ModelGardenService service,
      # or if the versioned client gem needs an update to support the ModelGardenService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.model_garden_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :ModelGardenService
        service_module = service_module.const_get :ModelGardenService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ModelService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::ModelService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-ModelService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ModelService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ModelService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.model_service_available?}.
      #
      # ## About ModelService
      #
      # A service for managing Vertex AI's machine learning Models.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.model_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:ModelService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ModelService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.model_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ModelService service,
      # or if the versioned client gem needs an update to support the ModelService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.model_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :ModelService
        service_module = service_module.const_get :ModelService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for NotebookService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::NotebookService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-NotebookService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the NotebookService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the NotebookService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.notebook_service_available?}.
      #
      # ## About NotebookService
      #
      # The interface for Vertex Notebook service (a.k.a. Colab on Workbench).
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.notebook_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:NotebookService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the NotebookService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.notebook_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the NotebookService service,
      # or if the versioned client gem needs an update to support the NotebookService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.notebook_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :NotebookService
        service_module = service_module.const_get :NotebookService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for PersistentResourceService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::PersistentResourceService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-PersistentResourceService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the PersistentResourceService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the PersistentResourceService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.persistent_resource_service_available?}.
      #
      # ## About PersistentResourceService
      #
      # A service for managing Vertex AI's machine learning PersistentResource.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.persistent_resource_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:PersistentResourceService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the PersistentResourceService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.persistent_resource_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the PersistentResourceService service,
      # or if the versioned client gem needs an update to support the PersistentResourceService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.persistent_resource_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :PersistentResourceService
        service_module = service_module.const_get :PersistentResourceService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for PipelineService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::PipelineService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-PipelineService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the PipelineService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the PipelineService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.pipeline_service_available?}.
      #
      # ## About PipelineService
      #
      # A service for creating and managing Vertex AI's pipelines. This includes both
      # `TrainingPipeline` resources (used for AutoML and custom training) and
      # `PipelineJob` resources (used for Vertex AI Pipelines).
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.pipeline_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:PipelineService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the PipelineService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.pipeline_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the PipelineService service,
      # or if the versioned client gem needs an update to support the PipelineService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.pipeline_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :PipelineService
        service_module = service_module.const_get :PipelineService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ReasoningEngineExecutionService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-ReasoningEngineExecutionService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ReasoningEngineExecutionService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ReasoningEngineExecutionService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.reasoning_engine_execution_service_available?}.
      #
      # ## About ReasoningEngineExecutionService
      #
      # A service for executing queries on Reasoning Engine.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.reasoning_engine_execution_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:ReasoningEngineExecutionService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ReasoningEngineExecutionService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.reasoning_engine_execution_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ReasoningEngineExecutionService service,
      # or if the versioned client gem needs an update to support the ReasoningEngineExecutionService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.reasoning_engine_execution_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :ReasoningEngineExecutionService
        service_module = service_module.const_get :ReasoningEngineExecutionService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ReasoningEngineService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::ReasoningEngineService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-ReasoningEngineService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ReasoningEngineService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ReasoningEngineService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.reasoning_engine_service_available?}.
      #
      # ## About ReasoningEngineService
      #
      # A service for managing Vertex AI's Reasoning Engines.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.reasoning_engine_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:ReasoningEngineService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ReasoningEngineService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.reasoning_engine_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ReasoningEngineService service,
      # or if the versioned client gem needs an update to support the ReasoningEngineService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.reasoning_engine_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :ReasoningEngineService
        service_module = service_module.const_get :ReasoningEngineService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ScheduleService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::ScheduleService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-ScheduleService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ScheduleService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ScheduleService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.schedule_service_available?}.
      #
      # ## About ScheduleService
      #
      # A service for creating and managing Vertex AI's Schedule resources to
      # periodically launch shceudled runs to make API calls.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.schedule_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:ScheduleService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ScheduleService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.schedule_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ScheduleService service,
      # or if the versioned client gem needs an update to support the ScheduleService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.schedule_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :ScheduleService
        service_module = service_module.const_get :ScheduleService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for SpecialistPoolService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::SpecialistPoolService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-SpecialistPoolService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the SpecialistPoolService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the SpecialistPoolService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.specialist_pool_service_available?}.
      #
      # ## About SpecialistPoolService
      #
      # A service for creating and managing Customer SpecialistPools.
      # When customers start Data Labeling jobs, they can reuse/create Specialist
      # Pools to bring their own Specialists to label the data.
      # Customers can add/remove Managers for the Specialist Pool on Cloud console,
      # then Managers will get email notifications to manage Specialists and tasks on
      # CrowdCompute console.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.specialist_pool_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:SpecialistPoolService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the SpecialistPoolService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.specialist_pool_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the SpecialistPoolService service,
      # or if the versioned client gem needs an update to support the SpecialistPoolService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.specialist_pool_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :SpecialistPoolService
        service_module = service_module.const_get :SpecialistPoolService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for TensorboardService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::TensorboardService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-TensorboardService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the TensorboardService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the TensorboardService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.tensorboard_service_available?}.
      #
      # ## About TensorboardService
      #
      # TensorboardService
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.tensorboard_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:TensorboardService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the TensorboardService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.tensorboard_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the TensorboardService service,
      # or if the versioned client gem needs an update to support the TensorboardService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.tensorboard_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :TensorboardService
        service_module = service_module.const_get :TensorboardService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for VertexRagDataService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::VertexRagDataService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-VertexRagDataService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the VertexRagDataService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the VertexRagDataService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.vertex_rag_data_service_available?}.
      #
      # ## About VertexRagDataService
      #
      # A service for managing user data for RAG.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.vertex_rag_data_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:VertexRagDataService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the VertexRagDataService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.vertex_rag_data_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the VertexRagDataService service,
      # or if the versioned client gem needs an update to support the VertexRagDataService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.vertex_rag_data_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :VertexRagDataService
        service_module = service_module.const_get :VertexRagDataService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for VertexRagService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::VertexRagService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-VertexRagService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the VertexRagService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the VertexRagService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.vertex_rag_service_available?}.
      #
      # ## About VertexRagService
      #
      # A service for retrieving relevant contexts.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.vertex_rag_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:VertexRagService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the VertexRagService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.vertex_rag_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the VertexRagService service,
      # or if the versioned client gem needs an update to support the VertexRagService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.vertex_rag_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :VertexRagService
        service_module = service_module.const_get :VertexRagService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for VizierService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AIPlatform::V1::VizierService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-ai_platform-v1/latest/Google-Cloud-AIPlatform-V1-VizierService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the VizierService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the VizierService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AIPlatform.vizier_service_available?}.
      #
      # ## About VizierService
      #
      # Vertex AI Vizier API.
      #
      # Vertex AI Vizier is a service to solve blackbox optimization problems,
      # such as tuning machine learning hyperparameters and searching over deep
      # learning architectures.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.vizier_service version: :v1, transport: :grpc, &block
        require "google/cloud/ai_platform/#{version.to_s.downcase}"

        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AIPlatform.const_get(package_name).const_get(:VizierService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the VizierService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AIPlatform.vizier_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the VizierService service,
      # or if the versioned client gem needs an update to support the VizierService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.vizier_service_available? version: :v1, transport: :grpc
        require "google/cloud/ai_platform/#{version.to_s.downcase}"
        package_name = Google::Cloud::AIPlatform
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AIPlatform.const_get package_name
        return false unless service_module.const_defined? :VizierService
        service_module = service_module.const_get :VizierService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-ai_platform library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.ai_platform if block_given?

        ::Google::Cloud.configure.ai_platform
      end
    end
  end
end

helper_path = ::File.join __dir__, "ai_platform", "helpers.rb"
require "google/cloud/ai_platform/helpers" if ::File.file? helper_path
