# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/vizier_service_pb"
require "google/cloud/ai_platform/v1/vizier_service/rest"


class ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_study
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Study.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    study = {}

    create_study_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_create_study_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_study_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_study({ parent: parent, study: study }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_study parent: parent, study: study do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_study ::Google::Cloud::AIPlatform::V1::CreateStudyRequest.new(parent: parent, study: study) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_study({ parent: parent, study: study }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_study(::Google::Cloud::AIPlatform::V1::CreateStudyRequest.new(parent: parent, study: study), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_study_client_stub.call_count
      end
    end
  end

  def test_get_study
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Study.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_study_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_get_study_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_study_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_study({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_study name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_study ::Google::Cloud::AIPlatform::V1::GetStudyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_study({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_study(::Google::Cloud::AIPlatform::V1::GetStudyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_study_client_stub.call_count
      end
    end
  end

  def test_list_studies
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListStudiesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_studies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_list_studies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_studies_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_studies({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_studies parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_studies ::Google::Cloud::AIPlatform::V1::ListStudiesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_studies({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_studies(::Google::Cloud::AIPlatform::V1::ListStudiesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_studies_client_stub.call_count
      end
    end
  end

  def test_delete_study
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_study_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_delete_study_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_study_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_study({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_study name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_study ::Google::Cloud::AIPlatform::V1::DeleteStudyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_study({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_study(::Google::Cloud::AIPlatform::V1::DeleteStudyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_study_client_stub.call_count
      end
    end
  end

  def test_lookup_study
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Study.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_name = "hello world"

    lookup_study_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_lookup_study_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_study_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_study({ parent: parent, display_name: display_name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_study parent: parent, display_name: display_name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_study ::Google::Cloud::AIPlatform::V1::LookupStudyRequest.new(parent: parent, display_name: display_name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_study({ parent: parent, display_name: display_name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_study(::Google::Cloud::AIPlatform::V1::LookupStudyRequest.new(parent: parent, display_name: display_name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_study_client_stub.call_count
      end
    end
  end

  def test_suggest_trials
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    suggestion_count = 42
    client_id = "hello world"
    contexts = [{}]

    suggest_trials_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_suggest_trials_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suggest_trials_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suggest_trials({ parent: parent, suggestion_count: suggestion_count, client_id: client_id, contexts: contexts }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suggest_trials parent: parent, suggestion_count: suggestion_count, client_id: client_id, contexts: contexts do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suggest_trials ::Google::Cloud::AIPlatform::V1::SuggestTrialsRequest.new(parent: parent, suggestion_count: suggestion_count, client_id: client_id, contexts: contexts) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suggest_trials({ parent: parent, suggestion_count: suggestion_count, client_id: client_id, contexts: contexts }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suggest_trials(::Google::Cloud::AIPlatform::V1::SuggestTrialsRequest.new(parent: parent, suggestion_count: suggestion_count, client_id: client_id, contexts: contexts), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suggest_trials_client_stub.call_count
      end
    end
  end

  def test_create_trial
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Trial.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    trial = {}

    create_trial_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_create_trial_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_trial_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_trial({ parent: parent, trial: trial }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_trial parent: parent, trial: trial do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_trial ::Google::Cloud::AIPlatform::V1::CreateTrialRequest.new(parent: parent, trial: trial) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_trial({ parent: parent, trial: trial }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_trial(::Google::Cloud::AIPlatform::V1::CreateTrialRequest.new(parent: parent, trial: trial), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_trial_client_stub.call_count
      end
    end
  end

  def test_get_trial
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Trial.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_trial_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_get_trial_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_trial_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_trial({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_trial name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_trial ::Google::Cloud::AIPlatform::V1::GetTrialRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_trial({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_trial(::Google::Cloud::AIPlatform::V1::GetTrialRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_trial_client_stub.call_count
      end
    end
  end

  def test_list_trials
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListTrialsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_trials_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_list_trials_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_trials_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_trials({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_trials parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_trials ::Google::Cloud::AIPlatform::V1::ListTrialsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_trials({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_trials(::Google::Cloud::AIPlatform::V1::ListTrialsRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_trials_client_stub.call_count
      end
    end
  end

  def test_add_trial_measurement
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Trial.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    trial_name = "hello world"
    measurement = {}

    add_trial_measurement_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_add_trial_measurement_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_trial_measurement_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_trial_measurement({ trial_name: trial_name, measurement: measurement }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_trial_measurement trial_name: trial_name, measurement: measurement do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_trial_measurement ::Google::Cloud::AIPlatform::V1::AddTrialMeasurementRequest.new(trial_name: trial_name, measurement: measurement) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_trial_measurement({ trial_name: trial_name, measurement: measurement }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_trial_measurement(::Google::Cloud::AIPlatform::V1::AddTrialMeasurementRequest.new(trial_name: trial_name, measurement: measurement), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_trial_measurement_client_stub.call_count
      end
    end
  end

  def test_complete_trial
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Trial.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    final_measurement = {}
    trial_infeasible = true
    infeasible_reason = "hello world"

    complete_trial_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_complete_trial_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, complete_trial_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.complete_trial({ name: name, final_measurement: final_measurement, trial_infeasible: trial_infeasible, infeasible_reason: infeasible_reason }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.complete_trial name: name, final_measurement: final_measurement, trial_infeasible: trial_infeasible, infeasible_reason: infeasible_reason do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.complete_trial ::Google::Cloud::AIPlatform::V1::CompleteTrialRequest.new(name: name, final_measurement: final_measurement, trial_infeasible: trial_infeasible, infeasible_reason: infeasible_reason) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.complete_trial({ name: name, final_measurement: final_measurement, trial_infeasible: trial_infeasible, infeasible_reason: infeasible_reason }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.complete_trial(::Google::Cloud::AIPlatform::V1::CompleteTrialRequest.new(name: name, final_measurement: final_measurement, trial_infeasible: trial_infeasible, infeasible_reason: infeasible_reason), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, complete_trial_client_stub.call_count
      end
    end
  end

  def test_delete_trial
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_trial_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_delete_trial_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_trial_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_trial({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_trial name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_trial ::Google::Cloud::AIPlatform::V1::DeleteTrialRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_trial({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_trial(::Google::Cloud::AIPlatform::V1::DeleteTrialRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_trial_client_stub.call_count
      end
    end
  end

  def test_check_trial_early_stopping_state
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    trial_name = "hello world"

    check_trial_early_stopping_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_check_trial_early_stopping_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, check_trial_early_stopping_state_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.check_trial_early_stopping_state({ trial_name: trial_name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.check_trial_early_stopping_state trial_name: trial_name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.check_trial_early_stopping_state ::Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateRequest.new(trial_name: trial_name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.check_trial_early_stopping_state({ trial_name: trial_name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.check_trial_early_stopping_state(::Google::Cloud::AIPlatform::V1::CheckTrialEarlyStoppingStateRequest.new(trial_name: trial_name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, check_trial_early_stopping_state_client_stub.call_count
      end
    end
  end

  def test_stop_trial
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Trial.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_trial_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_stop_trial_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_trial_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_trial({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_trial name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_trial ::Google::Cloud::AIPlatform::V1::StopTrialRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_trial({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_trial(::Google::Cloud::AIPlatform::V1::StopTrialRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_trial_client_stub.call_count
      end
    end
  end

  def test_list_optimal_trials
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListOptimalTrialsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_optimal_trials_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VizierService::Rest::ServiceStub.stub :transcode_list_optimal_trials_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_optimal_trials_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_optimal_trials({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_optimal_trials parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_optimal_trials ::Google::Cloud::AIPlatform::V1::ListOptimalTrialsRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_optimal_trials({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_optimal_trials(::Google::Cloud::AIPlatform::V1::ListOptimalTrialsRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_optimal_trials_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::VizierService::Rest::Client::Configuration, config
  end
end
