# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/vertex_rag_service_pb"
require "google/cloud/ai_platform/v1/vertex_rag_service"

class ::Google::Cloud::AIPlatform::V1::VertexRagService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_retrieve_contexts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::RetrieveContextsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    vertex_rag_store = {}
    parent = "hello world"
    query = {}

    retrieve_contexts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_contexts, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::RetrieveContextsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::RetrieveContextsRequest::VertexRagStore), request["vertex_rag_store"]
      assert_equal :vertex_rag_store, request.data_source
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::RagQuery), request["query"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_contexts_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_contexts({ vertex_rag_store: vertex_rag_store, parent: parent, query: query }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_contexts vertex_rag_store: vertex_rag_store, parent: parent, query: query do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_contexts ::Google::Cloud::AIPlatform::V1::RetrieveContextsRequest.new(vertex_rag_store: vertex_rag_store, parent: parent, query: query) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_contexts({ vertex_rag_store: vertex_rag_store, parent: parent, query: query }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_contexts(::Google::Cloud::AIPlatform::V1::RetrieveContextsRequest.new(vertex_rag_store: vertex_rag_store, parent: parent, query: query), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_contexts_client_stub.call_rpc_count
    end
  end

  def test_augment_prompt
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::AugmentPromptResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    vertex_rag_store = {}
    parent = "hello world"
    contents = [{}]
    model = {}

    augment_prompt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :augment_prompt, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::AugmentPromptRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::VertexRagStore), request["vertex_rag_store"]
      assert_equal :vertex_rag_store, request.data_source
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Content, request["contents"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::AugmentPromptRequest::Model), request["model"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, augment_prompt_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.augment_prompt({ vertex_rag_store: vertex_rag_store, parent: parent, contents: contents, model: model }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.augment_prompt vertex_rag_store: vertex_rag_store, parent: parent, contents: contents, model: model do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.augment_prompt ::Google::Cloud::AIPlatform::V1::AugmentPromptRequest.new(vertex_rag_store: vertex_rag_store, parent: parent, contents: contents, model: model) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.augment_prompt({ vertex_rag_store: vertex_rag_store, parent: parent, contents: contents, model: model }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.augment_prompt(::Google::Cloud::AIPlatform::V1::AugmentPromptRequest.new(vertex_rag_store: vertex_rag_store, parent: parent, contents: contents, model: model), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, augment_prompt_client_stub.call_rpc_count
    end
  end

  def test_corroborate_content
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::CorroborateContentResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    content = {}
    facts = [{}]
    parameters = {}

    corroborate_content_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :corroborate_content, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CorroborateContentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Content), request["content"]
      assert request.has_content?
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Fact, request["facts"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::CorroborateContentRequest::Parameters), request["parameters"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, corroborate_content_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.corroborate_content({ parent: parent, content: content, facts: facts, parameters: parameters }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.corroborate_content parent: parent, content: content, facts: facts, parameters: parameters do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.corroborate_content ::Google::Cloud::AIPlatform::V1::CorroborateContentRequest.new(parent: parent, content: content, facts: facts, parameters: parameters) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.corroborate_content({ parent: parent, content: content, facts: facts, parameters: parameters }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.corroborate_content(::Google::Cloud::AIPlatform::V1::CorroborateContentRequest.new(parent: parent, content: content, facts: facts, parameters: parameters), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, corroborate_content_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::VertexRagService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::VertexRagService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::VertexRagService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::VertexRagService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
