# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/vertex_rag_data_service_pb"
require "google/cloud/ai_platform/v1/vertex_rag_data_service"

class ::Google::Cloud::AIPlatform::V1::VertexRagDataService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_rag_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rag_corpus = {}

    create_rag_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_rag_corpus, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateRagCorpusRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::RagCorpus), request["rag_corpus"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_rag_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_rag_corpus({ parent: parent, rag_corpus: rag_corpus }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_rag_corpus parent: parent, rag_corpus: rag_corpus do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_rag_corpus ::Google::Cloud::AIPlatform::V1::CreateRagCorpusRequest.new(parent: parent, rag_corpus: rag_corpus) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_rag_corpus({ parent: parent, rag_corpus: rag_corpus }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_rag_corpus(::Google::Cloud::AIPlatform::V1::CreateRagCorpusRequest.new(parent: parent, rag_corpus: rag_corpus), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_rag_corpus_client_stub.call_rpc_count
    end
  end

  def test_update_rag_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rag_corpus = {}

    update_rag_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_rag_corpus, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateRagCorpusRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::RagCorpus), request["rag_corpus"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_rag_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_rag_corpus({ rag_corpus: rag_corpus }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_rag_corpus rag_corpus: rag_corpus do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_rag_corpus ::Google::Cloud::AIPlatform::V1::UpdateRagCorpusRequest.new(rag_corpus: rag_corpus) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_rag_corpus({ rag_corpus: rag_corpus }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_rag_corpus(::Google::Cloud::AIPlatform::V1::UpdateRagCorpusRequest.new(rag_corpus: rag_corpus), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_rag_corpus_client_stub.call_rpc_count
    end
  end

  def test_get_rag_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::RagCorpus.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rag_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rag_corpus, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetRagCorpusRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rag_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rag_corpus({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rag_corpus name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rag_corpus ::Google::Cloud::AIPlatform::V1::GetRagCorpusRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rag_corpus({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rag_corpus(::Google::Cloud::AIPlatform::V1::GetRagCorpusRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rag_corpus_client_stub.call_rpc_count
    end
  end

  def test_list_rag_corpora
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListRagCorporaResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_rag_corpora_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rag_corpora, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListRagCorporaRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rag_corpora_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rag_corpora({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rag_corpora parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rag_corpora ::Google::Cloud::AIPlatform::V1::ListRagCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rag_corpora({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rag_corpora(::Google::Cloud::AIPlatform::V1::ListRagCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rag_corpora_client_stub.call_rpc_count
    end
  end

  def test_delete_rag_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_rag_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_rag_corpus, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteRagCorpusRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_rag_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_rag_corpus({ name: name, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_rag_corpus name: name, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_rag_corpus ::Google::Cloud::AIPlatform::V1::DeleteRagCorpusRequest.new(name: name, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_rag_corpus({ name: name, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_rag_corpus(::Google::Cloud::AIPlatform::V1::DeleteRagCorpusRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_rag_corpus_client_stub.call_rpc_count
    end
  end

  def test_upload_rag_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::UploadRagFileResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rag_file = {}
    upload_rag_file_config = {}

    upload_rag_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upload_rag_file, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UploadRagFileRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::RagFile), request["rag_file"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::UploadRagFileConfig), request["upload_rag_file_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upload_rag_file_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upload_rag_file({ parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upload_rag_file parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upload_rag_file ::Google::Cloud::AIPlatform::V1::UploadRagFileRequest.new(parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upload_rag_file({ parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upload_rag_file(::Google::Cloud::AIPlatform::V1::UploadRagFileRequest.new(parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upload_rag_file_client_stub.call_rpc_count
    end
  end

  def test_import_rag_files
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_rag_files_config = {}

    import_rag_files_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_rag_files, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ImportRagFilesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ImportRagFilesConfig), request["import_rag_files_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_rag_files_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_rag_files({ parent: parent, import_rag_files_config: import_rag_files_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_rag_files parent: parent, import_rag_files_config: import_rag_files_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_rag_files ::Google::Cloud::AIPlatform::V1::ImportRagFilesRequest.new(parent: parent, import_rag_files_config: import_rag_files_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_rag_files({ parent: parent, import_rag_files_config: import_rag_files_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_rag_files(::Google::Cloud::AIPlatform::V1::ImportRagFilesRequest.new(parent: parent, import_rag_files_config: import_rag_files_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_rag_files_client_stub.call_rpc_count
    end
  end

  def test_get_rag_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::RagFile.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rag_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rag_file, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetRagFileRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rag_file_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rag_file({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rag_file name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rag_file ::Google::Cloud::AIPlatform::V1::GetRagFileRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rag_file({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rag_file(::Google::Cloud::AIPlatform::V1::GetRagFileRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rag_file_client_stub.call_rpc_count
    end
  end

  def test_list_rag_files
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListRagFilesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_rag_files_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rag_files, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListRagFilesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rag_files_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rag_files({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rag_files parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rag_files ::Google::Cloud::AIPlatform::V1::ListRagFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rag_files({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rag_files(::Google::Cloud::AIPlatform::V1::ListRagFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rag_files_client_stub.call_rpc_count
    end
  end

  def test_delete_rag_file
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_rag_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_rag_file, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteRagFileRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_rag_file_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_rag_file({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_rag_file name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_rag_file ::Google::Cloud::AIPlatform::V1::DeleteRagFileRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_rag_file({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_rag_file(::Google::Cloud::AIPlatform::V1::DeleteRagFileRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_rag_file_client_stub.call_rpc_count
    end
  end

  def test_update_rag_engine_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rag_engine_config = {}

    update_rag_engine_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_rag_engine_config, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateRagEngineConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::RagEngineConfig), request["rag_engine_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_rag_engine_config_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_rag_engine_config({ rag_engine_config: rag_engine_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_rag_engine_config rag_engine_config: rag_engine_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_rag_engine_config ::Google::Cloud::AIPlatform::V1::UpdateRagEngineConfigRequest.new(rag_engine_config: rag_engine_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_rag_engine_config({ rag_engine_config: rag_engine_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_rag_engine_config(::Google::Cloud::AIPlatform::V1::UpdateRagEngineConfigRequest.new(rag_engine_config: rag_engine_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_rag_engine_config_client_stub.call_rpc_count
    end
  end

  def test_get_rag_engine_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::RagEngineConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rag_engine_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rag_engine_config, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetRagEngineConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rag_engine_config_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rag_engine_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rag_engine_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rag_engine_config ::Google::Cloud::AIPlatform::V1::GetRagEngineConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rag_engine_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rag_engine_config(::Google::Cloud::AIPlatform::V1::GetRagEngineConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rag_engine_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Operations, client.operations_client
  end
end
