# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/vertex_rag_data_service_pb"
require "google/cloud/ai_platform/v1/vertex_rag_data_service/rest"


class ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_rag_corpus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rag_corpus = {}

    create_rag_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_create_rag_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_rag_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_rag_corpus({ parent: parent, rag_corpus: rag_corpus }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_rag_corpus parent: parent, rag_corpus: rag_corpus do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_rag_corpus ::Google::Cloud::AIPlatform::V1::CreateRagCorpusRequest.new(parent: parent, rag_corpus: rag_corpus) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_rag_corpus({ parent: parent, rag_corpus: rag_corpus }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_rag_corpus(::Google::Cloud::AIPlatform::V1::CreateRagCorpusRequest.new(parent: parent, rag_corpus: rag_corpus), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_rag_corpus_client_stub.call_count
      end
    end
  end

  def test_update_rag_corpus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rag_corpus = {}

    update_rag_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_update_rag_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_rag_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_rag_corpus({ rag_corpus: rag_corpus }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_rag_corpus rag_corpus: rag_corpus do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_rag_corpus ::Google::Cloud::AIPlatform::V1::UpdateRagCorpusRequest.new(rag_corpus: rag_corpus) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_rag_corpus({ rag_corpus: rag_corpus }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_rag_corpus(::Google::Cloud::AIPlatform::V1::UpdateRagCorpusRequest.new(rag_corpus: rag_corpus), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_rag_corpus_client_stub.call_count
      end
    end
  end

  def test_get_rag_corpus
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::RagCorpus.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rag_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_get_rag_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rag_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rag_corpus({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rag_corpus name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rag_corpus ::Google::Cloud::AIPlatform::V1::GetRagCorpusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rag_corpus({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rag_corpus(::Google::Cloud::AIPlatform::V1::GetRagCorpusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rag_corpus_client_stub.call_count
      end
    end
  end

  def test_list_rag_corpora
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListRagCorporaResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_rag_corpora_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_list_rag_corpora_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rag_corpora_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rag_corpora({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rag_corpora parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rag_corpora ::Google::Cloud::AIPlatform::V1::ListRagCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rag_corpora({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rag_corpora(::Google::Cloud::AIPlatform::V1::ListRagCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rag_corpora_client_stub.call_count
      end
    end
  end

  def test_delete_rag_corpus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_rag_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_delete_rag_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_rag_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_rag_corpus({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_rag_corpus name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_rag_corpus ::Google::Cloud::AIPlatform::V1::DeleteRagCorpusRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_rag_corpus({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_rag_corpus(::Google::Cloud::AIPlatform::V1::DeleteRagCorpusRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_rag_corpus_client_stub.call_count
      end
    end
  end

  def test_upload_rag_file
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::UploadRagFileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rag_file = {}
    upload_rag_file_config = {}

    upload_rag_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_upload_rag_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upload_rag_file_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upload_rag_file({ parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upload_rag_file parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upload_rag_file ::Google::Cloud::AIPlatform::V1::UploadRagFileRequest.new(parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upload_rag_file({ parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upload_rag_file(::Google::Cloud::AIPlatform::V1::UploadRagFileRequest.new(parent: parent, rag_file: rag_file, upload_rag_file_config: upload_rag_file_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upload_rag_file_client_stub.call_count
      end
    end
  end

  def test_import_rag_files
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_rag_files_config = {}

    import_rag_files_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_import_rag_files_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_rag_files_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_rag_files({ parent: parent, import_rag_files_config: import_rag_files_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_rag_files parent: parent, import_rag_files_config: import_rag_files_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_rag_files ::Google::Cloud::AIPlatform::V1::ImportRagFilesRequest.new(parent: parent, import_rag_files_config: import_rag_files_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_rag_files({ parent: parent, import_rag_files_config: import_rag_files_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_rag_files(::Google::Cloud::AIPlatform::V1::ImportRagFilesRequest.new(parent: parent, import_rag_files_config: import_rag_files_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_rag_files_client_stub.call_count
      end
    end
  end

  def test_get_rag_file
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::RagFile.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rag_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_get_rag_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rag_file_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rag_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rag_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rag_file ::Google::Cloud::AIPlatform::V1::GetRagFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rag_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rag_file(::Google::Cloud::AIPlatform::V1::GetRagFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rag_file_client_stub.call_count
      end
    end
  end

  def test_list_rag_files
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListRagFilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_rag_files_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_list_rag_files_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rag_files_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rag_files({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rag_files parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rag_files ::Google::Cloud::AIPlatform::V1::ListRagFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rag_files({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rag_files(::Google::Cloud::AIPlatform::V1::ListRagFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rag_files_client_stub.call_count
      end
    end
  end

  def test_delete_rag_file
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_rag_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_delete_rag_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_rag_file_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_rag_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_rag_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_rag_file ::Google::Cloud::AIPlatform::V1::DeleteRagFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_rag_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_rag_file(::Google::Cloud::AIPlatform::V1::DeleteRagFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_rag_file_client_stub.call_count
      end
    end
  end

  def test_update_rag_engine_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rag_engine_config = {}

    update_rag_engine_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_update_rag_engine_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_rag_engine_config_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_rag_engine_config({ rag_engine_config: rag_engine_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_rag_engine_config rag_engine_config: rag_engine_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_rag_engine_config ::Google::Cloud::AIPlatform::V1::UpdateRagEngineConfigRequest.new(rag_engine_config: rag_engine_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_rag_engine_config({ rag_engine_config: rag_engine_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_rag_engine_config(::Google::Cloud::AIPlatform::V1::UpdateRagEngineConfigRequest.new(rag_engine_config: rag_engine_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_rag_engine_config_client_stub.call_count
      end
    end
  end

  def test_get_rag_engine_config
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::RagEngineConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rag_engine_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::ServiceStub.stub :transcode_get_rag_engine_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rag_engine_config_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rag_engine_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rag_engine_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rag_engine_config ::Google::Cloud::AIPlatform::V1::GetRagEngineConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rag_engine_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rag_engine_config(::Google::Cloud::AIPlatform::V1::GetRagEngineConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rag_engine_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::VertexRagDataService::Rest::Client::Configuration, config
  end
end
