# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/tensorboard_service_pb"
require "google/cloud/ai_platform/v1/tensorboard_service"

class ::Google::Cloud::AIPlatform::V1::TensorboardService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_tensorboard
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard = {}

    create_tensorboard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tensorboard, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Tensorboard), request["tensorboard"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tensorboard_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tensorboard({ parent: parent, tensorboard: tensorboard }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tensorboard parent: parent, tensorboard: tensorboard do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tensorboard ::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest.new(parent: parent, tensorboard: tensorboard) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tensorboard({ parent: parent, tensorboard: tensorboard }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tensorboard(::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest.new(parent: parent, tensorboard: tensorboard), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tensorboard_client_stub.call_rpc_count
    end
  end

  def test_get_tensorboard
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Tensorboard.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tensorboard, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetTensorboardRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tensorboard_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tensorboard({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tensorboard name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tensorboard ::Google::Cloud::AIPlatform::V1::GetTensorboardRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tensorboard({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tensorboard(::Google::Cloud::AIPlatform::V1::GetTensorboardRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tensorboard_client_stub.call_rpc_count
    end
  end

  def test_update_tensorboard
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard = {}

    update_tensorboard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tensorboard, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Tensorboard), request["tensorboard"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tensorboard_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tensorboard({ update_mask: update_mask, tensorboard: tensorboard }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tensorboard update_mask: update_mask, tensorboard: tensorboard do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tensorboard ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest.new(update_mask: update_mask, tensorboard: tensorboard) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tensorboard({ update_mask: update_mask, tensorboard: tensorboard }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tensorboard(::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest.new(update_mask: update_mask, tensorboard: tensorboard), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tensorboard_client_stub.call_rpc_count
    end
  end

  def test_list_tensorboards
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListTensorboardsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboards_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tensorboards, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tensorboards_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tensorboards({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tensorboards parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tensorboards ::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tensorboards({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tensorboards(::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tensorboards_client_stub.call_rpc_count
    end
  end

  def test_delete_tensorboard
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tensorboard, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tensorboard_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tensorboard({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tensorboard name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tensorboard ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tensorboard({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tensorboard(::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tensorboard_client_stub.call_rpc_count
    end
  end

  def test_read_tensorboard_usage
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tensorboard = "hello world"

    read_tensorboard_usage_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read_tensorboard_usage, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest, request
      assert_equal "hello world", request["tensorboard"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_tensorboard_usage_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_tensorboard_usage({ tensorboard: tensorboard }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_tensorboard_usage tensorboard: tensorboard do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_tensorboard_usage ::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest.new(tensorboard: tensorboard) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_tensorboard_usage({ tensorboard: tensorboard }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_tensorboard_usage(::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest.new(tensorboard: tensorboard), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_tensorboard_usage_client_stub.call_rpc_count
    end
  end

  def test_read_tensorboard_size
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tensorboard = "hello world"

    read_tensorboard_size_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read_tensorboard_size, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest, request
      assert_equal "hello world", request["tensorboard"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_tensorboard_size_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_tensorboard_size({ tensorboard: tensorboard }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_tensorboard_size tensorboard: tensorboard do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_tensorboard_size ::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest.new(tensorboard: tensorboard) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_tensorboard_size({ tensorboard: tensorboard }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_tensorboard_size(::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest.new(tensorboard: tensorboard), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_tensorboard_size_client_stub.call_rpc_count
    end
  end

  def test_create_tensorboard_experiment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardExperiment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard_experiment = {}
    tensorboard_experiment_id = "hello world"

    create_tensorboard_experiment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tensorboard_experiment, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::TensorboardExperiment), request["tensorboard_experiment"]
      assert_equal "hello world", request["tensorboard_experiment_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tensorboard_experiment_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tensorboard_experiment({ parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tensorboard_experiment parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest.new(parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tensorboard_experiment({ parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest.new(parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tensorboard_experiment_client_stub.call_rpc_count
    end
  end

  def test_get_tensorboard_experiment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardExperiment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_experiment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tensorboard_experiment, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tensorboard_experiment_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tensorboard_experiment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tensorboard_experiment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tensorboard_experiment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tensorboard_experiment_client_stub.call_rpc_count
    end
  end

  def test_update_tensorboard_experiment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardExperiment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard_experiment = {}

    update_tensorboard_experiment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tensorboard_experiment, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::TensorboardExperiment), request["tensorboard_experiment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tensorboard_experiment_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tensorboard_experiment({ update_mask: update_mask, tensorboard_experiment: tensorboard_experiment }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tensorboard_experiment update_mask: update_mask, tensorboard_experiment: tensorboard_experiment do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest.new(update_mask: update_mask, tensorboard_experiment: tensorboard_experiment) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tensorboard_experiment({ update_mask: update_mask, tensorboard_experiment: tensorboard_experiment }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest.new(update_mask: update_mask, tensorboard_experiment: tensorboard_experiment), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tensorboard_experiment_client_stub.call_rpc_count
    end
  end

  def test_list_tensorboard_experiments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboard_experiments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tensorboard_experiments, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tensorboard_experiments_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tensorboard_experiments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tensorboard_experiments parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tensorboard_experiments ::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tensorboard_experiments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tensorboard_experiments(::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tensorboard_experiments_client_stub.call_rpc_count
    end
  end

  def test_delete_tensorboard_experiment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_experiment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tensorboard_experiment, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tensorboard_experiment_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tensorboard_experiment({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tensorboard_experiment name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tensorboard_experiment({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tensorboard_experiment_client_stub.call_rpc_count
    end
  end

  def test_create_tensorboard_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard_run = {}
    tensorboard_run_id = "hello world"

    create_tensorboard_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tensorboard_run, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::TensorboardRun), request["tensorboard_run"]
      assert_equal "hello world", request["tensorboard_run_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tensorboard_run_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tensorboard_run({ parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tensorboard_run parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tensorboard_run ::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest.new(parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tensorboard_run({ parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tensorboard_run(::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest.new(parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tensorboard_run_client_stub.call_rpc_count
    end
  end

  def test_batch_create_tensorboard_runs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_tensorboard_runs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_tensorboard_runs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_tensorboard_runs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_tensorboard_runs({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_tensorboard_runs parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_tensorboard_runs ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_tensorboard_runs({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_tensorboard_runs(::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_tensorboard_runs_client_stub.call_rpc_count
    end
  end

  def test_get_tensorboard_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tensorboard_run, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tensorboard_run_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tensorboard_run({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tensorboard_run name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tensorboard_run ::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tensorboard_run({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tensorboard_run(::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tensorboard_run_client_stub.call_rpc_count
    end
  end

  def test_update_tensorboard_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard_run = {}

    update_tensorboard_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tensorboard_run, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::TensorboardRun), request["tensorboard_run"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tensorboard_run_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tensorboard_run({ update_mask: update_mask, tensorboard_run: tensorboard_run }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tensorboard_run update_mask: update_mask, tensorboard_run: tensorboard_run do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tensorboard_run ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest.new(update_mask: update_mask, tensorboard_run: tensorboard_run) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tensorboard_run({ update_mask: update_mask, tensorboard_run: tensorboard_run }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tensorboard_run(::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest.new(update_mask: update_mask, tensorboard_run: tensorboard_run), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tensorboard_run_client_stub.call_rpc_count
    end
  end

  def test_list_tensorboard_runs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListTensorboardRunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboard_runs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tensorboard_runs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tensorboard_runs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tensorboard_runs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tensorboard_runs parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tensorboard_runs ::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tensorboard_runs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tensorboard_runs(::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tensorboard_runs_client_stub.call_rpc_count
    end
  end

  def test_delete_tensorboard_run
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tensorboard_run, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tensorboard_run_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tensorboard_run({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tensorboard_run name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tensorboard_run ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tensorboard_run({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tensorboard_run(::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tensorboard_run_client_stub.call_rpc_count
    end
  end

  def test_batch_create_tensorboard_time_series
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_tensorboard_time_series_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_tensorboard_time_series, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_tensorboard_time_series_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_tensorboard_time_series({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_tensorboard_time_series parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_tensorboard_time_series({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_tensorboard_time_series_client_stub.call_rpc_count
    end
  end

  def test_create_tensorboard_time_series
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard_time_series_id = "hello world"
    tensorboard_time_series = {}

    create_tensorboard_time_series_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tensorboard_time_series, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["tensorboard_time_series_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries), request["tensorboard_time_series"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tensorboard_time_series_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tensorboard_time_series({ parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tensorboard_time_series parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest.new(parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tensorboard_time_series({ parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest.new(parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tensorboard_time_series_client_stub.call_rpc_count
    end
  end

  def test_get_tensorboard_time_series
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_time_series_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tensorboard_time_series, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tensorboard_time_series_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tensorboard_time_series({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tensorboard_time_series name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tensorboard_time_series({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tensorboard_time_series_client_stub.call_rpc_count
    end
  end

  def test_update_tensorboard_time_series
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard_time_series = {}

    update_tensorboard_time_series_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tensorboard_time_series, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries), request["tensorboard_time_series"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tensorboard_time_series_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tensorboard_time_series({ update_mask: update_mask, tensorboard_time_series: tensorboard_time_series }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tensorboard_time_series update_mask: update_mask, tensorboard_time_series: tensorboard_time_series do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest.new(update_mask: update_mask, tensorboard_time_series: tensorboard_time_series) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tensorboard_time_series({ update_mask: update_mask, tensorboard_time_series: tensorboard_time_series }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest.new(update_mask: update_mask, tensorboard_time_series: tensorboard_time_series), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tensorboard_time_series_client_stub.call_rpc_count
    end
  end

  def test_list_tensorboard_time_series
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboard_time_series_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tensorboard_time_series, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tensorboard_time_series_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tensorboard_time_series({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tensorboard_time_series parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tensorboard_time_series({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tensorboard_time_series_client_stub.call_rpc_count
    end
  end

  def test_delete_tensorboard_time_series
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_time_series_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tensorboard_time_series, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tensorboard_time_series_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tensorboard_time_series({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tensorboard_time_series name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tensorboard_time_series({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tensorboard_time_series_client_stub.call_rpc_count
    end
  end

  def test_batch_read_tensorboard_time_series_data
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tensorboard = "hello world"
    time_series = ["hello world"]

    batch_read_tensorboard_time_series_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_read_tensorboard_time_series_data, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest, request
      assert_equal "hello world", request["tensorboard"]
      assert_equal ["hello world"], request["time_series"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_read_tensorboard_time_series_data_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_read_tensorboard_time_series_data({ tensorboard: tensorboard, time_series: time_series }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_read_tensorboard_time_series_data tensorboard: tensorboard, time_series: time_series do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_read_tensorboard_time_series_data ::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest.new(tensorboard: tensorboard, time_series: time_series) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_read_tensorboard_time_series_data({ tensorboard: tensorboard, time_series: time_series }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_read_tensorboard_time_series_data(::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest.new(tensorboard: tensorboard, time_series: time_series), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_read_tensorboard_time_series_data_client_stub.call_rpc_count
    end
  end

  def test_read_tensorboard_time_series_data
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tensorboard_time_series = "hello world"
    max_data_points = 42
    filter = "hello world"

    read_tensorboard_time_series_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read_tensorboard_time_series_data, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest, request
      assert_equal "hello world", request["tensorboard_time_series"]
      assert_equal 42, request["max_data_points"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_tensorboard_time_series_data_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_tensorboard_time_series_data tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_tensorboard_time_series_data ::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_tensorboard_time_series_data(::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_tensorboard_time_series_data_client_stub.call_rpc_count
    end
  end

  def test_read_tensorboard_blob_data
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    time_series = "hello world"
    blob_ids = ["hello world"]

    read_tensorboard_blob_data_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :read_tensorboard_blob_data, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest, request
      assert_equal "hello world", request["time_series"]
      assert_equal ["hello world"], request["blob_ids"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_tensorboard_blob_data_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_tensorboard_blob_data({ time_series: time_series, blob_ids: blob_ids }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_tensorboard_blob_data time_series: time_series, blob_ids: blob_ids do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_tensorboard_blob_data ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest.new(time_series: time_series, blob_ids: blob_ids) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_tensorboard_blob_data({ time_series: time_series, blob_ids: blob_ids }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_tensorboard_blob_data(::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest.new(time_series: time_series, blob_ids: blob_ids), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_tensorboard_blob_data_client_stub.call_rpc_count
    end
  end

  def test_write_tensorboard_experiment_data
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tensorboard_experiment = "hello world"
    write_run_data_requests = [{}]

    write_tensorboard_experiment_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :write_tensorboard_experiment_data, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest, request
      assert_equal "hello world", request["tensorboard_experiment"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest, request["write_run_data_requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, write_tensorboard_experiment_data_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.write_tensorboard_experiment_data({ tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.write_tensorboard_experiment_data tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.write_tensorboard_experiment_data ::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest.new(tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.write_tensorboard_experiment_data({ tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.write_tensorboard_experiment_data(::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest.new(tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, write_tensorboard_experiment_data_client_stub.call_rpc_count
    end
  end

  def test_write_tensorboard_run_data
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tensorboard_run = "hello world"
    time_series_data = [{}]

    write_tensorboard_run_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :write_tensorboard_run_data, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest, request
      assert_equal "hello world", request["tensorboard_run"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::TimeSeriesData, request["time_series_data"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, write_tensorboard_run_data_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.write_tensorboard_run_data({ tensorboard_run: tensorboard_run, time_series_data: time_series_data }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.write_tensorboard_run_data tensorboard_run: tensorboard_run, time_series_data: time_series_data do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.write_tensorboard_run_data ::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest.new(tensorboard_run: tensorboard_run, time_series_data: time_series_data) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.write_tensorboard_run_data({ tensorboard_run: tensorboard_run, time_series_data: time_series_data }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.write_tensorboard_run_data(::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest.new(tensorboard_run: tensorboard_run, time_series_data: time_series_data), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, write_tensorboard_run_data_client_stub.call_rpc_count
    end
  end

  def test_export_tensorboard_time_series_data
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tensorboard_time_series = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    export_tensorboard_time_series_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_tensorboard_time_series_data, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest, request
      assert_equal "hello world", request["tensorboard_time_series"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_tensorboard_time_series_data_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_tensorboard_time_series_data tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_tensorboard_time_series_data ::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_tensorboard_time_series_data(::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_tensorboard_time_series_data_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::TensorboardService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::TensorboardService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::TensorboardService::Operations, client.operations_client
  end
end
