# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/tensorboard_service_pb"
require "google/cloud/ai_platform/v1/tensorboard_service/rest"


class ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_tensorboard
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard = {}

    create_tensorboard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_create_tensorboard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tensorboard_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tensorboard({ parent: parent, tensorboard: tensorboard }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tensorboard parent: parent, tensorboard: tensorboard do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tensorboard ::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest.new(parent: parent, tensorboard: tensorboard) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tensorboard({ parent: parent, tensorboard: tensorboard }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tensorboard(::Google::Cloud::AIPlatform::V1::CreateTensorboardRequest.new(parent: parent, tensorboard: tensorboard), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tensorboard_client_stub.call_count
      end
    end
  end

  def test_get_tensorboard
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Tensorboard.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_get_tensorboard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tensorboard_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tensorboard({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tensorboard name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tensorboard ::Google::Cloud::AIPlatform::V1::GetTensorboardRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tensorboard({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tensorboard(::Google::Cloud::AIPlatform::V1::GetTensorboardRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tensorboard_client_stub.call_count
      end
    end
  end

  def test_update_tensorboard
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard = {}

    update_tensorboard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_update_tensorboard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tensorboard_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tensorboard({ update_mask: update_mask, tensorboard: tensorboard }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tensorboard update_mask: update_mask, tensorboard: tensorboard do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tensorboard ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest.new(update_mask: update_mask, tensorboard: tensorboard) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tensorboard({ update_mask: update_mask, tensorboard: tensorboard }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tensorboard(::Google::Cloud::AIPlatform::V1::UpdateTensorboardRequest.new(update_mask: update_mask, tensorboard: tensorboard), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tensorboard_client_stub.call_count
      end
    end
  end

  def test_list_tensorboards
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListTensorboardsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboards_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_list_tensorboards_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tensorboards_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tensorboards({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tensorboards parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tensorboards ::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tensorboards({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tensorboards(::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tensorboards_client_stub.call_count
      end
    end
  end

  def test_delete_tensorboard
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_delete_tensorboard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tensorboard_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tensorboard({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tensorboard name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tensorboard ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tensorboard({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tensorboard(::Google::Cloud::AIPlatform::V1::DeleteTensorboardRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tensorboard_client_stub.call_count
      end
    end
  end

  def test_read_tensorboard_usage
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tensorboard = "hello world"

    read_tensorboard_usage_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_read_tensorboard_usage_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, read_tensorboard_usage_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.read_tensorboard_usage({ tensorboard: tensorboard }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.read_tensorboard_usage tensorboard: tensorboard do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.read_tensorboard_usage ::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest.new(tensorboard: tensorboard) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.read_tensorboard_usage({ tensorboard: tensorboard }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.read_tensorboard_usage(::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageRequest.new(tensorboard: tensorboard), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, read_tensorboard_usage_client_stub.call_count
      end
    end
  end

  def test_read_tensorboard_size
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tensorboard = "hello world"

    read_tensorboard_size_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_read_tensorboard_size_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, read_tensorboard_size_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.read_tensorboard_size({ tensorboard: tensorboard }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.read_tensorboard_size tensorboard: tensorboard do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.read_tensorboard_size ::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest.new(tensorboard: tensorboard) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.read_tensorboard_size({ tensorboard: tensorboard }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.read_tensorboard_size(::Google::Cloud::AIPlatform::V1::ReadTensorboardSizeRequest.new(tensorboard: tensorboard), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, read_tensorboard_size_client_stub.call_count
      end
    end
  end

  def test_create_tensorboard_experiment
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardExperiment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard_experiment = {}
    tensorboard_experiment_id = "hello world"

    create_tensorboard_experiment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_create_tensorboard_experiment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tensorboard_experiment_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tensorboard_experiment({ parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tensorboard_experiment parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest.new(parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tensorboard_experiment({ parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::CreateTensorboardExperimentRequest.new(parent: parent, tensorboard_experiment: tensorboard_experiment, tensorboard_experiment_id: tensorboard_experiment_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tensorboard_experiment_client_stub.call_count
      end
    end
  end

  def test_get_tensorboard_experiment
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardExperiment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_experiment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_get_tensorboard_experiment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tensorboard_experiment_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tensorboard_experiment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tensorboard_experiment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tensorboard_experiment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::GetTensorboardExperimentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tensorboard_experiment_client_stub.call_count
      end
    end
  end

  def test_update_tensorboard_experiment
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardExperiment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard_experiment = {}

    update_tensorboard_experiment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_update_tensorboard_experiment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tensorboard_experiment_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tensorboard_experiment({ update_mask: update_mask, tensorboard_experiment: tensorboard_experiment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tensorboard_experiment update_mask: update_mask, tensorboard_experiment: tensorboard_experiment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest.new(update_mask: update_mask, tensorboard_experiment: tensorboard_experiment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tensorboard_experiment({ update_mask: update_mask, tensorboard_experiment: tensorboard_experiment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::UpdateTensorboardExperimentRequest.new(update_mask: update_mask, tensorboard_experiment: tensorboard_experiment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tensorboard_experiment_client_stub.call_count
      end
    end
  end

  def test_list_tensorboard_experiments
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboard_experiments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_list_tensorboard_experiments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tensorboard_experiments_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tensorboard_experiments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tensorboard_experiments parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tensorboard_experiments ::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tensorboard_experiments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tensorboard_experiments(::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tensorboard_experiments_client_stub.call_count
      end
    end
  end

  def test_delete_tensorboard_experiment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_experiment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_delete_tensorboard_experiment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tensorboard_experiment_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tensorboard_experiment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tensorboard_experiment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tensorboard_experiment ::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tensorboard_experiment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tensorboard_experiment(::Google::Cloud::AIPlatform::V1::DeleteTensorboardExperimentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tensorboard_experiment_client_stub.call_count
      end
    end
  end

  def test_create_tensorboard_run
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard_run = {}
    tensorboard_run_id = "hello world"

    create_tensorboard_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_create_tensorboard_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tensorboard_run_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tensorboard_run({ parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tensorboard_run parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tensorboard_run ::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest.new(parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tensorboard_run({ parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tensorboard_run(::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest.new(parent: parent, tensorboard_run: tensorboard_run, tensorboard_run_id: tensorboard_run_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tensorboard_run_client_stub.call_count
      end
    end
  end

  def test_batch_create_tensorboard_runs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_tensorboard_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_batch_create_tensorboard_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_tensorboard_runs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_tensorboard_runs({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_tensorboard_runs parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_tensorboard_runs ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_tensorboard_runs({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_tensorboard_runs(::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardRunsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_tensorboard_runs_client_stub.call_count
      end
    end
  end

  def test_get_tensorboard_run
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_get_tensorboard_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tensorboard_run_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tensorboard_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tensorboard_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tensorboard_run ::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tensorboard_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tensorboard_run(::Google::Cloud::AIPlatform::V1::GetTensorboardRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tensorboard_run_client_stub.call_count
      end
    end
  end

  def test_update_tensorboard_run
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard_run = {}

    update_tensorboard_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_update_tensorboard_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tensorboard_run_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tensorboard_run({ update_mask: update_mask, tensorboard_run: tensorboard_run }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tensorboard_run update_mask: update_mask, tensorboard_run: tensorboard_run do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tensorboard_run ::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest.new(update_mask: update_mask, tensorboard_run: tensorboard_run) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tensorboard_run({ update_mask: update_mask, tensorboard_run: tensorboard_run }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tensorboard_run(::Google::Cloud::AIPlatform::V1::UpdateTensorboardRunRequest.new(update_mask: update_mask, tensorboard_run: tensorboard_run), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tensorboard_run_client_stub.call_count
      end
    end
  end

  def test_list_tensorboard_runs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListTensorboardRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboard_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_list_tensorboard_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tensorboard_runs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tensorboard_runs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tensorboard_runs parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tensorboard_runs ::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tensorboard_runs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tensorboard_runs(::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tensorboard_runs_client_stub.call_count
      end
    end
  end

  def test_delete_tensorboard_run
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_delete_tensorboard_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tensorboard_run_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tensorboard_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tensorboard_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tensorboard_run ::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tensorboard_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tensorboard_run(::Google::Cloud::AIPlatform::V1::DeleteTensorboardRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tensorboard_run_client_stub.call_count
      end
    end
  end

  def test_batch_create_tensorboard_time_series
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_tensorboard_time_series_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_batch_create_tensorboard_time_series_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_tensorboard_time_series_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_tensorboard_time_series({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_tensorboard_time_series parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_tensorboard_time_series({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::BatchCreateTensorboardTimeSeriesRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_tensorboard_time_series_client_stub.call_count
      end
    end
  end

  def test_create_tensorboard_time_series
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tensorboard_time_series_id = "hello world"
    tensorboard_time_series = {}

    create_tensorboard_time_series_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_create_tensorboard_time_series_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tensorboard_time_series_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tensorboard_time_series({ parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tensorboard_time_series parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest.new(parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tensorboard_time_series({ parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest.new(parent: parent, tensorboard_time_series_id: tensorboard_time_series_id, tensorboard_time_series: tensorboard_time_series), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tensorboard_time_series_client_stub.call_count
      end
    end
  end

  def test_get_tensorboard_time_series
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tensorboard_time_series_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_get_tensorboard_time_series_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tensorboard_time_series_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tensorboard_time_series({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tensorboard_time_series name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tensorboard_time_series({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::GetTensorboardTimeSeriesRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tensorboard_time_series_client_stub.call_count
      end
    end
  end

  def test_update_tensorboard_time_series
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tensorboard_time_series = {}

    update_tensorboard_time_series_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_update_tensorboard_time_series_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tensorboard_time_series_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tensorboard_time_series({ update_mask: update_mask, tensorboard_time_series: tensorboard_time_series }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tensorboard_time_series update_mask: update_mask, tensorboard_time_series: tensorboard_time_series do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest.new(update_mask: update_mask, tensorboard_time_series: tensorboard_time_series) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tensorboard_time_series({ update_mask: update_mask, tensorboard_time_series: tensorboard_time_series }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::UpdateTensorboardTimeSeriesRequest.new(update_mask: update_mask, tensorboard_time_series: tensorboard_time_series), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tensorboard_time_series_client_stub.call_count
      end
    end
  end

  def test_list_tensorboard_time_series
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_tensorboard_time_series_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_list_tensorboard_time_series_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tensorboard_time_series_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tensorboard_time_series({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tensorboard_time_series parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tensorboard_time_series({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tensorboard_time_series_client_stub.call_count
      end
    end
  end

  def test_delete_tensorboard_time_series
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tensorboard_time_series_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_delete_tensorboard_time_series_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tensorboard_time_series_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tensorboard_time_series({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tensorboard_time_series name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tensorboard_time_series ::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tensorboard_time_series({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tensorboard_time_series(::Google::Cloud::AIPlatform::V1::DeleteTensorboardTimeSeriesRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tensorboard_time_series_client_stub.call_count
      end
    end
  end

  def test_batch_read_tensorboard_time_series_data
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tensorboard = "hello world"
    time_series = ["hello world"]

    batch_read_tensorboard_time_series_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_batch_read_tensorboard_time_series_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_read_tensorboard_time_series_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_read_tensorboard_time_series_data({ tensorboard: tensorboard, time_series: time_series }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_read_tensorboard_time_series_data tensorboard: tensorboard, time_series: time_series do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_read_tensorboard_time_series_data ::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest.new(tensorboard: tensorboard, time_series: time_series) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_read_tensorboard_time_series_data({ tensorboard: tensorboard, time_series: time_series }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_read_tensorboard_time_series_data(::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest.new(tensorboard: tensorboard, time_series: time_series), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_read_tensorboard_time_series_data_client_stub.call_count
      end
    end
  end

  def test_read_tensorboard_time_series_data
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tensorboard_time_series = "hello world"
    max_data_points = 42
    filter = "hello world"

    read_tensorboard_time_series_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_read_tensorboard_time_series_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, read_tensorboard_time_series_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.read_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.read_tensorboard_time_series_data tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.read_tensorboard_time_series_data ::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.read_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.read_tensorboard_time_series_data(::Google::Cloud::AIPlatform::V1::ReadTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, max_data_points: max_data_points, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, read_tensorboard_time_series_data_client_stub.call_count
      end
    end
  end

  def test_read_tensorboard_blob_data
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    time_series = "hello world"
    blob_ids = ["hello world"]

    read_tensorboard_blob_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, is_server_streaming:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_read_tensorboard_blob_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, read_tensorboard_blob_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.read_tensorboard_blob_data({ time_series: time_series, blob_ids: blob_ids }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use named arguments
        client.read_tensorboard_blob_data time_series: time_series, blob_ids: blob_ids do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use protobuf object
        client.read_tensorboard_blob_data ::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest.new(time_series: time_series, blob_ids: blob_ids) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use hash object with options
        client.read_tensorboard_blob_data({ time_series: time_series, blob_ids: blob_ids }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Use protobuf object with options
        client.read_tensorboard_blob_data(::Google::Cloud::AIPlatform::V1::ReadTensorboardBlobDataRequest.new(time_series: time_series, blob_ids: blob_ids), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end.first

        # Verify method calls
        assert_equal 5, read_tensorboard_blob_data_client_stub.call_count
      end
    end
  end

  def test_write_tensorboard_experiment_data
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tensorboard_experiment = "hello world"
    write_run_data_requests = [{}]

    write_tensorboard_experiment_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_write_tensorboard_experiment_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, write_tensorboard_experiment_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.write_tensorboard_experiment_data({ tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.write_tensorboard_experiment_data tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.write_tensorboard_experiment_data ::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest.new(tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.write_tensorboard_experiment_data({ tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.write_tensorboard_experiment_data(::Google::Cloud::AIPlatform::V1::WriteTensorboardExperimentDataRequest.new(tensorboard_experiment: tensorboard_experiment, write_run_data_requests: write_run_data_requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, write_tensorboard_experiment_data_client_stub.call_count
      end
    end
  end

  def test_write_tensorboard_run_data
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tensorboard_run = "hello world"
    time_series_data = [{}]

    write_tensorboard_run_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_write_tensorboard_run_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, write_tensorboard_run_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.write_tensorboard_run_data({ tensorboard_run: tensorboard_run, time_series_data: time_series_data }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.write_tensorboard_run_data tensorboard_run: tensorboard_run, time_series_data: time_series_data do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.write_tensorboard_run_data ::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest.new(tensorboard_run: tensorboard_run, time_series_data: time_series_data) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.write_tensorboard_run_data({ tensorboard_run: tensorboard_run, time_series_data: time_series_data }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.write_tensorboard_run_data(::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest.new(tensorboard_run: tensorboard_run, time_series_data: time_series_data), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, write_tensorboard_run_data_client_stub.call_count
      end
    end
  end

  def test_export_tensorboard_time_series_data
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tensorboard_time_series = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    export_tensorboard_time_series_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::ServiceStub.stub :transcode_export_tensorboard_time_series_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_tensorboard_time_series_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_tensorboard_time_series_data tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_tensorboard_time_series_data ::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_tensorboard_time_series_data({ tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_tensorboard_time_series_data(::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest.new(tensorboard_time_series: tensorboard_time_series, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_tensorboard_time_series_data_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::TensorboardService::Rest::Client::Configuration, config
  end
end
